/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.runtime.HerderRequest;
import org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.InternalRequestSignature;
import org.apache.kafka.connect.runtime.rest.entities.ActiveTopicsInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorOffsets;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.Message;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;

public interface Herder {
    public void start();

    public void stop();

    public boolean isRunning();

    public void connectors(Callback<Collection<String>> var1);

    public void connectorInfo(String var1, Callback<ConnectorInfo> var2);

    public void connectorConfig(String var1, Callback<Map<String, String>> var2);

    public void tasksConfig(String var1, Callback<Map<ConnectorTaskId, Map<String, String>>> var2);

    public void putConnectorConfig(String var1, Map<String, String> var2, boolean var3, Callback<Created<ConnectorInfo>> var4);

    public void deleteConnectorConfig(String var1, Callback<Created<ConnectorInfo>> var2);

    public void requestTaskReconfiguration(String var1);

    public void taskConfigs(String var1, Callback<List<TaskInfo>> var2);

    public void putTaskConfigs(String var1, List<Map<String, String>> var2, Callback<Void> var3, InternalRequestSignature var4);

    public void fenceZombieSourceTasks(String var1, Callback<Void> var2, InternalRequestSignature var3);

    public Collection<String> connectors();

    public ConnectorInfo connectorInfo(String var1);

    default public ConnectorInfo getProcessedConnectorInfo(String connName) {
        return this.connectorInfo(connName);
    }

    public ConnectorStateInfo connectorStatus(String var1);

    public ActiveTopicsInfo connectorActiveTopics(String var1);

    public void resetConnectorActiveTopics(String var1);

    public StatusBackingStore statusBackingStore();

    public ConnectorStateInfo.TaskState taskStatus(ConnectorTaskId var1);

    public void validateConnectorConfig(Map<String, String> var1, Callback<ConfigInfos> var2);

    default public void validateConnectorConfig(Map<String, String> connectorConfig, Callback<ConfigInfos> callback, boolean doLog) {
        this.validateConnectorConfig(connectorConfig, callback);
    }

    public void restartTask(ConnectorTaskId var1, Callback<Void> var2);

    public void restartConnector(String var1, Callback<Void> var2);

    public HerderRequest restartConnector(long var1, String var3, Callback<Void> var4);

    public void restartConnectorAndTasks(RestartRequest var1, Callback<ConnectorStateInfo> var2);

    public void stopConnector(String var1, Callback<Void> var2);

    public void pauseConnector(String var1);

    public void resumeConnector(String var1);

    public Plugins plugins();

    public String kafkaClusterId();

    public List<ConfigKeyInfo> connectorPluginConfig(String var1);

    public void connectorOffsets(String var1, Callback<ConnectorOffsets> var2);

    public void alterConnectorOffsets(String var1, Map<Map<String, ?>, Map<String, ?>> var2, Callback<Message> var3);

    public void resetConnectorOffsets(String var1, Callback<Message> var2);

    public static class Created<T> {
        private final boolean created;
        private final T result;

        public Created(boolean created, T result) {
            this.created = created;
            this.result = result;
        }

        public boolean created() {
            return this.created;
        }

        public T result() {
            return this.result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Created created1 = (Created)o;
            return Objects.equals(this.created, created1.created) && Objects.equals(this.result, created1.result);
        }

        public int hashCode() {
            return Objects.hash(this.created, this.result);
        }
    }

    public static enum ConfigReloadAction {
        NONE,
        RESTART;

    }
}

