/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.errors;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.connect.runtime.errors.ErrorReporter;
import org.apache.kafka.connect.runtime.errors.ProcessingContext;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.runtime.tracing.Tracer;
import org.apache.kafka.connect.runtime.tracing.TracingContext;
import org.slf4j.Logger;

@Confluent
public class TraceReporter
implements ErrorReporter {
    protected final Tracer tracer;
    private final Logger log;

    public TraceReporter(Tracer tracer) {
        this.tracer = tracer;
        this.log = new LogContext(String.format("[%s-tracer-%s] ", tracer.tracingContext().connectorTaskId(), tracer.tracingContext().traceID())).logger(TraceReporter.class);
    }

    @Override
    public Future<RecordMetadata> report(ProcessingContext context) {
        TracingContext tracingContext = this.tracer.tracingContext();
        switch (context.stage()) {
            case TRANSFORMATION: {
                this.log.debug("Writing failed transformation {} to trace topic ", (Object)tracingContext.currentTransformationName());
                this.tracer.traceRecordBuilder().appendTransformationError(tracingContext.currentTransformationName(), tracingContext.currentTransformationType(), context.error());
                break;
            }
            case KEY_CONVERTER: 
            case VALUE_CONVERTER: 
            case HEADER_CONVERTER: {
                this.log.debug("Writing failed conversion of record to trace topic");
                if (tracingContext.connectorType() == ConnectorType.SOURCE) {
                    this.tracer.traceRecordBuilder().appendSourceConversionError(context.stage(), context.sourceRecord(), context.error());
                    break;
                }
                this.tracer.traceRecordBuilder().appendSinkConversionError(context.stage(), context.consumerRecord(), context.error());
                break;
            }
            default: {
                this.log.debug("Writing error on stage {} to trace topic", (Object)context.stage());
                this.tracer.traceRecordBuilder().appendError(context.stage().toString(), context.executingClass(), context.error());
            }
        }
        this.tracer.buildAndWriteRecords();
        return CompletableFuture.completedFuture(null);
    }
}

