/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientUnitTestEnv;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.AdminRequestInterceptor;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfluentAdminUtilsTest {
    @Test
    public void testCreateConfluentAdmin() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        Integer requestTimeoutMs = 1000;
        configs.put("bootstrap.servers", "localhost:9092");
        configs.put("request.timeout.ms", requestTimeoutMs);
        AdminClientConfig adminConfig = new AdminClientConfig(configs);
        MockTime time = new MockTime();
        AdminMetadataManager metadataManager = new AdminMetadataManager(new LogContext(), adminConfig.getLong("retry.backoff.ms").longValue(), adminConfig.getLong("metadata.max.age.ms").longValue());
        MockClient mockClient = new MockClient(time);
        AdminRequestInterceptor.Factory interceptorFactory = AdminRequestInterceptor.Factory.DEFAULT_INTERCEPTOR_FACTORY;
        ConfluentAdmin admin = ConfluentAdminUtils.createConfluentAdmin((AdminClientConfig)adminConfig, (AdminMetadataManager)metadataManager, (KafkaClient)mockClient, (Time)time, (AdminRequestInterceptor.Factory)interceptorFactory);
        Assertions.assertEquals((Integer)requestTimeoutMs, (Integer)((Integer)TestUtils.fieldValue(admin, KafkaAdminClient.class, "requestTimeoutMs")));
        Assertions.assertEquals((Object)metadataManager, TestUtils.fieldValue(admin, KafkaAdminClient.class, "metadataManager"));
        Assertions.assertEquals((Object)mockClient, TestUtils.fieldValue(admin, KafkaAdminClient.class, "client"));
        Assertions.assertEquals((Object)time, TestUtils.fieldValue(admin, KafkaAdminClient.class, "time"));
        Assertions.assertEquals((Object)interceptorFactory, TestUtils.fieldValue(admin, KafkaAdminClient.class, "interceptorFactory"));
    }

    @Test
    public void testInitiateReverseConnections() {
        Cluster cluster = new Cluster("clusterId", Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            int initiateRequestId = 5;
            InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(Uuid.randomUuid()).setSourceClusterId("source").setTargetClusterId("dest").setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(initiateRequestId)));
            Map result = ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)env.adminClient(), (InitiateReverseConnectionsRequestData)requestData, (Integer)12);
            Assertions.assertEquals(Collections.singleton(initiateRequestId), result.keySet());
            Assertions.assertFalse((boolean)((KafkaFutureImpl)result.get(initiateRequestId)).isDone());
        }
    }
}

