/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.Deserializers;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FetchConfigTest {
    @Test
    public void testBasicFromConsumerConfig() {
        try (StringDeserializer keyDeserializer = new StringDeserializer();
             StringDeserializer valueDeserializer = new StringDeserializer();){
            this.newFetchConfigFromConsumerConfig((Deserializer<String>)keyDeserializer, (Deserializer<String>)valueDeserializer);
            this.newFetchConfigFromValues((Deserializer<String>)keyDeserializer, (Deserializer<String>)valueDeserializer);
        }
    }

    @Test
    public void testPreventNullKeyDeserializer() {
        try (StringDeserializer valueDeserializer = new StringDeserializer();){
            Assertions.assertThrows(NullPointerException.class, () -> this.newFetchConfigFromConsumerConfig(null, (Deserializer<String>)valueDeserializer));
            Assertions.assertThrows(NullPointerException.class, () -> this.newFetchConfigFromValues(null, (Deserializer<String>)valueDeserializer));
        }
    }

    @Test
    public void testPreventNullValueDeserializer() {
        try (StringDeserializer keyDeserializer = new StringDeserializer();){
            Assertions.assertThrows(NullPointerException.class, () -> this.newFetchConfigFromConsumerConfig((Deserializer<String>)keyDeserializer, null));
            Assertions.assertThrows(NullPointerException.class, () -> this.newFetchConfigFromValues((Deserializer<String>)keyDeserializer, null));
        }
    }

    private void newFetchConfigFromConsumerConfig(Deserializer<String> keyDeserializer, Deserializer<String> valueDeserializer) {
        Properties p = new Properties();
        p.put("bootstrap.servers", "localhost:9092");
        p.put("key.deserializer", StringSerializer.class.getName());
        p.put("value.deserializer", StringSerializer.class.getName());
        ConsumerConfig config = new ConsumerConfig(p);
        new FetchConfig(config, new Deserializers(keyDeserializer, valueDeserializer), IsolationLevel.READ_UNCOMMITTED);
    }

    private void newFetchConfigFromValues(Deserializer<String> keyDeserializer, Deserializer<String> valueDeserializer) {
        new FetchConfig(1, 0x3200000, 500, 0x100000, 500, true, "", new Deserializers(keyDeserializer, valueDeserializer), IsolationLevel.READ_UNCOMMITTED);
    }
}

