/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.DefaultBackgroundThread;
import org.apache.kafka.clients.consumer.internals.DefaultEventHandler;
import org.apache.kafka.clients.consumer.internals.PrototypeAsyncConsumer;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.WakeupTrigger;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.EventHandler;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.kafka.clients.consumer.internals.events.OffsetFetchApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ResetPositionsApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ValidatePositionsApplicationEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class PrototypeAsyncConsumerTest {
    private PrototypeAsyncConsumer<?, ?> consumer;
    private final Map<String, Object> consumerProps = new HashMap<String, Object>();
    private final Time time = new MockTime();
    private LogContext logContext;
    private SubscriptionState subscriptions;
    private ConsumerMetadata metadata;
    private EventHandler eventHandler;
    private Metrics metrics;
    private String groupId = "group.id";
    private ConsumerConfig config;

    @BeforeEach
    public void setup() {
        this.injectConsumerConfigs();
        this.config = new ConsumerConfig(this.consumerProps);
        this.logContext = new LogContext();
        this.subscriptions = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
        DefaultBackgroundThread bt = (DefaultBackgroundThread)Mockito.mock(DefaultBackgroundThread.class);
        LinkedBlockingQueue aq = new LinkedBlockingQueue();
        LinkedBlockingQueue bq = new LinkedBlockingQueue();
        this.eventHandler = (EventHandler)Mockito.spy((Object)new DefaultEventHandler(bt, aq, bq));
        this.metrics = new Metrics(this.time);
    }

    @AfterEach
    public void cleanup() {
        if (this.consumer != null) {
            this.consumer.close(Duration.ZERO);
        }
    }

    @Test
    public void testSuccessfulStartupShutdown() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertDoesNotThrow(() -> this.consumer.close());
    }

    @Test
    public void testInvalidGroupId() {
        this.groupId = null;
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> this.consumer.committed(new HashSet()));
    }

    @Test
    public void testCommitAsync_NullCallback() throws InterruptedException {
        CompletableFuture future = new CompletableFuture();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(new TopicPartition("my-topic", 0), new OffsetAndMetadata(100L));
        offsets.put(new TopicPartition("my-topic", 1), new OffsetAndMetadata(200L));
        PrototypeAsyncConsumer mockedConsumer = (PrototypeAsyncConsumer)Mockito.spy(this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer()));
        ((PrototypeAsyncConsumer)Mockito.doReturn(future).when((Object)mockedConsumer)).commit(offsets, false);
        mockedConsumer.commitAsync(offsets, null);
        future.complete(null);
        TestUtils.waitForCondition(() -> future.isDone(), 2000L, "commit future should complete");
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
    }

    @Test
    public void testCommitAsync_UserSuppliedCallback() {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(new TopicPartition("my-topic", 0), new OffsetAndMetadata(100L));
        offsets.put(new TopicPartition("my-topic", 1), new OffsetAndMetadata(200L));
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        PrototypeAsyncConsumer mockedConsumer = (PrototypeAsyncConsumer)Mockito.spy(consumer);
        ((PrototypeAsyncConsumer)Mockito.doReturn(future).when((Object)mockedConsumer)).commit(offsets, false);
        OffsetCommitCallback customCallback = (OffsetCommitCallback)Mockito.mock(OffsetCommitCallback.class);
        mockedConsumer.commitAsync(offsets, customCallback);
        future.complete(null);
        ((OffsetCommitCallback)Mockito.verify((Object)customCallback)).onComplete(offsets, null);
    }

    @Test
    public void testCommitted() {
        Map<TopicPartition, OffsetAndMetadata> offsets = this.mockTopicPartitionOffset();
        CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> committedFuture = new CompletableFuture<Map<TopicPartition, OffsetAndMetadata>>();
        committedFuture.complete(offsets);
        try (MockedConstruction<OffsetFetchApplicationEvent> ignored = PrototypeAsyncConsumerTest.offsetFetchEventMocker(committedFuture);){
            this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
            Assertions.assertDoesNotThrow(() -> this.consumer.committed(offsets.keySet(), Duration.ofMillis(1000L)));
            ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(OffsetFetchApplicationEvent.class));
        }
    }

    @Test
    public void testCommitted_ExceptionThrown() {
        Map<TopicPartition, OffsetAndMetadata> offsets = this.mockTopicPartitionOffset();
        CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> committedFuture = new CompletableFuture<Map<TopicPartition, OffsetAndMetadata>>();
        committedFuture.completeExceptionally(new KafkaException("Test exception"));
        try (MockedConstruction<OffsetFetchApplicationEvent> ignored = PrototypeAsyncConsumerTest.offsetFetchEventMocker(committedFuture);){
            this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
            Assertions.assertThrows(KafkaException.class, () -> this.consumer.committed(offsets.keySet(), Duration.ofMillis(1000L)));
            ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(OffsetFetchApplicationEvent.class));
        }
    }

    private static MockedConstruction<OffsetFetchApplicationEvent> offsetFetchEventMocker(CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> future) {
        Answer getInvocationAnswer = invocation -> {
            Timer timer = (Timer)invocation.getArgument(0);
            return (Map)ConsumerUtils.getResult((CompletableFuture)future, (Timer)timer);
        };
        MockedConstruction.MockInitializer mockInitializer = (mock, ctx) -> {
            Mockito.when((Object)mock.get((Timer)ArgumentMatchers.any())).thenAnswer(getInvocationAnswer);
            Mockito.when((Object)mock.type()).thenReturn((Object)ApplicationEvent.Type.FETCH_COMMITTED_OFFSET);
            Mockito.when((Object)mock.future()).thenReturn((Object)future);
        };
        return Mockito.mockConstruction(OffsetFetchApplicationEvent.class, (MockedConstruction.MockInitializer)mockInitializer);
    }

    @Test
    public void testAssign() {
        this.subscriptions = new SubscriptionState(this.logContext, OffsetResetStrategy.EARLIEST);
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        TopicPartition tp = new TopicPartition("foo", 3);
        this.consumer.assign(Collections.singleton(tp));
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().contains(tp));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.any(AssignmentChangeApplicationEvent.class));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.any(NewTopicsMetadataUpdateRequestEvent.class));
    }

    @Test
    public void testAssignOnNullTopicPartition() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(null));
    }

    @Test
    public void testAssignOnEmptyTopicPartition() {
        this.consumer = (PrototypeAsyncConsumer)Mockito.spy(this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer()));
        this.consumer.assign(Collections.emptyList());
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
    }

    @Test
    public void testAssignOnNullTopicInPartition() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(Collections.singleton(new TopicPartition(null, 0))));
    }

    @Test
    public void testAssignOnEmptyTopicInPartition() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(Collections.singleton(new TopicPartition("  ", 0))));
    }

    @Test
    public void testBeginningOffsetsFailsIfNullPartitions() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(NullPointerException.class, () -> this.consumer.beginningOffsets(null, Duration.ofMillis(1L)));
    }

    @Test
    public void testBeginningOffsets() {
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Map<TopicPartition, OffsetAndTimestamp> expectedOffsetsAndTimestamp = this.mockOffsetAndTimestamp();
        Set<TopicPartition> partitions = expectedOffsetsAndTimestamp.keySet();
        ((EventHandler)Mockito.doReturn(expectedOffsetsAndTimestamp).when((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        Map result = (Map)Assertions.assertDoesNotThrow(() -> consumer.beginningOffsets((Collection)partitions, Duration.ofMillis(1L)));
        Map<TopicPartition, Long> expectedOffsets = expectedOffsetsAndTimestamp.entrySet().stream().collect(Collectors.toMap(e -> (TopicPartition)e.getKey(), e -> ((OffsetAndTimestamp)e.getValue()).offset()));
        Assertions.assertEquals(expectedOffsets, (Object)result);
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testBeginningOffsetsThrowsKafkaExceptionForUnderlyingExecutionFailure() {
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Set<TopicPartition> partitions = this.mockTopicPartitionOffset().keySet();
        KafkaException eventProcessingFailure = new KafkaException("Unexpected failure processing List Offsets event");
        ((EventHandler)Mockito.doThrow((Throwable[])new Throwable[]{eventProcessingFailure}).when((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        Throwable consumerError = Assertions.assertThrows(KafkaException.class, () -> consumer.beginningOffsets((Collection)partitions, Duration.ofMillis(1L)));
        Assertions.assertEquals((Object)((Object)eventProcessingFailure), (Object)consumerError);
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testBeginningOffsetsTimeoutOnEventProcessingTimeout() {
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        ((EventHandler)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException()}).when((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        Assertions.assertThrows(TimeoutException.class, () -> consumer.beginningOffsets(Collections.singletonList(new TopicPartition("t1", 0)), Duration.ofMillis(1L)));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testOffsetsForTimesOnNullPartitions() {
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(NullPointerException.class, () -> consumer.offsetsForTimes(null, Duration.ofMillis(1L)));
    }

    @Test
    public void testOffsetsForTimes() {
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Map<TopicPartition, OffsetAndTimestamp> expectedResult = this.mockOffsetAndTimestamp();
        Map<TopicPartition, Long> timestampToSearch = this.mockTimestampToSearch();
        ((EventHandler)Mockito.doReturn(expectedResult).when((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(), (Timer)ArgumentMatchers.any());
        Map result = (Map)Assertions.assertDoesNotThrow(() -> consumer.offsetsForTimes(timestampToSearch, Duration.ofMillis(1L)));
        Assertions.assertEquals(expectedResult, (Object)result);
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testOffsetsForTimesWithZeroTimeout() {
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        TopicPartition tp = new TopicPartition("topic1", 0);
        Map<TopicPartition, Object> expectedResult = Collections.singletonMap(tp, null);
        Map<TopicPartition, Long> timestampToSearch = Collections.singletonMap(tp, 5L);
        Map result = (Map)Assertions.assertDoesNotThrow(() -> consumer.offsetsForTimes(timestampToSearch, Duration.ofMillis(0L)));
        Assertions.assertEquals(expectedResult, (Object)result);
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ListOffsetsApplicationEvent.class), (Timer)ArgumentMatchers.isA(Timer.class));
    }

    @Test
    public void testWakeup_committed() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        this.consumer.wakeup();
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.committed(this.mockTopicPartitionOffset().keySet()));
        this.assertNoPendingWakeup(this.consumer.wakeupTrigger());
    }

    @Test
    public void testRefreshCommittedOffsetsSuccess() {
        Map<TopicPartition, OffsetAndMetadata> committedOffsets = Collections.singletonMap(new TopicPartition("t1", 1), new OffsetAndMetadata(10L));
        this.testRefreshCommittedOffsetsSuccess(committedOffsets);
    }

    @Test
    public void testRefreshCommittedOffsetsSuccessButNoCommittedOffsetsFound() {
        this.testRefreshCommittedOffsetsSuccess(Collections.emptyMap());
    }

    @Test
    public void testRefreshCommittedOffsetsShouldNotResetIfFailedWithTimeout() {
        this.groupId = "consumer-group-1";
        this.testUpdateFetchPositionsWithFetchCommittedOffsetsTimeout(true);
    }

    @Test
    public void testRefreshCommittedOffsetsNotCalledIfNoGroupId() {
        this.groupId = null;
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        this.testUpdateFetchPositionsWithFetchCommittedOffsetsTimeout(false);
    }

    private void testUpdateFetchPositionsWithFetchCommittedOffsetsTimeout(boolean committedOffsetsEnabled) {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> committedFuture = new CompletableFuture<Map<TopicPartition, OffsetAndMetadata>>();
        Mockito.when((Object)this.subscriptions.initializingPartitions()).thenReturn(Collections.singleton(new TopicPartition("t1", 1)));
        try (MockedConstruction<OffsetFetchApplicationEvent> ignored = PrototypeAsyncConsumerTest.offsetFetchEventMocker(committedFuture);){
            this.consumer.poll(Duration.ofMillis(0L));
            ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(ValidatePositionsApplicationEvent.class));
            if (committedOffsetsEnabled) {
                ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(OffsetFetchApplicationEvent.class));
                ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).add((ApplicationEvent)ArgumentMatchers.isA(ResetPositionsApplicationEvent.class));
            } else {
                ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).add((ApplicationEvent)ArgumentMatchers.isA(OffsetFetchApplicationEvent.class));
                ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(ResetPositionsApplicationEvent.class));
            }
        }
    }

    private void testRefreshCommittedOffsetsSuccess(Map<TopicPartition, OffsetAndMetadata> committedOffsets) {
        CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> committedFuture = new CompletableFuture<Map<TopicPartition, OffsetAndMetadata>>();
        committedFuture.complete(committedOffsets);
        this.groupId = "consumer-group-1";
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        try (MockedConstruction<OffsetFetchApplicationEvent> ignored = PrototypeAsyncConsumerTest.offsetFetchEventMocker(committedFuture);){
            Mockito.when((Object)this.subscriptions.initializingPartitions()).thenReturn(committedOffsets.keySet());
            this.consumer.poll(Duration.ofMillis(0L));
            ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(ValidatePositionsApplicationEvent.class));
            ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(OffsetFetchApplicationEvent.class));
            ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(ResetPositionsApplicationEvent.class));
        }
    }

    private void assertNoPendingWakeup(WakeupTrigger wakeupTrigger) {
        Assertions.assertTrue((wakeupTrigger.getPendingTask() == null ? 1 : 0) != 0);
    }

    private Map<TopicPartition, OffsetAndMetadata> mockTopicPartitionOffset() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L));
        topicPartitionOffsets.put(t1, new OffsetAndMetadata(20L));
        return topicPartitionOffsets;
    }

    private Map<TopicPartition, OffsetAndTimestamp> mockOffsetAndTimestamp() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndTimestamp> offsetAndTimestamp = new HashMap<TopicPartition, OffsetAndTimestamp>();
        offsetAndTimestamp.put(t0, new OffsetAndTimestamp(5L, 1L));
        offsetAndTimestamp.put(t1, new OffsetAndTimestamp(6L, 3L));
        return offsetAndTimestamp;
    }

    private Map<TopicPartition, Long> mockTimestampToSearch() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, Long> timestampToSearch = new HashMap<TopicPartition, Long>();
        timestampToSearch.put(t0, 1L);
        timestampToSearch.put(t1, 2L);
        return timestampToSearch;
    }

    private void injectConsumerConfigs() {
        this.consumerProps.put("bootstrap.servers", "localhost:9999");
        this.consumerProps.put("default.api.timeout.ms", "60000");
        this.consumerProps.put("key.deserializer", StringDeserializer.class);
        this.consumerProps.put("value.deserializer", StringDeserializer.class);
    }

    private PrototypeAsyncConsumer<?, ?> newConsumer(Time time, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer) {
        this.consumerProps.put("key.deserializer", keyDeserializer.getClass());
        this.consumerProps.put("value.deserializer", valueDeserializer.getClass());
        return new PrototypeAsyncConsumer(time, this.logContext, this.config, this.subscriptions, this.metadata, this.eventHandler, this.metrics, Optional.ofNullable(this.groupId), this.config.getInt("default.api.timeout.ms").intValue());
    }
}

