/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TopicMetadataRequestManagerTest {
    private MockTime time;
    private TopicMetadataRequestManager topicMetadataRequestManager;

    @BeforeEach
    public void setup() {
        this.time = new MockTime();
        Properties props = new Properties();
        props.put("retry.backoff.ms", (Object)100);
        props.put("allow.auto.create.topics", (Object)false);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        this.topicMetadataRequestManager = (TopicMetadataRequestManager)Mockito.spy((Object)new TopicMetadataRequestManager(new LogContext(), new ConsumerConfig(props)));
    }

    @ParameterizedTest
    @MethodSource(value={"topicsProvider"})
    public void testPoll_SuccessfulRequestTopicMetadata(Optional<String> topic) {
        this.topicMetadataRequestManager.requestTopicMetadata(topic);
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
    }

    @ParameterizedTest
    @MethodSource(value={"exceptionProvider"})
    public void testExceptionAndInflightRequests(Errors error, boolean shouldRetry) {
        String topic = "hello";
        this.topicMetadataRequestManager.requestTopicMetadata(Optional.of("hello"));
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().complete(this.buildTopicMetadataClientResponse((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0), Optional.of(topic), error));
        List inflights = this.topicMetadataRequestManager.inflightRequests();
        if (shouldRetry) {
            Assertions.assertEquals((int)1, (int)inflights.size());
            Assertions.assertEquals((Object)topic, ((TopicMetadataRequestManager.TopicMetadataRequestState)inflights.get(0)).topic().orElse(null));
        } else {
            Assertions.assertEquals((int)0, (int)inflights.size());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"topicsProvider"})
    public void testSendingTheSameRequest(Optional<String> topic) {
        CompletableFuture future = this.topicMetadataRequestManager.requestTopicMetadata(topic);
        CompletableFuture future2 = this.topicMetadataRequestManager.requestTopicMetadata(topic);
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().complete(this.buildTopicMetadataClientResponse((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0), topic, Errors.NONE));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
        try {
            future.get();
        }
        catch (Throwable e) {
            Assertions.fail((String)"Expecting to succeed, but got: {}", (Throwable)e);
        }
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future2.isCompletedExceptionally());
    }

    @ParameterizedTest
    @MethodSource(value={"hardFailureExceptionProvider"})
    void testHardFailures(Exception exception) {
        Optional<String> topic = Optional.of("hello");
        this.topicMetadataRequestManager.requestTopicMetadata(topic);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().completeExceptionally(exception);
        if (exception instanceof RetriableException) {
            Assertions.assertFalse((boolean)this.topicMetadataRequestManager.inflightRequests().isEmpty());
        } else {
            Assertions.assertTrue((boolean)this.topicMetadataRequestManager.inflightRequests().isEmpty());
        }
    }

    private ClientResponse buildTopicMetadataClientResponse(NetworkClientDelegate.UnsentRequest request, Optional<String> topic, Errors error) {
        AbstractRequest abstractRequest = request.requestBuilder().build();
        Assertions.assertTrue((boolean)(abstractRequest instanceof MetadataRequest));
        MetadataRequest metadataRequest = (MetadataRequest)abstractRequest;
        Cluster cluster = TopicMetadataRequestManagerTest.mockCluster(3, 0);
        ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
        if (topic.isPresent()) {
            topics.add(new MetadataResponse.TopicMetadata(error, topic.get(), false, Collections.emptyList()));
        } else {
            topics.add(new MetadataResponse.TopicMetadata(error, "topic1", false, Collections.emptyList()));
            topics.add(new MetadataResponse.TopicMetadata(error, "topic2", false, Collections.emptyList()));
        }
        MetadataResponse metadataResponse = RequestTestUtils.metadataResponse(cluster.nodes(), cluster.clusterResource().clusterId(), cluster.controller().id(), topics);
        return new ClientResponse(new RequestHeader(ApiKeys.METADATA, metadataRequest.version(), "mockClientId", 1), request.callback(), "-1", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)metadataResponse);
    }

    private static Cluster mockCluster(int numNodes, int controllerIndex) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(controllerIndex));
    }

    private static Collection<Arguments> topicsProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{Optional.of("topic1")}), Arguments.of((Object[])new Object[]{Optional.empty()}));
    }

    private static Collection<Arguments> exceptionProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, false}), Arguments.of((Object[])new Object[]{Errors.INVALID_TOPIC_EXCEPTION, false}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_SERVER_ERROR, false}), Arguments.of((Object[])new Object[]{Errors.NETWORK_EXCEPTION, true}), Arguments.of((Object[])new Object[]{Errors.NONE, false}));
    }

    private static Collection<Arguments> hardFailureExceptionProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{new TimeoutException("timeout")}), Arguments.of((Object[])new Object[]{new KafkaException("non-retriable exception")}), Arguments.of((Object[])new Object[]{new NetworkException("retriable-exception")}));
    }
}

