/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.internals.WakeupTrigger;
import org.apache.kafka.common.errors.WakeupException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WakeupTriggerTest {
    private static long defaultTimeoutMs = 1000L;
    private WakeupTrigger wakeupTrigger;

    @BeforeEach
    public void setup() {
        this.wakeupTrigger = new WakeupTrigger();
    }

    @Test
    public void testEnsureActiveFutureCanBeWakeUp() {
        CompletableFuture task = new CompletableFuture();
        this.wakeupTrigger.setActiveTask(task);
        this.wakeupTrigger.wakeup();
        this.assertWakeupExceptionIsThrown(task);
        Assertions.assertNull((Object)this.wakeupTrigger.getPendingTask());
    }

    @Test
    public void testSettingActiveFutureAfterWakeupShouldThrow() {
        this.wakeupTrigger.wakeup();
        CompletableFuture task = new CompletableFuture();
        this.wakeupTrigger.setActiveTask(task);
        this.assertWakeupExceptionIsThrown(task);
        Assertions.assertNull((Object)this.wakeupTrigger.getPendingTask());
    }

    @Test
    public void testUnsetActiveFuture() {
        CompletableFuture task = new CompletableFuture();
        this.wakeupTrigger.setActiveTask(task);
        this.wakeupTrigger.clearActiveTask();
        Assertions.assertNull((Object)this.wakeupTrigger.getPendingTask());
    }

    private void assertWakeupExceptionIsThrown(CompletableFuture<?> future) {
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        try {
            future.get(defaultTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof WakeupException));
            return;
        }
        catch (Exception e) {
            Assertions.fail((String)("The task should throw an ExecutionException but got:" + e));
        }
        Assertions.fail((String)"The task should throw an ExecutionException");
    }
}

