/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanRequestData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeBrokerAdditionsRequestData;
import org.apache.kafka.common.message.DescribeBrokerAdditionsResponseData;
import org.apache.kafka.common.message.DescribeBrokerRemovalsRequestData;
import org.apache.kafka.common.message.DescribeBrokerRemovalsResponseData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.InitiateShutdownRequestData;
import org.apache.kafka.common.message.InitiateShutdownResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.message.SimpleExampleMessageData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.TriggerEvenClusterLoadRequestData;
import org.apache.kafka.common.message.TriggerEvenClusterLoadResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public final class MessageTest {
    private final String memberId = "memberId";
    private final String instanceId = "instanceId";
    private final List<Integer> listOfVersionsNonBatchOffsetFetch = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7);

    @Test
    public void testAddOffsetsToTxnVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnRequestData().setTransactionalId("foobar").setProducerId(52596993799604990L).setProducerEpoch((short)123).setGroupId("baaz"));
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnResponseData().setThrottleTimeMs(42).setErrorCode((short)0));
    }

    @Test
    public void testAddPartitionsToTxnVersions() throws Exception {
        AddPartitionsToTxnRequestData v3AndBelowData = new AddPartitionsToTxnRequestData().setV3AndBelowTransactionalId("blah").setV3AndBelowProducerId(52596993799604990L).setV3AndBelowProducerEpoch((short)30000).setV3AndBelowTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName("Topic").setPartitions(Collections.singletonList(1))).iterator()));
        this.testDuplication((Message)v3AndBelowData);
        this.testAllMessageRoundTripsUntilVersion((short)3, (Message)v3AndBelowData);
        AddPartitionsToTxnRequestData data = new AddPartitionsToTxnRequestData().setTransactions(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId("blah").setProducerId(52596993799604990L).setProducerEpoch((short)30000).setTopics(v3AndBelowData.v3AndBelowTopics())).iterator()));
        this.testDuplication((Message)data);
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)data);
    }

    @Test
    public void testCreateTopicsVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new CreateTopicsRequestData().setTimeoutMs(1000).setTopics(new CreateTopicsRequestData.CreatableTopicCollection()));
    }

    @Test
    public void testDescribeAclsRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeAclsRequestData().setResourceTypeFilter((byte)42).setResourceNameFilter(null).setPatternTypeFilter((byte)3).setPrincipalFilter("abc").setHostFilter(null).setOperation((byte)0).setPermissionType((byte)0));
    }

    @Test
    public void testMetadataVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new MetadataRequestData().setTopics(Arrays.asList(new MetadataRequestData.MetadataRequestTopic().setName("foo"), new MetadataRequestData.MetadataRequestTopic().setName("bar"))));
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(true).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(false).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
    }

    @Test
    public void testHeartbeatVersions() throws Exception {
        Supplier<HeartbeatRequestData> newRequest = () -> new HeartbeatRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testJoinGroupRequestVersions() throws Exception {
        Supplier<JoinGroupRequestData> newRequest = () -> new JoinGroupRequestData().setGroupId("groupId").setMemberId("memberId").setProtocolType("consumer").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection()).setSessionTimeoutMs(10000);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newRequest.get().setRebalanceTimeoutMs(20000));
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testListOffsetsRequestVersions() throws Exception {
        List<ListOffsetsRequestData.ListOffsetsTopic> v = Collections.singletonList(new ListOffsetsRequestData.ListOffsetsTopic().setName("topic").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(123L))));
        Supplier<ListOffsetsRequestData> newRequest = () -> new ListOffsetsRequestData().setTopics(v).setReplicaId(0);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newRequest.get().setIsolationLevel(IsolationLevel.READ_COMMITTED.id()));
    }

    @Test
    public void testListOffsetsResponseVersions() throws Exception {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partition = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.NONE.code()).setPartitionIndex(0).setOldStyleOffsets(Collections.singletonList(321L));
        List<ListOffsetsResponseData.ListOffsetsTopicResponse> topics = Collections.singletonList(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("topic").setPartitions(Collections.singletonList(partition)));
        Supplier<ListOffsetsResponseData> response = () -> new ListOffsetsResponseData().setTopics(topics);
        Iterator iterator = ApiKeys.LIST_OFFSETS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ListOffsetsResponseData responseData = response.get();
            if (version > 0) {
                ((ListOffsetsResponseData.ListOffsetsPartitionResponse)((ListOffsetsResponseData.ListOffsetsTopicResponse)responseData.topics().get(0)).partitions().get(0)).setOldStyleOffsets(Collections.emptyList()).setOffset(456L).setTimestamp(123L);
            }
            if (version > 1) {
                responseData.setThrottleTimeMs(1000);
            }
            if (version > 3) {
                partition.setLeaderEpoch(1);
            }
            this.testEquivalentMessageRoundTrip(version, (Message)responseData);
        }
    }

    @Test
    public void testJoinGroupResponseVersions() throws Exception {
        Supplier<JoinGroupResponseData> newResponse = () -> new JoinGroupResponseData().setMemberId("memberId").setLeader("memberId").setGenerationId(1).setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("memberId")));
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTrips((Message)((JoinGroupResponseData.JoinGroupResponseMember)newResponse.get().members().get(0)).setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)((JoinGroupResponseData.JoinGroupResponseMember)newResponse.get().members().get(0)).setGroupInstanceId("instanceId"));
    }

    @Test
    public void testLeaveGroupResponseVersions() throws Exception {
        Supplier<LeaveGroupResponseData> newResponse = () -> new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code());
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newResponse.get().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setMemberId("memberId").setGroupInstanceId("instanceId"))));
    }

    @Test
    public void testSyncGroupDefaultGroupInstanceId() throws Exception {
        Supplier<SyncGroupRequestData> request = () -> new SyncGroupRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15).setAssignments(new ArrayList());
        this.testAllMessageRoundTrips((Message)request.get());
        this.testAllMessageRoundTrips((Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testOffsetCommitDefaultGroupInstanceId() throws Exception {
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setTopics(new ArrayList()).setGroupId("groupId"));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId("groupId").setMemberId("memberId").setTopics(new ArrayList()).setGenerationIdOrMemberEpoch(15);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)7, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testDescribeGroupsRequestVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeGroupsRequestData().setGroups(Collections.singletonList("group")).setIncludeAuthorizedOperations(false));
    }

    @Test
    public void testDescribeGroupsResponseVersions() throws Exception {
        DescribeGroupsResponseData.DescribedGroupMember baseMember = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId");
        DescribeGroupsResponseData.DescribedGroup baseGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(baseMember)).setProtocolType("consumer");
        DescribeGroupsResponseData baseResponse = new DescribeGroupsResponseData().setGroups(Collections.singletonList(baseGroup));
        this.testAllMessageRoundTrips((Message)baseResponse);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)baseResponse.setThrottleTimeMs(10));
        baseGroup.setAuthorizedOperations(1);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)baseResponse);
        baseMember.setGroupInstanceId("instanceId");
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)baseResponse);
    }

    @Test
    public void testDescribeClusterRequestVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(true));
    }

    @Test
    public void testDescribeClusterResponseVersions() throws Exception {
        DescribeClusterResponseData data = new DescribeClusterResponseData().setBrokers(new DescribeClusterResponseData.DescribeClusterBrokerCollection(Collections.singletonList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(1).setHost("localhost").setPort(9092).setRack("rack1")).iterator())).setClusterId("clusterId").setControllerId(1).setClusterAuthorizedOperations(10);
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testGroupInstanceIdIgnorableInDescribeGroupsResponse() throws Exception {
        DescribeGroupsResponseData responseWithGroupInstanceId = new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId").setGroupInstanceId("instanceId"))).setProtocolType("consumer")));
        ByteBuffer buf = MessageUtil.toByteBuffer((Message)responseWithGroupInstanceId, (short)responseWithGroupInstanceId.highestSupportedVersion());
        DescribeGroupsResponseData expectedResponse = new DescribeGroupsResponseData((Readable)new ByteBufferAccessor(buf), responseWithGroupInstanceId.highestSupportedVersion(), MessageContext.IDENTITY);
        ((DescribeGroupsResponseData.DescribedGroupMember)((DescribeGroupsResponseData.DescribedGroup)expectedResponse.groups().get(0)).members().get(0)).setGroupInstanceId(null);
        this.testAllMessageRoundTripsBeforeVersion((short)4, (Message)responseWithGroupInstanceId, (Message)expectedResponse);
    }

    @Test
    public void testThrottleTimeIgnorableInDescribeGroupsResponse() throws Exception {
        DescribeGroupsResponseData responseWithGroupInstanceId = new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId"))).setProtocolType("consumer"))).setThrottleTimeMs(10);
        ByteBuffer buf = MessageUtil.toByteBuffer((Message)responseWithGroupInstanceId, (short)responseWithGroupInstanceId.highestSupportedVersion());
        DescribeGroupsResponseData expectedResponse = new DescribeGroupsResponseData((Readable)new ByteBufferAccessor(buf), responseWithGroupInstanceId.highestSupportedVersion(), MessageContext.IDENTITY);
        expectedResponse.setThrottleTimeMs(0);
        this.testAllMessageRoundTripsBeforeVersion((short)1, (Message)responseWithGroupInstanceId, (Message)expectedResponse);
    }

    @Test
    public void testOffsetForLeaderEpochVersions() throws Exception {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataNoCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(0).setLeaderEpoch(3);
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataWithCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(0).setLeaderEpoch(3).setCurrentLeaderEpoch(5);
        OffsetForLeaderEpochRequestData data = new OffsetForLeaderEpochRequestData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic("foo").setPartitions(Collections.singletonList(partitionDataNoCurrentEpoch)));
        this.testAllMessageRoundTrips((Message)data);
        this.testAllMessageRoundTripsBeforeVersion((short)2, (Message)partitionDataWithCurrentEpoch, (Message)partitionDataNoCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)partitionDataWithCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5));
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData());
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData().setReplicaId(-2));
    }

    @Test
    public void testLeaderAndIsrVersions() throws Exception {
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateNoAddingRemovingReplicas = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Collections.singletonList(0))));
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateWithAddingRemovingReplicas = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Collections.singletonList(0)).setAddingReplicas(Collections.singletonList(1)).setRemovingReplicas(Collections.singletonList(1))));
        this.testAllMessageRoundTripsBetweenVersions((short)2, (short)3, (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithAddingRemovingReplicas)), (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateNoAddingRemovingReplicas)));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithAddingRemovingReplicas)));
    }

    @Test
    public void testLeaderAndIsrRequestWithObserversGroupedTopics() throws Exception {
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateWithObserver = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Arrays.asList(0, 1, 2)).setObservers(Collections.singletonList(2))));
        LeaderAndIsrRequestData leaderAndIsrRequestDataWithObservers = new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithObserver));
        LeaderAndIsrRequestData.LeaderAndIsrTopicState partitionStateWithoutObserver = new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName("topic").setPartitionStates(Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(0).setReplicas(Arrays.asList(0, 1, 2))));
        LeaderAndIsrRequestData leaderAndIsrRequestDataWithoutObservers = new LeaderAndIsrRequestData().setTopicStates(Collections.singletonList(partitionStateWithoutObserver));
        this.testAllMessageRoundTripsBetweenVersions((short)2, (short)4, (Message)leaderAndIsrRequestDataWithObservers, (Message)leaderAndIsrRequestDataWithoutObservers);
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)leaderAndIsrRequestDataWithObservers);
    }

    @Test
    public void testLeaderAndIsrRequestWithObserversUngroupedTopics() throws Exception {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionStateWithObserver = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic").setPartitionIndex(0).setReplicas(Arrays.asList(0, 1, 2)).setObservers(Collections.singletonList(2));
        LeaderAndIsrRequestData leaderAndIsrRequestDataWithObservers = new LeaderAndIsrRequestData().setUngroupedPartitionStates(Collections.singletonList(partitionStateWithObserver));
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionStateWithoutObserver = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic").setPartitionIndex(0).setReplicas(Arrays.asList(0, 1, 2));
        LeaderAndIsrRequestData leaderAndIsrRequestDataWithoutObservers = new LeaderAndIsrRequestData().setUngroupedPartitionStates(Collections.singletonList(partitionStateWithoutObserver));
        this.testAllMessageRoundTripsBetweenVersions((short)0, (short)2, (Message)leaderAndIsrRequestDataWithObservers, (Message)leaderAndIsrRequestDataWithoutObservers);
    }

    @Test
    public void testAlterPartitionReassignmentRequestWithObservers() throws Exception {
        AlterPartitionReassignmentsRequestData.ReassignablePartition reassignablePartition = new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6)).setObservers(Arrays.asList(4, 5, 6));
        AlterPartitionReassignmentsRequestData.ReassignableTopic reassignableTopic = new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName("topic-0").setPartitions(Collections.singletonList(reassignablePartition));
        AlterPartitionReassignmentsRequestData requestWithObservers = new AlterPartitionReassignmentsRequestData().setTopics(Collections.singletonList(reassignableTopic)).setTimeoutMs(60000);
        this.testAllMessageRoundTrips((Message)requestWithObservers);
    }

    @Test
    public void testAlterPartitionReassignmentRequestWithoutObservers() throws Exception {
        AlterPartitionReassignmentsRequestData.ReassignablePartition reassignablePartition = new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
        AlterPartitionReassignmentsRequestData.ReassignableTopic reassignableTopic = new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName("topic-0").setPartitions(Collections.singletonList(reassignablePartition));
        AlterPartitionReassignmentsRequestData requestWithoutObservers = new AlterPartitionReassignmentsRequestData().setTopics(Collections.singletonList(reassignableTopic)).setTimeoutMs(60000);
        this.testAllMessageRoundTrips((Message)requestWithoutObservers);
    }

    @Test
    public void testMetadataResponseResultWithObservers() throws Exception {
        MetadataResponseData.MetadataResponsePartition responsePartitionWithObserver = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(0).setReplicaNodes(Arrays.asList(1, 2, 3, 4, 5, 6)).setIsrNodes(Arrays.asList(1, 2, 3)).setLeaderId(1).setObservers(Arrays.asList(4, 5, 6));
        MetadataResponseData.MetadataResponseTopic responseTopicWithObserver = new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName("topic-0").setIsInternal(false).setPartitions(Collections.singletonList(responsePartitionWithObserver));
        MetadataResponseData.MetadataResponseTopicCollection responseTopicCollectionWithObserver = new MetadataResponseData.MetadataResponseTopicCollection(Collections.singletonList(responseTopicWithObserver).iterator());
        MetadataResponseData metadataResponseDataWithObservers = new MetadataResponseData().setTopics(responseTopicCollectionWithObserver);
        MetadataResponseData.MetadataResponsePartition responsePartitionWithoutObserver = new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(0).setReplicaNodes(Arrays.asList(1, 2, 3, 4, 5, 6)).setIsrNodes(Arrays.asList(1, 2, 3)).setLeaderId(1);
        MetadataResponseData.MetadataResponseTopic responseTopicWithoutObserver = new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName("topic-0").setIsInternal(false).setPartitions(Collections.singletonList(responsePartitionWithoutObserver));
        MetadataResponseData.MetadataResponseTopicCollection responseTopicCollectionWithoutObserver = new MetadataResponseData.MetadataResponseTopicCollection(Collections.singletonList(responseTopicWithoutObserver).iterator());
        MetadataResponseData metadataResponseDataWithoutObservers = new MetadataResponseData().setTopics(responseTopicCollectionWithoutObserver);
        this.testAllMessageRoundTripsBetweenVersions((short)0, (short)9, (Message)metadataResponseDataWithObservers, (Message)metadataResponseDataWithoutObservers);
        this.testAllMessageRoundTripsFromVersion((short)9, (Message)metadataResponseDataWithObservers);
    }

    @Test
    public void testUpdateMetadataRequestWithObserversGroupedTopics() throws Exception {
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionWithObserver = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2)).setOfflineReplicas(Arrays.asList(2)).setObservers(Arrays.asList(2));
        UpdateMetadataRequestData.UpdateMetadataTopicState topicWithObserver = new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName("topic-0").setPartitionStates(Arrays.asList(partitionWithObserver));
        UpdateMetadataRequestData updateMetadataWithObservers = new UpdateMetadataRequestData().setTopicStates(Arrays.asList(topicWithObserver));
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionWithoutObserver = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2)).setOfflineReplicas(Arrays.asList(2));
        UpdateMetadataRequestData.UpdateMetadataTopicState topicWithoutObserver = new UpdateMetadataRequestData.UpdateMetadataTopicState().setTopicName("topic-0").setPartitionStates(Arrays.asList(partitionWithoutObserver));
        UpdateMetadataRequestData updateMetadataWithoutObservers = new UpdateMetadataRequestData().setTopicStates(Arrays.asList(topicWithoutObserver));
        this.testAllMessageRoundTripsBetweenVersions((short)5, (short)6, (Message)updateMetadataWithObservers, (Message)updateMetadataWithoutObservers);
        this.testAllMessageRoundTripsFromVersion((short)6, (Message)updateMetadataWithObservers);
    }

    @Test
    public void testUpdateMetadataRequestWithObserversUngroupedTopics() throws Exception {
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionWithObserver = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic-0").setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2)).setObservers(Arrays.asList(2));
        UpdateMetadataRequestData updateMetadataWithObservers = new UpdateMetadataRequestData().setUngroupedPartitionStates(Collections.singletonList(partitionWithObserver));
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionWithoutObserver = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic-0").setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2));
        UpdateMetadataRequestData updateMetadataWithoutObservers = new UpdateMetadataRequestData().setUngroupedPartitionStates(Collections.singletonList(partitionWithoutObserver));
        this.testAllMessageRoundTripsBetweenVersions((short)0, (short)5, (Message)updateMetadataWithObservers, (Message)updateMetadataWithoutObservers);
    }

    @Test
    public void testOffsetCommitRequestVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        String metadata = "metadata";
        int partition = 2;
        int offset = 100;
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setGroupId(groupId).setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedMetadata(metadata).setCommittedOffset((long)offset))))));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId(groupId).setMemberId("memberId").setGroupInstanceId("instanceId").setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedLeaderEpoch(10).setCommittedMetadata(metadata).setCommittedOffset((long)offset).setCommitTimestamp(20L))))).setRetentionTimeMs(20L);
        Iterator iterator = ApiKeys.OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            OffsetCommitRequestData requestData = request.get();
            if (version < 1) {
                requestData.setMemberId("");
                requestData.setGenerationIdOrMemberEpoch(-1);
            }
            if (version != 1) {
                ((OffsetCommitRequestData.OffsetCommitRequestPartition)((OffsetCommitRequestData.OffsetCommitRequestTopic)requestData.topics().get(0)).partitions().get(0)).setCommitTimestamp(-1L);
            }
            if (version < 2 || version > 4) {
                requestData.setRetentionTimeMs(-1L);
            }
            if (version < 6) {
                ((OffsetCommitRequestData.OffsetCommitRequestPartition)((OffsetCommitRequestData.OffsetCommitRequestTopic)requestData.topics().get(0)).partitions().get(0)).setCommittedLeaderEpoch(-1);
            }
            if (version < 7) {
                requestData.setGroupInstanceId(null);
            }
            if (version == 1) {
                this.testEquivalentMessageRoundTrip(version, (Message)requestData);
                continue;
            }
            if (version >= 2 && version <= 4) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)5, (Message)requestData, (Message)requestData);
                continue;
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)requestData);
        }
    }

    @Test
    public void testOffsetCommitResponseVersions() throws Exception {
        Supplier<OffsetCommitResponseData> response = () -> new OffsetCommitResponseData().setTopics(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))))).setThrottleTimeMs(20);
        Iterator iterator = ApiKeys.OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            OffsetCommitResponseData responseData = response.get();
            if (version < 3) {
                responseData.setThrottleTimeMs(0);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)responseData);
        }
    }

    @Test
    public void testTxnOffsetCommitRequestVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        String metadata = "metadata";
        String txnId = "transactionalId";
        int producerId = 25;
        short producerEpoch = 10;
        String instanceId = "instance";
        String memberId = "member";
        int generationId = 1;
        int partition = 2;
        int offset = 100;
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId((long)producerId).setProducerEpoch(producerEpoch).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedMetadata(metadata).setCommittedOffset((long)offset))))));
        Supplier<TxnOffsetCommitRequestData> request = () -> new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId((long)producerId).setProducerEpoch(producerEpoch).setGroupInstanceId(instanceId).setMemberId(memberId).setGenerationId(generationId).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedLeaderEpoch(10).setCommittedMetadata(metadata).setCommittedOffset((long)offset)))));
        Iterator iterator = ApiKeys.TXN_OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            TxnOffsetCommitRequestData requestData = request.get();
            if (version < 2) {
                ((TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition)((TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic)requestData.topics().get(0)).partitions().get(0)).setCommittedLeaderEpoch(-1);
            }
            if (version < 3) {
                short finalVersion = version;
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setGroupInstanceId(null);
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setMemberId("");
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setGenerationId(-1);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)requestData);
        }
    }

    @Test
    public void testTxnOffsetCommitResponseVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))))).setThrottleTimeMs(20));
    }

    @Test
    public void testOffsetFetchV0ToV7() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        List<OffsetFetchRequestData.OffsetFetchRequestTopic> topics = Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopic().setName(topicName).setPartitionIndexes(Collections.singletonList(5)));
        this.testAllMessageRoundTripsOffsetFetchV0ToV7((Message)new OffsetFetchRequestData().setTopics(new ArrayList()).setGroupId(groupId));
        this.testAllMessageRoundTripsOffsetFetchV0ToV7((Message)new OffsetFetchRequestData().setGroupId(groupId).setTopics(topics));
        OffsetFetchRequestData allPartitionData = new OffsetFetchRequestData().setGroupId(groupId).setTopics(null);
        OffsetFetchRequestData requireStableData = new OffsetFetchRequestData().setGroupId(groupId).setTopics(topics).setRequireStable(true);
        for (int version : this.listOfVersionsNonBatchOffsetFetch) {
            short finalVersion = (short)version;
            if (version < 2) {
                Assertions.assertThrows(NullPointerException.class, () -> this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(finalVersion, (Message)allPartitionData));
            } else {
                this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7((short)version, (Message)allPartitionData);
            }
            if (version < 7) {
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(finalVersion, (Message)requireStableData));
                continue;
            }
            this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(finalVersion, (Message)requireStableData);
        }
        Supplier<OffsetFetchResponseData> response = () -> new OffsetFetchResponseData().setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topicName).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(5).setMetadata(null).setCommittedOffset(100L).setCommittedLeaderEpoch(3).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()))))).setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10);
        for (int version : this.listOfVersionsNonBatchOffsetFetch) {
            OffsetFetchResponseData responseData = response.get();
            if (version <= 1) {
                responseData.setErrorCode(Errors.NONE.code());
            }
            if (version <= 2) {
                responseData.setThrottleTimeMs(0);
            }
            if (version <= 4) {
                ((OffsetFetchResponseData.OffsetFetchResponsePartition)((OffsetFetchResponseData.OffsetFetchResponseTopic)responseData.topics().get(0)).partitions().get(0)).setCommittedLeaderEpoch(-1);
            }
            this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7((short)version, (Message)responseData);
        }
    }

    private void testAllMessageRoundTripsOffsetFetchV0ToV7(Message message) throws Exception {
        this.testDuplication(message);
        this.testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(message.lowestSupportedVersion(), message);
    }

    private void testAllMessageRoundTripsOffsetFetchFromVersionV0ToV7(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version <= 7; version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    @Test
    public void testOffsetFetchV8AndAboveSingleGroup() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> topic = Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topicName).setPartitionIndexes(Collections.singletonList(5)));
        OffsetFetchRequestData allPartitionData = new OffsetFetchRequestData().setGroups(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId).setTopics(null)));
        OffsetFetchRequestData specifiedPartitionData = new OffsetFetchRequestData().setGroups(Collections.singletonList(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId).setTopics(topic))).setRequireStable(true);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)allPartitionData);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)specifiedPartitionData);
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version < 8) continue;
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)specifiedPartitionData);
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)allPartitionData);
        }
        Supplier<OffsetFetchResponseData> response = () -> new OffsetFetchResponseData().setGroups(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponseTopics().setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setMetadata(null).setCommittedOffset(100L).setCommittedLeaderEpoch(3).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()))))).setErrorCode(Errors.NOT_COORDINATOR.code()))).setThrottleTimeMs(10);
        Iterator iterator2 = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator2.hasNext()) {
            short version = (Short)iterator2.next();
            if (version < 8) continue;
            OffsetFetchResponseData responseData = response.get();
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)responseData);
        }
    }

    @Test
    public void testOffsetFetchV8AndAbove() throws Exception {
        String groupOne = "group1";
        String groupTwo = "group2";
        String groupThree = "group3";
        String groupFour = "group4";
        String groupFive = "group5";
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        OffsetFetchRequestData.OffsetFetchRequestTopics topicOne = new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topic1).setPartitionIndexes(Collections.singletonList(5));
        OffsetFetchRequestData.OffsetFetchRequestTopics topicTwo = new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topic2).setPartitionIndexes(Collections.singletonList(10));
        OffsetFetchRequestData.OffsetFetchRequestTopics topicThree = new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(topic3).setPartitionIndexes(Collections.singletonList(15));
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> groupOneTopics = Collections.singletonList(topicOne);
        OffsetFetchRequestData.OffsetFetchRequestGroup group1 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupOne).setTopics(groupOneTopics);
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> groupTwoTopics = Arrays.asList(topicOne, topicTwo);
        OffsetFetchRequestData.OffsetFetchRequestGroup group2 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupTwo).setTopics(groupTwoTopics);
        List<OffsetFetchRequestData.OffsetFetchRequestTopics> groupThreeTopics = Arrays.asList(topicOne, topicTwo, topicThree);
        OffsetFetchRequestData.OffsetFetchRequestGroup group3 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupThree).setTopics(groupThreeTopics);
        OffsetFetchRequestData.OffsetFetchRequestGroup group4 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupFour).setTopics(null);
        OffsetFetchRequestData.OffsetFetchRequestGroup group5 = new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupFive).setTopics(null);
        OffsetFetchRequestData requestData = new OffsetFetchRequestData().setGroups(Arrays.asList(group1, group2, group3, group4, group5)).setRequireStable(true);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)requestData);
        this.testAllMessageRoundTripsOffsetFetchV8AndAbove((Message)requestData.setRequireStable(false));
        Iterator iterator = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version < 8) continue;
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)requestData);
        }
        OffsetFetchResponseData.OffsetFetchResponseTopics responseTopic1 = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic1).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setMetadata(null).setCommittedOffset(100L).setCommittedLeaderEpoch(3).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code())));
        OffsetFetchResponseData.OffsetFetchResponseTopics responseTopic2 = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic2).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(10).setMetadata("foo").setCommittedOffset(200L).setCommittedLeaderEpoch(2).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code())));
        OffsetFetchResponseData.OffsetFetchResponseTopics responseTopic3 = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic3).setPartitions(Collections.singletonList(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(15).setMetadata("bar").setCommittedOffset(300L).setCommittedLeaderEpoch(1).setErrorCode(Errors.GROUP_AUTHORIZATION_FAILED.code())));
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup1 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupOne).setTopics(Collections.singletonList(responseTopic1)).setErrorCode(Errors.NOT_COORDINATOR.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup2 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupTwo).setTopics(Arrays.asList(responseTopic1, responseTopic2)).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup3 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupThree).setTopics(Arrays.asList(responseTopic1, responseTopic2, responseTopic3)).setErrorCode(Errors.NONE.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup4 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupFour).setTopics(Arrays.asList(responseTopic1, responseTopic2, responseTopic3)).setErrorCode(Errors.NONE.code());
        OffsetFetchResponseData.OffsetFetchResponseGroup responseGroup5 = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupFive).setTopics(Arrays.asList(responseTopic1, responseTopic2, responseTopic3)).setErrorCode(Errors.NONE.code());
        Supplier<OffsetFetchResponseData> response = () -> new OffsetFetchResponseData().setGroups(Arrays.asList(responseGroup1, responseGroup2, responseGroup3, responseGroup4, responseGroup5)).setThrottleTimeMs(10);
        Iterator iterator2 = ApiKeys.OFFSET_FETCH.allVersions().iterator();
        while (iterator2.hasNext()) {
            short version = (Short)iterator2.next();
            if (version < 8) continue;
            OffsetFetchResponseData responseData = response.get();
            this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(version, (Message)responseData);
        }
    }

    private void testAllMessageRoundTripsOffsetFetchV8AndAbove(Message message) throws Exception {
        this.testDuplication(message);
        this.testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove((short)8, message);
    }

    private void testAllMessageRoundTripsOffsetFetchFromVersionV8AndAbove(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version <= message.highestSupportedVersion(); version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    @Test
    public void testProduceResponseVersions() throws Exception {
        String topicName = "topic";
        int partitionIndex = 0;
        short errorCode = Errors.INVALID_TOPIC_EXCEPTION.code();
        long baseOffset = 12L;
        int throttleTimeMs = 1234;
        long logAppendTimeMs = 1234L;
        long logStartOffset = 1234L;
        int batchIndex = 0;
        String batchIndexErrorMessage = "error message";
        String errorMessage = "global error message";
        this.testAllMessageRoundTrips((Message)new ProduceResponseData().setResponses(new ProduceResponseData.TopicProduceResponseCollection(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setName(topicName).setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset)))).iterator())));
        Supplier<ProduceResponseData> response = () -> new ProduceResponseData().setResponses(new ProduceResponseData.TopicProduceResponseCollection(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setName(topicName).setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset).setLogAppendTimeMs(logAppendTimeMs).setLogStartOffset(logStartOffset).setRecordErrors(Collections.singletonList(new ProduceResponseData.BatchIndexAndErrorMessage().setBatchIndex(batchIndex).setBatchIndexErrorMessage(batchIndexErrorMessage))).setErrorMessage(errorMessage)))).iterator())).setThrottleTimeMs(throttleTimeMs);
        Iterator iterator = ApiKeys.PRODUCE.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ProduceResponseData responseData = response.get();
            if (version < 8) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setRecordErrors(Collections.emptyList());
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setErrorMessage(null);
            }
            if (version < 5) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setLogStartOffset(-1L);
            }
            if (version < 2) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setLogAppendTimeMs(-1L);
            }
            if (version < 1) {
                responseData.setThrottleTimeMs(0);
            }
            if (version >= 3 && version <= 4) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)5, (Message)responseData, (Message)responseData);
                continue;
            }
            if (version >= 6 && version <= 7) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)8, (Message)responseData, (Message)responseData);
                continue;
            }
            this.testEquivalentMessageRoundTrip(version, (Message)responseData);
        }
    }

    @Test
    public void defaultValueShouldBeWritable() {
        for (short version = 0; version <= 2; version = (short)(version + 1)) {
            MessageUtil.toByteBuffer((Message)new SimpleExampleMessageData(), (short)version);
        }
    }

    @Test
    public void testSimpleMessage() throws Exception {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.setMyStruct(new SimpleExampleMessageData.MyStruct().setStructId(25).setArrayInStruct(Collections.singletonList(new SimpleExampleMessageData.StructArray().setArrayFieldId(20))));
        message.setMyTaggedStruct(new SimpleExampleMessageData.TaggedStruct().setStructId("abc"));
        message.setProcessId(Uuid.randomUuid());
        message.setMyNullableString("notNull");
        message.setMyInt16((short)3);
        message.setMyString("test string");
        SimpleExampleMessageData duplicate = message.duplicate();
        Assertions.assertEquals((Object)duplicate, (Object)message);
        Assertions.assertEquals((Object)message, (Object)duplicate);
        duplicate.setMyTaggedIntArray(Collections.singletonList(123));
        Assertions.assertNotEquals((Object)duplicate, (Object)message);
        Assertions.assertNotEquals((Object)message, (Object)duplicate);
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)message);
    }

    @Test
    public void testListReassignmentResultWithObservers() throws Exception {
        ListPartitionReassignmentsResponseData.OngoingPartitionReassignment reassignmentWithObservers = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6)).setObservers(Arrays.asList(4, 5, 6));
        ListPartitionReassignmentsResponseData responseWithObservers = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.NONE.code()).setTopics(Collections.singletonList(new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("topic").setPartitions(Collections.singletonList(reassignmentWithObservers))));
        this.testAllMessageRoundTrips((Message)responseWithObservers);
    }

    @Test
    public void testListReassignmentResultWithoutObservers() throws Exception {
        ListPartitionReassignmentsResponseData.OngoingPartitionReassignment reassignmentWithoutObservers = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
        Assertions.assertEquals(Collections.emptyList(), (Object)reassignmentWithoutObservers.observers());
        ListPartitionReassignmentsResponseData responseWithoutObservers = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.NONE.code()).setTopics(Collections.singletonList(new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("topic").setPartitions(Collections.singletonList(reassignmentWithoutObservers))));
        this.testAllMessageRoundTrips((Message)responseWithoutObservers);
    }

    private void testAllMessageRoundTrips(Message message) throws Exception {
        this.testDuplication(message);
        this.testAllMessageRoundTripsFromVersion(message.lowestSupportedVersion(), message);
    }

    private void testDuplication(Message message) {
        Message duplicate = message.duplicate();
        Assertions.assertEquals((Object)duplicate, (Object)message);
        Assertions.assertEquals((Object)message, (Object)duplicate);
        Assertions.assertEquals((int)duplicate.hashCode(), (int)message.hashCode());
        Assertions.assertEquals((int)message.hashCode(), (int)duplicate.hashCode());
    }

    private void testAllMessageRoundTripsBeforeVersion(short beforeVersion, Message message, Message expected) throws Exception {
        this.testAllMessageRoundTripsBetweenVersions((short)0, beforeVersion, message, expected);
    }

    private void testAllMessageRoundTripsBetweenVersions(short startVersion, short endVersion, Message message, Message expected) throws Exception {
        for (short version = startVersion; version < endVersion; version = (short)(version + 1)) {
            this.testMessageRoundTrip(version, message, expected);
        }
    }

    private void testAllMessageRoundTripsFromVersion(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version <= message.highestSupportedVersion(); version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testAllMessageRoundTripsUntilVersion(short untilVersion, Message message) throws Exception {
        for (short version = message.lowestSupportedVersion(); version <= untilVersion; version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testMessageRoundTrip(short version, Message message, Message expected) throws Exception {
        this.testByteBufferRoundTrip(version, message, expected);
    }

    private void testEquivalentMessageRoundTrip(short version, Message message) throws Exception {
        this.testByteBufferRoundTrip(version, message, message);
        this.testJsonRoundTrip(version, message, message);
    }

    private void testByteBufferRoundTrip(short version, Message message, Message expected) throws Exception {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("The result of the size function does not match the number of bytes written for version " + version));
        Message message2 = (Message)message.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        buf.flip();
        message2.read((Readable)byteBufferAccessor, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("The result of the size function does not match the number of bytes read back in for version " + version));
        Assertions.assertEquals((Object)expected, (Object)message2, (String)("The message object created after a round trip did not match for version " + version));
        Assertions.assertEquals((int)expected.hashCode(), (int)message2.hashCode());
        Assertions.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private void testJsonRoundTrip(short version, Message message, Message expected) throws Exception {
        String jsonConverter = MessageTest.jsonConverterTypeName(message.getClass().getTypeName());
        Class<?> converter = Class.forName(jsonConverter);
        Method writeMethod = converter.getMethod("write", message.getClass(), Short.TYPE);
        JsonNode jsonNode = (JsonNode)writeMethod.invoke(null, message, version);
        Method readMethod = converter.getMethod("read", JsonNode.class, Short.TYPE);
        Message message2 = (Message)readMethod.invoke(null, jsonNode, version);
        Assertions.assertEquals((Object)expected, (Object)message2);
        Assertions.assertEquals((int)expected.hashCode(), (int)message2.hashCode());
        Assertions.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private static String jsonConverterTypeName(String source) {
        int outerClassIndex = source.lastIndexOf(36);
        if (outerClassIndex == -1) {
            return source + "JsonConverter";
        }
        return source.substring(0, outerClassIndex) + "JsonConverter$" + source.substring(outerClassIndex + 1) + "JsonConverter";
    }

    @Test
    public void testMessageVersions() {
        for (ApiKeys apiKey : ApiKeys.values()) {
            ApiMessage message = null;
            try {
                message = ApiMessageType.fromApiKey((short)apiKey.id).newRequest();
            }
            catch (UnsupportedVersionException e) {
                Assertions.fail((String)("No request message spec found for API " + apiKey));
            }
            Assertions.assertTrue((apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0, (String)("Request message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()));
            try {
                message = ApiMessageType.fromApiKey((short)apiKey.id).newResponse();
            }
            catch (UnsupportedVersionException e) {
                Assertions.fail((String)("No response message spec found for API " + apiKey));
            }
            Assertions.assertTrue((apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0, (String)("Response message spec for " + apiKey + " only supports versions up to " + message.highestSupportedVersion()));
        }
    }

    @Test
    public void testDefaultValues() {
        this.verifyWriteRaisesUve((short)0, "validateOnly", (Message)new CreateTopicsRequestData().setValidateOnly(true));
        this.verifyWriteSucceeds((short)0, (Message)new CreateTopicsRequestData().setValidateOnly(false));
        this.verifyWriteSucceeds((short)0, (Message)new OffsetCommitRequestData().setRetentionTimeMs(123L));
        this.verifyWriteRaisesUve((short)5, "forgotten", (Message)new FetchRequestData().setForgottenTopicsData(Collections.singletonList(new FetchRequestData.ForgottenTopic().setTopic("foo"))));
    }

    @Test
    public void testNonIgnorableFieldWithDefaultNull() {
        this.verifyWriteRaisesUve((short)0, "groupInstanceId", (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId("instanceId"));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId(null));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId"));
    }

    @Test
    public void testWriteNullForNonNullableFieldRaisesException() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData().setTopics(null);
        Iterator iterator = ApiKeys.CREATE_TOPICS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            this.verifyWriteRaisesNpe(version, (Message)createTopics);
        }
        MetadataRequestData metadata = new MetadataRequestData().setTopics(null);
        this.verifyWriteRaisesNpe((short)0, (Message)metadata);
    }

    @Test
    public void testUnknownTaggedFields() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
        RawTaggedField field1000 = new RawTaggedField(1000, new byte[]{1, 2, 3});
        createTopics.unknownTaggedFields().add(field1000);
        this.verifyWriteRaisesUve((short)0, "Tagged fields were set", (Message)createTopics);
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
    }

    @Test
    public void testAlterPartitionReassignmentWithObservers() throws Exception {
        AlterPartitionReassignmentsRequestData.ReassignablePartition partition = new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3)).setObservers(Arrays.asList(3));
        AlterPartitionReassignmentsRequestData.ReassignableTopic topic = new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName("topic").setPartitions(Arrays.asList(partition));
        AlterPartitionReassignmentsRequestData data = new AlterPartitionReassignmentsRequestData().setTopics(Arrays.asList(topic));
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testInitiateShutdownRequest() throws Exception {
        InitiateShutdownRequestData data = new InitiateShutdownRequestData().setBrokerEpoch(1L);
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testInitiateShutdownResponse() throws Exception {
        InitiateShutdownResponseData data = new InitiateShutdownResponseData().setErrorCode(Errors.STALE_BROKER_EPOCH.code()).setErrorMessage("error");
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testAlterPartitionReassignmentWithoutObservers() throws Exception {
        AlterPartitionReassignmentsRequestData.ReassignablePartition partition = new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2, 3));
        AlterPartitionReassignmentsRequestData.ReassignableTopic topic = new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName("topic").setPartitions(Arrays.asList(partition));
        AlterPartitionReassignmentsRequestData data = new AlterPartitionReassignmentsRequestData().setTopics(Arrays.asList(topic));
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testTriggerEvenClusterLoadRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new TriggerEvenClusterLoadRequestData());
    }

    @Test
    public void testTriggerEvenClusterLoadResponse() throws Exception {
        Supplier<TriggerEvenClusterLoadResponseData> response = () -> new TriggerEvenClusterLoadResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("Not controller node!").setThrottleTimeMs(10);
        this.testAllMessageRoundTrips((Message)response.get());
    }

    @Test
    public void testComputeEvenClusterLoadPlanRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new ComputeEvenClusterLoadPlanRequestData());
    }

    @Test
    public void testComputeEvenClusterLoadPlanResponse() throws Exception {
        Supplier<ComputeEvenClusterLoadPlanResponseData> response = () -> new ComputeEvenClusterLoadPlanResponseData().setThrottleTimeMs(10).setInterBrokerMoves(14).setInterBrokerMovesMB(34858.0).setLeadershipMoves(12).setRecentWindows(6).setPartitionCoveragePercent(100.0).setNewBrokers(Arrays.asList(5, 7)).setDeadOrRemovedBrokers(Arrays.asList(1, 3)).setViolatedGoalsBeforeOptimization(Arrays.asList("LeaderBytesInDistributionGoal", "NetworkInboundUsageDistributionGoal", "CpuUsageDistributionGoal", "DiskUsageDistributionGoal", "NetworkOutboundUsageDistributionGoal")).setViolatedGoalsAfterOptimization(Arrays.asList("CpuUsageDistributionGoal")).setMovementGeneratingGoals(Arrays.asList("LeaderBytesInDistributionGoal", "NetworkInboundUsageDistributionGoal", "CpuUsageDistributionGoal", "DiskUsageDistributionGoal", "NetworkOutboundUsageDistributionGoal")).setExcludedTopics(Arrays.asList("lkc-*****__confluent-healthcheck_362")).setBrokersExcludedForLeadership(Arrays.asList(0, 3)).setBrokersExcludedForReplicaMove(Arrays.asList(6, 7, 8, 9, 10, 11)).setTotalBrokers(18).setTotalReplicas(947).setTotalTopics(19).setBalancednessScorePreRebalance(83.842).setBalancednessScorePostRebalance(97.115).setGoalStats(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.GoalStat().setGoalName("DiskUsageDistributionGoal").setAvgResources(new ComputeEvenClusterLoadPlanResponseData.AvgResources().setCpuPercent(28.835).setNetworkInboundKBps(28240.951).setNetworkOutboundKBps(27849.211).setDiskMB(45366.01).setPotentialNwOutKBps(87839.004).setReplicas(158).setLeaderReplicas(52).setTopicReplicas(8)).setMaxResources(new ComputeEvenClusterLoadPlanResponseData.MaxResources().setCpuPercent(34.145).setNetworkInboundKBps(32054.334).setNetworkOutboundKBps(34599.855).setDiskMB(54622.617).setPotentialNwOutKBps(95007.256).setReplicas(173).setLeaderReplicas(58).setTopicReplicas(50)).setMinResources(new ComputeEvenClusterLoadPlanResponseData.MinResources().setCpuPercent(23.694).setNetworkInboundKBps(23647.879).setNetworkOutboundKBps(23185.646).setDiskMB(35209.719).setPotentialNwOutKBps(75145.148).setReplicas(143).setLeaderReplicas(47).setTopicReplicas(0)).setStdResources(new ComputeEvenClusterLoadPlanResponseData.StdResources().setCpuPercent(3.796).setNetworkInboundKBps(2818.515).setNetworkOutboundKBps(3707.753).setDiskMB(8347.475).setPotentialNwOutKBps(6810.038).setReplicas(14).setLeaderReplicas(5).setTopicReplicas(6)).setGoalOverview(new ComputeEvenClusterLoadPlanResponseData.GoalOverview().setGoalStatus("NO-ACTION").setProposalsGenerated(0).setProposalsRejected(0).setProposalsRejectedPercent(0.0).setProposalsAccepted(0).setProposalsAcceptedPercent(0.0).setMoves(0).setSwaps(0).setRejectingGoals(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.RejectingGoal().setGoalName("ReplicaDistributionGoal").setProposalsRejected(543), new ComputeEvenClusterLoadPlanResponseData.RejectingGoal().setGoalName("RackAwareGoal").setProposalsRejected(247)))))).setClusterLoadPreRebalance(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(0).setHost("host1").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15), new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(1).setHost("host2").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15))).setClusterLoadPostRebalance(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(0).setHost("host1").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15), new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(1).setHost("host2").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15)));
        this.testAllMessageRoundTrips((Message)response.get());
    }

    @Test
    public void testComputeEvenClusterLoadPlanResponseWhenNotControllerNode() throws Exception {
        Supplier<ComputeEvenClusterLoadPlanResponseData> response = () -> new ComputeEvenClusterLoadPlanResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("Not controller node!").setThrottleTimeMs(10);
        this.testAllMessageRoundTrips((Message)response.get());
    }

    @Test
    public void testRemoveBrokers() throws Exception {
        RemoveBrokersRequestData.BrokerId brokerId = new RemoveBrokersRequestData.BrokerId().setBrokerId(1);
        RemoveBrokersRequestData data = new RemoveBrokersRequestData().setBrokersToRemove(Collections.singletonList(brokerId)).setTimeoutMs(100);
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testDescribeBrokerRemovalsRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeBrokerRemovalsRequestData());
    }

    @Test
    public void testDescribeBrokerRemovalsResponse() throws Exception {
        Supplier<DescribeBrokerRemovalsResponseData> response = () -> new DescribeBrokerRemovalsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("err!").setThrottleTimeMs(11).setRemovedBrokers(Arrays.asList(new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setRemovalErrorCode(Errors.NONE.code()).setBrokerId(0).setBrokerShutdownStatus("PENDING").setPartitionReassignmentsStatus("PENDING").setGeneralOperationStatus("IN_PROGRESS").setReassignmentsStatus("PENDING").setPartitionReassignmentsStatus("FAILED").setCreateTimeMs(10L).setLastUpdateTimeMs(100L), new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setRemovalErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()).setRemovalErrorMessage("plan computation failed!").setBrokerId(1).setBrokerShutdownStatus("COMPLETE").setGeneralOperationStatus("IN_PROGRESS").setReassignmentsStatus("PENDING").setPartitionReassignmentsStatus("FAILED").setCreateTimeMs(10L).setLastUpdateTimeMs(100L)));
        for (short version = 0; version <= ApiKeys.DESCRIBE_BROKER_REMOVALS.latestVersion(); version = (short)(version + 1)) {
            DescribeBrokerRemovalsResponseData expected;
            DescribeBrokerRemovalsResponseData responseData = response.get();
            if (version == 0) {
                expected = response.get();
                for (DescribeBrokerRemovalsResponseData.BrokerRemovalResponse expectedRemovalResponse : expected.removedBrokers()) {
                    expectedRemovalResponse.setGeneralOperationStatus("").setReassignmentsStatus("").setCreateTimeMs(0L).setLastUpdateTimeMs(0L);
                }
                this.testAllMessageRoundTripsBetweenVersions((short)0, (short)1, (Message)responseData, (Message)expected);
                continue;
            }
            if (version <= 1) continue;
            expected = response.get();
            for (DescribeBrokerRemovalsResponseData.BrokerRemovalResponse expectedRemovalResponse : expected.removedBrokers()) {
                expectedRemovalResponse.setPartitionReassignmentsStatus("").setBrokerShutdownStatus("");
            }
            this.testAllMessageRoundTripsBetweenVersions((short)1, ApiKeys.DESCRIBE_BROKER_REMOVALS.latestVersion(), (Message)responseData, (Message)expected);
        }
    }

    @Test
    public void testDescribeBrokerAdditionsRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeBrokerAdditionsRequestData());
    }

    @Test
    public void testDescribeBrokerAdditionsResponse() throws Exception {
        DescribeBrokerAdditionsResponseData data = new DescribeBrokerAdditionsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage("err!").setThrottleTimeMs(11).setBrokerAdditions(Arrays.asList(new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setAdditionErrorCode(Errors.NONE.code()).setBrokerId(0).setCreateTimeMs(11L).setLastUpdateTimeMs(111L).setPartitionReassignmentsStatus("PENDING").setGeneralOperationStatus("IN_PROGRESS"), new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setAdditionErrorCode(Errors.REBALANCE_PLAN_COMPUTATION_FAILED.code()).setAdditionErrorMessage("plan computation failed!").setBrokerId(1).setPartitionReassignmentsStatus("COMPLETE").setGeneralOperationStatus("COMPLETED").setCreateTimeMs(11L).setLastUpdateTimeMs(111L)));
        this.testAllMessageRoundTrips((Message)data);
    }

    public void testLongTaggedString() throws Exception {
        char[] chars = new char[1024];
        Arrays.fill(chars, 'a');
        String longString = new String(chars);
        SimpleExampleMessageData message = new SimpleExampleMessageData().setMyString(longString);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        short version = 1;
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position());
    }

    private void verifyWriteRaisesNpe(short version, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        Assertions.assertThrows(NullPointerException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
    }

    private void verifyWriteRaisesUve(short version, String problemText, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        UnsupportedVersionException e = (UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
        Assertions.assertTrue((boolean)e.getMessage().contains(problemText), (String)("Expected to get an error message about " + problemText + ", but got: " + e.getMessage()));
    }

    private void verifyWriteSucceeds(short version, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size * 2);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("Expected the serialized size to be " + size + ", but it was " + buf.position()));
    }

    @Test
    public void testCompareWithUnknownTaggedFields() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTimeoutMs(123);
        CreateTopicsRequestData createTopics2 = new CreateTopicsRequestData();
        createTopics2.setTimeoutMs(123);
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
        createTopics.unknownTaggedFields();
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
        createTopics.unknownTaggedFields().add(new RawTaggedField(0, new byte[]{0}));
        Assertions.assertNotEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertNotEquals((Object)createTopics2, (Object)createTopics);
        createTopics2.unknownTaggedFields().add(new RawTaggedField(0, new byte[]{0}));
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
    }
}

