/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.TokenBucketTest;
import org.apache.kafka.common.metrics.stats.MinTokenBucket;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MinTokenBucketTest
extends TokenBucketTest {
    private final MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)5.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);

    @Override
    protected TokenBucket tokenBucket() {
        return new MinTokenBucket(-1.7976931348623157E308);
    }

    @Test
    public void testRecordWithMinTokens() {
        MinTokenBucket minBucket = new MinTokenBucket(-10.0);
        Assertions.assertEquals((double)100.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
        minBucket.record(this.config, 105.0, this.time.milliseconds());
        Assertions.assertEquals((double)-5.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
        minBucket.record(this.config, 10.0, this.time.milliseconds());
        Assertions.assertEquals((double)-10.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        Assertions.assertEquals((double)0.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
    }

    @Test
    public void testUnrecordWithMinTokens() {
        MinTokenBucket minBucket = new MinTokenBucket(-10.0);
        Assertions.assertEquals((double)100.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
        minBucket.record(this.config, 120.0, this.time.milliseconds());
        Assertions.assertEquals((double)-10.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
        minBucket.record(this.config, -10.0, this.time.milliseconds());
        Assertions.assertEquals((double)0.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        Assertions.assertEquals((double)10.0, (double)minBucket.measure(this.config, this.time.milliseconds()), (double)0.1);
    }

    @Test
    public void testNonNegativeMinTokenBucketThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MinTokenBucket(0.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MinTokenBucket(1.0));
    }
}

