/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.IntCounterSuite;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntCounterSuiteTest {
    private static final Logger log = LoggerFactory.getLogger(IntCounterSuiteTest.class);

    private static IntCounterSuite<String> createIntGaugeSuite() {
        MetricConfig config = new MetricConfig();
        Metrics metrics = new Metrics(config);
        IntCounterSuite suite = new IntCounterSuite(log, "mySuite", metrics, name -> new MetricName(name, "group", "myMetric", Collections.emptyMap()), 3);
        return suite;
    }

    @Test
    public void testCreateAndClose() {
        IntCounterSuite<String> suite = IntCounterSuiteTest.createIntGaugeSuite();
        Assertions.assertEquals((int)3, (int)suite.maxEntries());
        suite.close();
        suite.close();
        suite.metrics().close();
    }

    @Test
    public void testCreateMetrics() {
        IntCounterSuite<String> suite = IntCounterSuiteTest.createIntGaugeSuite();
        suite.increment((Object)"foo");
        Map values = suite.values();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)values.get("foo")));
        Assertions.assertEquals((int)1, (int)values.size());
        suite.increment((Object)"foo");
        suite.increment((Object)"bar");
        suite.increment((Object)"baz");
        suite.increment((Object)"quux");
        values = suite.values();
        Assertions.assertEquals((Integer)2, (Integer)((Integer)values.get("foo")));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)values.get("bar")));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)values.get("baz")));
        Assertions.assertEquals((int)3, (int)values.size());
        Assertions.assertFalse((boolean)values.containsKey("quux"));
        suite.close();
        suite.metrics().close();
    }

    @Test
    public void testCreateAndRemoveMetrics() {
        IntCounterSuite<String> suite = IntCounterSuiteTest.createIntGaugeSuite();
        suite.increment((Object)"foo");
        suite.decrement((Object)"foo");
        suite.increment((Object)"foo");
        suite.increment((Object)"foo");
        suite.increment((Object)"bar");
        suite.decrement((Object)"bar");
        suite.increment((Object)"baz");
        suite.increment((Object)"quux");
        Map values = suite.values();
        Assertions.assertEquals((Integer)2, (Integer)((Integer)values.get("foo")));
        Assertions.assertFalse((boolean)values.containsKey("bar"));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)values.get("baz")));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)values.get("quux")));
        Assertions.assertEquals((int)3, (int)values.size());
        suite.close();
        suite.metrics().close();
    }
}

