/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioEchoServer
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(NioEchoServer.class);
    private static final double EPS = 1.0E-4;
    private final int port;
    private final ServerSocketChannel serverSocketChannel;
    private final List<SocketChannel> newChannels;
    private final List<SocketChannel> socketChannels;
    private final AcceptorThread acceptorThread;
    private final Selector selector;
    private volatile TransferableChannel outputChannel;
    private final CredentialCache credentialCache;
    private final Metrics metrics;
    private volatile int numSent = 0;
    private volatile boolean closeKafkaChannels;
    private final DelegationTokenCache tokenCache;
    private final Time time;

    public NioEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig config, String serverHost, ChannelBuilder channelBuilder, CredentialCache credentialCache, Time time) throws Exception {
        this(listenerName, securityProtocol, config, serverHost, channelBuilder, credentialCache, 100, time);
    }

    public NioEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig config, String serverHost, ChannelBuilder channelBuilder, CredentialCache credentialCache, int failedAuthenticationDelayMs, Time time) throws Exception {
        this(listenerName, securityProtocol, config, serverHost, channelBuilder, credentialCache, failedAuthenticationDelayMs, time, new DelegationTokenCache(ScramMechanism.mechanismNames()), Optional.empty(), null);
    }

    public NioEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig config, String serverHost, ChannelBuilder channelBuilder, CredentialCache credentialCache, Time time, Optional<AuditLogProvider> auditLogProvider) throws Exception {
        this(listenerName, securityProtocol, config, serverHost, channelBuilder, credentialCache, 100, time, new DelegationTokenCache(ScramMechanism.mechanismNames()), auditLogProvider, null);
    }

    public NioEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig config, String serverHost, ChannelBuilder channelBuilder, CredentialCache credentialCache, int failedAuthenticationDelayMs, Time time, DelegationTokenCache tokenCache, Optional<AuditLogProvider> auditLogProvider, ProxyProtocolEngineFactory proxyProtocolEngineFactory) throws Exception {
        super("echoserver");
        this.setDaemon(true);
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        this.serverSocketChannel.socket().bind(new InetSocketAddress(serverHost, 0));
        this.port = this.serverSocketChannel.socket().getLocalPort();
        this.socketChannels = Collections.synchronizedList(new ArrayList());
        this.newChannels = Collections.synchronizedList(new ArrayList());
        this.credentialCache = credentialCache;
        this.tokenCache = tokenCache;
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            for (String mechanism : ScramMechanism.mechanismNames()) {
                if (credentialCache.cache(mechanism, ScramCredential.class) != null) continue;
                credentialCache.createCache(mechanism, ScramCredential.class);
            }
        }
        LogContext logContext = new LogContext();
        if (channelBuilder == null) {
            channelBuilder = ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (boolean)false, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialCache, (DelegationTokenCache)tokenCache, (Time)time, (LogContext)logContext, () -> TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.ZK_BROKER), (RequestCallback)new DefaultRequestCallbackManager(), (ProxyProtocolEngineFactory)proxyProtocolEngineFactory);
        }
        this.metrics = new Metrics();
        this.selector = new Selector(10000L, failedAuthenticationDelayMs, this.metrics, time, "MetricGroup", channelBuilder, logContext, auditLogProvider, true);
        this.acceptorThread = new AcceptorThread();
        this.time = time;
    }

    public int port() {
        return this.port;
    }

    public CredentialCache credentialCache() {
        return this.credentialCache;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public double metricValue(String name) {
        for (Map.Entry entry : this.metrics.metrics().entrySet()) {
            if (!((MetricName)entry.getKey()).name().equals(name)) continue;
            return (Double)((KafkaMetric)entry.getValue()).metricValue();
        }
        throw new IllegalStateException("Metric not found, " + name + ", found=" + this.metrics.metrics().keySet());
    }

    public double metricValue(String name, String mechanism) {
        for (Map.Entry entry : this.metrics.metrics().entrySet()) {
            if (!((MetricName)entry.getKey()).name().equals(name) || !((MetricName)entry.getKey()).tags().getOrDefault("mechanism", "").equals(mechanism)) continue;
            return (Double)((KafkaMetric)entry.getValue()).metricValue();
        }
        throw new IllegalStateException("Metric not found, " + name + ", found=" + this.metrics.metrics().keySet());
    }

    public void verifyAuthenticationMetrics(int successfulAuthentications, int failedAuthentications) throws InterruptedException {
        this.waitForMetrics("successful-authentication", successfulAuthentications, EnumSet.of(MetricType.TOTAL, MetricType.RATE));
        this.waitForMetrics("failed-authentication", failedAuthentications, EnumSet.of(MetricType.TOTAL, MetricType.RATE));
    }

    public void verifyReauthenticationMetrics(int successfulReauthentications, int failedReauthentications) throws InterruptedException {
        this.waitForMetrics("successful-reauthentication", successfulReauthentications, EnumSet.of(MetricType.TOTAL, MetricType.RATE));
        this.waitForMetrics("failed-reauthentication", failedReauthentications, EnumSet.of(MetricType.TOTAL, MetricType.RATE));
        this.waitForMetrics("successful-authentication-no-reauth", 0.0, EnumSet.of(MetricType.TOTAL));
        if (!(this.time instanceof MockTime)) {
            this.waitForMetrics("reauthentication-latency", Math.signum(successfulReauthentications), EnumSet.of(MetricType.MAX, MetricType.AVG));
        }
    }

    public void verifyAuthenticationMetricsForMechanism(int successfulAuthentications, int failedAuthentications, String mechanism) throws InterruptedException {
        this.verifyAuthenticationMetricsForMechanism(successfulAuthentications, failedAuthentications, mechanism, EnumSet.of(MetricType.TOTAL, MetricType.RATE));
    }

    public void verifyAuthenticationMetricsForMechanism(int successfulAuthentications, int failedAuthentications, String mechanism, Set<MetricType> set) throws InterruptedException {
        this.waitForMetrics("successful-connection-authentications", successfulAuthentications, set, mechanism);
        this.waitForMetrics("failed-connection-authentications", failedAuthentications, set, mechanism);
        if (!(this.time instanceof MockTime)) {
            this.waitForMetrics("authentication-time-ns", Math.signum(successfulAuthentications + failedAuthentications), EnumSet.of(MetricType.MAX, MetricType.AVG), mechanism);
        }
    }

    public void verifyAuthenticationNoReauthMetric(int successfulAuthenticationNoReauths) throws InterruptedException {
        this.waitForMetrics("successful-authentication-no-reauth", successfulAuthenticationNoReauths, EnumSet.of(MetricType.TOTAL));
    }

    public void waitForMetric(String name, double expectedValue) throws InterruptedException {
        this.waitForMetrics(name, expectedValue, EnumSet.of(MetricType.TOTAL, MetricType.RATE));
    }

    public void waitForMetrics(String namePrefix, double expectedValue, Set<MetricType> metricTypes) throws InterruptedException {
        long maxAggregateWaitMs = 15000L;
        long startMs = this.time.milliseconds();
        for (MetricType metricType : metricTypes) {
            long currentElapsedMs = this.time.milliseconds() - startMs;
            long thisMaxWaitMs = maxAggregateWaitMs - currentElapsedMs;
            String metricName = namePrefix + metricType.metricNameSuffix();
            if (expectedValue == 0.0) {
                double expected = expectedValue;
                if (metricType == MetricType.MAX || metricType == MetricType.AVG) {
                    expected = Double.NaN;
                }
                Assertions.assertEquals((double)expected, (double)this.metricValue(metricName), (double)1.0E-4, (String)("Metric not updated " + metricName + " expected:<" + expectedValue + "> but was:<" + this.metricValue(metricName) + ">"));
                continue;
            }
            if (metricType == MetricType.TOTAL) {
                TestUtils.waitForCondition(() -> Math.abs(this.metricValue(metricName) - expectedValue) <= 1.0E-4, thisMaxWaitMs, () -> "Metric not updated " + metricName + " expected:<" + expectedValue + "> but was:<" + this.metricValue(metricName) + ">");
                continue;
            }
            TestUtils.waitForCondition(() -> this.metricValue(metricName) > 0.0, thisMaxWaitMs, () -> "Metric not updated " + metricName + " expected:<a positive number> but was:<" + this.metricValue(metricName) + ">");
        }
    }

    public void waitForMetrics(String namePrefix, double expectedValue, Set<MetricType> metricTypes, String mechanism) throws InterruptedException {
        long maxAggregateWaitMs = 15000L;
        long startMs = this.time.milliseconds();
        for (MetricType metricType : metricTypes) {
            long currentElapsedMs = this.time.milliseconds() - startMs;
            long thisMaxWaitMs = maxAggregateWaitMs - currentElapsedMs;
            String metricName = namePrefix + metricType.metricNameSuffix();
            if (expectedValue == 0.0) {
                Double expected = expectedValue;
                if (metricType == MetricType.MAX || metricType == MetricType.AVG) {
                    expected = Double.NaN;
                }
                Assertions.assertEquals((double)expected, (double)this.metricValue(metricName, mechanism), (double)1.0E-4, (String)("Metric not updated " + metricName + " expected:<" + expectedValue + "> but was:<" + this.metricValue(metricName, mechanism) + ">"));
                continue;
            }
            if (metricType == MetricType.TOTAL) {
                TestUtils.waitForCondition(() -> Math.abs(this.metricValue(metricName, mechanism) - expectedValue) <= 1.0E-4, thisMaxWaitMs, () -> "Metric not updated " + metricName + " expected:<" + expectedValue + "> but was:<" + this.metricValue(metricName, mechanism) + ">");
                continue;
            }
            TestUtils.waitForCondition(() -> this.metricValue(metricName, mechanism) > 0.0, thisMaxWaitMs, () -> "Metric not updated " + metricName + " expected:<a positive number> but was:<" + this.metricValue(metricName, mechanism) + ">");
        }
    }

    protected void poll() throws IOException {
        this.selector.poll(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.acceptorThread.start();
            while (this.serverSocketChannel.isOpen()) {
                this.poll();
                List<SocketChannel> list = this.newChannels;
                synchronized (list) {
                    for (SocketChannel socketChannel : this.newChannels) {
                        String id = this.id(socketChannel);
                        this.selector.register(id, socketChannel);
                        this.socketChannels.add(socketChannel);
                    }
                    this.newChannels.clear();
                }
                if (this.closeKafkaChannels) {
                    for (KafkaChannel channel : this.selector.channels()) {
                        this.selector.close(channel.id());
                    }
                }
                Collection completedReceives = this.selector.completedReceives();
                for (NetworkReceive rcv : completedReceives) {
                    KafkaChannel channel = this.channel(rcv.source());
                    if (NioEchoServer.maybeBeginServerReauthentication(channel, rcv, this.time)) continue;
                    String channelId = channel.id();
                    this.selector.mute(channelId);
                    NetworkSend send = new NetworkSend(rcv.source(), (Send)ByteBufferSend.sizePrefixed((ByteBuffer)rcv.payload()));
                    if (this.outputChannel == null) {
                        this.selector.send(send);
                        continue;
                    }
                    send.writeTo(this.outputChannel);
                    this.selector.unmute(channelId);
                }
                for (NetworkSend send : this.selector.completedSends()) {
                    this.selector.unmute(send.destinationId());
                    ++this.numSent;
                }
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public int numSent() {
        return this.numSent;
    }

    private static boolean maybeBeginServerReauthentication(KafkaChannel channel, NetworkReceive networkReceive, Time time) {
        try {
            if (TestUtils.apiKeyFrom(networkReceive) == ApiKeys.SASL_HANDSHAKE) {
                return channel.maybeBeginServerReauthentication(networkReceive, () -> ((Time)time).nanoseconds());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String id(SocketChannel channel) {
        return channel.socket().getLocalAddress().getHostAddress() + ":" + channel.socket().getLocalPort() + "-" + channel.socket().getInetAddress().getHostAddress() + ":" + channel.socket().getPort();
    }

    private KafkaChannel channel(String id) {
        KafkaChannel channel = this.selector.channel(id);
        return channel == null ? this.selector.closingChannel(id) : channel;
    }

    public void outputChannel(final WritableByteChannel channel) {
        this.outputChannel = new TransferableChannel(){

            public boolean hasPendingWrites() {
                return false;
            }

            public long transferFrom(FileChannel fileChannel, long position, long count) throws IOException {
                return fileChannel.transferTo(position, count, channel);
            }

            public boolean isOpen() {
                return channel.isOpen();
            }

            public void close() throws IOException {
                channel.close();
            }

            public int write(ByteBuffer src) throws IOException {
                return channel.write(src);
            }

            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                long result = 0L;
                for (int i = offset; i < offset + length; ++i) {
                    result += (long)this.write(srcs[i]);
                }
                return result;
            }

            public long write(ByteBuffer[] srcs) throws IOException {
                return this.write(srcs, 0, srcs.length);
            }
        };
    }

    public Selector selector() {
        return this.selector;
    }

    public void closeKafkaChannels() {
        this.closeKafkaChannels = true;
        this.selector.wakeup();
        try {
            TestUtils.waitForCondition(() -> this.selector.channels().isEmpty(), "Channels not closed");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeKafkaChannels = false;
        }
    }

    public void closeSocketChannels() throws IOException {
        for (SocketChannel channel : this.socketChannels) {
            channel.close();
        }
        this.socketChannels.clear();
    }

    public void close() throws IOException, InterruptedException {
        this.serverSocketChannel.close();
        this.closeSocketChannels();
        Utils.closeQuietly((AutoCloseable)this.selector, (String)"selector");
        this.acceptorThread.interrupt();
        this.acceptorThread.join();
        this.interrupt();
        this.join();
    }

    private class AcceptorThread
    extends Thread {
        public AcceptorThread() {
            this.setName("acceptor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            java.nio.channels.Selector acceptSelector = null;
            try {
                acceptSelector = java.nio.channels.Selector.open();
                NioEchoServer.this.serverSocketChannel.register(acceptSelector, 16);
                while (NioEchoServer.this.serverSocketChannel.isOpen()) {
                    if (acceptSelector.select(1000L) <= 0) continue;
                    Iterator<SelectionKey> it = acceptSelector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        SelectionKey key = it.next();
                        if (key.isAcceptable()) {
                            SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
                            socketChannel.configureBlocking(false);
                            NioEchoServer.this.newChannels.add(socketChannel);
                            NioEchoServer.this.selector.wakeup();
                        }
                        it.remove();
                    }
                }
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            finally {
                Utils.closeQuietly((AutoCloseable)acceptSelector, (String)"acceptSelector");
            }
        }
    }

    public static enum MetricType {
        TOTAL,
        RATE,
        AVG,
        MAX;

        private final String metricNameSuffix = "-" + this.name().toLowerCase(Locale.ROOT);

        public String metricNameSuffix() {
            return this.metricNameSuffix;
        }
    }
}

