/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.EchoServer;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.kafka.common.network.PlaintextSender;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Timeout(value=240L)
public class SelectorTest {
    protected static final int BUFFER_SIZE = 4096;
    private static final String METRIC_GROUP = "MetricGroup";
    private static final long CONNECTION_MAX_IDLE_MS = 5000L;
    protected EchoServer server;
    protected Time time;
    protected Selector selector;
    protected ChannelBuilder channelBuilder;
    protected Metrics metrics;

    @BeforeEach
    public void setUp() throws Exception {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        this.server = new EchoServer(SecurityProtocol.PLAINTEXT, configs);
        this.server.start();
        this.time = new MockTime();
        this.channelBuilder = new PlaintextChannelBuilder(Mode.CLIENT, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new ProxyProtocolEngineFactory(ProxyProtocol.NONE));
        this.channelBuilder.configure(this.clientConfigs());
        this.metrics = new Metrics();
        this.selector = new Selector(5000L, this.metrics, this.time, METRIC_GROUP, this.channelBuilder, new LogContext());
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.verifySelectorEmpty();
        }
        finally {
            this.selector.close();
            this.server.close();
            this.metrics.close();
        }
    }

    protected Map<String, Object> clientConfigs() {
        return new HashMap<String, Object>();
    }

    @Test
    public void testServerDisconnect() throws Exception {
        String node = "0";
        this.blockingConnect("0");
        Assertions.assertEquals((Object)"hello", (Object)this.blockingRequest("0", "hello"));
        KafkaChannel channel = this.selector.channel("0");
        this.server.closeConnections();
        TestUtils.waitForCondition(() -> {
            try {
                this.selector.poll(1000L);
                return this.selector.disconnected().containsKey("0");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, 5000L, "Failed to observe disconnected node in disconnected set");
        Assertions.assertNull((Object)channel.selectionKey().attachment());
        this.blockingConnect("0");
        Assertions.assertEquals((Object)"hello", (Object)this.blockingRequest("0", "hello"));
    }

    @Test
    public void testCantSendWithInProgress() throws Exception {
        String node = "0";
        this.blockingConnect(node);
        this.selector.send(this.createSend(node, "test1"));
        try {
            this.selector.send(this.createSend(node, "test2"));
            Assertions.fail((String)"IllegalStateException not thrown when sending a request with one in flight");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.selector.poll(0L);
        Assertions.assertTrue((boolean)this.selector.disconnected().containsKey(node), (String)"Channel not closed");
        Assertions.assertEquals((Object)ChannelState.FAILED_SEND, this.selector.disconnected().get(node));
    }

    @Test
    public void testSendWithoutConnecting() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.selector.send(this.createSend("0", "test")));
    }

    @Test
    public void testNoRouteToHost() {
        Assertions.assertThrows(IOException.class, () -> this.selector.connect("0", new InetSocketAddress("some.invalid.hostname.foo.bar.local", this.server.port), 4096, 4096));
    }

    @Test
    public void testConnectionRefused() throws Exception {
        String node = "0";
        ServerSocket nonListeningSocket = new ServerSocket(0);
        int nonListeningPort = nonListeningSocket.getLocalPort();
        this.selector.connect(node, new InetSocketAddress("localhost", nonListeningPort), 4096, 4096);
        while (this.selector.disconnected().containsKey(node)) {
            Assertions.assertEquals((Object)ChannelState.NOT_CONNECTED, this.selector.disconnected().get(node));
            this.selector.poll(1000L);
        }
        nonListeningSocket.close();
    }

    @Test
    public void testNormalOperation() throws Exception {
        int conns = 5;
        int reqs = 500;
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        for (int i = 0; i < conns; ++i) {
            this.connect(Integer.toString(i), addr);
        }
        HashMap<String, Integer> requests = new HashMap<String, Integer>();
        HashMap<String, Integer> responses = new HashMap<String, Integer>();
        int responseCount = 0;
        for (int i = 0; i < conns; ++i) {
            String node = Integer.toString(i);
            this.selector.send(this.createSend(node, node + "-0"));
        }
        while (responseCount < conns * reqs) {
            this.selector.poll(0L);
            Assertions.assertEquals((int)0, (int)this.selector.disconnected().size(), (String)"No disconnects should have occurred.");
            for (NetworkReceive receive : this.selector.completedReceives()) {
                String[] pieces = this.asString(receive).split("-");
                Assertions.assertEquals((int)2, (int)pieces.length, (String)"Should be in the form 'conn-counter'");
                Assertions.assertEquals((Object)receive.source(), (Object)pieces[0], (String)"Check the source");
                Assertions.assertEquals((int)0, (int)receive.payload().position(), (String)"Check that the receive has kindly been rewound");
                if (responses.containsKey(receive.source())) {
                    Assertions.assertEquals((int)((Integer)responses.get(receive.source())), (int)Integer.parseInt(pieces[1]), (String)"Check the request counter");
                    responses.put(receive.source(), (Integer)responses.get(receive.source()) + 1);
                } else {
                    Assertions.assertEquals((int)0, (int)Integer.parseInt(pieces[1]), (String)"Check the request counter");
                    responses.put(receive.source(), 1);
                }
                ++responseCount;
            }
            for (NetworkSend send : this.selector.completedSends()) {
                String dest = send.destinationId();
                if (requests.containsKey(dest)) {
                    requests.put(dest, (Integer)requests.get(dest) + 1);
                } else {
                    requests.put(dest, 1);
                }
                if ((Integer)requests.get(dest) >= reqs) continue;
                this.selector.send(this.createSend(dest, dest + "-" + requests.get(dest)));
            }
        }
        if (this.channelBuilder instanceof PlaintextChannelBuilder) {
            Assertions.assertEquals((int)0, (int)SelectorTest.cipherMetrics(this.metrics).size());
        } else {
            TestUtils.waitForCondition(() -> SelectorTest.cipherMetrics(this.metrics).size() == 1, "Waiting for cipher metrics to be created.");
            Assertions.assertEquals((Object)5, (Object)SelectorTest.cipherMetrics(this.metrics).get(0).metricValue());
        }
    }

    static List<KafkaMetric> cipherMetrics(Metrics metrics) {
        return metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).description().contains("The number of connections with this SSL cipher and protocol.")).map(e -> (KafkaMetric)e.getValue()).collect(Collectors.toList());
    }

    @Test
    public void testSendLargeRequest() throws Exception {
        String node = "0";
        this.blockingConnect(node);
        String big = TestUtils.randomString(40960);
        Assertions.assertEquals((Object)big, (Object)this.blockingRequest(node, big));
    }

    @Test
    public void testPartialSendAndReceiveReflectedInMetrics() throws Exception {
        int payloadSize = 81920;
        String payload = TestUtils.randomString(payloadSize);
        String nodeId = "0";
        this.blockingConnect(nodeId);
        ByteBufferSend send = ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(payload.getBytes()));
        NetworkSend networkSend = new NetworkSend(nodeId, (Send)send);
        this.selector.send(networkSend);
        KafkaChannel channel = this.selector.channel(nodeId);
        KafkaMetric outgoingByteTotal = this.findUntaggedMetricByName("outgoing-byte-total");
        KafkaMetric incomingByteTotal = this.findUntaggedMetricByName("incoming-byte-total");
        TestUtils.waitForCondition(() -> {
            long bytesSent = send.size() - send.remaining();
            Assertions.assertEquals((long)bytesSent, (long)((Double)outgoingByteTotal.metricValue()).longValue());
            NetworkReceive currentReceive = channel.currentReceive();
            if (currentReceive != null) {
                Assertions.assertEquals((int)currentReceive.bytesRead(), (int)((Double)incomingByteTotal.metricValue()).intValue());
            }
            this.selector.poll(50L);
            return !this.selector.completedReceives().isEmpty();
        }, "Failed to receive expected response");
        KafkaMetric requestTotal = this.findUntaggedMetricByName("request-total");
        Assertions.assertEquals((int)1, (int)((Double)requestTotal.metricValue()).intValue());
        KafkaMetric responseTotal = this.findUntaggedMetricByName("response-total");
        Assertions.assertEquals((int)1, (int)((Double)responseTotal.metricValue()).intValue());
    }

    @Test
    public void testLargeMessageSequence() throws Exception {
        int bufferSize = 524288;
        String node = "0";
        int reqs = 50;
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        this.connect(node, addr);
        String requestPrefix = TestUtils.randomString(bufferSize);
        this.sendAndReceive(node, requestPrefix, 0, reqs);
    }

    @Test
    public void testEmptyRequest() throws Exception {
        String node = "0";
        this.blockingConnect(node);
        Assertions.assertEquals((Object)"", (Object)this.blockingRequest(node, ""));
    }

    @Test
    public void testClearCompletedSendsAndReceives() throws Exception {
        int bufferSize = 1024;
        String node = "0";
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        this.connect(node, addr);
        String request = TestUtils.randomString(bufferSize);
        this.selector.send(this.createSend(node, request));
        boolean sent = false;
        boolean received = false;
        while (!sent || !received) {
            this.selector.poll(1000L);
            Assertions.assertEquals((int)0, (int)this.selector.disconnected().size(), (String)"No disconnects should have occurred.");
            if (!this.selector.completedSends().isEmpty()) {
                Assertions.assertEquals((int)1, (int)this.selector.completedSends().size());
                this.selector.clearCompletedSends();
                Assertions.assertEquals((int)0, (int)this.selector.completedSends().size());
                sent = true;
            }
            if (this.selector.completedReceives().isEmpty()) continue;
            Assertions.assertEquals((int)1, (int)this.selector.completedReceives().size());
            Assertions.assertEquals((Object)request, (Object)this.asString((NetworkReceive)this.selector.completedReceives().iterator().next()));
            this.selector.clearCompletedReceives();
            Assertions.assertEquals((int)0, (int)this.selector.completedReceives().size());
            received = true;
        }
    }

    @Test
    public void testExistingConnectionId() throws IOException {
        this.blockingConnect("0");
        Assertions.assertThrows(IllegalStateException.class, () -> this.blockingConnect("0"));
    }

    @Test
    public void testMute() throws Exception {
        this.blockingConnect("0");
        this.blockingConnect("1");
        this.selector.send(this.createSend("0", "hello"));
        this.selector.send(this.createSend("1", "hi"));
        this.selector.mute("1");
        while (this.selector.completedReceives().isEmpty()) {
            this.selector.poll(5L);
        }
        Assertions.assertEquals((int)1, (int)this.selector.completedReceives().size(), (String)"We should have only one response");
        Assertions.assertEquals((Object)"0", (Object)((NetworkReceive)this.selector.completedReceives().iterator().next()).source(), (String)"The response should not be from the muted node");
        this.selector.unmute("1");
        do {
            this.selector.poll(5L);
        } while (this.selector.completedReceives().isEmpty());
        Assertions.assertEquals((int)1, (int)this.selector.completedReceives().size(), (String)"We should have only one response");
        Assertions.assertEquals((Object)"1", (Object)((NetworkReceive)this.selector.completedReceives().iterator().next()).source(), (String)"The response should be from the previously muted node");
    }

    @Test
    public void testCloseAllChannels() throws Exception {
        final AtomicInteger closedChannelsCount = new AtomicInteger(0);
        PlaintextChannelBuilder channelBuilder = new PlaintextChannelBuilder(Mode.SERVER, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new ProxyProtocolEngineFactory(ProxyProtocol.NONE)){
            private int channelIndex;
            {
                super(x0, x1, x2);
                this.channelIndex = 0;
            }

            KafkaChannel buildChannel(String id, TransportLayer transportLayer, Supplier<Authenticator> authenticatorCreator, int maxReceiveSize, AsyncAuthExecutor asyncAuthExecutor, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, BrokerInterceptor interceptor, Time time, boolean shouldParseSni, boolean shouldParseLkcId) {
                return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, asyncAuthExecutor, memoryPool, metadataRegistry, interceptor, time, shouldParseSni, shouldParseLkcId){
                    private final int index;
                    {
                        this.index = channelIndex++;
                    }

                    public void close() throws IOException {
                        closedChannelsCount.getAndIncrement();
                        if (this.index == 0) {
                            throw new RuntimeException("you should fail");
                        }
                        super.close();
                    }
                };
            }
        };
        channelBuilder.configure(this.clientConfigs());
        Selector selector = new Selector(5000L, new Metrics(), (Time)new MockTime(), METRIC_GROUP, (ChannelBuilder)channelBuilder, new LogContext());
        selector.connect("0", new InetSocketAddress("localhost", this.server.port), 4096, 4096);
        selector.connect("1", new InetSocketAddress("localhost", this.server.port), 4096, 4096);
        Assertions.assertThrows(RuntimeException.class, () -> ((Selector)selector).close());
        Assertions.assertEquals((int)2, (int)closedChannelsCount.get());
    }

    @Test
    public void registerFailure() throws Exception {
        PlaintextChannelBuilder channelBuilder = new PlaintextChannelBuilder(Mode.CLIENT, null, new ProxyProtocolEngineFactory(ProxyProtocol.NONE)){

            public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, AsyncAuthExecutor asyncAuthExecutor, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, Time time) throws KafkaException {
                throw new RuntimeException("Test exception");
            }
        };
        Selector selector = new Selector(5000L, new Metrics(), (Time)new MockTime(), METRIC_GROUP, (ChannelBuilder)channelBuilder, new LogContext());
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> selector.register("1", socketChannel));
        Assertions.assertTrue((boolean)e.getCause().getMessage().contains("Test exception"), (String)("Unexpected exception: " + e));
        Assertions.assertFalse((boolean)socketChannel.isOpen(), (String)"Socket not closed");
        selector.close();
    }

    @Test
    public void testCloseOldestConnection() throws Exception {
        String id = "0";
        this.selector.connect(id, new InetSocketAddress("localhost", this.server.port), 4096, 4096);
        NetworkTestUtils.waitForChannelConnected(this.selector, id);
        this.verifyIdleConnectionCloseMetric(0.0);
        this.time.sleep(6000L);
        this.selector.poll(0L);
        Assertions.assertTrue((boolean)this.selector.disconnected().containsKey(id), (String)"The idle connection should have been closed");
        Assertions.assertEquals((Object)ChannelState.EXPIRED, this.selector.disconnected().get(id));
        this.verifyIdleConnectionCloseMetric(1.0);
    }

    @Test
    public void testIdleExpiryWithoutReadyKeys() throws Exception {
        String id = "0";
        this.selector.connect(id, new InetSocketAddress("localhost", this.server.port), 4096, 4096);
        KafkaChannel channel = this.selector.channel(id);
        channel.selectionKey().interestOps(0);
        this.time.sleep(6000L);
        this.selector.poll(0L);
        Assertions.assertTrue((boolean)this.selector.disconnected().containsKey(id), (String)"The idle connection should have been closed");
        Assertions.assertEquals((Object)ChannelState.EXPIRED, this.selector.disconnected().get(id));
        this.verifyIdleConnectionCloseMetric(1.0);
    }

    @Test
    public void testImmediatelyConnectedCleaned() throws Exception {
        Metrics metrics = new Metrics();
        ImmediatelyConnectingSelector selector = new ImmediatelyConnectingSelector(5000L, metrics, this.time, METRIC_GROUP, this.channelBuilder, new LogContext());
        try {
            this.testImmediatelyConnectedCleaned(selector, true);
            this.testImmediatelyConnectedCleaned(selector, false);
        }
        finally {
            selector.close();
            metrics.close();
        }
    }

    private void testImmediatelyConnectedCleaned(Selector selector, boolean closeAfterFirstPoll) throws Exception {
        String id = "0";
        selector.connect(id, new InetSocketAddress("localhost", this.server.port), 4096, 4096);
        this.verifyNonEmptyImmediatelyConnectedKeys(selector);
        if (closeAfterFirstPoll) {
            selector.poll(0L);
            this.verifyEmptyImmediatelyConnectedKeys(selector);
        }
        selector.close(id);
        SelectorTest.verifySelectorEmpty(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectException() throws Exception {
        Metrics metrics = new Metrics();
        final AtomicBoolean throwIOException = new AtomicBoolean();
        ImmediatelyConnectingSelector selector = new ImmediatelyConnectingSelector(5000L, metrics, this.time, METRIC_GROUP, this.channelBuilder, new LogContext()){

            protected SelectionKey registerChannel(String id, SocketChannel socketChannel, int interestedOps) throws IOException {
                SelectionKey key = super.registerChannel(id, socketChannel, interestedOps);
                key.cancel();
                if (throwIOException.get()) {
                    throw new IOException("Test exception");
                }
                return key;
            }
        };
        try {
            this.verifyImmediatelyConnectedException(selector, "0");
            throwIOException.set(true);
            this.verifyImmediatelyConnectedException(selector, "1");
        }
        finally {
            selector.close();
            metrics.close();
        }
    }

    private void verifyImmediatelyConnectedException(Selector selector, String id) throws Exception {
        try {
            selector.connect(id, new InetSocketAddress("localhost", this.server.port), 4096, 4096);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (Exception e) {
            this.verifyEmptyImmediatelyConnectedKeys(selector);
            Assertions.assertNull((Object)selector.channel(id), (String)"Channel not removed");
            SelectorTest.ensureEmptySelectorFields(selector);
        }
    }

    @Test
    public void testExpireConnectionWithPendingReceives() throws Exception {
        KafkaChannel channel = this.createConnectionWithPendingReceives(5);
        this.verifyChannelExpiry(channel);
    }

    @Disabled
    @Test
    public void testExpireClosedConnectionWithPendingReceives() throws Exception {
        KafkaChannel channel = this.createConnectionWithPendingReceives(5);
        this.server.closeConnections();
        this.verifyChannelExpiry(channel);
    }

    private void verifyChannelExpiry(KafkaChannel channel) throws Exception {
        String id = channel.id();
        this.selector.mute(id);
        this.time.sleep(6000L);
        this.selector.poll(0L);
        Assertions.assertNull((Object)this.selector.channel(id), (String)"Channel not expired");
        Assertions.assertNull((Object)this.selector.closingChannel(id), (String)"Channel not removed from closingChannels");
        Assertions.assertEquals((Object)ChannelState.EXPIRED, (Object)channel.state());
        Assertions.assertNull((Object)channel.selectionKey().attachment());
        Assertions.assertTrue((boolean)this.selector.disconnected().containsKey(id), (String)"Disconnect not notified");
        Assertions.assertEquals((Object)ChannelState.EXPIRED, this.selector.disconnected().get(id));
        this.verifyIdleConnectionCloseMetric(1.0);
        this.verifySelectorEmpty();
    }

    private void verifyIdleConnectionCloseMetric(double expectedValue) throws Exception {
        double count = (Double)this.getMetric("idle-connection-close-total").metricValue();
        Assertions.assertEquals((double)expectedValue, (double)count, (double)0.0);
    }

    @Test
    public void testGracefulClose() throws Exception {
        int maxReceiveCountAfterClose = 0;
        for (int i = 6; i <= 100 && maxReceiveCountAfterClose < 5; ++i) {
            int receiveCount = 0;
            KafkaChannel channel = this.createConnectionWithPendingReceives(i);
            TestUtils.waitForCondition(() -> {
                this.selector.poll(1000L);
                return this.selector.completedReceives().size() > 0;
            }, 5000L, "Receive not completed");
            this.server.closeConnections();
            while (this.selector.disconnected().isEmpty()) {
                this.selector.poll(1L);
                receiveCount += this.selector.completedReceives().size();
                Assertions.assertTrue((this.selector.completedReceives().size() <= 1 ? 1 : 0) != 0, (String)"Too many completed receives in one poll");
            }
            Assertions.assertEquals((Object)channel.id(), this.selector.disconnected().keySet().iterator().next());
            maxReceiveCountAfterClose = Math.max(maxReceiveCountAfterClose, receiveCount);
        }
        Assertions.assertTrue((maxReceiveCountAfterClose >= 5 ? 1 : 0) != 0, (String)("Too few receives after close: " + maxReceiveCountAfterClose));
    }

    @Test
    public void testPartialReceiveGracefulClose() throws Exception {
        String id = "0";
        this.blockingConnect(id);
        KafkaChannel channel = this.selector.channel(id);
        this.injectNetworkReceive(channel, 100000);
        this.sendNoReceive(channel, 2);
        this.selector.poll(1000L);
        Assertions.assertEquals((int)0, (int)this.selector.completedReceives().size());
        this.server.closeConnections();
        TestUtils.waitForCondition(() -> {
            try {
                this.selector.poll(100L);
                return !this.selector.disconnected().isEmpty();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, 10000L, "Channel not disconnected");
        Assertions.assertEquals((int)1, (int)this.selector.disconnected().size());
        Assertions.assertEquals((Object)channel.id(), this.selector.disconnected().keySet().iterator().next());
        Assertions.assertEquals((int)0, (int)this.selector.completedReceives().size());
    }

    @Test
    public void testMuteOnOOM() throws Exception {
        this.selector.close();
        SimpleMemoryPool pool = new SimpleMemoryPool(900L, 900, false, null);
        this.selector = new Selector(-1, 5000L, this.metrics, this.time, METRIC_GROUP, new HashMap(), true, false, this.channelBuilder, (MemoryPool)pool, new LogContext());
        try (ServerSocketChannel ss = ServerSocketChannel.open();){
            ss.bind(new InetSocketAddress(0));
            InetSocketAddress serverAddress = (InetSocketAddress)ss.getLocalAddress();
            Thread sender1 = this.createSender(serverAddress, this.randomPayload(900));
            Thread sender2 = this.createSender(serverAddress, this.randomPayload(900));
            sender1.start();
            sender2.start();
            sender1.join(5000L);
            sender2.join(5000L);
            SocketChannel channelX = ss.accept();
            channelX.configureBlocking(false);
            SocketChannel channelY = ss.accept();
            channelY.configureBlocking(false);
            this.selector.register("clientX", channelX);
            this.selector.register("clientY", channelY);
            Collection<Object> completed = Collections.emptyList();
            long deadline = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < deadline && completed.isEmpty()) {
                this.selector.poll(1000L);
                completed = this.selector.completedReceives();
            }
            Assertions.assertEquals((int)1, (int)completed.size(), (String)"could not read a single request within timeout");
            NetworkReceive firstReceive = (NetworkReceive)completed.iterator().next();
            Assertions.assertEquals((long)0L, (long)pool.availableMemory());
            Assertions.assertTrue((boolean)this.selector.isOutOfMemory());
            this.selector.poll(10L);
            Assertions.assertTrue((boolean)this.selector.completedReceives().isEmpty());
            Assertions.assertEquals((long)0L, (long)pool.availableMemory());
            Assertions.assertTrue((boolean)this.selector.isOutOfMemory());
            firstReceive.close();
            Assertions.assertEquals((long)900L, (long)pool.availableMemory());
            completed = Collections.emptyList();
            deadline = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < deadline && completed.isEmpty()) {
                this.selector.poll(1000L);
                completed = this.selector.completedReceives();
            }
            Assertions.assertEquals((int)1, (int)this.selector.completedReceives().size(), (String)"could not read a single request within timeout");
            Assertions.assertEquals((long)0L, (long)pool.availableMemory());
            Assertions.assertFalse((boolean)this.selector.isOutOfMemory());
        }
    }

    private Thread createSender(InetSocketAddress serverAddress, byte[] payload) {
        return new PlaintextSender(serverAddress, payload);
    }

    protected byte[] randomPayload(int sizeBytes) throws Exception {
        Random random = new Random();
        byte[] payload = new byte[sizeBytes + 4];
        random.nextBytes(payload);
        ByteArrayOutputStream prefixOs = new ByteArrayOutputStream();
        DataOutputStream prefixDos = new DataOutputStream(prefixOs);
        prefixDos.writeInt(sizeBytes);
        prefixDos.flush();
        prefixDos.close();
        prefixOs.flush();
        prefixOs.close();
        byte[] prefix = prefixOs.toByteArray();
        System.arraycopy(prefix, 0, payload, 0, prefix.length);
        return payload;
    }

    @Test
    public void testConnectDisconnectDuringInSinglePoll() throws Exception {
        KafkaChannel kafkaChannel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        Mockito.when((Object)kafkaChannel.id()).thenReturn((Object)"1");
        Mockito.when((Object)kafkaChannel.socketDescription()).thenReturn((Object)"");
        Mockito.when((Object)kafkaChannel.state()).thenReturn((Object)ChannelState.NOT_CONNECTED);
        Mockito.when((Object)kafkaChannel.finishConnect()).thenReturn((Object)true);
        Mockito.when((Object)kafkaChannel.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)kafkaChannel.ready()).thenReturn((Object)false);
        ((KafkaChannel)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)kafkaChannel)).prepare();
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)kafkaChannel.selectionKey()).thenReturn((Object)selectionKey);
        Mockito.when((Object)selectionKey.channel()).thenReturn((Object)SocketChannel.open());
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)8);
        Mockito.when((Object)selectionKey.attachment()).thenReturn((Object)kafkaChannel);
        Set selectionKeys = Utils.mkSet((Object[])new SelectionKey[]{selectionKey});
        this.selector.pollSelectionKeys(selectionKeys, false, System.nanoTime());
        Assertions.assertFalse((boolean)this.selector.connected().contains(kafkaChannel.id()));
        Assertions.assertTrue((boolean)this.selector.disconnected().containsKey(kafkaChannel.id()));
        ((KafkaChannel)Mockito.verify((Object)kafkaChannel, (VerificationMode)Mockito.atLeastOnce())).ready();
        ((KafkaChannel)Mockito.verify((Object)kafkaChannel)).disconnect();
        ((KafkaChannel)Mockito.verify((Object)kafkaChannel)).close();
        ((SelectionKey)Mockito.verify((Object)selectionKey)).cancel();
    }

    @Test
    public void testOutboundConnectionsCountInConnectionCreationMetric() throws Exception {
        int expectedConnections = 5;
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        for (int i = 0; i < expectedConnections; ++i) {
            this.connect(Integer.toString(i), addr);
        }
        int seenConnections = 0;
        for (int i = 0; i < 10; ++i) {
            this.selector.poll(100L);
            if ((seenConnections += this.selector.connected().size()) == expectedConnections) break;
        }
        Assertions.assertEquals((Object)expectedConnections, (Object)this.getMetric("connection-creation-total").metricValue());
        Assertions.assertEquals((Object)expectedConnections, (Object)this.getMetric("connection-count").metricValue());
    }

    @Test
    public void testInboundConnectionsCountInConnectionCreationMetric() throws Exception {
        int conns = 5;
        try (ServerSocketChannel ss = ServerSocketChannel.open();){
            ss.bind(new InetSocketAddress(0));
            InetSocketAddress serverAddress = (InetSocketAddress)ss.getLocalAddress();
            for (int i = 0; i < conns; ++i) {
                Thread sender = this.createSender(serverAddress, this.randomPayload(1));
                sender.start();
                SocketChannel channel = ss.accept();
                channel.configureBlocking(false);
                this.selector.register(Integer.toString(i), channel);
            }
        }
        Assertions.assertEquals((Object)conns, (Object)this.getMetric("connection-creation-total").metricValue());
        Assertions.assertEquals((Object)conns, (Object)this.getMetric("connection-count").metricValue());
    }

    @Test
    public void testConnectionsByClientMetric() throws Exception {
        String node = "0";
        Map<String, String> unknownNameAndVersion = this.softwareNameAndVersionTags("unknown", "unknown");
        Map<String, String> knownNameAndVersion = this.softwareNameAndVersionTags("A", "B");
        try (ServerSocketChannel ss = ServerSocketChannel.open();){
            ss.bind(new InetSocketAddress(0));
            InetSocketAddress serverAddress = (InetSocketAddress)ss.getLocalAddress();
            Thread sender = this.createSender(serverAddress, this.randomPayload(1));
            sender.start();
            SocketChannel channel = ss.accept();
            channel.configureBlocking(false);
            this.selector.register(node, channel);
            Assertions.assertEquals((Object)1, (Object)this.getMetric("connections", unknownNameAndVersion).metricValue());
            Assertions.assertEquals((Object)ClientInformation.EMPTY, (Object)this.selector.channel(node).channelMetadataRegistry().clientInformation());
            ClientInformation clientInformation = new ClientInformation("A", "B");
            this.selector.channel(node).channelMetadataRegistry().registerClientInformation(clientInformation);
            Assertions.assertEquals((Object)clientInformation, (Object)this.selector.channel(node).channelMetadataRegistry().clientInformation());
            Assertions.assertEquals((Object)0, (Object)this.getMetric("connections", unknownNameAndVersion).metricValue());
            Assertions.assertEquals((Object)1, (Object)this.getMetric("connections", knownNameAndVersion).metricValue());
            this.selector.close(node);
            Assertions.assertEquals((Object)0, (Object)this.getMetric("connections", knownNameAndVersion).metricValue());
        }
    }

    private Map<String, String> softwareNameAndVersionTags(String clientSoftwareName, String clientSoftwareVersion) {
        HashMap<String, String> tags = new HashMap<String, String>(2);
        tags.put("clientSoftwareName", clientSoftwareName);
        tags.put("clientSoftwareVersion", clientSoftwareVersion);
        return tags;
    }

    private KafkaMetric getMetric(String name, Map<String, String> tags) throws Exception {
        Optional<Map.Entry> metric = this.metrics.metrics().entrySet().stream().filter(entry -> ((MetricName)entry.getKey()).name().equals(name) && ((MetricName)entry.getKey()).tags().equals(tags)).findFirst();
        if (!metric.isPresent()) {
            throw new Exception(String.format("Could not find metric called %s with tags %s", name, tags.toString()));
        }
        return (KafkaMetric)metric.get().getValue();
    }

    @Test
    public void testLowestPriorityChannel() throws Exception {
        int conns = 5;
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        for (int i = 0; i < conns; ++i) {
            this.connect(String.valueOf(i), addr);
        }
        Assertions.assertNotNull((Object)this.selector.lowestPriorityChannel());
        Assertions.assertEquals((Object)"0", (Object)this.selector.lowestPriorityChannel().id());
        Field field = Selector.class.getDeclaredField("closingChannels");
        field.setAccessible(true);
        Map closingChannels = (Map)field.get(this.selector);
        closingChannels.put("3", this.selector.channel("3"));
        Assertions.assertEquals((Object)"3", (Object)this.selector.lowestPriorityChannel().id());
        closingChannels.remove("3");
        for (int i = 0; i < conns; ++i) {
            this.selector.close(String.valueOf(i));
        }
        Assertions.assertNull((Object)this.selector.lowestPriorityChannel());
    }

    @Test
    public void testMetricsCleanupOnSelectorClose() throws Exception {
        Metrics metrics = new Metrics();
        ImmediatelyConnectingSelector selector = new ImmediatelyConnectingSelector(5000L, metrics, this.time, METRIC_GROUP, this.channelBuilder, new LogContext()){

            public void close(String id) {
                throw new RuntimeException();
            }
        };
        Assertions.assertTrue((metrics.metrics().size() > 1 ? 1 : 0) != 0);
        String id = "0";
        selector.connect(id, new InetSocketAddress("localhost", this.server.port), 4096, 4096);
        Assertions.assertThrows(RuntimeException.class, () -> ((Selector)selector).close());
        Assertions.assertEquals((int)1, (int)metrics.metrics().size());
    }

    @Test
    public void testWriteCompletesSendWithNoBytesWritten() throws IOException {
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        Mockito.when((Object)channel.id()).thenReturn((Object)"1");
        Mockito.when((Object)channel.write()).thenReturn((Object)0L);
        NetworkSend send = new NetworkSend("destination", (Send)new ByteBufferSend(new ByteBuffer[]{ByteBuffer.allocate(0)}));
        Mockito.when((Object)channel.maybeCompleteSend()).thenReturn((Object)send);
        this.selector.write(channel);
        Assertions.assertEquals(Arrays.asList(send), (Object)this.selector.completedSends());
    }

    @Test
    public void testChannelCloseWhileProcessingReceives() throws Exception {
        int numChannels = 4;
        Map channels = (Map)TestUtils.fieldValue(this.selector, Selector.class, "channels");
        HashSet<SelectionKey> selectionKeys = new HashSet<SelectionKey>();
        for (int i = 0; i < numChannels; ++i) {
            String id = String.valueOf(i);
            KafkaChannel channel2 = (KafkaChannel)Mockito.mock(KafkaChannel.class);
            channels.put(id, channel2);
            Mockito.when((Object)channel2.id()).thenReturn((Object)id);
            Mockito.when((Object)channel2.state()).thenReturn((Object)ChannelState.READY);
            Mockito.when((Object)channel2.isConnected()).thenReturn((Object)true);
            Mockito.when((Object)channel2.ready()).thenReturn((Object)true);
            Mockito.when((Object)channel2.read()).thenReturn((Object)1L);
            SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
            Mockito.when((Object)channel2.selectionKey()).thenReturn((Object)selectionKey);
            Mockito.when((Object)selectionKey.isValid()).thenReturn((Object)true);
            Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
            Mockito.when((Object)selectionKey.isReadable()).thenReturn((Object)true);
            Mockito.when((Object)selectionKey.attachment()).thenReturn((Object)channel2).thenReturn(null);
            selectionKeys.add(selectionKey);
            NetworkReceive receive = (NetworkReceive)Mockito.mock(NetworkReceive.class);
            Mockito.when((Object)receive.source()).thenReturn((Object)id);
            Mockito.when((Object)receive.size()).thenReturn((Object)10);
            Mockito.when((Object)receive.bytesRead()).thenReturn((Object)1);
            Mockito.when((Object)receive.payload()).thenReturn((Object)ByteBuffer.allocate(10));
            Mockito.when((Object)channel2.maybeCompleteReceive()).thenReturn((Object)receive);
        }
        this.selector.pollSelectionKeys(selectionKeys, false, System.nanoTime());
        Assertions.assertEquals((int)numChannels, (int)this.selector.completedReceives().size());
        HashSet<KafkaChannel> closed = new HashSet<KafkaChannel>();
        HashSet<KafkaChannel> notClosed = new HashSet<KafkaChannel>();
        for (NetworkReceive receive : this.selector.completedReceives()) {
            KafkaChannel channel3 = this.selector.channel(receive.source());
            Assertions.assertNotNull((Object)channel3);
            if (closed.size() < 2) {
                this.selector.close(channel3.id());
                closed.add(channel3);
                continue;
            }
            notClosed.add(channel3);
        }
        Assertions.assertEquals(notClosed, new HashSet(this.selector.channels()));
        closed.forEach(channel -> Assertions.assertNull((Object)this.selector.channel(channel.id())));
        this.selector.poll(0L);
        Assertions.assertEquals((int)0, (int)this.selector.completedReceives().size());
    }

    @Test
    public void testProxyReadyAndDisconnectInSinglePoll() throws Exception {
        KafkaChannel kafkaChannel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        Mockito.when((Object)kafkaChannel.id()).thenReturn((Object)"1");
        Mockito.when((Object)kafkaChannel.socketDescription()).thenReturn((Object)"");
        Mockito.when((Object)kafkaChannel.state()).thenReturn((Object)ChannelState.AUTHENTICATE);
        Mockito.when((Object)kafkaChannel.finishConnect()).thenReturn((Object)true);
        Mockito.when((Object)kafkaChannel.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)kafkaChannel.ready()).thenReturn((Object)false);
        Mockito.when((Object)kafkaChannel.proxyState()).thenReturn((Object)KafkaChannel.ChannelProxyState.PROXY_READY);
        ((KafkaChannel)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)kafkaChannel)).prepare();
        SelectionKey selectionKey = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)kafkaChannel.selectionKey()).thenReturn((Object)selectionKey);
        Mockito.when((Object)selectionKey.channel()).thenReturn((Object)SocketChannel.open());
        Mockito.when((Object)selectionKey.readyOps()).thenReturn((Object)1);
        selectionKey.attach(kafkaChannel);
        Mockito.when((Object)selectionKey.attachment()).thenReturn((Object)kafkaChannel);
        Set selectionKeys = Utils.mkSet((Object[])new SelectionKey[]{selectionKey});
        this.selector.pollSelectionKeys(selectionKeys, false, System.nanoTime());
        Assertions.assertFalse((boolean)this.selector.connected().contains(kafkaChannel.id()));
        Assertions.assertTrue((boolean)this.selector.disconnected().containsKey(kafkaChannel.id()));
        Assertions.assertTrue((boolean)this.selector.proxyReadyChannels().contains(kafkaChannel));
        ((KafkaChannel)Mockito.verify((Object)kafkaChannel, (VerificationMode)Mockito.atLeastOnce())).ready();
        ((KafkaChannel)Mockito.verify((Object)kafkaChannel)).disconnect();
        ((KafkaChannel)Mockito.verify((Object)kafkaChannel)).proxyState();
        ((KafkaChannel)Mockito.verify((Object)kafkaChannel)).close();
        ((SelectionKey)Mockito.verify((Object)selectionKey)).cancel();
    }

    @Test
    public void testThrottledProxyConnection() throws Exception {
        String node = "0";
        try (ServerSocketChannel ss = ServerSocketChannel.open();){
            ss.bind(new InetSocketAddress(0));
            InetSocketAddress serverAddress = (InetSocketAddress)ss.getLocalAddress();
            Thread sender = this.createSender(serverAddress, this.randomPayload(1));
            sender.start();
            SocketChannel channel = ss.accept();
            channel.configureBlocking(false);
            this.selector.register(node, channel);
            KafkaChannel kafkaChannel = (KafkaChannel)this.selector.channels().get(0);
            SelectionKey key = kafkaChannel.selectionKey();
            this.selector.removeChannelKeyFromSelection(kafkaChannel);
            Assertions.assertTrue((boolean)kafkaChannel.isConnected());
            Assertions.assertFalse((boolean)key.isValid());
            Assertions.assertNull((Object)key.attachment());
            this.selector.poll(1000L);
            Assertions.assertEquals((int)0, (int)this.selector.completedReceives().size());
            kafkaChannel = this.selector.channel(kafkaChannel.id());
            this.selector.close(kafkaChannel.id());
            Assertions.assertEquals((int)0, (int)this.selector.channels().size());
            Assertions.assertEquals((Object)ChannelState.LOCAL_CLOSE, (Object)kafkaChannel.state());
            Assertions.assertFalse((boolean)kafkaChannel.isConnected());
        }
    }

    private String blockingRequest(String node, String s) throws IOException {
        NetworkReceive receive;
        this.selector.send(this.createSend(node, s));
        block0: while (true) {
            this.selector.poll(1000L);
            Iterator iterator = this.selector.completedReceives().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(receive = (NetworkReceive)iterator.next()).source().equals(node));
            break;
        }
        return this.asString(receive);
    }

    protected void connect(String node, InetSocketAddress serverAddr) throws IOException {
        this.selector.connect(node, serverAddr, 4096, 4096);
    }

    private void blockingConnect(String node) throws IOException {
        this.blockingConnect(node, new InetSocketAddress("localhost", this.server.port));
    }

    protected void blockingConnect(String node, InetSocketAddress serverAddr) throws IOException {
        this.selector.connect(node, serverAddr, 4096, 4096);
        NetworkTestUtils.waitForChannelReady(this.selector, node);
    }

    protected final NetworkSend createSend(String node, String payload) {
        return new NetworkSend(node, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(payload.getBytes())));
    }

    protected String asString(NetworkReceive receive) {
        return new String(Utils.toArray((ByteBuffer)receive.payload()));
    }

    private void sendAndReceive(String node, String requestPrefix, int startIndex, int endIndex) throws Exception {
        int requests = startIndex;
        int responses = startIndex;
        this.selector.send(this.createSend(node, requestPrefix + "-" + startIndex));
        ++requests;
        while (responses < endIndex) {
            this.selector.poll(0L);
            Assertions.assertEquals((int)0, (int)this.selector.disconnected().size(), (String)"No disconnects should have occurred.");
            for (NetworkReceive receive : this.selector.completedReceives()) {
                Assertions.assertEquals((Object)(requestPrefix + "-" + responses), (Object)this.asString(receive));
                ++responses;
            }
            for (int i = 0; i < this.selector.completedSends().size() && requests < endIndex; ++i, ++requests) {
                this.selector.send(this.createSend(node, requestPrefix + "-" + requests));
            }
        }
    }

    private void verifyNonEmptyImmediatelyConnectedKeys(Selector selector) throws Exception {
        Field field = Selector.class.getDeclaredField("immediatelyConnectedKeys");
        field.setAccessible(true);
        Collection immediatelyConnectedKeys = (Collection)field.get(selector);
        Assertions.assertFalse((boolean)immediatelyConnectedKeys.isEmpty());
    }

    private void verifyEmptyImmediatelyConnectedKeys(Selector selector) throws Exception {
        Field field = Selector.class.getDeclaredField("immediatelyConnectedKeys");
        SelectorTest.ensureEmptySelectorField(selector, field);
    }

    protected void verifySelectorEmpty() throws Exception {
        SelectorTest.verifySelectorEmpty(this.selector);
    }

    public static void verifySelectorEmpty(Selector selector) throws Exception {
        for (KafkaChannel channel : selector.channels()) {
            selector.close(channel.id());
            Assertions.assertNull((Object)channel.selectionKey().attachment());
        }
        selector.poll(0L);
        selector.poll(0L);
        SelectorTest.ensureEmptySelectorFields(selector);
    }

    private static void ensureEmptySelectorFields(Selector selector) throws Exception {
        for (Field field : Selector.class.getDeclaredFields()) {
            SelectorTest.ensureEmptySelectorField(selector, field);
        }
    }

    private static void ensureEmptySelectorField(Selector selector, Field field) throws Exception {
        field.setAccessible(true);
        Object obj = field.get(selector);
        if (obj instanceof Collection) {
            Assertions.assertTrue((boolean)((Collection)obj).isEmpty(), (String)("Field not empty: " + field + " " + obj));
        } else if (obj instanceof Map) {
            Assertions.assertTrue((boolean)((Map)obj).isEmpty(), (String)("Field not empty: " + field + " " + obj));
        }
    }

    private KafkaMetric getMetric(String name) throws Exception {
        Optional<Map.Entry> metric = this.metrics.metrics().entrySet().stream().filter(entry -> ((MetricName)entry.getKey()).name().equals(name)).findFirst();
        if (!metric.isPresent()) {
            throw new Exception(String.format("Could not find metric called %s", name));
        }
        return (KafkaMetric)metric.get().getValue();
    }

    private KafkaMetric findUntaggedMetricByName(String name) {
        MetricName metricName = new MetricName(name, "MetricGroup-metrics", "", new HashMap());
        KafkaMetric metric = (KafkaMetric)this.metrics.metrics().get(metricName);
        Assertions.assertNotNull((Object)metric);
        return metric;
    }

    private KafkaChannel createConnectionWithPendingReceives(int pendingReceives) throws Exception {
        String id = "0";
        this.blockingConnect(id);
        KafkaChannel channel = this.selector.channel(id);
        this.sendNoReceive(channel, pendingReceives);
        return channel;
    }

    private void sendNoReceive(KafkaChannel channel, int numRequests) throws Exception {
        this.selector.mute(channel.id());
        for (int i = 0; i < numRequests; ++i) {
            this.selector.send(this.createSend(channel.id(), String.valueOf(i)));
            do {
                this.selector.poll(10L);
            } while (this.selector.completedSends().isEmpty());
        }
        this.selector.unmute(channel.id());
    }

    private void injectNetworkReceive(KafkaChannel channel, int size) throws Exception {
        NetworkReceive receive = new NetworkReceive();
        TestUtils.setFieldValue(channel, "receive", receive);
        ByteBuffer sizeBuffer = (ByteBuffer)TestUtils.fieldValue(receive, NetworkReceive.class, "size");
        sizeBuffer.putInt(size);
        TestUtils.setFieldValue(receive, "buffer", ByteBuffer.allocate(size));
    }

    private static class ImmediatelyConnectingSelector
    extends Selector {
        public ImmediatelyConnectingSelector(long connectionMaxIdleMS, Metrics metrics, Time time, String metricGrpPrefix, ChannelBuilder channelBuilder, LogContext logContext) {
            super(connectionMaxIdleMS, metrics, time, metricGrpPrefix, channelBuilder, logContext);
        }

        protected boolean doConnect(SocketChannel channel, InetSocketAddress address) throws IOException {
            channel.configureBlocking(true);
            boolean connected = super.doConnect(channel, address);
            channel.configureBlocking(false);
            return connected;
        }
    }
}

