/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.common.message.DescribeEvenClusterLoadStatusResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusRequest;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeEvenClusterLoadStatusResponseTest {
    @Test
    public void testErrorCounts() {
        DescribeEvenClusterLoadStatusRequest request = (DescribeEvenClusterLoadStatusRequest)new DescribeEvenClusterLoadStatusRequest.Builder().build();
        DescribeEvenClusterLoadStatusResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    @Test
    public void testResponseFields() {
        DescribeEvenClusterLoadStatusResponse response = new DescribeEvenClusterLoadStatusResponse(new DescribeEvenClusterLoadStatusResponseData().setEvenClusterLoadStatus(new DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse().setCurrentStatus(EvenClusterLoadStatus.BALANCING.name()).setCurrentStatusLastUpdateTimeMs(102L).setPreviousStatus(EvenClusterLoadStatus.BALANCING_FAILED.name()).setPreviousStatusLastUpdateTimeMs(100L).setEvenClusterLoadErrorCode(Errors.BALANCER_OPERATION_OVERRIDDEN.code()).setEvenClusterLoadErrorMessage(Errors.BALANCER_OPERATION_OVERRIDDEN.message())));
        DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse evenClusterLoadStatusResponse = response.data().evenClusterLoadStatus();
        Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING.name(), (Object)evenClusterLoadStatusResponse.currentStatus());
        Assertions.assertEquals((long)102L, (long)evenClusterLoadStatusResponse.currentStatusLastUpdateTimeMs());
        Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING_FAILED.name(), (Object)evenClusterLoadStatusResponse.previousStatus());
        Assertions.assertEquals((long)100L, (long)evenClusterLoadStatusResponse.previousStatusLastUpdateTimeMs());
        Assertions.assertEquals((short)Errors.BALANCER_OPERATION_OVERRIDDEN.code(), (short)evenClusterLoadStatusResponse.evenClusterLoadErrorCode());
        Assertions.assertEquals((Object)Errors.BALANCER_OPERATION_OVERRIDDEN.message(), (Object)evenClusterLoadStatusResponse.evenClusterLoadErrorMessage());
    }

    @Test
    public void testToString() {
        DescribeEvenClusterLoadStatusRequest request = (DescribeEvenClusterLoadStatusRequest)new DescribeEvenClusterLoadStatusRequest.Builder().build();
        DescribeEvenClusterLoadStatusResponse response = request.getErrorResponse(0, (Throwable)Errors.NOT_CONTROLLER.exception());
        String responseStr = response.toString();
        Assertions.assertTrue((boolean)responseStr.contains(DescribeEvenClusterLoadStatusResponse.class.getSimpleName()));
        Assertions.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NOT_CONTROLLER.code()));
    }

    @Test
    public void testApiVersions() {
        DescribeEvenClusterLoadStatusResponseData responseData = new DescribeEvenClusterLoadStatusResponseData().setEvenClusterLoadStatus(new DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse().setHealUnevenLoadTrigger(BalancerSelfHealMode.EMPTY_BROKER.name()).setCurrentStatus(EvenClusterLoadStatus.BALANCING.name()).setCurrentStatusLastUpdateTimeMs(102L).setPreviousStatus(EvenClusterLoadStatus.BALANCING_FAILED.name()).setPreviousStatusLastUpdateTimeMs(100L).setEvenClusterLoadErrorCode(Errors.BALANCER_OPERATION_OVERRIDDEN.code()).setEvenClusterLoadErrorMessage(Errors.BALANCER_OPERATION_OVERRIDDEN.message()));
        DescribeEvenClusterLoadStatusResponse response = DescribeEvenClusterLoadStatusResponse.prepareResponse((short)0, (int)0, (DescribeEvenClusterLoadStatusResponseData)responseData);
        DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse evenClusterLoadStatusResponse = response.data().evenClusterLoadStatus();
        Assertions.assertEquals((Object)EvenClusterLoadStatus.DISABLED.name(), (Object)evenClusterLoadStatusResponse.currentStatus());
        Assertions.assertEquals((long)0L, (long)evenClusterLoadStatusResponse.currentStatusLastUpdateTimeMs());
        Assertions.assertNull((Object)evenClusterLoadStatusResponse.previousStatus());
        Assertions.assertEquals((long)0L, (long)evenClusterLoadStatusResponse.previousStatusLastUpdateTimeMs());
        Assertions.assertEquals((short)0, (short)evenClusterLoadStatusResponse.evenClusterLoadErrorCode());
        Assertions.assertNull((Object)evenClusterLoadStatusResponse.evenClusterLoadErrorMessage());
        responseData = new DescribeEvenClusterLoadStatusResponseData().setEvenClusterLoadStatus(new DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse().setCurrentStatus(EvenClusterLoadStatus.BALANCING.name()).setCurrentStatusLastUpdateTimeMs(102L).setPreviousStatus(EvenClusterLoadStatus.BALANCING_FAILED.name()).setPreviousStatusLastUpdateTimeMs(100L).setEvenClusterLoadErrorCode(Errors.BALANCER_OPERATION_OVERRIDDEN.code()).setEvenClusterLoadErrorMessage(Errors.BALANCER_OPERATION_OVERRIDDEN.message()));
        response = DescribeEvenClusterLoadStatusResponse.prepareResponse((short)0, (int)0, (DescribeEvenClusterLoadStatusResponseData)responseData);
        evenClusterLoadStatusResponse = response.data().evenClusterLoadStatus();
        Assertions.assertEquals((Object)"", (Object)evenClusterLoadStatusResponse.healUnevenLoadTrigger());
        Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING.name(), (Object)evenClusterLoadStatusResponse.currentStatus());
        Assertions.assertEquals((long)102L, (long)evenClusterLoadStatusResponse.currentStatusLastUpdateTimeMs());
        Assertions.assertEquals((Object)EvenClusterLoadStatus.BALANCING_FAILED.name(), (Object)evenClusterLoadStatusResponse.previousStatus());
        Assertions.assertEquals((long)100L, (long)evenClusterLoadStatusResponse.previousStatusLastUpdateTimeMs());
        Assertions.assertEquals((short)Errors.BALANCER_OPERATION_OVERRIDDEN.code(), (short)evenClusterLoadStatusResponse.evenClusterLoadErrorCode());
        Assertions.assertEquals((Object)Errors.BALANCER_OPERATION_OVERRIDDEN.message(), (Object)evenClusterLoadStatusResponse.evenClusterLoadErrorMessage());
    }
}

