/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReportQuotaConsumptionRequestTest {
    @Test
    public void testGetErrorResponseWithEntities() {
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.entries().add(new ReportQuotaConsumptionRequestData.EntryData().setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("confluent-tenant").setEntityName("lkc-abcdef"))).setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("ingress").setThrottled(false).setUsage(100.0))));
        ReportQuotaConsumptionRequest req = new ReportQuotaConsumptionRequest(data, 0);
        ReportQuotaConsumptionResponse resp = req.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)resp.errorCounts());
    }

    @Test
    public void testEmpyErrorCountsWhenNoErrors() {
        ReportQuotaConsumptionResponseData data = new ReportQuotaConsumptionResponseData().setThrottleTimeMs(10);
        ReportQuotaConsumptionResponse response = new ReportQuotaConsumptionResponse(data);
        Assertions.assertEquals(Collections.emptyMap(), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsOneError() {
        ReportQuotaConsumptionResponseData data = new ReportQuotaConsumptionResponseData().setThrottleTimeMs(10);
        data.entries().add(new ReportQuotaConsumptionResponseData.EntryData().setErrorCode(Errors.NOT_COORDINATOR.code()));
        ReportQuotaConsumptionResponse response = new ReportQuotaConsumptionResponse(data);
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals((int)1, (int)errorCounts.size());
        Assertions.assertEquals((int)1, (Integer)((Integer)errorCounts.get(Errors.NOT_COORDINATOR)));
    }
}

