/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.BrokerReplicaExclusionNotFoundException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.message.AlterCellResponseData;
import org.apache.kafka.common.message.AlterClientQuotasResponseData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.message.AppendRecordsResponseData;
import org.apache.kafka.common.message.AssignBrokersToCellResponseData;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.ComputeEvenClusterLoadPlanResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateCellResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteCellResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteTenantsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeBalancerStatusResponseData;
import org.apache.kafka.common.message.DescribeBrokerAdditionsResponseData;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.message.DescribeBrokerRemovalsResponseData;
import org.apache.kafka.common.message.DescribeBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.DescribeBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.message.DescribeCellLoadResponseData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeEvenClusterLoadStatusResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeNetworkRequestData;
import org.apache.kafka.common.message.DescribeNetworkResponseData;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.common.message.DescribeTransactionsRequestData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DrainCellResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.message.EnvelopeResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.message.InitiateShutdownResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.ListTransactionsRequestData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.message.PublishQuotaTargetResponseData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.message.RemoveBrokersResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionResponseData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TriggerEvenClusterLoadResponseData;
import org.apache.kafka.common.message.UnAssignBrokersFromCellResponseData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.AlterCellRequest;
import org.apache.kafka.common.requests.AlterCellResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.AppendRecordsRequest;
import org.apache.kafka.common.requests.AppendRecordsResponse;
import org.apache.kafka.common.requests.AssignBrokersToCellRequest;
import org.apache.kafka.common.requests.AssignBrokersToCellResponse;
import org.apache.kafka.common.requests.AssignTenantsToCellRequest;
import org.apache.kafka.common.requests.AssignTenantsToCellResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanRequest;
import org.apache.kafka.common.requests.ComputeEvenClusterLoadPlanResponse;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateCellRequest;
import org.apache.kafka.common.requests.CreateCellResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteCellRequest;
import org.apache.kafka.common.requests.DeleteCellResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTenantsRequest;
import org.apache.kafka.common.requests.DeleteTenantsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeBalancerStatusRequest;
import org.apache.kafka.common.requests.DescribeBalancerStatusResponse;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsRequest;
import org.apache.kafka.common.requests.DescribeBrokerAdditionsResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthRequest;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsRequest;
import org.apache.kafka.common.requests.DescribeBrokerRemovalsResponse;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.DescribeBrokerReplicaExclusionsResponse;
import org.apache.kafka.common.requests.DescribeCellLoadRequest;
import org.apache.kafka.common.requests.DescribeCellLoadResponse;
import org.apache.kafka.common.requests.DescribeCellsRequest;
import org.apache.kafka.common.requests.DescribeCellsResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusRequest;
import org.apache.kafka.common.requests.DescribeEvenClusterLoadStatusResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeNetworkRequest;
import org.apache.kafka.common.requests.DescribeNetworkResponse;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeProducersResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.DescribeTenantsRequest;
import org.apache.kafka.common.requests.DescribeTenantsResponse;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DrainCellRequest;
import org.apache.kafka.common.requests.DrainCellResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.InitiateShutdownRequest;
import org.apache.kafka.common.requests.InitiateShutdownResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.ListTransactionsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.requests.PublishQuotaTargetResponse;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.common.requests.RemoveBrokersResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadRequest;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadResponse;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellRequest;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class RequestResponseTest {
    private final UnknownServerException unknownServerException = new UnknownServerException("secret");

    @Test
    public void testSerialization() {
        HashMap<ApiKeys, List> toSkip = new HashMap<ApiKeys, List>();
        toSkip.put(ApiKeys.METADATA, Collections.singletonList((short)0));
        toSkip.put(ApiKeys.DESCRIBE_LOG_DIRS, Arrays.asList((short)0, (short)1, (short)2));
        toSkip.put(ApiKeys.ELECT_LEADERS, Collections.singletonList((short)0));
        toSkip.put(ApiKeys.REPLICA_STATUS, ApiKeys.REPLICA_STATUS.allVersions());
        toSkip.put(ApiKeys.CREATE_CLUSTER_LINKS, ApiKeys.CREATE_CLUSTER_LINKS.allVersions());
        toSkip.put(ApiKeys.LIST_CLUSTER_LINKS, ApiKeys.LIST_CLUSTER_LINKS.allVersions());
        toSkip.put(ApiKeys.DELETE_CLUSTER_LINKS, ApiKeys.DELETE_CLUSTER_LINKS.allVersions());
        toSkip.put(ApiKeys.ALTER_MIRRORS, ApiKeys.ALTER_MIRRORS.allVersions());
        toSkip.put(ApiKeys.LIST_MIRRORS, ApiKeys.LIST_MIRRORS.allVersions());
        toSkip.put(ApiKeys.DESCRIBE_MIRRORS, ApiKeys.DESCRIBE_MIRRORS.allVersions());
        toSkip.put(ApiKeys.INITIATE_REVERSE_CONNECTIONS, ApiKeys.INITIATE_REVERSE_CONNECTIONS.allVersions());
        toSkip.put(ApiKeys.REVERSE_CONNECTION, ApiKeys.REVERSE_CONNECTION.allVersions());
        toSkip.put(ApiKeys.DESCRIBE_CLUSTER_LINKS, ApiKeys.DESCRIBE_CLUSTER_LINKS.allVersions());
        toSkip.put(ApiKeys.ALTER_MIRROR_TOPICS, ApiKeys.ALTER_MIRROR_TOPICS.allVersions());
        for (ApiKeys apikey : ApiKeys.values()) {
            Iterator iterator = apikey.allVersions().iterator();
            while (iterator.hasNext()) {
                short version = (Short)iterator.next();
                if (toSkip.containsKey(apikey) && ((List)toSkip.get(apikey)).contains(version)) continue;
                AbstractRequest request = this.getRequest(apikey, version);
                this.checkRequest(request);
                this.checkErrorResponse(request, (Throwable)this.unknownServerException);
                this.checkResponse(this.getResponse(apikey, version), version);
            }
        }
    }

    @Test
    public void testSerializationSpecialCases() {
        short version;
        this.checkResponse((AbstractResponse)this.createProduceResponseWithErrorMessage(), (short)8);
        this.checkResponse((AbstractResponse)this.createFetchResponse(true), (short)4);
        ArrayList<TopicIdPartition> toForgetTopics = new ArrayList<TopicIdPartition>();
        toForgetTopics.add(new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0)));
        toForgetTopics.add(new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 2)));
        toForgetTopics.add(new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("bar", 0)));
        this.checkRequest((AbstractRequest)this.createFetchRequest((short)7, new FetchMetadata(123, 456), toForgetTopics));
        this.checkResponse((AbstractResponse)this.createFetchResponse(123), (short)7);
        this.checkResponse((AbstractResponse)this.createFetchResponse(Errors.FETCH_SESSION_ID_NOT_FOUND, 123), (short)7);
        this.checkOlderFetchVersions();
        this.checkRequest((AbstractRequest)MetadataRequest.Builder.allTopics().build((short)2));
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestWithMultipleGroups((short)8, true));
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestWithMultipleGroups((short)8, false));
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestForAllPartition((short)7, true));
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestForAllPartition((short)8, true));
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequestWithMultipleGroups((short)8, true), (Throwable)this.unknownServerException);
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequestForAllPartition((short)7, true), (Throwable)new NotCoordinatorException("Not Coordinator"));
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequestForAllPartition((short)8, true), (Throwable)new NotCoordinatorException("Not Coordinator"));
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequestWithMultipleGroups((short)8, true), (Throwable)new NotCoordinatorException("Not Coordinator"));
        Iterator iterator = ApiKeys.METADATA.allVersions().iterator();
        while (iterator.hasNext()) {
            version = (Short)iterator.next();
            if (version > 0) {
                this.checkRequest((AbstractRequest)MetadataRequest.Builder.allTopics().build(version));
                this.checkRequest((AbstractRequest)this.createMetadataRequest(version, Collections.singletonList("topic1")));
                this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(version, Collections.singletonList("topic1")), (Throwable)this.unknownServerException);
            }
            this.checkResponse((AbstractResponse)this.createMetadataResponse(version), version);
        }
        iterator = ApiKeys.STOP_REPLICA.allVersions().iterator();
        while (iterator.hasNext()) {
            version = (Short)iterator.next();
            this.checkRequest((AbstractRequest)this.createStopReplicaRequest(version, true));
            this.checkRequest((AbstractRequest)this.createStopReplicaRequest(version, false));
            this.checkErrorResponse((AbstractRequest)this.createStopReplicaRequest(version, true), (Throwable)this.unknownServerException);
            this.checkErrorResponse((AbstractRequest)this.createStopReplicaRequest(version, false), (Throwable)this.unknownServerException);
            this.checkResponse((AbstractResponse)this.createStopReplicaResponse(), version);
        }
        iterator = ApiKeys.CREATE_PARTITIONS.allVersions().iterator();
        while (iterator.hasNext()) {
            version = (Short)iterator.next();
            this.checkRequest((AbstractRequest)this.createCreatePartitionsRequest(version));
            this.checkRequest((AbstractRequest)this.createCreatePartitionsRequestWithAssignments(version));
            this.checkErrorResponse((AbstractRequest)this.createCreatePartitionsRequest(version), (Throwable)this.unknownServerException);
            this.checkResponse((AbstractResponse)this.createCreatePartitionsResponse(), version);
        }
        iterator = ApiKeys.UPDATE_METADATA.allVersions().iterator();
        while (iterator.hasNext()) {
            version = (Short)iterator.next();
            this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(version, null));
            this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(version, "rack1"));
            this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(version, null), (Throwable)this.unknownServerException);
            this.checkResponse((AbstractResponse)this.createUpdateMetadataResponse(), version);
        }
        this.checkRequest((AbstractRequest)this.createLeaderEpochRequestForConsumer());
        this.checkErrorResponse((AbstractRequest)this.createLeaderEpochRequestForConsumer(), (Throwable)this.unknownServerException);
        this.checkRequest((AbstractRequest)this.createTxnOffsetCommitRequestWithAutoDowngrade());
        this.checkErrorResponse((AbstractRequest)this.createTxnOffsetCommitRequestWithAutoDowngrade(), (Throwable)this.unknownServerException);
        this.checkErrorResponse((AbstractRequest)this.createDescribeAclsRequest((short)0), (Throwable)new SecurityDisabledException("Security is not enabled."));
        this.checkErrorResponse((AbstractRequest)this.createCreateAclsRequest((short)0), (Throwable)new SecurityDisabledException("Security is not enabled."));
        this.checkErrorResponse((AbstractRequest)this.createDeleteAclsRequest((short)0), (Throwable)new SecurityDisabledException("Security is not enabled."));
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithConfigEntries((short)0));
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithConfigEntries((short)1));
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithDocumentation((short)1));
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithDocumentation((short)2));
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithDocumentation((short)3));
        this.checkDescribeConfigsResponseVersions();
        this.checkRequest((AbstractRequest)this.createElectLeadersRequestNullPartitions());
        this.checkResponse((AbstractResponse)this.createDescribeBrokerRemovalsResponse(), (short)1);
    }

    @Test
    public void testApiVersionsSerialization() {
        Iterator iterator = ApiKeys.API_VERSIONS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            this.checkErrorResponse((AbstractRequest)this.createApiVersionRequest(version), new UnsupportedVersionException("Not Supported"));
            this.checkResponse((AbstractResponse)TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.ZK_BROKER), version);
        }
    }

    @Test
    public void testBatchedFindCoordinatorRequestSerialization() {
        Iterator iterator = ApiKeys.FIND_COORDINATOR.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            this.checkRequest((AbstractRequest)this.createBatchedFindCoordinatorRequest(Collections.singletonList("group1"), version));
            if (version < 4) {
                Assertions.assertThrows(FindCoordinatorRequest.NoBatchedFindCoordinatorsException.class, () -> this.createBatchedFindCoordinatorRequest(Arrays.asList("group1", "group2"), version));
                continue;
            }
            this.checkRequest((AbstractRequest)this.createBatchedFindCoordinatorRequest(Arrays.asList("group1", "group2"), version));
        }
    }

    @Test
    public void testResponseHeader() {
        ResponseHeader header = new ResponseHeader(10, 1);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        ByteBuffer buffer = ByteBuffer.allocate(header.size(serializationCache));
        header.write(buffer, serializationCache);
        buffer.flip();
        ResponseHeader deserialized = ResponseHeader.parse((ByteBuffer)buffer, (short)header.headerVersion());
        Assertions.assertEquals((int)header.size(), (int)deserialized.size());
        Assertions.assertEquals((int)header.correlationId(), (int)deserialized.correlationId());
    }

    @Test
    public void cannotUseFindCoordinatorV0ToFindTransactionCoordinator() {
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id).setKey("foobar"));
        Assertions.assertThrows(UnsupportedVersionException.class, () -> builder.build((short)0));
    }

    @Test
    public void testProduceRequestPartitionSize() {
        TopicPartition tp0 = new TopicPartition("test", 0);
        TopicPartition tp1 = new TopicPartition("test", 1);
        MemoryRecords records0 = MemoryRecords.withRecords((byte)2, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("woot".getBytes())});
        MemoryRecords records1 = MemoryRecords.withRecords((byte)2, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("woot".getBytes()), new SimpleRecord("woot".getBytes())});
        ProduceRequest request = ProduceRequest.forMagic((byte)2, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Arrays.asList(new ProduceRequestData.TopicProduceData().setName(tp0.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(tp0.partition()).setRecords((BaseRecords)records0))), new ProduceRequestData.TopicProduceData().setName(tp1.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(tp1.partition()).setRecords((BaseRecords)records1)))).iterator())).setAcks((short)1).setTimeoutMs(5000).setTransactionalId("transactionalId")).build((short)3);
        Assertions.assertEquals((int)2, (int)request.partitionSizes().size());
        Assertions.assertEquals((int)records0.sizeInBytes(), (int)((Integer)request.partitionSizes().get(tp0)));
        Assertions.assertEquals((int)records1.sizeInBytes(), (int)((Integer)request.partitionSizes().get(tp1)));
    }

    @Test
    public void produceRequestToStringTest() {
        ProduceRequest request = this.createProduceRequest(ApiKeys.PRODUCE.latestVersion());
        Assertions.assertEquals((int)1, (int)request.data().topicData().size());
        Assertions.assertFalse((boolean)request.toString(false).contains("partitionSizes"));
        Assertions.assertTrue((boolean)request.toString(false).contains("numPartitions=1"));
        Assertions.assertTrue((boolean)request.toString(true).contains("partitionSizes"));
        Assertions.assertFalse((boolean)request.toString(true).contains("numPartitions"));
        request.clearPartitionRecords();
        try {
            request.data();
            Assertions.fail((String)"dataOrException should fail after clearPartitionRecords()");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)request.toString(false).contains("partitionSizes"));
        Assertions.assertTrue((boolean)request.toString(false).contains("numPartitions=1"));
        Assertions.assertTrue((boolean)request.toString(true).contains("partitionSizes"));
        Assertions.assertFalse((boolean)request.toString(true).contains("numPartitions"));
    }

    @Test
    public void produceRequestGetErrorResponseTest() {
        ProduceRequest request = this.createProduceRequest(ApiKeys.PRODUCE.latestVersion());
        ProduceResponse errorResponse = (ProduceResponse)request.getErrorResponse((Throwable)new NotEnoughReplicasException());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)errorResponse.data().responses().iterator().next();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)topicProduceResponse.partitionResponses().iterator().next();
        Assertions.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        request.clearPartitionRecords();
        errorResponse = (ProduceResponse)request.getErrorResponse((Throwable)new NotEnoughReplicasException());
        topicProduceResponse = (ProduceResponseData.TopicProduceResponse)errorResponse.data().responses().iterator().next();
        partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)topicProduceResponse.partitionResponses().iterator().next();
        Assertions.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
    }

    @Test
    public void fetchResponseVersionTest() {
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        Uuid id = Uuid.randomUuid();
        Map<Uuid, String> topicNames = Collections.singletonMap(id, "test");
        TopicPartition tp = new TopicPartition("test", 0);
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(1000000L).setLogStartOffset(-1L).setRecords((BaseRecords)records);
        responseData.put(new TopicIdPartition(Uuid.ZERO_UUID, tp), partitionData);
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> tpResponseData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        tpResponseData.put(tp, partitionData);
        FetchResponse v0Response = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, responseData);
        FetchResponse v1Response = FetchResponse.of((Errors)Errors.NONE, (int)10, (int)0, responseData);
        FetchResponse v0Deserialized = FetchResponse.parse((ByteBuffer)v0Response.serialize((short)0), (short)0, (MessageContext)MessageContext.IDENTITY);
        FetchResponse v1Deserialized = FetchResponse.parse((ByteBuffer)v1Response.serialize((short)1), (short)1, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((int)0, (int)v0Deserialized.throttleTimeMs(), (String)"Throttle time must be zero");
        Assertions.assertEquals((int)10, (int)v1Deserialized.throttleTimeMs(), (String)"Throttle time must be 10");
        Assertions.assertEquals(tpResponseData, (Object)v0Deserialized.responseData(topicNames, (short)0), (String)"Response data does not match");
        Assertions.assertEquals(tpResponseData, (Object)v1Deserialized.responseData(topicNames, (short)1), (String)"Response data does not match");
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> idResponseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        idResponseData.put(new TopicIdPartition(id, new TopicPartition("test", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(1000000L).setLogStartOffset(-1L).setRecords((BaseRecords)records));
        FetchResponse idTestResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, idResponseData);
        FetchResponse v12Deserialized = FetchResponse.parse((ByteBuffer)idTestResponse.serialize((short)12), (short)12, (MessageContext)MessageContext.IDENTITY);
        FetchResponse newestDeserialized = FetchResponse.parse((ByteBuffer)idTestResponse.serialize(ApiKeys.FETCH.latestVersion()), (short)ApiKeys.FETCH.latestVersion(), (MessageContext)MessageContext.IDENTITY);
        Assertions.assertTrue((boolean)v12Deserialized.topicIds().isEmpty());
        Assertions.assertEquals((int)1, (int)newestDeserialized.topicIds().size());
        Assertions.assertTrue((boolean)newestDeserialized.topicIds().contains(id));
    }

    @Test
    public void testFetchResponseV4() {
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        topicNames.put(Uuid.randomUuid(), "bar");
        topicNames.put(Uuid.randomUuid(), "foo");
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Arrays.asList(new FetchResponseData.AbortedTransaction().setProducerId(10L).setFirstOffset(100L), new FetchResponseData.AbortedTransaction().setProducerId(15L).setFirstOffset(50L));
        responseData.put(new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("bar", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(1000000L).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)records));
        responseData.put(new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("bar", 1)), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(900000L).setLastStableOffset(5L).setRecords((BaseRecords)records));
        responseData.put(new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(70000L).setLastStableOffset(6L).setRecords((BaseRecords)records));
        FetchResponse response = FetchResponse.of((Errors)Errors.NONE, (int)10, (int)0, responseData);
        FetchResponse deserialized = FetchResponse.parse((ByteBuffer)response.serialize((short)4), (short)4, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals(responseData.entrySet().stream().collect(Collectors.toMap(e -> ((TopicIdPartition)e.getKey()).topicPartition(), Map.Entry::getValue)), (Object)deserialized.responseData(topicNames, (short)4));
    }

    @Test
    public void verifyFetchResponseFullWrites() throws Exception {
        this.verifyFetchResponseFullWrite(ApiKeys.FETCH.latestVersion(), this.createFetchResponse(123));
        this.verifyFetchResponseFullWrite(ApiKeys.FETCH.latestVersion(), this.createFetchResponse(Errors.FETCH_SESSION_ID_NOT_FOUND, 123));
        Iterator iterator = ApiKeys.FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version;
            this.verifyFetchResponseFullWrite(version, this.createFetchResponse((version = ((Short)iterator.next()).shortValue()) >= 4));
        }
    }

    private void verifyFetchResponseFullWrite(short version, FetchResponse fetchResponse) throws Exception {
        int correlationId = 15;
        short responseHeaderVersion = ApiKeys.FETCH.responseHeaderVersion(version);
        Send send = fetchResponse.toSend(new ResponseHeader(correlationId, responseHeaderVersion), version);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)channel);
        channel.close();
        ByteBuffer buf = channel.buffer();
        int size = buf.getInt();
        Assertions.assertTrue((size > 0 ? 1 : 0) != 0);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)channel.buffer(), (short)responseHeaderVersion);
        Assertions.assertEquals((int)correlationId, (int)responseHeader.correlationId());
        Assertions.assertEquals((Object)fetchResponse.serialize(version), (Object)buf);
        FetchResponseData deserialized = new FetchResponseData((Readable)new ByteBufferAccessor(buf), version, MessageContext.IDENTITY);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        Assertions.assertEquals((int)size, (int)(responseHeader.size() + deserialized.size(serializationCache, version)));
    }

    @Test
    public void testControlledShutdownResponse() {
        ControlledShutdownResponse response = this.createControlledShutdownResponse();
        short version = ApiKeys.CONTROLLED_SHUTDOWN.latestVersion();
        ByteBuffer buffer = response.serialize(version);
        ControlledShutdownResponse deserialized = ControlledShutdownResponse.parse((ByteBuffer)buffer, (short)version, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)response.error(), (Object)deserialized.error());
        Assertions.assertEquals((Object)response.data().remainingPartitions(), (Object)deserialized.data().remainingPartitions());
    }

    @Test
    public void testCreateTopicRequestV0FailsIfValidateOnly() {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.createCreateTopicRequest((short)0, true));
    }

    @Test
    public void testCreateTopicRequestV3FailsIfNoPartitionsOrReplicas() {
        UnsupportedVersionException exception = (UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> {
            CreateTopicsRequestData data = new CreateTopicsRequestData().setTimeoutMs(123).setValidateOnly(false);
            data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(-1).setReplicationFactor((short)1));
            data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(1).setReplicationFactor((short)-1));
            new CreateTopicsRequest.Builder(data).build((short)3);
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("supported in CreateTopicRequest version 4+"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("[foo, bar]"));
    }

    @Test
    public void testFetchRequestMaxBytesOldVersions() {
        boolean version = true;
        FetchRequest fr = this.createFetchRequest((short)1);
        FetchRequest fr2 = FetchRequest.parse((ByteBuffer)fr.serialize(), (short)1, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((int)fr2.maxBytes(), (int)fr.maxBytes());
    }

    @Test
    public void testFetchRequestIsolationLevel() {
        FetchRequest request = this.createFetchRequest((short)4, IsolationLevel.READ_COMMITTED);
        FetchRequest deserialized = (FetchRequest)AbstractRequest.parseRequest((ApiKeys)request.apiKey(), (short)request.version(), (ByteBuffer)request.serialize(), (MessageContext)MessageContext.IDENTITY).request;
        Assertions.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
        request = this.createFetchRequest((short)4, IsolationLevel.READ_UNCOMMITTED);
        deserialized = (FetchRequest)AbstractRequest.parseRequest((ApiKeys)request.apiKey(), (short)request.version(), (ByteBuffer)request.serialize(), (MessageContext)MessageContext.IDENTITY).request;
        Assertions.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
    }

    @Test
    public void testFetchRequestWithMetadata() {
        FetchRequest request = this.createFetchRequest((short)4, IsolationLevel.READ_COMMITTED);
        FetchRequest deserialized = (FetchRequest)AbstractRequest.parseRequest((ApiKeys)ApiKeys.FETCH, (short)request.version(), (ByteBuffer)request.serialize(), (MessageContext)MessageContext.IDENTITY).request;
        Assertions.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
        request = this.createFetchRequest((short)4, IsolationLevel.READ_UNCOMMITTED);
        deserialized = (FetchRequest)AbstractRequest.parseRequest((ApiKeys)ApiKeys.FETCH, (short)request.version(), (ByteBuffer)request.serialize(), (MessageContext)MessageContext.IDENTITY).request;
        Assertions.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
    }

    @Test
    public void testFetchRequestCompat() {
        HashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new HashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test", 0), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 100L, 2L, 100, Optional.empty(), Optional.of(42), Optional.empty()));
        FetchRequest req = FetchRequest.Builder.forConsumer((short)2, (int)100, (int)100, fetchData).metadata(new FetchMetadata(10, 20)).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)2);
        FetchRequestData data = req.data();
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = data.size(cache, (short)2);
        ByteBufferAccessor writer = new ByteBufferAccessor(ByteBuffer.allocate(size));
        data.write((Writable)writer, cache, (short)2);
    }

    @Test
    public void testSerializeWithHeader() {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(1);
        topicsToCreate.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName("topic").setNumPartitions(3).setReplicationFactor((short)2));
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(10).setTopics(topicsToCreate)).build();
        short requestVersion = ApiKeys.CREATE_TOPICS.latestVersion();
        RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, "client", 2);
        ByteBuffer serializedRequest = createTopicsRequest.serializeWithHeader(requestHeader);
        RequestHeader parsedHeader = RequestHeader.parse((ByteBuffer)serializedRequest);
        Assertions.assertEquals((int)requestHeader.size(), (int)parsedHeader.size());
        Assertions.assertEquals((Object)requestHeader, (Object)parsedHeader);
        RequestAndSize parsedRequest = AbstractRequest.parseRequest((ApiKeys)ApiKeys.CREATE_TOPICS, (short)requestVersion, (ByteBuffer)serializedRequest, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)createTopicsRequest.data(), (Object)parsedRequest.request.data());
    }

    @Test
    public void testSerializeWithInconsistentHeaderApiKey() {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)new CreateTopicsRequest.Builder(new CreateTopicsRequestData()).build();
        short requestVersion = ApiKeys.CREATE_TOPICS.latestVersion();
        RequestHeader requestHeader = new RequestHeader(ApiKeys.DELETE_TOPICS, requestVersion, "client", 2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> createTopicsRequest.serializeWithHeader(requestHeader));
    }

    @Test
    public void testSerializeWithInconsistentHeaderVersion() {
        CreateTopicsRequest createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData()).build((short)2);
        RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, 1, "client", 2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> createTopicsRequest.serializeWithHeader(requestHeader));
    }

    @Test
    public void testJoinGroupRequestV0RebalanceTimeout() {
        boolean version = false;
        JoinGroupRequest jgr = this.createJoinGroupRequest((short)0);
        JoinGroupRequest jgr2 = JoinGroupRequest.parse((ByteBuffer)jgr.serialize(), (short)0, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((int)jgr2.data().rebalanceTimeoutMs(), (int)jgr.data().rebalanceTimeoutMs());
    }

    @Test
    public void testOffsetFetchRequestBuilderToStringV0ToV7() {
        List<Boolean> stableFlags = Arrays.asList(true, false);
        for (Boolean requireStable : stableFlags) {
            String allTopicPartitionsString = new OffsetFetchRequest.Builder("someGroup", requireStable.booleanValue(), null, false).toString();
            Assertions.assertTrue((boolean)allTopicPartitionsString.contains("groupId='', topics=[], groups=[OffsetFetchRequestGroup(groupId='someGroup', memberId=null, memberEpoch=-1, topics=null)], requireStable=" + requireStable));
            String string = new OffsetFetchRequest.Builder("group1", requireStable.booleanValue(), Collections.singletonList(new TopicPartition("test11", 1)), false).toString();
            Assertions.assertTrue((boolean)string.contains("test11"));
            Assertions.assertTrue((boolean)string.contains("group1"));
            Assertions.assertTrue((boolean)string.contains("requireStable=" + requireStable));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testOffsetFetchRequestBuilderToStringV8AndAbove(boolean requireStable) {
        String allTopicPartitionsString = new OffsetFetchRequest.Builder(Collections.singletonMap("someGroup", null), requireStable, false).toString();
        Assertions.assertTrue((boolean)allTopicPartitionsString.contains("groups=[OffsetFetchRequestGroup(groupId='someGroup', memberId=null, memberEpoch=-1, topics=null)], requireStable=" + requireStable));
        String subsetTopicPartitionsString = new OffsetFetchRequest.Builder(Collections.singletonMap("group1", Collections.singletonList(new TopicPartition("test11", 1))), requireStable, false).toString();
        Assertions.assertTrue((boolean)subsetTopicPartitionsString.contains("test11"));
        Assertions.assertTrue((boolean)subsetTopicPartitionsString.contains("group1"));
        Assertions.assertTrue((boolean)subsetTopicPartitionsString.contains("requireStable=" + requireStable));
    }

    @Test
    public void testApiVersionsRequestBeforeV3Validation() {
        for (short version = 0; version < 3; version = (short)(version + 1)) {
            ApiVersionsRequest request = new ApiVersionsRequest(new ApiVersionsRequestData(), version);
            Assertions.assertTrue((boolean)request.isValid());
        }
    }

    @Test
    public void testValidApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        Assertions.assertTrue((boolean)request.isValid());
        request = new ApiVersionsRequest(new ApiVersionsRequestData().setClientSoftwareName("apache-kafka.java").setClientSoftwareVersion("0.0.0-SNAPSHOT"), ApiKeys.API_VERSIONS.latestVersion());
        Assertions.assertTrue((boolean)request.isValid());
    }

    @Test
    public void testListGroupRequestV3FailsWithStates() {
        ListGroupsRequestData data = new ListGroupsRequestData().setStatesFilter(Collections.singletonList(ConsumerGroupState.STABLE.name()));
        Assertions.assertThrows(UnsupportedVersionException.class, () -> new ListGroupsRequest.Builder(data).build((short)3));
    }

    @Test
    public void testInvalidApiVersionsRequest() {
        this.testInvalidCase("java@apache_kafka", "0.0.0-SNAPSHOT");
        this.testInvalidCase("apache-kafka-java", "0.0.0@java");
        this.testInvalidCase("-apache-kafka-java", "0.0.0");
        this.testInvalidCase("apache-kafka-java.", "0.0.0");
    }

    private void testInvalidCase(String name, String version) {
        ApiVersionsRequest request = new ApiVersionsRequest(new ApiVersionsRequestData().setClientSoftwareName(name).setClientSoftwareVersion(version), ApiKeys.API_VERSIONS.latestVersion());
        Assertions.assertFalse((boolean)request.isValid());
    }

    @Test
    public void testApiVersionResponseWithUnsupportedError() {
        Iterator iterator = ApiKeys.API_VERSIONS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ApiVersionsRequest request = new ApiVersionsRequest.Builder().build(version);
            ApiVersionsResponse response = request.getErrorResponse(0, (Throwable)Errors.UNSUPPORTED_VERSION.exception());
            Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)response.data().errorCode());
            ApiVersionsResponseData.ApiVersion apiVersion = response.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
            Assertions.assertNotNull((Object)apiVersion);
            Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
            Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
            Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
        }
    }

    @Test
    public void testApiVersionResponseWithNotUnsupportedError() {
        Iterator iterator = ApiKeys.API_VERSIONS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ApiVersionsRequest request = new ApiVersionsRequest.Builder().build(version);
            ApiVersionsResponse response = request.getErrorResponse(0, (Throwable)Errors.INVALID_REQUEST.exception());
            Assertions.assertEquals((short)response.data().errorCode(), (short)Errors.INVALID_REQUEST.code());
            Assertions.assertTrue((boolean)response.data().apiKeys().isEmpty());
        }
    }

    private ApiVersionsResponse defaultApiVersionsResponse() {
        return TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.ZK_BROKER);
    }

    @Test
    public void testApiVersionResponseParsingFallback() {
        Iterator iterator = ApiKeys.API_VERSIONS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ByteBuffer buffer = this.defaultApiVersionsResponse().serialize((short)0);
            ApiVersionsResponse response = ApiVersionsResponse.parse((ByteBuffer)buffer, (short)version, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        }
    }

    @Test
    public void testApiVersionResponseParsingFallbackException() {
        Iterator iterator = ApiKeys.API_VERSIONS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            Assertions.assertThrows(BufferUnderflowException.class, () -> ApiVersionsResponse.parse((ByteBuffer)ByteBuffer.allocate(0), (short)version, (MessageContext)MessageContext.IDENTITY));
        }
    }

    @Test
    public void testApiVersionResponseParsing() {
        Iterator iterator = ApiKeys.API_VERSIONS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ByteBuffer buffer = this.defaultApiVersionsResponse().serialize(version);
            ApiVersionsResponse response = ApiVersionsResponse.parse((ByteBuffer)buffer, (short)version, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        }
    }

    @Test
    public void testMetadataResponse() {
        MetadataResponse response = this.createMetadataResponse(ApiKeys.METADATA.latestVersion());
        Collection topicMetadatas = response.topicMetadata();
        Assertions.assertEquals((int)3, (int)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicWithObservers = topicMetadatas.stream().filter(topicMetadata -> topicMetadata.topic().equals("__consumer_offsets")).findFirst().get();
        for (MetadataResponse.PartitionMetadata partition : topicWithObservers.partitionMetadata()) {
            Assertions.assertEquals((int)2, (int)partition.replicaIds.size());
            Assertions.assertEquals((int)1, (int)partition.observerIds.size());
            Assertions.assertTrue((boolean)partition.replicaIds.containsAll(partition.observerIds));
            PartitionInfo partitionInfo = MetadataResponse.toPartitionInfo((MetadataResponse.PartitionMetadata)partition, partition.replicaIds.stream().collect(Collectors.toMap(id -> id, id -> new Node(id.intValue(), "", 9092))));
            Assertions.assertEquals((Object)partition.observerIds, Arrays.asList(partitionInfo.observers()).stream().map(Node::id).collect(Collectors.toList()));
        }
        MetadataResponse.TopicMetadata topicWithoutObservers = topicMetadatas.stream().filter(topicMetadata -> topicMetadata.topic().equals("topic3")).findFirst().get();
        for (MetadataResponse.PartitionMetadata partition : topicWithoutObservers.partitionMetadata()) {
            Assertions.assertEquals((int)1, (int)partition.replicaIds.size());
            Assertions.assertTrue((boolean)partition.observerIds.isEmpty());
            Assertions.assertEquals((int)0, (int)partition.observerIds.size());
            PartitionInfo partitionInfo = MetadataResponse.toPartitionInfo((MetadataResponse.PartitionMetadata)partition, partition.replicaIds.stream().collect(Collectors.toMap(id -> id, id -> new Node(id.intValue(), "", 9092))));
            Assertions.assertEquals((Object)partition.observerIds, Arrays.asList(partitionInfo.observers()).stream().map(Node::id).collect(Collectors.toList()));
        }
    }

    @Test
    public void testInitProducerIdRequestVersions() {
        InitProducerIdRequest.Builder bld = new InitProducerIdRequest.Builder(new InitProducerIdRequestData().setTransactionTimeoutMs(1000).setTransactionalId("abracadabra").setProducerId(123L));
        UnsupportedVersionException exception = (UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> bld.build((short)2).serialize());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Attempted to write a non-default producerId at version 2"));
        bld.build((short)3);
    }

    @Test
    public void testDeletableTopicResultErrorMessageIsNullByDefault() {
        DeleteTopicsResponseData.DeletableTopicResult result = new DeleteTopicsResponseData.DeletableTopicResult().setName("topic").setErrorCode(Errors.THROTTLING_QUOTA_EXCEEDED.code());
        Assertions.assertEquals((Object)"topic", (Object)result.name());
        Assertions.assertEquals((short)Errors.THROTTLING_QUOTA_EXCEEDED.code(), (short)result.errorCode());
        Assertions.assertNull((Object)result.errorMessage());
    }

    @Test
    public void testErrorCountsIncludesNone() {
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createAddOffsetsToTxnResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createAddPartitionsToTxnResponse((short)3).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createAddPartitionsToTxnResponse((short)4).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createAlterClientQuotasResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createAlterConfigsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createAlterPartitionReassignmentsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createAlterReplicaLogDirsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createApiVersionResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createBrokerHeartbeatResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createBrokerRegistrationResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createControlledShutdownResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createCreateAclsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createCreatePartitionsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createCreateTokenResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createCreateTopicResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createDeleteAclsResponse(ApiKeys.DELETE_ACLS.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createDeleteGroupsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createDeleteTopicsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createDescribeAclsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createDescribeClientQuotasResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createDescribeConfigsResponse(ApiKeys.DESCRIBE_CONFIGS.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createDescribeGroupResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createDescribeLogDirsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createDescribeTokenResponse(ApiKeys.DESCRIBE_DELEGATION_TOKEN.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createElectLeadersResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createEndTxnResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createExpireTokenResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)3, (Integer)((Integer)this.createFetchResponse(123).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createFindCoordinatorResponse(ApiKeys.FIND_COORDINATOR.oldestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createFindCoordinatorResponse(ApiKeys.FIND_COORDINATOR.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createHeartBeatResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createIncrementalAlterConfigsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createJoinGroupResponse(ApiKeys.JOIN_GROUP.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createLeaderAndIsrResponse((short)4).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createLeaderAndIsrResponse((short)5).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)3, (Integer)((Integer)this.createLeaderEpochResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createLeaveGroupResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createListGroupsResponse(ApiKeys.LIST_GROUPS.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createListOffsetResponse(ApiKeys.LIST_OFFSETS.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createListPartitionReassignmentsResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)3, (Integer)((Integer)this.createMetadataResponse(ApiKeys.METADATA.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createOffsetCommitResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createOffsetDeleteResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)3, (Integer)((Integer)this.createOffsetFetchResponse(ApiKeys.OFFSET_FETCH.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createProduceResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createRenewTokenResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createSaslAuthenticateResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createSaslHandshakeResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)2, (Integer)((Integer)this.createStopReplicaResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createSyncGroupResponse(ApiKeys.SYNC_GROUP.latestVersion()).errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createTxnOffsetCommitResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createUpdateMetadataResponse().errorCounts().get(Errors.NONE)));
        Assertions.assertEquals((int)1, (Integer)((Integer)this.createWriteTxnMarkersResponse().errorCounts().get(Errors.NONE)));
    }

    private AbstractRequest getRequest(ApiKeys apikey, short version) {
        switch (apikey) {
            case PRODUCE: {
                return this.createProduceRequest(version);
            }
            case FETCH: {
                return this.createFetchRequest(version);
            }
            case LIST_OFFSETS: {
                return this.createListOffsetRequest(version);
            }
            case METADATA: {
                return this.createMetadataRequest(version, Collections.singletonList("topic1"));
            }
            case LEADER_AND_ISR: {
                return this.createLeaderAndIsrRequest(version);
            }
            case STOP_REPLICA: {
                return this.createStopReplicaRequest(version, true);
            }
            case UPDATE_METADATA: {
                return this.createUpdateMetadataRequest(version, "rack1");
            }
            case CONTROLLED_SHUTDOWN: {
                return this.createControlledShutdownRequest(version);
            }
            case OFFSET_COMMIT: {
                return this.createOffsetCommitRequest(version);
            }
            case OFFSET_FETCH: {
                return this.createOffsetFetchRequest(version, true);
            }
            case FIND_COORDINATOR: {
                return this.createFindCoordinatorRequest(version);
            }
            case JOIN_GROUP: {
                return this.createJoinGroupRequest(version);
            }
            case HEARTBEAT: {
                return this.createHeartBeatRequest(version);
            }
            case LEAVE_GROUP: {
                return this.createLeaveGroupRequest(version);
            }
            case SYNC_GROUP: {
                return this.createSyncGroupRequest(version);
            }
            case DESCRIBE_GROUPS: {
                return this.createDescribeGroupRequest(version);
            }
            case LIST_GROUPS: {
                return this.createListGroupsRequest(version);
            }
            case SASL_HANDSHAKE: {
                return this.createSaslHandshakeRequest(version);
            }
            case API_VERSIONS: {
                return this.createApiVersionRequest(version);
            }
            case CREATE_TOPICS: {
                return this.createCreateTopicRequest(version);
            }
            case DELETE_TOPICS: {
                return this.createDeleteTopicsRequest(version);
            }
            case DELETE_RECORDS: {
                return this.createDeleteRecordsRequest(version);
            }
            case INIT_PRODUCER_ID: {
                return this.createInitPidRequest(version);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return this.createLeaderEpochRequestForReplica(version, 1);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return this.createAddPartitionsToTxnRequest(version);
            }
            case ADD_OFFSETS_TO_TXN: {
                return this.createAddOffsetsToTxnRequest(version);
            }
            case END_TXN: {
                return this.createEndTxnRequest(version);
            }
            case WRITE_TXN_MARKERS: {
                return this.createWriteTxnMarkersRequest(version);
            }
            case TXN_OFFSET_COMMIT: {
                return this.createTxnOffsetCommitRequest(version);
            }
            case DESCRIBE_ACLS: {
                return this.createDescribeAclsRequest(version);
            }
            case CREATE_ACLS: {
                return this.createCreateAclsRequest(version);
            }
            case DELETE_ACLS: {
                return this.createDeleteAclsRequest(version);
            }
            case DESCRIBE_CONFIGS: {
                return this.createDescribeConfigsRequest(version);
            }
            case ALTER_CONFIGS: {
                return this.createAlterConfigsRequest(version);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return this.createAlterReplicaLogDirsRequest(version);
            }
            case DESCRIBE_LOG_DIRS: {
                return this.createDescribeLogDirsRequest(version);
            }
            case SASL_AUTHENTICATE: {
                return this.createSaslAuthenticateRequest(version);
            }
            case CREATE_PARTITIONS: {
                return this.createCreatePartitionsRequest(version);
            }
            case CREATE_DELEGATION_TOKEN: {
                return this.createCreateTokenRequest(version);
            }
            case RENEW_DELEGATION_TOKEN: {
                return this.createRenewTokenRequest(version);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return this.createExpireTokenRequest(version);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return this.createDescribeTokenRequest(version);
            }
            case DELETE_GROUPS: {
                return this.createDeleteGroupsRequest(version);
            }
            case ELECT_LEADERS: {
                return this.createElectLeadersRequest(version);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return this.createIncrementalAlterConfigsRequest(version);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return this.createAlterPartitionReassignmentsRequest(version);
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return this.createListPartitionReassignmentsRequest(version);
            }
            case OFFSET_DELETE: {
                return this.createOffsetDeleteRequest(version);
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return this.createDescribeClientQuotasRequest(version);
            }
            case ALTER_CLIENT_QUOTAS: {
                return this.createAlterClientQuotasRequest(version);
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return this.createDescribeUserScramCredentialsRequest(version);
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return this.createAlterUserScramCredentialsRequest(version);
            }
            case VOTE: {
                return this.createVoteRequest(version);
            }
            case BEGIN_QUORUM_EPOCH: {
                return this.createBeginQuorumEpochRequest(version);
            }
            case END_QUORUM_EPOCH: {
                return this.createEndQuorumEpochRequest(version);
            }
            case DESCRIBE_QUORUM: {
                return this.createDescribeQuorumRequest(version);
            }
            case ALTER_PARTITION: {
                return this.createAlterPartitionRequest(version);
            }
            case UPDATE_FEATURES: {
                return this.createUpdateFeaturesRequest(version);
            }
            case ENVELOPE: {
                return this.createEnvelopeRequest(version);
            }
            case FETCH_SNAPSHOT: {
                return this.createFetchSnapshotRequest(version);
            }
            case DESCRIBE_CLUSTER: {
                return this.createDescribeClusterRequest(version);
            }
            case DESCRIBE_PRODUCERS: {
                return this.createDescribeProducersRequest(version);
            }
            case BROKER_REGISTRATION: {
                return this.createBrokerRegistrationRequest(version);
            }
            case BROKER_HEARTBEAT: {
                return this.createBrokerHeartbeatRequest(version);
            }
            case UNREGISTER_BROKER: {
                return this.createUnregisterBrokerRequest(version);
            }
            case DESCRIBE_TRANSACTIONS: {
                return this.createDescribeTransactionsRequest(version);
            }
            case LIST_TRANSACTIONS: {
                return this.createListTransactionsRequest(version);
            }
            case ALLOCATE_PRODUCER_IDS: {
                return this.createAllocateProducerIdsRequest(version);
            }
            case CONSUMER_GROUP_HEARTBEAT: {
                return this.createConsumerGroupHeartbeatRequest(version);
            }
            case REMOVE_BROKERS: {
                return this.createRemoveBrokerRequest(version);
            }
            case INITIATE_SHUTDOWN: {
                return this.createInitiateShutdownRequest(version);
            }
            case DESCRIBE_BROKER_REMOVALS: {
                return this.createDescribeBrokerRemovalsRequest(version);
            }
            case DESCRIBE_BROKER_ADDITIONS: {
                return this.createDescribeBrokerAdditionsRequest(version);
            }
            case DESCRIBE_BALANCER_STATUS: {
                return this.createDescribeBalancerStatusRequest(version);
            }
            case TRIGGER_EVEN_CLUSTER_LOAD: {
                return this.createTriggerEvenClusterLoadRequest(version);
            }
            case COMPUTE_EVEN_CLUSTER_LOAD_PLAN: {
                return this.createComputeEvenClusterLoadPlanRequest(version);
            }
            case DESCRIBE_EVEN_CLUSTER_LOAD_STATUS: {
                return this.createDescribeEvenClusterLoadStatusRequest(version);
            }
            case ALTER_BROKER_REPLICA_EXCLUSIONS: {
                return this.createAlterBrokerReplicaExclusionsRequest(version);
            }
            case DESCRIBE_BROKER_REPLICA_EXCLUSIONS: {
                return this.createDescribeBrokerReplicaExclusionsRequest(version);
            }
            case REPORT_QUOTA_CONSUMPTION: {
                return this.createReportQuotaConsumptionRequest(version);
            }
            case PUBLISH_QUOTA_TARGET: {
                return this.createPublishQuotaTargetRequest(version);
            }
            case ALTER_BROKER_HEALTH: {
                return this.createAlterBrokerHealthRequest(version);
            }
            case DESCRIBE_BROKER_HEALTH: {
                return this.createDescribeBrokerHealthRequest(version);
            }
            case CREATE_CELL: {
                return this.createCellRequest(version);
            }
            case DRAIN_CELL: {
                return this.createDrainCellRequest(version);
            }
            case DELETE_CELL: {
                return this.createDeleteCellRequest(version);
            }
            case ALTER_CELL: {
                return this.createAlterCellRequest(version);
            }
            case DESCRIBE_CELLS: {
                return this.createDescribeCellsRequest(version);
            }
            case DESCRIBE_TENANTS: {
                return this.createDescribeTenantsRequest(version);
            }
            case ASSIGN_TENANTS_TO_CELL: {
                return this.createAssignTenantsToCellRequest(version);
            }
            case ASSIGN_BROKERS_TO_CELL: {
                return this.createAssignBrokersToCellRequest(version);
            }
            case UN_ASSIGN_BROKERS_FROM_CELL: {
                return this.createUnassignBrokersFromCellRequest(version);
            }
            case DELETE_TENANTS: {
                return this.createDeleteTenantsRequest(version);
            }
            case DESCRIBE_CELL_LOAD: {
                return this.createDescribeCellsLoadRequest(version);
            }
            case DESCRIBE_NETWORK: {
                return this.createDescribeNetworkRequest(version);
            }
            case APPEND_RECORDS: {
                return this.createAppendRecordsRequest(version);
            }
        }
        throw new IllegalArgumentException("Unknown API key " + apikey);
    }

    private AbstractResponse getResponse(ApiKeys apikey, short version) {
        switch (apikey) {
            case PRODUCE: {
                return this.createProduceResponse();
            }
            case FETCH: {
                return this.createFetchResponse(version);
            }
            case LIST_OFFSETS: {
                return this.createListOffsetResponse(version);
            }
            case METADATA: {
                return this.createMetadataResponse(version);
            }
            case LEADER_AND_ISR: {
                return this.createLeaderAndIsrResponse(version);
            }
            case STOP_REPLICA: {
                return this.createStopReplicaResponse();
            }
            case UPDATE_METADATA: {
                return this.createUpdateMetadataResponse();
            }
            case CONTROLLED_SHUTDOWN: {
                return this.createControlledShutdownResponse();
            }
            case OFFSET_COMMIT: {
                return this.createOffsetCommitResponse();
            }
            case OFFSET_FETCH: {
                return this.createOffsetFetchResponse(version);
            }
            case FIND_COORDINATOR: {
                return this.createFindCoordinatorResponse(version);
            }
            case JOIN_GROUP: {
                return this.createJoinGroupResponse(version);
            }
            case HEARTBEAT: {
                return this.createHeartBeatResponse();
            }
            case LEAVE_GROUP: {
                return this.createLeaveGroupResponse();
            }
            case SYNC_GROUP: {
                return this.createSyncGroupResponse(version);
            }
            case DESCRIBE_GROUPS: {
                return this.createDescribeGroupResponse();
            }
            case LIST_GROUPS: {
                return this.createListGroupsResponse(version);
            }
            case SASL_HANDSHAKE: {
                return this.createSaslHandshakeResponse();
            }
            case API_VERSIONS: {
                return this.createApiVersionResponse();
            }
            case CREATE_TOPICS: {
                return this.createCreateTopicResponse();
            }
            case DELETE_TOPICS: {
                return this.createDeleteTopicsResponse();
            }
            case DELETE_RECORDS: {
                return this.createDeleteRecordsResponse();
            }
            case INIT_PRODUCER_ID: {
                return this.createInitPidResponse();
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return this.createLeaderEpochResponse();
            }
            case ADD_PARTITIONS_TO_TXN: {
                return this.createAddPartitionsToTxnResponse(version);
            }
            case ADD_OFFSETS_TO_TXN: {
                return this.createAddOffsetsToTxnResponse();
            }
            case END_TXN: {
                return this.createEndTxnResponse();
            }
            case WRITE_TXN_MARKERS: {
                return this.createWriteTxnMarkersResponse();
            }
            case TXN_OFFSET_COMMIT: {
                return this.createTxnOffsetCommitResponse();
            }
            case DESCRIBE_ACLS: {
                return this.createDescribeAclsResponse();
            }
            case CREATE_ACLS: {
                return this.createCreateAclsResponse();
            }
            case DELETE_ACLS: {
                return this.createDeleteAclsResponse(version);
            }
            case DESCRIBE_CONFIGS: {
                return this.createDescribeConfigsResponse(version);
            }
            case ALTER_CONFIGS: {
                return this.createAlterConfigsResponse();
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return this.createAlterReplicaLogDirsResponse();
            }
            case DESCRIBE_LOG_DIRS: {
                return this.createDescribeLogDirsResponse();
            }
            case SASL_AUTHENTICATE: {
                return this.createSaslAuthenticateResponse();
            }
            case CREATE_PARTITIONS: {
                return this.createCreatePartitionsResponse();
            }
            case CREATE_DELEGATION_TOKEN: {
                return this.createCreateTokenResponse();
            }
            case RENEW_DELEGATION_TOKEN: {
                return this.createRenewTokenResponse();
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return this.createExpireTokenResponse();
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return this.createDescribeTokenResponse(version);
            }
            case DELETE_GROUPS: {
                return this.createDeleteGroupsResponse();
            }
            case ELECT_LEADERS: {
                return this.createElectLeadersResponse();
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return this.createIncrementalAlterConfigsResponse();
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                return this.createAlterPartitionReassignmentsResponse();
            }
            case LIST_PARTITION_REASSIGNMENTS: {
                return this.createListPartitionReassignmentsResponse();
            }
            case OFFSET_DELETE: {
                return this.createOffsetDeleteResponse();
            }
            case DESCRIBE_CLIENT_QUOTAS: {
                return this.createDescribeClientQuotasResponse();
            }
            case ALTER_CLIENT_QUOTAS: {
                return this.createAlterClientQuotasResponse();
            }
            case DESCRIBE_USER_SCRAM_CREDENTIALS: {
                return this.createDescribeUserScramCredentialsResponse();
            }
            case ALTER_USER_SCRAM_CREDENTIALS: {
                return this.createAlterUserScramCredentialsResponse();
            }
            case VOTE: {
                return this.createVoteResponse();
            }
            case BEGIN_QUORUM_EPOCH: {
                return this.createBeginQuorumEpochResponse();
            }
            case END_QUORUM_EPOCH: {
                return this.createEndQuorumEpochResponse();
            }
            case DESCRIBE_QUORUM: {
                return this.createDescribeQuorumResponse();
            }
            case ALTER_PARTITION: {
                return this.createAlterPartitionResponse(version);
            }
            case UPDATE_FEATURES: {
                return this.createUpdateFeaturesResponse();
            }
            case ENVELOPE: {
                return this.createEnvelopeResponse();
            }
            case FETCH_SNAPSHOT: {
                return this.createFetchSnapshotResponse();
            }
            case DESCRIBE_CLUSTER: {
                return this.createDescribeClusterResponse();
            }
            case DESCRIBE_PRODUCERS: {
                return this.createDescribeProducersResponse();
            }
            case BROKER_REGISTRATION: {
                return this.createBrokerRegistrationResponse();
            }
            case BROKER_HEARTBEAT: {
                return this.createBrokerHeartbeatResponse();
            }
            case UNREGISTER_BROKER: {
                return this.createUnregisterBrokerResponse();
            }
            case DESCRIBE_TRANSACTIONS: {
                return this.createDescribeTransactionsResponse();
            }
            case LIST_TRANSACTIONS: {
                return this.createListTransactionsResponse();
            }
            case ALLOCATE_PRODUCER_IDS: {
                return this.createAllocateProducerIdsResponse();
            }
            case CONSUMER_GROUP_HEARTBEAT: {
                return this.createConsumerGroupHeartbeatResponse();
            }
            case REMOVE_BROKERS: {
                return this.createRemoveBrokersResponse();
            }
            case INITIATE_SHUTDOWN: {
                return this.createInitiateShutdownResponse();
            }
            case DESCRIBE_BROKER_REMOVALS: {
                return this.createDescribeBrokerRemovalsResponse(version);
            }
            case DESCRIBE_BROKER_ADDITIONS: {
                return this.createDescribeBrokerAdditionsResponse();
            }
            case DESCRIBE_BALANCER_STATUS: {
                return this.createDescribeBalancerStatusResponse();
            }
            case TRIGGER_EVEN_CLUSTER_LOAD: {
                return this.createTriggerEvenClusterLoadResponse();
            }
            case COMPUTE_EVEN_CLUSTER_LOAD_PLAN: {
                return this.createComputeEvenClusterLoadPlanResponse();
            }
            case DESCRIBE_EVEN_CLUSTER_LOAD_STATUS: {
                return this.createDescribeEvenClusterLoadStatusResponse();
            }
            case ALTER_BROKER_REPLICA_EXCLUSIONS: {
                return this.createAlterBrokerReplicaExclusionsResponse();
            }
            case DESCRIBE_BROKER_REPLICA_EXCLUSIONS: {
                return this.createDescribeBrokerReplicaExclusionsResponse();
            }
            case REPORT_QUOTA_CONSUMPTION: {
                return this.createReportQuotaConsumptionResponse();
            }
            case PUBLISH_QUOTA_TARGET: {
                return this.createPublishQuotaTargetResponse();
            }
            case ALTER_BROKER_HEALTH: {
                return this.createAlterBrokerHealthResponse(version);
            }
            case DESCRIBE_BROKER_HEALTH: {
                return this.createDescribeBrokerHealthResponse(version);
            }
            case CREATE_CELL: {
                return this.createCellResponse(version);
            }
            case DRAIN_CELL: {
                return this.createDrainCellResponse(version);
            }
            case DELETE_CELL: {
                return this.createDeleteCellResponse(version);
            }
            case ALTER_CELL: {
                return this.createAlterCellResponse(version);
            }
            case DESCRIBE_CELLS: {
                return this.createDescribeCellsResponse(version);
            }
            case DESCRIBE_TENANTS: {
                return this.createDescribeTenantsResponse(version);
            }
            case ASSIGN_TENANTS_TO_CELL: {
                return this.createAssignTenantsToCellResponse(version);
            }
            case ASSIGN_BROKERS_TO_CELL: {
                return this.createAssignBrokersToCellResponse(version);
            }
            case UN_ASSIGN_BROKERS_FROM_CELL: {
                return this.createUnassignBrokersFromCellResponse(version);
            }
            case DELETE_TENANTS: {
                return this.createDeleteTenantsResponse(version);
            }
            case DESCRIBE_CELL_LOAD: {
                return this.createDescribeCellsLoadResponse();
            }
            case DESCRIBE_NETWORK: {
                return this.createDescribeNetworkResponse();
            }
            case APPEND_RECORDS: {
                return this.createAppendRecordsResponse();
            }
        }
        throw new IllegalArgumentException("Unknown API key " + apikey);
    }

    private ConsumerGroupHeartbeatRequest createConsumerGroupHeartbeatRequest(short version) {
        ConsumerGroupHeartbeatRequestData data = new ConsumerGroupHeartbeatRequestData().setGroupId("group").setMemberId("memberid").setMemberEpoch(10).setRebalanceTimeoutMs(60000).setServerAssignor("range").setRackId("rackid").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(Uuid.randomUuid()).setPartitions(Arrays.asList(0, 1, 2)), new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(Uuid.randomUuid()).setPartitions(Arrays.asList(3, 4, 5))));
        return new ConsumerGroupHeartbeatRequest.Builder(data).build(version);
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponse() {
        ConsumerGroupHeartbeatResponseData data = new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(1000).setMemberId("memberid").setMemberEpoch(11).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setPartitions(Arrays.asList(0, 1, 2)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setPartitions(Arrays.asList(3, 4, 5)))));
        return new ConsumerGroupHeartbeatResponse(data);
    }

    private FetchSnapshotRequest createFetchSnapshotRequest(short version) {
        FetchSnapshotRequestData data = new FetchSnapshotRequestData().setClusterId("clusterId").setTopics(Collections.singletonList(new FetchSnapshotRequestData.TopicSnapshot().setName("topic1").setPartitions(Collections.singletonList(new FetchSnapshotRequestData.PartitionSnapshot().setSnapshotId(new FetchSnapshotRequestData.SnapshotId().setEndOffset(123L).setEpoch(0)).setPosition(123L).setPartition(0).setCurrentLeaderEpoch(1))))).setMaxBytes(1000).setReplicaId(2);
        return new FetchSnapshotRequest.Builder(data).build(version);
    }

    private FetchSnapshotResponse createFetchSnapshotResponse() {
        FetchSnapshotResponseData data = new FetchSnapshotResponseData().setErrorCode(Errors.NONE.code()).setTopics(Collections.singletonList(new FetchSnapshotResponseData.TopicSnapshot().setName("topic1").setPartitions(Collections.singletonList(new FetchSnapshotResponseData.PartitionSnapshot().setErrorCode(Errors.NONE.code()).setIndex(0).setCurrentLeader(new FetchSnapshotResponseData.LeaderIdAndEpoch().setLeaderEpoch(0).setLeaderId(1)).setSnapshotId(new FetchSnapshotResponseData.SnapshotId().setEndOffset(123L).setEpoch(0)).setPosition(234L).setSize(345L).setUnalignedRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())})))))).setThrottleTimeMs(123);
        return new FetchSnapshotResponse(data);
    }

    private EnvelopeRequest createEnvelopeRequest(short version) {
        return new EnvelopeRequest.Builder(ByteBuffer.wrap("data".getBytes(StandardCharsets.UTF_8)), "principal".getBytes(StandardCharsets.UTF_8), "address".getBytes(StandardCharsets.UTF_8)).build(version);
    }

    private EnvelopeResponse createEnvelopeResponse() {
        EnvelopeResponseData data = new EnvelopeResponseData().setResponseData(ByteBuffer.wrap("data".getBytes(StandardCharsets.UTF_8))).setErrorCode(Errors.NONE.code());
        return new EnvelopeResponse(data);
    }

    private DescribeQuorumRequest createDescribeQuorumRequest(short version) {
        DescribeQuorumRequestData data = new DescribeQuorumRequestData().setTopics(Collections.singletonList(new DescribeQuorumRequestData.TopicData().setPartitions(Collections.singletonList(new DescribeQuorumRequestData.PartitionData().setPartitionIndex(0))).setTopicName("topic1")));
        return new DescribeQuorumRequest.Builder(data).build(version);
    }

    private DescribeQuorumResponse createDescribeQuorumResponse() {
        DescribeQuorumResponseData data = new DescribeQuorumResponseData().setErrorCode(Errors.NONE.code());
        return new DescribeQuorumResponse(data);
    }

    private EndQuorumEpochRequest createEndQuorumEpochRequest(short version) {
        EndQuorumEpochRequestData data = new EndQuorumEpochRequestData().setClusterId("clusterId").setTopics(Collections.singletonList(new EndQuorumEpochRequestData.TopicData().setPartitions(Collections.singletonList(new EndQuorumEpochRequestData.PartitionData().setLeaderEpoch(0).setLeaderId(1).setPartitionIndex(2).setPreferredSuccessors(Arrays.asList(0, 1, 2)))).setTopicName("topic1")));
        return new EndQuorumEpochRequest.Builder(data).build(version);
    }

    private EndQuorumEpochResponse createEndQuorumEpochResponse() {
        EndQuorumEpochResponseData data = new EndQuorumEpochResponseData().setErrorCode(Errors.NONE.code()).setTopics(Collections.singletonList(new EndQuorumEpochResponseData.TopicData().setPartitions(Collections.singletonList(new EndQuorumEpochResponseData.PartitionData().setErrorCode(Errors.NONE.code()).setLeaderEpoch(1))).setTopicName("topic1")));
        return new EndQuorumEpochResponse(data);
    }

    private BeginQuorumEpochRequest createBeginQuorumEpochRequest(short version) {
        BeginQuorumEpochRequestData data = new BeginQuorumEpochRequestData().setClusterId("clusterId").setTopics(Collections.singletonList(new BeginQuorumEpochRequestData.TopicData().setPartitions(Collections.singletonList(new BeginQuorumEpochRequestData.PartitionData().setLeaderEpoch(0).setLeaderId(1).setPartitionIndex(2)))));
        return new BeginQuorumEpochRequest.Builder(data).build(version);
    }

    private BeginQuorumEpochResponse createBeginQuorumEpochResponse() {
        BeginQuorumEpochResponseData data = new BeginQuorumEpochResponseData().setErrorCode(Errors.NONE.code()).setTopics(Collections.singletonList(new BeginQuorumEpochResponseData.TopicData().setPartitions(Collections.singletonList(new BeginQuorumEpochResponseData.PartitionData().setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setLeaderId(1).setPartitionIndex(2)))));
        return new BeginQuorumEpochResponse(data);
    }

    private VoteRequest createVoteRequest(short version) {
        VoteRequestData data = new VoteRequestData().setClusterId("clusterId").setTopics(Collections.singletonList(new VoteRequestData.TopicData().setPartitions(Collections.singletonList(new VoteRequestData.PartitionData().setPartitionIndex(0).setCandidateEpoch(1).setCandidateId(2).setLastOffset(3L).setLastOffsetEpoch(4))).setTopicName("topic1")));
        return new VoteRequest.Builder(data).build(version);
    }

    private VoteResponse createVoteResponse() {
        VoteResponseData data = new VoteResponseData().setErrorCode(Errors.NONE.code()).setTopics(Collections.singletonList(new VoteResponseData.TopicData().setPartitions(Collections.singletonList(new VoteResponseData.PartitionData().setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setPartitionIndex(1).setLeaderId(2).setVoteGranted(false)))));
        return new VoteResponse(data);
    }

    private AlterUserScramCredentialsRequest createAlterUserScramCredentialsRequest(short version) {
        AlterUserScramCredentialsRequestData data = new AlterUserScramCredentialsRequestData().setDeletions(Collections.singletonList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("user1").setMechanism((byte)0))).setUpsertions(Collections.singletonList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("user2").setIterations(1024).setMechanism((byte)1).setSalt("salt".getBytes())));
        return new AlterUserScramCredentialsRequest.Builder(data).build(version);
    }

    private AlterUserScramCredentialsResponse createAlterUserScramCredentialsResponse() {
        AlterUserScramCredentialsResponseData data = new AlterUserScramCredentialsResponseData().setResults(Collections.singletonList(new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setErrorCode(Errors.NONE.code()).setUser("user1").setErrorMessage("error message")));
        return new AlterUserScramCredentialsResponse(data);
    }

    private DescribeUserScramCredentialsRequest createDescribeUserScramCredentialsRequest(short version) {
        DescribeUserScramCredentialsRequestData data = new DescribeUserScramCredentialsRequestData().setUsers(Collections.singletonList(new DescribeUserScramCredentialsRequestData.UserName().setName("user1")));
        return new DescribeUserScramCredentialsRequest.Builder(data).build(version);
    }

    private DescribeUserScramCredentialsResponse createDescribeUserScramCredentialsResponse() {
        DescribeUserScramCredentialsResponseData data = new DescribeUserScramCredentialsResponseData().setResults(Collections.singletonList(new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser("user1").setErrorCode(Errors.NONE.code()).setErrorMessage("error message").setCredentialInfos(Collections.singletonList(new DescribeUserScramCredentialsResponseData.CredentialInfo().setIterations(1024).setMechanism((byte)0))))).setErrorCode(Errors.NONE.code()).setErrorMessage("error message").setThrottleTimeMs(123);
        return new DescribeUserScramCredentialsResponse(data);
    }

    private AlterPartitionRequest createAlterPartitionRequest(short version) {
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(1).setPartitionEpoch(2).setLeaderEpoch(3).setNewIsrWithEpochs(AlterPartitionRequest.newIsrToSimpleNewIsrWithBrokerEpochs(Arrays.asList(1, 2))).setMirrorTopicError((short)1);
        if (version >= 1) {
            partitionData.setLeaderRecoveryState((byte)1);
        }
        AlterPartitionRequestData data = new AlterPartitionRequestData().setBrokerEpoch(123L).setBrokerId(1).setTopics(Collections.singletonList(new AlterPartitionRequestData.TopicData().setTopicName("topic1").setTopicId(Uuid.randomUuid()).setPartitions(Collections.singletonList(partitionData))));
        return new AlterPartitionRequest.Builder(data, version >= 1).build(version);
    }

    private AlterPartitionResponse createAlterPartitionResponse(int version) {
        AlterPartitionResponseData.PartitionData partitionData = new AlterPartitionResponseData.PartitionData().setPartitionEpoch(1).setIsr(Arrays.asList(0, 1, 2)).setErrorCode(Errors.NONE.code()).setLeaderEpoch(2).setLeaderId(3);
        if (version >= 1) {
            partitionData.setLeaderRecoveryState((byte)1);
        }
        AlterPartitionResponseData data = new AlterPartitionResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(123).setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicName("topic1").setTopicId(Uuid.randomUuid()).setPartitions(Collections.singletonList(partitionData))));
        return new AlterPartitionResponse(data);
    }

    private UpdateFeaturesRequest createUpdateFeaturesRequest(short version) {
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection features = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        features.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesRequestData.FeatureUpdateKey().setFeature("feature1").setAllowDowngrade(false).setMaxVersionLevel((short)1));
        UpdateFeaturesRequestData data = new UpdateFeaturesRequestData().setFeatureUpdates(features).setTimeoutMs(123);
        return new UpdateFeaturesRequest.Builder(data).build(version);
    }

    private UpdateFeaturesResponse createUpdateFeaturesResponse() {
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        results.add((ImplicitLinkedHashCollection.Element)new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature("feature1").setErrorCode(Errors.NONE.code()).setErrorMessage("error message"));
        UpdateFeaturesResponseData data = new UpdateFeaturesResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(123).setResults(results).setErrorMessage("error message");
        return new UpdateFeaturesResponse(data);
    }

    private AllocateProducerIdsRequest createAllocateProducerIdsRequest(short version) {
        AllocateProducerIdsRequestData data = new AllocateProducerIdsRequestData().setBrokerEpoch(123L).setBrokerId(2);
        return new AllocateProducerIdsRequest.Builder(data).build(version);
    }

    private AllocateProducerIdsResponse createAllocateProducerIdsResponse() {
        AllocateProducerIdsResponseData data = new AllocateProducerIdsResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(123).setProducerIdLen(234).setProducerIdStart(345L);
        return new AllocateProducerIdsResponse(data);
    }

    private DescribeLogDirsRequest createDescribeLogDirsRequest(short version) {
        DescribeLogDirsRequestData.DescribableLogDirTopicCollection topics = new DescribeLogDirsRequestData.DescribableLogDirTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)new DescribeLogDirsRequestData.DescribableLogDirTopic().setPartitions(Arrays.asList(0, 1, 2)).setTopic("topic1"));
        DescribeLogDirsRequestData data = new DescribeLogDirsRequestData().setTopics(topics);
        return new DescribeLogDirsRequest.Builder(data).build(version);
    }

    private DescribeLogDirsResponse createDescribeLogDirsResponse() {
        DescribeLogDirsResponseData data = new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(Errors.NONE.code()).setLogDir("logdir").setTopics(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsTopic().setName("topic1").setPartitions(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsPartition().setPartitionIndex(0).setIsFutureKey(false).setOffsetLag(123L).setPartitionSize(234L))))))).setThrottleTimeMs(123);
        return new DescribeLogDirsResponse(data);
    }

    private DeleteRecordsRequest createDeleteRecordsRequest(short version) {
        DeleteRecordsRequestData.DeleteRecordsTopic topic = new DeleteRecordsRequestData.DeleteRecordsTopic().setName("topic1").setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setPartitionIndex(1).setOffset(123L)));
        DeleteRecordsRequestData data = new DeleteRecordsRequestData().setTopics(Collections.singletonList(topic)).setTimeoutMs(123);
        return new DeleteRecordsRequest.Builder(data).build(version);
    }

    private DeleteRecordsResponse createDeleteRecordsResponse() {
        DeleteRecordsResponseData.DeleteRecordsTopicResultCollection topics = new DeleteRecordsResponseData.DeleteRecordsTopicResultCollection();
        DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection partitions = new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection();
        partitions.add((ImplicitLinkedHashCollection.Element)new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setErrorCode(Errors.NONE.code()).setLowWatermark(123L).setPartitionIndex(0));
        topics.add((ImplicitLinkedHashCollection.Element)new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName("topic1").setPartitions(partitions));
        DeleteRecordsResponseData data = new DeleteRecordsResponseData().setThrottleTimeMs(123).setTopics(topics);
        return new DeleteRecordsResponse(data);
    }

    private DescribeClusterRequest createDescribeClusterRequest(short version) {
        return new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(true)).build(version);
    }

    private DescribeClusterResponse createDescribeClusterResponse() {
        return new DescribeClusterResponse(new DescribeClusterResponseData().setBrokers(new DescribeClusterResponseData.DescribeClusterBrokerCollection(Collections.singletonList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(1).setHost("localhost").setPort(9092).setRack("rack1")).iterator())).setClusterId("clusterId").setControllerId(1).setClusterAuthorizedOperations(10));
    }

    private void checkOlderFetchVersions() {
        Iterator iterator = ApiKeys.FETCH.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version > 7) {
                this.checkErrorResponse((AbstractRequest)this.createFetchRequest(version), (Throwable)this.unknownServerException);
            }
            this.checkRequest((AbstractRequest)this.createFetchRequest(version));
            this.checkResponse((AbstractResponse)this.createFetchResponse(version >= 4), version);
        }
    }

    private void verifyDescribeConfigsResponse(DescribeConfigsResponse expected, DescribeConfigsResponse actual, short version) {
        for (Map.Entry resource : expected.resultMap().entrySet()) {
            List actualEntries = ((DescribeConfigsResponseData.DescribeConfigsResult)actual.resultMap().get(resource.getKey())).configs();
            List expectedEntries = ((DescribeConfigsResponseData.DescribeConfigsResult)expected.resultMap().get(resource.getKey())).configs();
            Assertions.assertEquals((int)expectedEntries.size(), (int)actualEntries.size());
            for (int i = 0; i < actualEntries.size(); ++i) {
                DescribeConfigsResponseData.DescribeConfigsResourceResult actualEntry = (DescribeConfigsResponseData.DescribeConfigsResourceResult)actualEntries.get(i);
                DescribeConfigsResponseData.DescribeConfigsResourceResult expectedEntry = (DescribeConfigsResponseData.DescribeConfigsResourceResult)expectedEntries.get(i);
                Assertions.assertEquals((Object)expectedEntry.name(), (Object)actualEntry.name());
                Assertions.assertEquals((Object)expectedEntry.value(), (Object)actualEntry.value(), (String)("Non-matching values for " + actualEntry.name() + " in version " + version));
                Assertions.assertEquals((Object)expectedEntry.readOnly(), (Object)actualEntry.readOnly(), (String)("Non-matching readonly for " + actualEntry.name() + " in version " + version));
                Assertions.assertEquals((Object)expectedEntry.isSensitive(), (Object)actualEntry.isSensitive(), (String)("Non-matching isSensitive for " + actualEntry.name() + " in version " + version));
                if (version < 3) {
                    Assertions.assertEquals((byte)DescribeConfigsResponse.ConfigType.UNKNOWN.id(), (byte)actualEntry.configType(), (String)("Non-matching configType for " + actualEntry.name() + " in version " + version));
                } else {
                    Assertions.assertEquals((byte)expectedEntry.configType(), (byte)actualEntry.configType(), (String)("Non-matching configType for " + actualEntry.name() + " in version " + version));
                }
                if (version == 0) {
                    Assertions.assertEquals((byte)DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG.id(), (byte)actualEntry.configSource(), (String)("Non matching configSource for " + actualEntry.name() + " in version " + version));
                    continue;
                }
                Assertions.assertEquals((byte)expectedEntry.configSource(), (byte)actualEntry.configSource(), (String)("Non-matching configSource for " + actualEntry.name() + " in version " + version));
            }
        }
    }

    private void checkDescribeConfigsResponseVersions() {
        Iterator iterator = ApiKeys.DESCRIBE_CONFIGS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            DescribeConfigsResponse response = this.createDescribeConfigsResponse(version);
            DescribeConfigsResponse deserialized = (DescribeConfigsResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.DESCRIBE_CONFIGS, (ByteBuffer)response.serialize(version), (short)version, (MessageContext)MessageContext.IDENTITY);
            this.verifyDescribeConfigsResponse(response, deserialized, version);
        }
    }

    private void checkErrorResponse(AbstractRequest req, Throwable e) {
        AbstractResponse response = req.getErrorResponse(e);
        this.checkResponse(response, req.version());
        Errors error = Errors.forException((Throwable)e);
        Map errorCounts = response.errorCounts();
        Assertions.assertEquals(Collections.singleton(error), errorCounts.keySet(), (String)("API Key " + req.apiKey().name + " v" + req.version() + " failed errorCounts test"));
        Assertions.assertTrue(((Integer)errorCounts.get(error) > 0 ? 1 : 0) != 0);
        if (e instanceof UnknownServerException) {
            String responseStr = response.toString();
            Assertions.assertFalse((boolean)responseStr.contains(e.getMessage()), (String)String.format("Unknown message included in response for %s: %s ", req.apiKey(), responseStr));
        }
    }

    private void checkRequest(AbstractRequest req) {
        try {
            ByteBuffer serializedBytes = req.serialize();
            AbstractRequest deserialized = AbstractRequest.parseRequest((ApiKeys)req.apiKey(), (short)req.version(), (ByteBuffer)serializedBytes, (MessageContext)MessageContext.IDENTITY).request;
            ByteBuffer serializedBytes2 = deserialized.serialize();
            serializedBytes.rewind();
            Assertions.assertEquals((Object)serializedBytes, (Object)serializedBytes2, (String)("Request " + req + "failed equality test"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize request " + req + " with type " + req.getClass(), e);
        }
    }

    private void checkResponse(AbstractResponse response, short version) {
        try {
            ByteBuffer serializedBytes = response.serialize(version);
            AbstractResponse deserialized = AbstractResponse.parseResponse((ApiKeys)response.apiKey(), (ByteBuffer)serializedBytes, (short)version, (MessageContext)MessageContext.IDENTITY);
            ByteBuffer serializedBytes2 = deserialized.serialize(version);
            serializedBytes.rewind();
            Assertions.assertEquals((Object)serializedBytes, (Object)serializedBytes2, (String)("Response " + response + "failed equality test"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize version " + version + " response " + response + " with type " + response.getClass(), e);
        }
    }

    private FindCoordinatorRequest createFindCoordinatorRequest(short version) {
        return new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey("test-group")).build(version);
    }

    private FindCoordinatorRequest createBatchedFindCoordinatorRequest(List<String> coordinatorKeys, short version) {
        return new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setCoordinatorKeys(coordinatorKeys)).build(version);
    }

    private FindCoordinatorResponse createFindCoordinatorResponse(short version) {
        Node node = new Node(10, "host1", 2014);
        if (version < 4) {
            return FindCoordinatorResponse.prepareOldResponse((Errors)Errors.NONE, (Node)node);
        }
        return FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"group", (Node)node);
    }

    private FetchRequest createFetchRequest(short version, FetchMetadata metadata, List<TopicIdPartition> toForget) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(Uuid.randomUuid(), 100L, -1L, 1000000, Optional.empty(), Optional.empty(), Optional.empty()));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(Uuid.randomUuid(), 200L, -1L, 1000000, Optional.empty(), Optional.empty(), Optional.empty()));
        return FetchRequest.Builder.forConsumer((short)version, (int)100, (int)100000, fetchData).metadata(metadata).setMaxBytes(1000).removed(toForget).build(version);
    }

    private FetchRequest createFetchRequest(short version, IsolationLevel isolationLevel) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(Uuid.randomUuid(), 100L, -1L, 1000000, Optional.empty(), Optional.empty(), Optional.empty()));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(Uuid.randomUuid(), 200L, -1L, 1000000, Optional.empty(), Optional.empty(), Optional.empty()));
        return FetchRequest.Builder.forConsumer((short)version, (int)100, (int)100000, fetchData).isolationLevel(isolationLevel).setMaxBytes(1000).build(version);
    }

    private FetchRequest createFetchRequest(short version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(Uuid.randomUuid(), 100L, -1L, 1000000, Optional.empty(), Optional.empty(), Optional.empty()));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(Uuid.randomUuid(), 200L, -1L, 1000000, Optional.empty(), Optional.empty(), Optional.empty()));
        return FetchRequest.Builder.forConsumer((short)version, (int)100, (int)100000, fetchData).setMaxBytes(1000).build(version);
    }

    private FetchResponse createFetchResponse(Errors error, int sessionId) {
        return FetchResponse.parse((ByteBuffer)FetchResponse.of((Errors)error, (int)25, (int)sessionId, new LinkedHashMap()).serialize(ApiKeys.FETCH.latestVersion()), (short)ApiKeys.FETCH.latestVersion(), (MessageContext)MessageContext.IDENTITY);
    }

    private FetchResponse createFetchResponse(int sessionId) {
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put("test", Uuid.randomUuid());
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
        responseData.put(new TopicIdPartition((Uuid)topicIds.get("test"), new TopicPartition("test", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(1000000L).setLogStartOffset(0L).setRecords((BaseRecords)records));
        List<FetchResponseData.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponseData.AbortedTransaction().setProducerId(234L).setFirstOffset(999L));
        responseData.put(new TopicIdPartition((Uuid)topicIds.get("test"), new TopicPartition("test", 1)), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(1000000L).setLogStartOffset(0L).setAbortedTransactions(abortedTransactions));
        return FetchResponse.parse((ByteBuffer)FetchResponse.of((Errors)Errors.NONE, (int)25, (int)sessionId, responseData).serialize(ApiKeys.FETCH.latestVersion()), (short)ApiKeys.FETCH.latestVersion(), (MessageContext)MessageContext.IDENTITY);
    }

    private FetchResponse createFetchResponse(boolean includeAborted) {
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        Uuid topicId = Uuid.randomUuid();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
        responseData.put(new TopicIdPartition(topicId, new TopicPartition("test", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(1000000L).setLogStartOffset(0L).setRecords((BaseRecords)records));
        List<Object> abortedTransactions = Collections.emptyList();
        if (includeAborted) {
            abortedTransactions = Collections.singletonList(new FetchResponseData.AbortedTransaction().setProducerId(234L).setFirstOffset(999L));
        }
        responseData.put(new TopicIdPartition(topicId, new TopicPartition("test", 1)), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(1000000L).setLogStartOffset(0L).setAbortedTransactions(abortedTransactions));
        return FetchResponse.parse((ByteBuffer)FetchResponse.of((Errors)Errors.NONE, (int)25, (int)0, responseData).serialize(ApiKeys.FETCH.latestVersion()), (short)ApiKeys.FETCH.latestVersion(), (MessageContext)MessageContext.IDENTITY);
    }

    private FetchResponse createFetchResponse(short version) {
        FetchResponseData data = new FetchResponseData();
        if (version > 0) {
            data.setThrottleTimeMs(345);
        }
        if (version > 6) {
            data.setErrorCode(Errors.NONE.code()).setSessionId(123);
        }
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
        FetchResponseData.PartitionData partition = new FetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setHighWatermark(123L).setRecords((BaseRecords)records);
        if (version > 3) {
            partition.setLastStableOffset(234L);
        }
        if (version > 4) {
            partition.setLogStartOffset(456L);
        }
        if (version > 10) {
            partition.setPreferredReadReplica(1);
        }
        if (version > 11) {
            partition.setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEndOffset(1L).setEpoch(2)).setSnapshotId(new FetchResponseData.SnapshotId().setEndOffset(1L).setEndOffset(2L)).setCurrentLeader(new FetchResponseData.LeaderIdAndEpoch().setLeaderEpoch(1).setLeaderId(2));
        }
        FetchResponseData.FetchableTopicResponse response = new FetchResponseData.FetchableTopicResponse().setTopic("topic").setPartitions(Collections.singletonList(partition));
        if (version > 12) {
            response.setTopicId(Uuid.randomUuid());
        }
        data.setResponses(Collections.singletonList(response));
        return new FetchResponse(data);
    }

    private HeartbeatRequest createHeartBeatRequest(short version) {
        return new HeartbeatRequest.Builder(new HeartbeatRequestData().setGroupId("group1").setGenerationId(1).setMemberId("consumer1")).build(version);
    }

    private HeartbeatResponse createHeartBeatResponse() {
        return new HeartbeatResponse(new HeartbeatResponseData().setErrorCode(Errors.NONE.code()));
    }

    private JoinGroupRequest createJoinGroupRequest(short version) {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(Collections.singleton(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("consumer-range").setMetadata(new byte[0])).iterator());
        JoinGroupRequestData data = new JoinGroupRequestData().setGroupId("group1").setSessionTimeoutMs(30000).setMemberId("consumer1").setProtocolType("consumer").setProtocols(protocols).setReason("reason: test");
        if (version >= 1) {
            data.setRebalanceTimeoutMs(60000);
        }
        if (version >= 5) {
            data.setGroupInstanceId("groupInstanceId");
        }
        return new JoinGroupRequest.Builder(data).build(version);
    }

    private JoinGroupResponse createJoinGroupResponse(short version) {
        ArrayList<JoinGroupResponseData.JoinGroupResponseMember> members = new ArrayList<JoinGroupResponseData.JoinGroupResponseMember>();
        for (int i = 0; i < 2; ++i) {
            JoinGroupResponseData.JoinGroupResponseMember member = new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("consumer" + i).setMetadata(new byte[0]).setGroupInstanceId("instance" + i);
            members.add(member);
        }
        JoinGroupResponseData data = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setLeader("leader").setMemberId("consumer1").setMembers(members);
        if (version >= 1) {
            data.setThrottleTimeMs(1000);
        }
        return new JoinGroupResponse(data, version);
    }

    private SyncGroupRequest createSyncGroupRequest(short version) {
        List<SyncGroupRequestData.SyncGroupRequestAssignment> assignments = Collections.singletonList(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member").setAssignment(new byte[0]));
        SyncGroupRequestData data = new SyncGroupRequestData().setGroupId("group1").setGenerationId(1).setMemberId("member").setProtocolType("consumer").setProtocolName("range").setAssignments(assignments);
        if (version >= 3) {
            data.setGroupInstanceId("groupInstanceId");
        }
        return new SyncGroupRequest.Builder(data).build(version);
    }

    private SyncGroupResponse createSyncGroupResponse(short version) {
        SyncGroupResponseData data = new SyncGroupResponseData().setErrorCode(Errors.NONE.code()).setProtocolType("consumer").setProtocolName("range").setAssignment(new byte[0]);
        if (version >= 1) {
            data.setThrottleTimeMs(1000);
        }
        return new SyncGroupResponse(data);
    }

    private ListGroupsRequest createListGroupsRequest(short version) {
        ListGroupsRequestData data = new ListGroupsRequestData();
        if (version >= 4) {
            data.setStatesFilter(Collections.singletonList("Stable"));
        }
        return new ListGroupsRequest.Builder(data).build(version);
    }

    private ListGroupsResponse createListGroupsResponse(short version) {
        ListGroupsResponseData.ListedGroup group = new ListGroupsResponseData.ListedGroup().setGroupId("test-group").setProtocolType("consumer");
        if (version >= 4) {
            group.setGroupState("Stable");
        }
        ListGroupsResponseData data = new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(group));
        return new ListGroupsResponse(data);
    }

    private DescribeGroupsRequest createDescribeGroupRequest(short version) {
        return new DescribeGroupsRequest.Builder(new DescribeGroupsRequestData().setGroups(Collections.singletonList("test-group"))).build(version);
    }

    private DescribeGroupsResponse createDescribeGroupResponse() {
        String clientId = "consumer-1";
        String clientHost = "localhost";
        DescribeGroupsResponseData describeGroupsResponseData = new DescribeGroupsResponseData();
        DescribeGroupsResponseData.DescribedGroupMember member = DescribeGroupsResponse.groupMember((String)"memberId", null, (String)clientId, (String)clientHost, (byte[])new byte[0], (byte[])new byte[0]);
        DescribeGroupsResponseData.DescribedGroup metadata = DescribeGroupsResponse.groupMetadata((String)"test-group", (Errors)Errors.NONE, (String)"STABLE", (String)"consumer", (String)"roundrobin", Collections.singletonList(member), (int)Integer.MIN_VALUE);
        describeGroupsResponseData.groups().add(metadata);
        return new DescribeGroupsResponse(describeGroupsResponseData);
    }

    private LeaveGroupRequest createLeaveGroupRequest(short version) {
        LeaveGroupRequestData.MemberIdentity member = new LeaveGroupRequestData.MemberIdentity().setMemberId("consumer1").setReason("reason: test");
        return new LeaveGroupRequest.Builder("group1", Collections.singletonList(member)).build(version);
    }

    private LeaveGroupResponse createLeaveGroupResponse() {
        return new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()));
    }

    private DeleteGroupsRequest createDeleteGroupsRequest(short version) {
        return new DeleteGroupsRequest.Builder(new DeleteGroupsRequestData().setGroupsNames(Collections.singletonList("test-group"))).build(version);
    }

    private DeleteGroupsResponse createDeleteGroupsResponse() {
        DeleteGroupsResponseData.DeletableGroupResultCollection result = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        result.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("test-group").setErrorCode(Errors.NONE.code()));
        return new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(result));
    }

    private ListOffsetsRequest createListOffsetRequest(short version) {
        if (version == 0) {
            ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName("test").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(1000000L).setMaxNumOffsets(10).setCurrentLeaderEpoch(5)));
            return ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(Collections.singletonList(topic)).build(version);
        }
        if (version == 1) {
            ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName("test").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(1000000L).setCurrentLeaderEpoch(5)));
            return ListOffsetsRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(Collections.singletonList(topic)).build(version);
        }
        if (version >= 2 && version <= ApiKeys.LIST_OFFSETS.latestVersion()) {
            ListOffsetsRequestData.ListOffsetsPartition partition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(1000000L).setCurrentLeaderEpoch(5);
            ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName("test").setPartitions(Collections.singletonList(partition));
            return ListOffsetsRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_COMMITTED, (boolean)false).setTargetTimes(Collections.singletonList(topic)).build(version);
        }
        throw new IllegalArgumentException("Illegal ListOffsetRequest version " + version);
    }

    private ListOffsetsResponse createListOffsetResponse(short version) {
        if (version == 0) {
            ListOffsetsResponseData data = new ListOffsetsResponseData().setTopics(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("test").setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setOldStyleOffsets(Collections.singletonList(100L))))));
            return new ListOffsetsResponse(data);
        }
        if (version >= 1 && version <= ApiKeys.LIST_OFFSETS.latestVersion()) {
            ListOffsetsResponseData.ListOffsetsPartitionResponse partition = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setTimestamp(10000L).setOffset(100L);
            if (version >= 4) {
                partition.setLeaderEpoch(27);
            }
            ListOffsetsResponseData data = new ListOffsetsResponseData().setTopics(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("test").setPartitions(Collections.singletonList(partition))));
            return new ListOffsetsResponse(data);
        }
        throw new IllegalArgumentException("Illegal ListOffsetResponse version " + version);
    }

    private MetadataRequest createMetadataRequest(short version, List<String> topics) {
        return new MetadataRequest.Builder(topics, true).build(version);
    }

    private MetadataResponse createMetadataResponse(int version) {
        Node node = new Node(1, "host1", 1001);
        Node observer = new Node(2, "host2", 1001);
        List<Integer> replicas = Collections.singletonList(node.id());
        List<Integer> isr = Collections.singletonList(node.id());
        List offlineReplicas = Collections.emptyList();
        ArrayList<MetadataResponse.TopicMetadata> allTopicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "__consumer_offsets", true, Collections.singletonList(new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition("__consumer_offsets", 1), Optional.of(node.id()), Optional.of(5), Arrays.asList(node.id(), observer.id()), Collections.singletonList(observer.id()), isr, offlineReplicas))));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, "topic2", false, Collections.emptyList()));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "topic3", false, Collections.singletonList(new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, new TopicPartition("topic3", 0), Optional.empty(), Optional.empty(), replicas, isr, offlineReplicas))));
        return RequestTestUtils.metadataResponse(Arrays.asList(node, observer), null, -1, allTopicMetadata, (short)version);
    }

    private OffsetCommitRequest createOffsetCommitRequest(short version) {
        return new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId("group1").setMemberId("consumer1").setGroupInstanceId(null).setGenerationIdOrMemberEpoch(100).setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("test").setPartitions(Arrays.asList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setCommittedMetadata(""), new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(1).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setCommittedMetadata(null)))))).build(version);
    }

    private OffsetCommitResponse createOffsetCommitResponse() {
        return new OffsetCommitResponse(new OffsetCommitResponseData().setTopics(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("test").setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()))))));
    }

    private OffsetFetchRequest createOffsetFetchRequest(short version, boolean requireStable) {
        if (version < 8) {
            return new OffsetFetchRequest.Builder("group1", requireStable, Collections.singletonList(new TopicPartition("test11", 1)), false).build(version);
        }
        return new OffsetFetchRequest.Builder(Collections.singletonMap("group1", Collections.singletonList(new TopicPartition("test11", 1))), requireStable, false).build(version);
    }

    private OffsetFetchRequest createOffsetFetchRequestWithMultipleGroups(short version, boolean requireStable) {
        HashMap<String, List<TopicPartition>> groupToPartitionMap = new HashMap<String, List<TopicPartition>>();
        List<TopicPartition> topic1 = Collections.singletonList(new TopicPartition("topic1", 0));
        List<TopicPartition> topic2 = Arrays.asList(new TopicPartition("topic1", 0), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1));
        List<TopicPartition> topic3 = Arrays.asList(new TopicPartition("topic1", 0), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2));
        groupToPartitionMap.put("group1", topic1);
        groupToPartitionMap.put("group2", topic2);
        groupToPartitionMap.put("group3", topic3);
        groupToPartitionMap.put("group4", null);
        groupToPartitionMap.put("group5", null);
        return new OffsetFetchRequest.Builder(groupToPartitionMap, requireStable, false).build(version);
    }

    private OffsetFetchRequest createOffsetFetchRequestForAllPartition(short version, boolean requireStable) {
        if (version < 8) {
            return new OffsetFetchRequest.Builder("group1", requireStable, null, false).build(version);
        }
        return new OffsetFetchRequest.Builder(Collections.singletonMap("group1", null), requireStable, false).build(version);
    }

    private OffsetFetchResponse createOffsetFetchResponse(short version) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new OffsetFetchResponse.PartitionData(100L, Optional.empty(), "", Errors.NONE));
        responseData.put(new TopicPartition("test", 1), new OffsetFetchResponse.PartitionData(100L, Optional.of(10), null, Errors.NONE));
        if (version < 8) {
            return new OffsetFetchResponse(Errors.NONE, responseData);
        }
        int throttleMs = 10;
        return new OffsetFetchResponse(throttleMs, Collections.singletonMap("group1", Errors.NONE), Collections.singletonMap("group1", responseData));
    }

    private ProduceRequest createProduceRequest(short version) {
        if (version < 2) {
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
            ProduceRequestData data = new ProduceRequestData().setAcks((short)-1).setTimeoutMs(123).setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic1").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(1).setRecords((BaseRecords)records)))).iterator()));
            return new ProduceRequest.Builder(version, version, data).build(version);
        }
        byte magic = version == 2 ? (byte)1 : 2;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("woot".getBytes())});
        return ProduceRequest.forMagic((byte)magic, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)records)))).iterator())).setAcks((short)1).setTimeoutMs(5000).setTransactionalId(version >= 3 ? "transactionalId" : null)).build(version);
    }

    private ProduceResponse createProduceResponse() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        return new ProduceResponse(responseData, 0);
    }

    private ProduceResponse createProduceResponseWithErrorMessage() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L, Collections.singletonList(new ProduceResponse.RecordError(0, "error message")), "global error message"));
        return new ProduceResponse(responseData, 0);
    }

    private StopReplicaRequest createStopReplicaRequest(short version, boolean deletePartitions) {
        ArrayList<StopReplicaRequestData.StopReplicaTopicState> topicStates = new ArrayList<StopReplicaRequestData.StopReplicaTopicState>();
        StopReplicaRequestData.StopReplicaTopicState topic1 = new StopReplicaRequestData.StopReplicaTopicState().setTopicName("topic1").setPartitionStates(Collections.singletonList(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0).setLeaderEpoch(1).setDeletePartition(deletePartitions)));
        topicStates.add(topic1);
        StopReplicaRequestData.StopReplicaTopicState topic2 = new StopReplicaRequestData.StopReplicaTopicState().setTopicName("topic2").setPartitionStates(Collections.singletonList(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(1).setLeaderEpoch(2).setDeletePartition(deletePartitions)));
        topicStates.add(topic2);
        return new StopReplicaRequest.Builder(version, 0, 1, 0L, deletePartitions, topicStates).build(version);
    }

    private StopReplicaResponse createStopReplicaResponse() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> partitions = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        partitions.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("test").setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
        return new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions));
    }

    private ControlledShutdownRequest createControlledShutdownRequest(short version) {
        ControlledShutdownRequestData data = new ControlledShutdownRequestData().setBrokerId(10).setBrokerEpoch(0L);
        return new ControlledShutdownRequest.Builder(data, ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()).build(version);
    }

    private ControlledShutdownResponse createControlledShutdownResponse() {
        ControlledShutdownResponseData.RemainingPartition p1 = new ControlledShutdownResponseData.RemainingPartition().setTopicName("test2").setPartitionIndex(5);
        ControlledShutdownResponseData.RemainingPartition p2 = new ControlledShutdownResponseData.RemainingPartition().setTopicName("test1").setPartitionIndex(10);
        ControlledShutdownResponseData.RemainingPartitionCollection pSet = new ControlledShutdownResponseData.RemainingPartitionCollection();
        pSet.add((ImplicitLinkedHashCollection.Element)p1);
        pSet.add((ImplicitLinkedHashCollection.Element)p2);
        ControlledShutdownResponseData data = new ControlledShutdownResponseData().setErrorCode(Errors.NONE.code()).setRemainingPartitions(pSet);
        return new ControlledShutdownResponse(data);
    }

    private LeaderAndIsrRequest createLeaderAndIsrRequest(short version) {
        ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put("topic5", Uuid.randomUuid());
        topicIds.put("topic20", Uuid.randomUuid());
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic5").setTopicId((Uuid)topicIds.get("topic5")).setPartitionIndex(105).setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(isr).setPartitionEpoch(2).setReplicas(replicas).setIsNew(false));
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic5").setTopicId((Uuid)topicIds.get("topic5")).setPartitionIndex(1).setControllerEpoch(1).setLeader(1).setLeaderEpoch(1).setIsr(isr).setPartitionEpoch(2).setReplicas(replicas).setIsNew(false).setClusterLinkId(UUID.randomUUID().toString()).setClusterLinkSourceTopicId(Uuid.randomUuid()));
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic20").setTopicId((Uuid)topicIds.get("topic20")).setPartitionIndex(1).setControllerEpoch(1).setLeader(0).setLeaderEpoch(1).setIsr(isr).setPartitionEpoch(2).setReplicas(replicas).setIsNew(false));
        Set leaders = Utils.mkSet((Object[])new Node[]{new Node(0, "test0", 1223), new Node(1, "test1", 1223)});
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(version, 1, 10, 0L, partitionStates, topicIds, false, (Collection)leaders, false).build();
    }

    private LeaderAndIsrResponse createLeaderAndIsrResponse(short version) {
        if (version < 5) {
            ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
            partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName("test").setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
            return new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions), version);
        }
        List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partition = Collections.singletonList(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
        LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection topics = new LeaderAndIsrResponseData.LeaderAndIsrTopicErrorCollection();
        topics.add((ImplicitLinkedHashCollection.Element)new LeaderAndIsrResponseData.LeaderAndIsrTopicError().setTopicId(Uuid.randomUuid()).setPartitionErrors(partition));
        return new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setTopics(topics), version);
    }

    private UpdateMetadataRequest createUpdateMetadataRequest(short version, String rack) {
        ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        List offlineReplicas = Collections.emptyList();
        partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic5").setPartitionIndex(105).setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setOfflineReplicas(offlineReplicas));
        partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic5").setPartitionIndex(1).setControllerEpoch(1).setLeader(1).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setOfflineReplicas(offlineReplicas));
        partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic20").setPartitionIndex(1).setControllerEpoch(1).setLeader(0).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setOfflineReplicas(offlineReplicas));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        if (version > 6) {
            topicIds.put("topic5", Uuid.randomUuid());
            topicIds.put("topic20", Uuid.randomUuid());
        }
        SecurityProtocol plaintext = SecurityProtocol.PLAINTEXT;
        ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints1 = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>();
        endpoints1.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(1223).setSecurityProtocol(plaintext.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)plaintext).value()));
        ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints2 = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>();
        endpoints2.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(1244).setSecurityProtocol(plaintext.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)plaintext).value()));
        if (version > 0) {
            SecurityProtocol ssl = SecurityProtocol.SSL;
            endpoints2.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host2").setPort(1234).setSecurityProtocol(ssl.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)ssl).value()));
            endpoints2.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host2").setPort(1334).setSecurityProtocol(ssl.id));
            if (version >= 3) {
                ((UpdateMetadataRequestData.UpdateMetadataEndpoint)endpoints2.get(1)).setListener("CLIENT");
            }
        }
        List<UpdateMetadataRequestData.Tag> tags = Arrays.asList(new UpdateMetadataRequestData.Tag().setName("a1").setValue("v1"), new UpdateMetadataRequestData.Tag().setName("a2").setValue("v2"));
        List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(endpoints1).setRack(rack).setTags(tags), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(endpoints2).setRack(rack).setTags(tags));
        return (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 1, 10, 0L, Collections.emptyList(), partitionStates, liveBrokers, topicIds, Collections.emptyList(), false).build();
    }

    private UpdateMetadataResponse createUpdateMetadataResponse() {
        return new UpdateMetadataResponse(new UpdateMetadataResponseData().setErrorCode(Errors.NONE.code()));
    }

    private SaslHandshakeRequest createSaslHandshakeRequest(short version) {
        return new SaslHandshakeRequest.Builder(new SaslHandshakeRequestData().setMechanism("PLAIN")).build(version);
    }

    private SaslHandshakeResponse createSaslHandshakeResponse() {
        return new SaslHandshakeResponse(new SaslHandshakeResponseData().setErrorCode(Errors.NONE.code()).setMechanisms(Collections.singletonList("GSSAPI")));
    }

    private SaslAuthenticateRequest createSaslAuthenticateRequest(short version) {
        SaslAuthenticateRequestData data = new SaslAuthenticateRequestData().setAuthBytes(new byte[0]);
        return new SaslAuthenticateRequest(data, version);
    }

    private SaslAuthenticateResponse createSaslAuthenticateResponse() {
        SaslAuthenticateResponseData data = new SaslAuthenticateResponseData().setErrorCode(Errors.NONE.code()).setAuthBytes(new byte[0]).setSessionLifetimeMs(Long.MAX_VALUE);
        return new SaslAuthenticateResponse(data);
    }

    private ApiVersionsRequest createApiVersionRequest(short version) {
        return new ApiVersionsRequest.Builder().build(version);
    }

    private ApiVersionsResponse createApiVersionResponse() {
        ApiVersionsResponseData.ApiVersionCollection apiVersions = new ApiVersionsResponseData.ApiVersionCollection();
        apiVersions.add((ImplicitLinkedHashCollection.Element)new ApiVersionsResponseData.ApiVersion().setApiKey((short)0).setMinVersion((short)0).setMaxVersion((short)2));
        return new ApiVersionsResponse(new ApiVersionsResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(0).setApiKeys(apiVersions));
    }

    private CreateTopicsRequest createCreateTopicRequest(short version) {
        return this.createCreateTopicRequest(version, version >= 1);
    }

    private CreateTopicsRequest createCreateTopicRequest(short version, boolean validateOnly) {
        CreateTopicsRequestData data = new CreateTopicsRequestData().setTimeoutMs(123).setValidateOnly(validateOnly);
        data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setNumPartitions(3).setReplicationFactor((short)5));
        CreateTopicsRequestData.CreatableTopic topic2 = new CreateTopicsRequestData.CreatableTopic();
        data.topics().add((ImplicitLinkedHashCollection.Element)topic2);
        topic2.assignments().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(0).setBrokerIds(Arrays.asList(1, 2, 3)));
        topic2.assignments().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(1).setBrokerIds(Arrays.asList(2, 3, 4)));
        topic2.configs().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName("config1").setValue("value1"));
        return new CreateTopicsRequest.Builder(data).build(version);
    }

    private CreateTopicsResponse createCreateTopicResponse() {
        CreateTopicsResponseData data = new CreateTopicsResponseData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("t1").setErrorCode(Errors.INVALID_TOPIC_EXCEPTION.code()).setErrorMessage(null));
        data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("t2").setErrorCode(Errors.LEADER_NOT_AVAILABLE.code()).setErrorMessage("Leader with id 5 is not available."));
        data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName("t3").setErrorCode(Errors.NONE.code()).setNumPartitions(1).setReplicationFactor((short)2).setConfigs(Collections.singletonList(new CreateTopicsResponseData.CreatableTopicConfigs().setConfigName("min.insync.replicas").setValue("2"))));
        return new CreateTopicsResponse(data);
    }

    private DeleteTopicsRequest createDeleteTopicsRequest(short version) {
        return new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("my_t1", "my_t2")).setTimeoutMs(1000)).build(version);
    }

    private DeleteTopicsResponse createDeleteTopicsResponse() {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName("t1").setErrorCode(Errors.INVALID_TOPIC_EXCEPTION.code()).setErrorMessage("Error Message"));
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName("t2").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Error Message"));
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName("t3").setErrorCode(Errors.NOT_CONTROLLER.code()));
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName("t4").setErrorCode(Errors.NONE.code()));
        return new DeleteTopicsResponse(data);
    }

    private InitProducerIdRequest createInitPidRequest(short version) {
        InitProducerIdRequestData requestData = new InitProducerIdRequestData().setTransactionalId(null).setTransactionTimeoutMs(100);
        return new InitProducerIdRequest.Builder(requestData).build(version);
    }

    private InitProducerIdResponse createInitPidResponse() {
        InitProducerIdResponseData responseData = new InitProducerIdResponseData().setErrorCode(Errors.NONE.code()).setProducerEpoch((short)3).setProducerId(3332L).setThrottleTimeMs(0);
        return new InitProducerIdResponse(responseData);
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection createOffsetForLeaderTopicCollection() {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic("topic1").setPartitions(Arrays.asList(new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(0).setLeaderEpoch(1).setCurrentLeaderEpoch(0), new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(1).setLeaderEpoch(1).setCurrentLeaderEpoch(0))));
        topics.add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic("topic2").setPartitions(Collections.singletonList(new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(2).setLeaderEpoch(3).setCurrentLeaderEpoch(-1))));
        return topics;
    }

    private OffsetsForLeaderEpochRequest createLeaderEpochRequestForConsumer() {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.createOffsetForLeaderTopicCollection();
        return (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forConsumer((OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs).build();
    }

    private OffsetsForLeaderEpochRequest createLeaderEpochRequestForReplica(short version, int replicaId) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.createOffsetForLeaderTopicCollection();
        return (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)version, (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)replicaId).build();
    }

    private OffsetsForLeaderEpochResponse createLeaderEpochResponse() {
        OffsetForLeaderEpochResponseData data = new OffsetForLeaderEpochResponseData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic("topic1").setPartitions(Arrays.asList(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(0).setErrorCode(Errors.NONE.code()).setLeaderEpoch(1).setEndOffset(0L), new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(1).setErrorCode(Errors.NONE.code()).setLeaderEpoch(1).setEndOffset(1L))));
        data.topics().add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic("topic2").setPartitions(Collections.singletonList(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(2).setErrorCode(Errors.NONE.code()).setLeaderEpoch(1).setEndOffset(1L))));
        return new OffsetsForLeaderEpochResponse(data);
    }

    private AddPartitionsToTxnRequest createAddPartitionsToTxnRequest(short version) {
        if (version < 4) {
            return AddPartitionsToTxnRequest.Builder.forClient((String)"tid", (long)21L, (short)42, Collections.singletonList(new TopicPartition("topic", 73))).build(version);
        }
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId("tid").setProducerId(21L).setProducerEpoch((short)42).setVerifyOnly(false).setTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName("topic").setPartitions(Collections.singletonList(73))).iterator()))).iterator());
        return AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions).build(version);
    }

    private AddPartitionsToTxnResponse createAddPartitionsToTxnResponse(short version) {
        String txnId = version < 4 ? "" : "tid";
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult result = AddPartitionsToTxnResponse.resultForTransaction((String)txnId, Collections.singletonMap(new TopicPartition("t", 0), Errors.NONE));
        AddPartitionsToTxnResponseData data = new AddPartitionsToTxnResponseData().setThrottleTimeMs(0);
        if (version < 4) {
            data.setResultsByTopicV3AndBelow(result.topicResults());
        } else {
            data.setResultsByTransaction(new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection(Collections.singletonList(result).iterator()));
        }
        return new AddPartitionsToTxnResponse(data);
    }

    private AddOffsetsToTxnRequest createAddOffsetsToTxnRequest(short version) {
        return new AddOffsetsToTxnRequest.Builder(new AddOffsetsToTxnRequestData().setTransactionalId("tid").setProducerId(21L).setProducerEpoch((short)42).setGroupId("gid")).build(version);
    }

    private AddOffsetsToTxnResponse createAddOffsetsToTxnResponse() {
        return new AddOffsetsToTxnResponse(new AddOffsetsToTxnResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(0));
    }

    private EndTxnRequest createEndTxnRequest(short version) {
        return new EndTxnRequest.Builder(new EndTxnRequestData().setTransactionalId("tid").setProducerId(21L).setProducerEpoch((short)42).setCommitted(TransactionResult.COMMIT.id)).build(version);
    }

    private EndTxnResponse createEndTxnResponse() {
        return new EndTxnResponse(new EndTxnResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(0));
    }

    private WriteTxnMarkersRequest createWriteTxnMarkersRequest(short version) {
        List<TopicPartition> partitions = Collections.singletonList(new TopicPartition("topic", 73));
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarkerEntry = new WriteTxnMarkersRequest.TxnMarkerEntry(21L, 42, 73, TransactionResult.ABORT, partitions);
        return new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Collections.singletonList(txnMarkerEntry)).build(version);
    }

    private WriteTxnMarkersResponse createWriteTxnMarkersResponse() {
        HashMap<TopicPartition, Errors> errorPerPartitions = new HashMap<TopicPartition, Errors>();
        errorPerPartitions.put(new TopicPartition("topic", 73), Errors.NONE);
        HashMap<Long, HashMap<TopicPartition, Errors>> response = new HashMap<Long, HashMap<TopicPartition, Errors>>();
        response.put(21L, errorPerPartitions);
        return new WriteTxnMarkersResponse(response);
    }

    private TxnOffsetCommitRequest createTxnOffsetCommitRequest(short version) {
        HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> offsets = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        offsets.put(new TopicPartition("topic", 73), new TxnOffsetCommitRequest.CommittedOffset(100L, null, Optional.empty()));
        offsets.put(new TopicPartition("topic", 74), new TxnOffsetCommitRequest.CommittedOffset(100L, "blah", Optional.of(27)));
        if (version < 3) {
            return (TxnOffsetCommitRequest)new TxnOffsetCommitRequest.Builder("transactionalId", "groupId", 21L, 42, offsets).build();
        }
        return new TxnOffsetCommitRequest.Builder("transactionalId", "groupId", 21L, 42, offsets, "member", 2, Optional.of("instance")).build(version);
    }

    private TxnOffsetCommitRequest createTxnOffsetCommitRequestWithAutoDowngrade() {
        HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> offsets = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        offsets.put(new TopicPartition("topic", 73), new TxnOffsetCommitRequest.CommittedOffset(100L, null, Optional.empty()));
        offsets.put(new TopicPartition("topic", 74), new TxnOffsetCommitRequest.CommittedOffset(100L, "blah", Optional.of(27)));
        return (TxnOffsetCommitRequest)new TxnOffsetCommitRequest.Builder("transactionalId", "groupId", 21L, 42, offsets, "member", 2, Optional.of("instance")).build();
    }

    private TxnOffsetCommitResponse createTxnOffsetCommitResponse() {
        HashMap<TopicPartition, Errors> errorPerPartitions = new HashMap<TopicPartition, Errors>();
        errorPerPartitions.put(new TopicPartition("topic", 73), Errors.NONE);
        return new TxnOffsetCommitResponse(0, errorPerPartitions);
    }

    private DescribeAclsRequest createDescribeAclsRequest(short version) {
        return new DescribeAclsRequest.Builder(new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY))).build(version);
    }

    private DescribeAclsResponse createDescribeAclsResponse() {
        DescribeAclsResponseData data = new DescribeAclsResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setThrottleTimeMs(0).setResources(Collections.singletonList(new DescribeAclsResponseData.DescribeAclsResource().setResourceType(ResourceType.TOPIC.code()).setResourceName("mytopic").setPatternType(PatternType.LITERAL.code()).setAcls(Collections.singletonList(new DescribeAclsResponseData.AclDescription().setHost("*").setOperation(AclOperation.WRITE.code()).setPermissionType(AclPermissionType.ALLOW.code()).setPrincipal("User:ANONYMOUS").setClusterLinkIds(Collections.singletonList(Uuid.randomUuid()))))));
        return new DescribeAclsResponse(data);
    }

    private CreateAclsRequest createCreateAclsRequest(short version) {
        ArrayList<CreateAclsRequestData.AclCreation> creations = new ArrayList<CreateAclsRequestData.AclCreation>();
        creations.add(CreateAclsRequest.aclCreation((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.ALLOW, Collections.singleton(Uuid.randomUuid())))));
        creations.add(CreateAclsRequest.aclCreation((AclBinding)new AclBinding(new ResourcePattern(ResourceType.GROUP, "mygroup", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.DENY))));
        CreateAclsRequestData data = new CreateAclsRequestData().setCreations(creations);
        return new CreateAclsRequest.Builder(data).build(version);
    }

    private CreateAclsResponse createCreateAclsResponse() {
        return new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult(), new CreateAclsResponseData.AclCreationResult().setErrorCode(Errors.NONE.code()).setErrorMessage("Foo bar"))));
    }

    private DeleteAclsRequest createDeleteAclsRequest(short version) {
        DeleteAclsRequestData data = new DeleteAclsRequestData().setFilters(Arrays.asList(new DeleteAclsRequestData.DeleteAclsFilter().setResourceTypeFilter(ResourceType.ANY.code()).setResourceNameFilter(null).setPatternTypeFilter(PatternType.LITERAL.code()).setPrincipalFilter("User:ANONYMOUS").setHostFilter(null).setOperation(AclOperation.ANY.code()).setPermissionType(AclPermissionType.ANY.code()).setClusterLinkIds(Collections.singletonList(Uuid.randomUuid())), new DeleteAclsRequestData.DeleteAclsFilter().setResourceTypeFilter(ResourceType.ANY.code()).setResourceNameFilter(null).setPatternTypeFilter(PatternType.LITERAL.code()).setPrincipalFilter("User:bob").setHostFilter(null).setOperation(AclOperation.ANY.code()).setPermissionType(AclPermissionType.ANY.code())));
        return new DeleteAclsRequest.Builder(data).build(version);
    }

    private DeleteAclsResponse createDeleteAclsResponse(short version) {
        ArrayList<DeleteAclsResponseData.DeleteAclsFilterResult> filterResults = new ArrayList<DeleteAclsResponseData.DeleteAclsFilterResult>();
        filterResults.add(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.TOPIC.code()).setResourceName("mytopic3").setPatternType(PatternType.LITERAL.code()).setPrincipal("User:ANONYMOUS").setHost("*").setOperation(AclOperation.DESCRIBE.code()).setPermissionType(AclPermissionType.ALLOW.code()).setClusterLinkIds(Collections.singletonList(Uuid.randomUuid())), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.TOPIC.code()).setResourceName("mytopic4").setPatternType(PatternType.LITERAL.code()).setPrincipal("User:ANONYMOUS").setHost("*").setOperation(AclOperation.DESCRIBE.code()).setPermissionType(AclPermissionType.DENY.code()))));
        filterResults.add(new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security"));
        return new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(filterResults), version);
    }

    private DescribeConfigsRequest createDescribeConfigsRequest(short version) {
        return new DescribeConfigsRequest.Builder(new DescribeConfigsRequestData().setResources(Arrays.asList(new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0"), new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("topic")))).build(version);
    }

    private DescribeConfigsRequest createDescribeConfigsRequestWithConfigEntries(short version) {
        return new DescribeConfigsRequest.Builder(new DescribeConfigsRequestData().setResources(Arrays.asList(new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setConfigurationKeys(Arrays.asList("foo", "bar")), new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("topic").setConfigurationKeys(null), new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("topic a").setConfigurationKeys(Collections.emptyList())))).build(version);
    }

    private DescribeConfigsRequest createDescribeConfigsRequestWithDocumentation(short version) {
        DescribeConfigsRequestData data = new DescribeConfigsRequestData().setResources(Collections.singletonList(new DescribeConfigsRequestData.DescribeConfigsResource().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setConfigurationKeys(Arrays.asList("foo", "bar"))));
        if (version == 3) {
            data.setIncludeDocumentation(true);
        }
        return new DescribeConfigsRequest.Builder(data).build(version);
    }

    private DescribeConfigsResponse createDescribeConfigsResponse(short version) {
        return new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("0").setConfigs(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("config_name").setValue("config_value").setConfigSource(version == 0 ? DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG.id).setIsSensitive(true).setReadOnly(false).setSynonyms(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("yet_another_name").setValue("yet another value").setConfigSource(version == 0 ? DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id).setIsSensitive(false).setReadOnly(true).setSynonyms(Collections.emptyList()).setConfigType(DescribeConfigsResponse.ConfigType.BOOLEAN.id()).setDocumentation("some description"), new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName("another_name").setValue("another value").setConfigSource(version == 0 ? DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id).setIsSensitive(false).setReadOnly(true).setSynonyms(Collections.emptyList()))), new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("topic").setConfigs(Collections.emptyList()))));
    }

    private AlterConfigsRequest createAlterConfigsRequest(short version) {
        LinkedHashMap<ConfigResource, AlterConfigsRequest.Config> configs = new LinkedHashMap<ConfigResource, AlterConfigsRequest.Config>();
        List<AlterConfigsRequest.ConfigEntry> configEntries = Arrays.asList(new AlterConfigsRequest.ConfigEntry("config_name", "config_value"), new AlterConfigsRequest.ConfigEntry("another_name", "another value"));
        configs.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new AlterConfigsRequest.Config(configEntries));
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, "topic"), new AlterConfigsRequest.Config(Collections.emptyList()));
        AlterConfigsRequest alterConfigsRequest = new AlterConfigsRequest.Builder(configs, false).build(version);
        Assertions.assertEquals((Object)("AlterConfigsRequestData(resources=[AlterConfigsResource(resourceType=" + ConfigResource.Type.BROKER.id() + ", resourceName='0', configs=[AlterableConfig(name='config_name', value='REDACTED'), AlterableConfig(name='another_name', value='REDACTED')]), AlterConfigsResource(resourceType=" + ConfigResource.Type.TOPIC.id() + ", resourceName='topic', configs=[])], validateOnly=false)"), (Object)alterConfigsRequest.toString());
        return alterConfigsRequest;
    }

    private AlterConfigsResponse createAlterConfigsResponse() {
        AlterConfigsResponseData data = new AlterConfigsResponseData().setThrottleTimeMs(20);
        data.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.NONE.code()).setErrorMessage(null).setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()));
        data.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("This request is invalid").setResourceName("topic").setResourceType(ConfigResource.Type.TOPIC.id()));
        return new AlterConfigsResponse(data);
    }

    private CreatePartitionsRequest createCreatePartitionsRequest(short version) {
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topics = new CreatePartitionsRequestData.CreatePartitionsTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_topic").setCount(3));
        topics.add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_other_topic").setCount(3));
        CreatePartitionsRequestData data = new CreatePartitionsRequestData().setTimeoutMs(0).setValidateOnly(false).setTopics(topics);
        return new CreatePartitionsRequest(data, version);
    }

    private CreatePartitionsRequest createCreatePartitionsRequestWithAssignments(short version) {
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topics = new CreatePartitionsRequestData.CreatePartitionsTopicCollection();
        CreatePartitionsRequestData.CreatePartitionsAssignment myTopicAssignment = new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Collections.singletonList(2));
        topics.add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_topic").setCount(3).setAssignments(Collections.singletonList(myTopicAssignment)));
        topics.add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_other_topic").setCount(3).setAssignments(Arrays.asList(new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Arrays.asList(2, 3)), new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Arrays.asList(3, 1)))));
        CreatePartitionsRequestData data = new CreatePartitionsRequestData().setTimeoutMs(0).setValidateOnly(false).setTopics(topics);
        return new CreatePartitionsRequest(data, version);
    }

    private CreatePartitionsResponse createCreatePartitionsResponse() {
        LinkedList<CreatePartitionsResponseData.CreatePartitionsTopicResult> results = new LinkedList<CreatePartitionsResponseData.CreatePartitionsTopicResult>();
        results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("my_topic").setErrorCode(Errors.INVALID_REPLICA_ASSIGNMENT.code()));
        results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("my_topic").setErrorCode(Errors.NONE.code()));
        CreatePartitionsResponseData data = new CreatePartitionsResponseData().setThrottleTimeMs(42).setResults(results);
        return new CreatePartitionsResponse(data);
    }

    private CreateDelegationTokenRequest createCreateTokenRequest(short version) {
        ArrayList<CreateDelegationTokenRequestData.CreatableRenewers> renewers = new ArrayList<CreateDelegationTokenRequestData.CreatableRenewers>();
        renewers.add(new CreateDelegationTokenRequestData.CreatableRenewers().setPrincipalType("User").setPrincipalName("user1"));
        renewers.add(new CreateDelegationTokenRequestData.CreatableRenewers().setPrincipalType("User").setPrincipalName("user2"));
        return new CreateDelegationTokenRequest.Builder(new CreateDelegationTokenRequestData().setRenewers(renewers).setMaxLifetimeMs(System.currentTimeMillis())).build(version);
    }

    private CreateDelegationTokenResponse createCreateTokenResponse() {
        CreateDelegationTokenResponseData data = new CreateDelegationTokenResponseData().setThrottleTimeMs(20).setErrorCode(Errors.NONE.code()).setPrincipalType("User").setPrincipalName("user1").setIssueTimestampMs(System.currentTimeMillis()).setExpiryTimestampMs(System.currentTimeMillis()).setMaxTimestampMs(System.currentTimeMillis()).setTokenId("token1").setHmac("test".getBytes());
        CreateDelegationTokenResponse response = new CreateDelegationTokenResponse(data);
        String responseStr = response.toString();
        Assertions.assertTrue((boolean)responseStr.contains("tokenId='REDACTED'"));
        Assertions.assertTrue((boolean)responseStr.contains("hmac=[]"));
        return response;
    }

    private RenewDelegationTokenRequest createRenewTokenRequest(short version) {
        RenewDelegationTokenRequestData data = new RenewDelegationTokenRequestData().setHmac("test".getBytes()).setRenewPeriodMs(System.currentTimeMillis());
        return new RenewDelegationTokenRequest.Builder(data).build(version);
    }

    private RenewDelegationTokenResponse createRenewTokenResponse() {
        RenewDelegationTokenResponseData data = new RenewDelegationTokenResponseData().setThrottleTimeMs(20).setErrorCode(Errors.NONE.code()).setExpiryTimestampMs(System.currentTimeMillis());
        return new RenewDelegationTokenResponse(data);
    }

    private ExpireDelegationTokenRequest createExpireTokenRequest(short version) {
        ExpireDelegationTokenRequestData data = new ExpireDelegationTokenRequestData().setHmac("test".getBytes()).setExpiryTimePeriodMs(System.currentTimeMillis());
        return new ExpireDelegationTokenRequest.Builder(data).build(version);
    }

    private ExpireDelegationTokenResponse createExpireTokenResponse() {
        ExpireDelegationTokenResponseData data = new ExpireDelegationTokenResponseData().setThrottleTimeMs(20).setErrorCode(Errors.NONE.code()).setExpiryTimestampMs(System.currentTimeMillis());
        return new ExpireDelegationTokenResponse(data);
    }

    private DescribeDelegationTokenRequest createDescribeTokenRequest(short version) {
        ArrayList<KafkaPrincipal> owners = new ArrayList<KafkaPrincipal>();
        owners.add(SecurityUtils.parseKafkaPrincipal((String)"User:user1"));
        owners.add(SecurityUtils.parseKafkaPrincipal((String)"User:user2"));
        return new DescribeDelegationTokenRequest.Builder(owners).build(version);
    }

    private DescribeDelegationTokenResponse createDescribeTokenResponse(short version) {
        ArrayList<KafkaPrincipal> renewers = new ArrayList<KafkaPrincipal>();
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user1"));
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user2"));
        LinkedList<DelegationToken> tokenList = new LinkedList<DelegationToken>();
        TokenInformation tokenInfo1 = new TokenInformation("1", SecurityUtils.parseKafkaPrincipal((String)"User:owner"), renewers, System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        TokenInformation tokenInfo2 = new TokenInformation("2", SecurityUtils.parseKafkaPrincipal((String)"User:owner1"), renewers, System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        tokenList.add(new DelegationToken(tokenInfo1, "test".getBytes()));
        tokenList.add(new DelegationToken(tokenInfo2, "test".getBytes()));
        DescribeDelegationTokenResponse response = new DescribeDelegationTokenResponse((int)version, 20, Errors.NONE, tokenList);
        String responseStr = response.toString();
        String[] parts = responseStr.split(",");
        Assertions.assertEquals((long)2L, (long)Arrays.stream(parts).filter(s -> s.trim().contains("tokenId='REDACTED'")).count());
        Assertions.assertEquals((long)2L, (long)Arrays.stream(parts).filter(s -> s.trim().contains("hmac=[]")).count());
        return response;
    }

    private ElectLeadersRequest createElectLeadersRequestNullPartitions() {
        return new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 100).build((short)1);
    }

    private ElectLeadersRequest createElectLeadersRequest(short version) {
        List<TopicPartition> partitions = Arrays.asList(new TopicPartition("data", 1), new TopicPartition("data", 2));
        return new ElectLeadersRequest.Builder(ElectionType.PREFERRED, partitions, 100).build(version);
    }

    private ElectLeadersResponse createElectLeadersResponse() {
        String topic = "myTopic";
        ArrayList<ElectLeadersResponseData.ReplicaElectionResult> electionResults = new ArrayList<ElectLeadersResponseData.ReplicaElectionResult>();
        ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
        electionResults.add(electionResult);
        electionResult.setTopic(topic);
        ElectLeadersResponseData.PartitionResult partitionResult = new ElectLeadersResponseData.PartitionResult();
        partitionResult.setPartitionId(0);
        partitionResult.setErrorCode(ApiError.NONE.error().code());
        partitionResult.setErrorMessage(ApiError.NONE.message());
        electionResult.partitionResult().add(partitionResult);
        partitionResult = new ElectLeadersResponseData.PartitionResult();
        partitionResult.setPartitionId(1);
        partitionResult.setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code());
        partitionResult.setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message());
        electionResult.partitionResult().add(partitionResult);
        return new ElectLeadersResponse(200, Errors.NONE.code(), electionResults, ApiKeys.ELECT_LEADERS.latestVersion());
    }

    private IncrementalAlterConfigsRequest createIncrementalAlterConfigsRequest(short version) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfig alterableConfig = new IncrementalAlterConfigsRequestData.AlterableConfig().setName("retention.ms").setConfigOperation((byte)0).setValue("100");
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        alterableConfigs.add((ImplicitLinkedHashCollection.Element)alterableConfig);
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("testtopic").setResourceType(ResourceType.TOPIC.code()).setConfigs(alterableConfigs));
        return new IncrementalAlterConfigsRequest.Builder(data).build(version);
    }

    private IncrementalAlterConfigsResponse createIncrementalAlterConfigsResponse() {
        IncrementalAlterConfigsResponseData data = new IncrementalAlterConfigsResponseData();
        data.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("testtopic").setResourceType(ResourceType.TOPIC.code()).setErrorCode(Errors.NONE.code()).setErrorMessage("Duplicate Keys"));
        return new IncrementalAlterConfigsResponse(data);
    }

    private AlterPartitionReassignmentsRequest createAlterPartitionReassignmentsRequest(short version) {
        AlterPartitionReassignmentsRequestData data = new AlterPartitionReassignmentsRequestData();
        data.topics().add(new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName("topic").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(0).setReplicas(null))));
        return new AlterPartitionReassignmentsRequest.Builder(data).build(version);
    }

    private AlterPartitionReassignmentsResponse createAlterPartitionReassignmentsResponse() {
        AlterPartitionReassignmentsResponseData data = new AlterPartitionReassignmentsResponseData();
        data.responses().add(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("topic").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NONE.code()).setErrorMessage("No reassignment is in progress for topic topic partition 0"))));
        return new AlterPartitionReassignmentsResponse(data);
    }

    private ListPartitionReassignmentsRequest createListPartitionReassignmentsRequest(short version) {
        ListPartitionReassignmentsRequestData data = new ListPartitionReassignmentsRequestData();
        data.setTopics(Collections.singletonList(new ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics().setName("topic").setPartitionIndexes(Collections.singletonList(1))));
        return new ListPartitionReassignmentsRequest.Builder(data).build(version);
    }

    private ListPartitionReassignmentsResponse createListPartitionReassignmentsResponse() {
        ListPartitionReassignmentsResponseData data = new ListPartitionReassignmentsResponseData();
        data.setTopics(Collections.singletonList(new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("topic").setPartitions(Collections.singletonList(new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2)).setAddingReplicas(Collections.singletonList(2)).setRemovingReplicas(Collections.singletonList(1))))));
        return new ListPartitionReassignmentsResponse(data);
    }

    private OffsetDeleteRequest createOffsetDeleteRequest(short version) {
        OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection topics = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("topic1").setPartitions(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0))));
        OffsetDeleteRequestData data = new OffsetDeleteRequestData();
        data.setGroupId("group1");
        data.setTopics(topics);
        return new OffsetDeleteRequest.Builder(data).build(version);
    }

    private OffsetDeleteResponse createOffsetDeleteResponse() {
        OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection partitions = new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection();
        partitions.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
        OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection topics = new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection();
        topics.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("topic1").setPartitions(partitions));
        OffsetDeleteResponseData data = new OffsetDeleteResponseData();
        data.setErrorCode(Errors.NONE.code());
        data.setTopics(topics);
        return new OffsetDeleteResponse(data);
    }

    private RemoveBrokersRequest createRemoveBrokerRequest(short version) {
        HashSet<RemoveBrokersRequestData.BrokerId> brokerIds = new HashSet<RemoveBrokersRequestData.BrokerId>();
        brokerIds.add(new RemoveBrokersRequestData.BrokerId().setBrokerId(5));
        return new RemoveBrokersRequest.Builder(brokerIds, true).build(version);
    }

    private RemoveBrokersResponse createRemoveBrokersResponse() {
        RemoveBrokersResponseData data = new RemoveBrokersResponseData();
        data.setBrokersToRemove(Collections.singletonList(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(1)));
        return new RemoveBrokersResponse(data);
    }

    private InitiateShutdownRequest createInitiateShutdownRequest(short version) {
        return new InitiateShutdownRequest.Builder(Long.MAX_VALUE).build(version);
    }

    private InitiateShutdownResponse createInitiateShutdownResponse() {
        InitiateShutdownResponseData data = new InitiateShutdownResponseData();
        return new InitiateShutdownResponse(data);
    }

    private DescribeBrokerRemovalsRequest createDescribeBrokerRemovalsRequest(short version) {
        return new DescribeBrokerRemovalsRequest.Builder().build(version);
    }

    private DescribeBrokerRemovalsResponse createDescribeBrokerRemovalsResponse(int version) {
        DescribeBrokerRemovalsResponseData data = new DescribeBrokerRemovalsResponseData();
        DescribeBrokerRemovalsResponseData.BrokerRemovalResponse removalResponse = new DescribeBrokerRemovalsResponseData.BrokerRemovalResponse().setBrokerId(1).setBrokerShutdownStatus("COMPLETE").setShutdownStatus("COMPLETED").setPartitionReassignmentsStatus("IN_PROGRESS").setReassignmentsStatus("IN_PROGRESS").setRemovalErrorCode(Errors.NONE.code());
        if (version >= 1) {
            removalResponse = removalResponse.setCreateTimeMs(110L).setLastUpdateTimeMs(115L);
        }
        data.setRemovedBrokers(Collections.singletonList(removalResponse));
        return new DescribeBrokerRemovalsResponse(data);
    }

    private DescribeBrokerRemovalsResponse createDescribeBrokerRemovalsResponse() {
        return this.createDescribeBrokerRemovalsResponse(ApiKeys.DESCRIBE_BROKER_REMOVALS.latestVersion());
    }

    private DescribeBrokerAdditionsRequest createDescribeBrokerAdditionsRequest(short version) {
        return new DescribeBrokerAdditionsRequest.Builder().build(version);
    }

    private DescribeBrokerAdditionsResponse createDescribeBrokerAdditionsResponse() {
        DescribeBrokerAdditionsResponseData data = new DescribeBrokerAdditionsResponseData();
        data.setBrokerAdditions(Collections.singletonList(new DescribeBrokerAdditionsResponseData.BrokerAdditionsResponse().setBrokerId(1).setPartitionReassignmentsStatus("COMPLETE").setGeneralOperationStatus("COMPLETED").setAdditionErrorCode(Errors.NONE.code()).setCreateTimeMs(100L).setLastUpdateTimeMs(110L)));
        return new DescribeBrokerAdditionsResponse(data);
    }

    private DescribeBalancerStatusRequest createDescribeBalancerStatusRequest(short version) {
        return new DescribeBalancerStatusRequest.Builder().build(version);
    }

    private DescribeBalancerStatusResponse createDescribeBalancerStatusResponse() {
        DescribeBalancerStatusResponseData data = new DescribeBalancerStatusResponseData();
        data.setBalancerStatus(new DescribeBalancerStatusResponseData.BalancerStatusResponse().setGeneralBalancerStatus("RUNNING").setBalancerStatusErrorCode(Errors.NONE.code()));
        return new DescribeBalancerStatusResponse(data);
    }

    private DescribeEvenClusterLoadStatusRequest createDescribeEvenClusterLoadStatusRequest(short version) {
        return new DescribeEvenClusterLoadStatusRequest.Builder().build(version);
    }

    private DescribeEvenClusterLoadStatusResponse createDescribeEvenClusterLoadStatusResponse() {
        DescribeEvenClusterLoadStatusResponseData data = new DescribeEvenClusterLoadStatusResponseData();
        data.setEvenClusterLoadStatus(new DescribeEvenClusterLoadStatusResponseData.EvenClusterLoadStatusResponse().setCurrentStatus("BALANCED").setCurrentStatusLastUpdateTimeMs(105L).setPreviousStatus("BALANCED").setPreviousStatusLastUpdateTimeMs(100L).setEvenClusterLoadErrorCode(Errors.NONE.code()));
        return new DescribeEvenClusterLoadStatusResponse(data);
    }

    private TriggerEvenClusterLoadRequest createTriggerEvenClusterLoadRequest(short version) {
        return new TriggerEvenClusterLoadRequest.Builder(new ArrayList()).build(version);
    }

    private TriggerEvenClusterLoadResponse createTriggerEvenClusterLoadResponse() {
        TriggerEvenClusterLoadResponseData data = new TriggerEvenClusterLoadResponseData();
        data.setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message());
        return new TriggerEvenClusterLoadResponse(data);
    }

    private ComputeEvenClusterLoadPlanRequest createComputeEvenClusterLoadPlanRequest(short version) {
        return new ComputeEvenClusterLoadPlanRequest.Builder(new ArrayList()).build(version);
    }

    private ComputeEvenClusterLoadPlanResponse createComputeEvenClusterLoadPlanResponse() {
        ComputeEvenClusterLoadPlanResponseData data = new ComputeEvenClusterLoadPlanResponseData();
        data.setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setInterBrokerMoves(14).setInterBrokerMovesMB(34858.0).setLeadershipMoves(12).setRecentWindows(6).setPartitionCoveragePercent(100.0).setNewBrokers(Arrays.asList(5, 7)).setDeadOrRemovedBrokers(Arrays.asList(1, 3)).setViolatedGoalsBeforeOptimization(Arrays.asList("LeaderBytesInDistributionGoal", "NetworkInboundUsageDistributionGoal", "CpuUsageDistributionGoal", "DiskUsageDistributionGoal", "NetworkOutboundUsageDistributionGoal")).setViolatedGoalsAfterOptimization(Arrays.asList("CpuUsageDistributionGoal")).setMovementGeneratingGoals(Arrays.asList("LeaderBytesInDistributionGoal", "NetworkInboundUsageDistributionGoal", "CpuUsageDistributionGoal", "DiskUsageDistributionGoal", "NetworkOutboundUsageDistributionGoal")).setExcludedTopics(Arrays.asList("lkc-*****__confluent-healthcheck_362")).setBrokersExcludedForLeadership(Arrays.asList(0, 3)).setBrokersExcludedForReplicaMove(Arrays.asList(6, 7, 8, 9, 10, 11)).setTotalBrokers(18).setTotalReplicas(947).setTotalTopics(19).setBalancednessScorePreRebalance(83.842).setBalancednessScorePostRebalance(97.115).setGoalStats(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.GoalStat().setGoalName("ReplicaPlacementGoal").setAvgResources(new ComputeEvenClusterLoadPlanResponseData.AvgResources().setCpuPercent(28.835).setNetworkInboundKBps(28240.951).setNetworkOutboundKBps(27849.211).setDiskMB(45366.01).setPotentialNwOutKBps(87839.004).setReplicas(158).setLeaderReplicas(52).setTopicReplicas(8)).setMaxResources(new ComputeEvenClusterLoadPlanResponseData.MaxResources().setCpuPercent(34.145).setNetworkInboundKBps(32054.334).setNetworkOutboundKBps(34599.855).setDiskMB(54622.617).setPotentialNwOutKBps(95007.256).setReplicas(173).setLeaderReplicas(58).setTopicReplicas(50)).setMinResources(new ComputeEvenClusterLoadPlanResponseData.MinResources().setCpuPercent(23.694).setNetworkInboundKBps(23647.879).setNetworkOutboundKBps(23185.646).setDiskMB(35209.719).setPotentialNwOutKBps(75145.148).setReplicas(143).setLeaderReplicas(47).setTopicReplicas(0)).setStdResources(new ComputeEvenClusterLoadPlanResponseData.StdResources().setCpuPercent(3.796).setNetworkInboundKBps(2818.515).setNetworkOutboundKBps(3707.753).setDiskMB(8347.475).setPotentialNwOutKBps(6810.038).setReplicas(14).setLeaderReplicas(5).setTopicReplicas(6)).setGoalOverview(new ComputeEvenClusterLoadPlanResponseData.GoalOverview().setProposalsGenerated(0).setProposalsRejected(0).setProposalsRejectedPercent(0.0).setProposalsAccepted(0).setProposalsAcceptedPercent(0.0).setMoves(0).setSwaps(0)))).setClusterLoadPreRebalance(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(0).setHost("host1").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15), new ComputeEvenClusterLoadPlanResponseData.PreBrokerStat().setBrokerId(1).setHost("host2").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15))).setClusterLoadPostRebalance(Arrays.asList(new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(0).setHost("host1").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15), new ComputeEvenClusterLoadPlanResponseData.PostBrokerStat().setBrokerId(1).setHost("host2").setDiskMB(10.0).setDiskPercent(50.0).setCpuPercent(50.0).setLeaderNetworkInKBps(20.0).setFollowerNetworkInKBps(20.0).setNetworkOutKBps(20.0).setPotentialNetworkOutKBps(60.0).setLeaders(5).setReplicas(15)));
        return new ComputeEvenClusterLoadPlanResponse(data);
    }

    private AlterReplicaLogDirsRequest createAlterReplicaLogDirsRequest(short version) {
        AlterReplicaLogDirsRequestData data = new AlterReplicaLogDirsRequestData();
        data.dirs().add((ImplicitLinkedHashCollection.Element)new AlterReplicaLogDirsRequestData.AlterReplicaLogDir().setPath("/data0").setTopics(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopicCollection(Collections.singletonList(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setPartitions(Collections.singletonList(0)).setName("topic")).iterator())));
        return new AlterReplicaLogDirsRequest.Builder(data).build(version);
    }

    private AlterReplicaLogDirsResponse createAlterReplicaLogDirsResponse() {
        AlterReplicaLogDirsResponseData data = new AlterReplicaLogDirsResponseData();
        data.results().add(new AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult().setTopicName("topic").setPartitions(Collections.singletonList(new AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult().setPartitionIndex(0).setErrorCode(Errors.NONE.code()))));
        return new AlterReplicaLogDirsResponse(data);
    }

    private DescribeClientQuotasRequest createDescribeClientQuotasRequest(short version) {
        ClientQuotaFilter filter = ClientQuotaFilter.all();
        return new DescribeClientQuotasRequest.Builder(filter).build(version);
    }

    private DescribeClientQuotasResponse createDescribeClientQuotasResponse() {
        DescribeClientQuotasResponseData data = new DescribeClientQuotasResponseData().setEntries(Collections.singletonList(new DescribeClientQuotasResponseData.EntryData().setEntity(Collections.singletonList(new DescribeClientQuotasResponseData.EntityData().setEntityType("user").setEntityName("user"))).setValues(Collections.singletonList(new DescribeClientQuotasResponseData.ValueData().setKey("request_percentage").setValue(1.0)))));
        return new DescribeClientQuotasResponse(data);
    }

    private AlterClientQuotasRequest createAlterClientQuotasRequest(short version) {
        ClientQuotaEntity entity = new ClientQuotaEntity(Collections.singletonMap("user", "user"));
        ClientQuotaAlteration.Op op = new ClientQuotaAlteration.Op("request_percentage", Double.valueOf(2.0));
        ClientQuotaAlteration alteration = new ClientQuotaAlteration(entity, Collections.singleton(op));
        return new AlterClientQuotasRequest.Builder(Collections.singleton(alteration), false).build(version);
    }

    private AlterClientQuotasResponse createAlterClientQuotasResponse() {
        AlterClientQuotasResponseData data = new AlterClientQuotasResponseData().setEntries(Collections.singletonList(new AlterClientQuotasResponseData.EntryData().setEntity(Collections.singletonList(new AlterClientQuotasResponseData.EntityData().setEntityType("user").setEntityName("user")))));
        return new AlterClientQuotasResponse(data);
    }

    private AlterBrokerReplicaExclusionsRequest createAlterBrokerReplicaExclusionsRequest(short version) {
        return new AlterBrokerReplicaExclusionsRequest.Builder().addExclusion(1, new ExclusionOp(ExclusionOp.OpType.SET, "maintenance")).addExclusion(2, new ExclusionOp(ExclusionOp.OpType.DELETE)).build(version);
    }

    private AlterBrokerReplicaExclusionsResponse createAlterBrokerReplicaExclusionsResponse() {
        AlterBrokerReplicaExclusionsResponseData data = new AlterBrokerReplicaExclusionsResponseData().setThrottleTimeMs(100).setWasApplied(false).setBrokerExclusions(Arrays.asList(new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(1).setExclusionOperationCode(ExclusionOp.OpType.SET.id()).setReason("maintenance"), new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(2).setExclusionOperationCode(ExclusionOp.OpType.DELETE.id()).setExclusionErrorCode(Errors.forException((Throwable)new BrokerReplicaExclusionNotFoundException("")).code()).setExclusionErrorMessage("No such exclusion existed")));
        return new AlterBrokerReplicaExclusionsResponse(data);
    }

    private DescribeBrokerReplicaExclusionsRequest createDescribeBrokerReplicaExclusionsRequest(short version) {
        DescribeBrokerReplicaExclusionsRequestData data = new DescribeBrokerReplicaExclusionsRequestData();
        return new DescribeBrokerReplicaExclusionsRequest.Builder(data).build(version);
    }

    private DescribeBrokerReplicaExclusionsResponse createDescribeBrokerReplicaExclusionsResponse() {
        DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection collection = new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponseCollection();
        collection.addAll(Arrays.asList(new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setReason("reason 1").setBrokerId(1), new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setReason("reason 2").setBrokerId(2), new DescribeBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setReason("reason 3").setBrokerId(3)));
        DescribeBrokerReplicaExclusionsResponseData data = new DescribeBrokerReplicaExclusionsResponseData().setThrottleTimeMs(100).setExcludedBrokers(collection);
        return new DescribeBrokerReplicaExclusionsResponse(data);
    }

    private AlterBrokerHealthRequest createAlterBrokerHealthRequest(short version) {
        AlterBrokerHealthRequestData data = new AlterBrokerHealthRequestData().setBrokerIds(Arrays.asList(1)).setReason("test").setStatusCode(ComponentHealthStatus.DEGRADED.id());
        if (version == 2) {
            data = data.setComponentCode(BrokerComponent.UNSPECIFIED.id());
        } else if (version >= 3) {
            data = data.setComponentCode(BrokerComponent.STORAGE.id());
        }
        return new AlterBrokerHealthRequest.Builder(data).build(version);
    }

    private AlterBrokerHealthResponse createAlterBrokerHealthResponse(short version) {
        AlterBrokerHealthResponseData data;
        if (version < 2) {
            data = new AlterBrokerHealthResponseData().setThrottleTimeMs(100).setBrokerHealthStatusResults(Arrays.asList(new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(0).setStatusCode(ComponentHealthStatus.DEGRADED.id()), new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(1).setStatusCode(ComponentHealthStatus.DEGRADED.id())));
        } else {
            byte componentCode = version >= 3 ? BrokerComponent.STORAGE.id() : BrokerComponent.UNSPECIFIED.id();
            data = new AlterBrokerHealthResponseData().setThrottleTimeMs(100).setBrokerHealthStatusResults(Arrays.asList(new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(0).setComponentCode(componentCode).setStatusCode(ComponentHealthStatus.DEGRADED.id()), new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(1).setComponentCode(componentCode).setStatusCode(ComponentHealthStatus.DEGRADED.id())));
        }
        return new AlterBrokerHealthResponse(data);
    }

    private CreateCellRequest createCellRequest(short version) {
        return new CreateCellRequest.Builder().setCellId(1).build(version);
    }

    private CreateCellResponse createCellResponse(short version) {
        CreateCellResponseData data = new CreateCellResponseData().setThrottleTimeMs(100).setErrorCode(Errors.NONE.code()).setErrorMessage("None");
        return new CreateCellResponse(data);
    }

    private DrainCellRequest createDrainCellRequest(short version) {
        return new DrainCellRequest.Builder().setCellId(100).build(version);
    }

    private DrainCellResponse createDrainCellResponse(short version) {
        DrainCellResponseData data = new DrainCellResponseData().setThrottleTimeMs(100);
        return new DrainCellResponse(data);
    }

    private DeleteCellRequest createDeleteCellRequest(short version) {
        return new DeleteCellRequest.Builder().setCellId(100).build(version);
    }

    private DeleteCellResponse createDeleteCellResponse(short version) {
        DeleteCellResponseData data = new DeleteCellResponseData().setThrottleTimeMs(100);
        return new DeleteCellResponse(data);
    }

    private AlterCellRequest createAlterCellRequest(short version) {
        return new AlterCellRequest.Builder().setCellId(1).setState(CellState.EXCLUDED).build(version);
    }

    private AlterCellResponse createAlterCellResponse(short version) {
        AlterCellResponseData data = new AlterCellResponseData().setThrottleTimeMs(100);
        return new AlterCellResponse(data);
    }

    private DescribeCellsRequest createDescribeCellsRequest(short version) {
        return new DescribeCellsRequest.Builder().setCellId(Arrays.asList(1)).build(version);
    }

    private DescribeCellsResponse createDescribeCellsResponse(short version) {
        DescribeCellsResponseData.Cell cellData = new DescribeCellsResponseData.Cell().setCellId(1).setState((byte)1).setBrokers(Arrays.asList(11, 12, 13));
        DescribeCellsResponseData data = new DescribeCellsResponseData().setThrottleTimeMs(100).setCells(Arrays.asList(cellData));
        return new DescribeCellsResponse(data);
    }

    private DescribeTenantsRequest createDescribeTenantsRequest(short version) {
        return new DescribeTenantsRequest.Builder().setTenants(Arrays.asList("tenant1")).build(version);
    }

    private DescribeTenantsResponse createDescribeTenantsResponse(short version) {
        DescribeTenantsResponseData.TenantDescription tenantData = new DescribeTenantsResponseData.TenantDescription().setCellId(11).setCellId(1);
        DescribeTenantsResponseData data = new DescribeTenantsResponseData().setTenantDescriptions(Arrays.asList(tenantData)).setThrottleTimeMs(100);
        return new DescribeTenantsResponse(data);
    }

    private AssignTenantsToCellRequest createAssignTenantsToCellRequest(short version) {
        return new AssignTenantsToCellRequest.Builder().setTenants(Arrays.asList(new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId("t1").setCellId(1).setForce(false))).build(version);
    }

    private AssignTenantsToCellResponse createAssignTenantsToCellResponse(short version) {
        AssignTenantsToCellResponseData data = new AssignTenantsToCellResponseData().setThrottleTimeMs(100);
        return new AssignTenantsToCellResponse(data);
    }

    private AssignBrokersToCellRequest createAssignBrokersToCellRequest(short version) {
        return new AssignBrokersToCellRequest.Builder().setCellId(1).setBrokers(Arrays.asList(1, 2, 3)).build(version);
    }

    private AssignBrokersToCellResponse createAssignBrokersToCellResponse(short version) {
        AssignBrokersToCellResponseData data = new AssignBrokersToCellResponseData().setThrottleTimeMs(100);
        return new AssignBrokersToCellResponse(data);
    }

    private UnAssignBrokersFromCellRequest createUnassignBrokersFromCellRequest(short version) {
        return new UnAssignBrokersFromCellRequest.Builder().setCellId(1).setBrokers(Arrays.asList(1, 2, 3)).build(version);
    }

    private UnAssignBrokersFromCellResponse createUnassignBrokersFromCellResponse(short version) {
        UnAssignBrokersFromCellResponseData data = new UnAssignBrokersFromCellResponseData().setThrottleTimeMs(100).setErrorCode(Errors.NONE.code());
        return new UnAssignBrokersFromCellResponse(data);
    }

    private DeleteTenantsRequest createDeleteTenantsRequest(short version) {
        return new DeleteTenantsRequest.Builder().setTenants(Arrays.asList("t1", "t2")).build(version);
    }

    private DeleteTenantsResponse createDeleteTenantsResponse(short version) {
        return new DeleteTenantsResponse(new DeleteTenantsResponseData().setFailedTenants(Arrays.asList("t1", "t2")).setErrorCode(Errors.NONE.code()));
    }

    private DescribeBrokerHealthRequest createDescribeBrokerHealthRequest(short version) {
        return new DescribeBrokerHealthRequest.Builder().build(version);
    }

    private DescribeBrokerHealthResponse createDescribeBrokerHealthResponse(short version) {
        DescribeBrokerHealthResponseData data = new DescribeBrokerHealthResponseData().setThrottleTimeMs(100).setDegradedBrokers(Arrays.asList(new DescribeBrokerHealthResponseData.DegradedBroker().setBrokerId(1).setDegradedBrokerComponents(Arrays.asList(new DescribeBrokerHealthResponseData.DegradedBrokerComponent().setReason("test").setComponentCode(BrokerComponent.UNSPECIFIED.id())))));
        DescribeBrokerHealthResponse.maybeDowngradeResponseData((DescribeBrokerHealthResponseData)data, (short)version);
        return new DescribeBrokerHealthResponse(data);
    }

    private DescribeNetworkRequest createDescribeNetworkRequest(short version) {
        DescribeNetworkRequestData data = new DescribeNetworkRequestData().setTenantId("tenant1").setListenerName("INTERNAL").setIpAddresses(Arrays.asList("1.2.3.4", "10.234.56.23")).setClientApiKeys(Arrays.asList("client.api.key1"));
        return new DescribeNetworkRequest.Builder(data).build(version);
    }

    private DescribeCellLoadRequest createDescribeCellsLoadRequest(short version) {
        return new DescribeCellLoadRequest.Builder().setCellId(Arrays.asList(1, 2)).build(version);
    }

    private DescribeNetworkResponse createDescribeNetworkResponse() {
        DescribeNetworkResponseData.TenantIpAddr tenantIpAddr = new DescribeNetworkResponseData.TenantIpAddr().setTenantId("tenant1").setIpAddress("1.2.3.4");
        DescribeNetworkResponseData data = new DescribeNetworkResponseData().setThrottleTimeMs(100).setTenantIpAddrList(Arrays.asList(tenantIpAddr));
        return new DescribeNetworkResponse(data);
    }

    private AppendRecordsRequest createAppendRecordsRequest(short version) {
        AppendRecordsRequestData data = new AppendRecordsRequestData().setReplicaEpoch(0L).setTopics(Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId(Uuid.ZERO_UUID).setPartitions(Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId(0L)))));
        return new AppendRecordsRequest.Builder(data).build(version);
    }

    private AppendRecordsResponse createAppendRecordsResponse() {
        AppendRecordsResponseData data = new AppendRecordsResponseData().setThrottleTimeMs(100).setTopics(Collections.singletonList(new AppendRecordsResponseData.TopicData().setTopicId(Uuid.ZERO_UUID).setPartitions(Collections.singletonList(new AppendRecordsResponseData.PartitionData().setPartitionIndex(0).setLogStartOffset(5L).setLogEndOffset(10L)))));
        return new AppendRecordsResponse(data);
    }

    private DescribeCellLoadResponse createDescribeCellsLoadResponse() {
        DescribeCellLoadResponseData data = new DescribeCellLoadResponseData().setThrottleTimeMs(100).setCells(Arrays.asList(new DescribeCellLoadResponseData.CellLoad().setCellId(1).setLoad(0.5)));
        return new DescribeCellLoadResponse(data);
    }

    private DescribeProducersRequest createDescribeProducersRequest(short version) {
        DescribeProducersRequestData data = new DescribeProducersRequestData();
        DescribeProducersRequestData.TopicRequest topicRequest = new DescribeProducersRequestData.TopicRequest();
        topicRequest.setName("test");
        topicRequest.partitionIndexes().add(0);
        topicRequest.partitionIndexes().add(1);
        data.topics().add(topicRequest);
        return new DescribeProducersRequest.Builder(data).build(version);
    }

    private DescribeProducersResponse createDescribeProducersResponse() {
        DescribeProducersResponseData data = new DescribeProducersResponseData();
        DescribeProducersResponseData.TopicResponse topicResponse = new DescribeProducersResponseData.TopicResponse();
        topicResponse.partitions().add(new DescribeProducersResponseData.PartitionResponse().setErrorCode(Errors.NONE.code()).setPartitionIndex(0).setActiveProducers(Arrays.asList(new DescribeProducersResponseData.ProducerState().setProducerId(1234L).setProducerEpoch(15).setLastTimestamp(13490218304L).setCurrentTxnStartOffset(5000L), new DescribeProducersResponseData.ProducerState().setProducerId(9876L).setProducerEpoch(32).setLastTimestamp(13490218399L))));
        data.topics().add(topicResponse);
        return new DescribeProducersResponse(data);
    }

    private BrokerHeartbeatRequest createBrokerHeartbeatRequest(short v) {
        BrokerHeartbeatRequestData data = new BrokerHeartbeatRequestData().setBrokerId(1).setBrokerEpoch(1L).setCurrentMetadataOffset(1L).setWantFence(false).setWantShutDown(false);
        return new BrokerHeartbeatRequest.Builder(data).build(v);
    }

    private BrokerHeartbeatResponse createBrokerHeartbeatResponse() {
        BrokerHeartbeatResponseData data = new BrokerHeartbeatResponseData().setIsFenced(false).setShouldShutDown(false).setThrottleTimeMs(0);
        return new BrokerHeartbeatResponse(data);
    }

    private BrokerRegistrationRequest createBrokerRegistrationRequest(short v) {
        BrokerRegistrationRequestData data = new BrokerRegistrationRequestData().setBrokerId(1).setClusterId(Uuid.randomUuid().toString()).setRack("1").setFeatures(new BrokerRegistrationRequestData.FeatureCollection(Collections.singletonList(new BrokerRegistrationRequestData.Feature()).iterator())).setListeners(new BrokerRegistrationRequestData.ListenerCollection(Collections.singletonList(new BrokerRegistrationRequestData.Listener()).iterator())).setIncarnationId(Uuid.randomUuid());
        return new BrokerRegistrationRequest.Builder(data).build(v);
    }

    private BrokerRegistrationResponse createBrokerRegistrationResponse() {
        BrokerRegistrationResponseData data = new BrokerRegistrationResponseData().setBrokerEpoch(1L).setThrottleTimeMs(0);
        return new BrokerRegistrationResponse(data);
    }

    private UnregisterBrokerRequest createUnregisterBrokerRequest(short version) {
        UnregisterBrokerRequestData data = new UnregisterBrokerRequestData().setBrokerId(1);
        return new UnregisterBrokerRequest.Builder(data).build(version);
    }

    private UnregisterBrokerResponse createUnregisterBrokerResponse() {
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData());
    }

    private DescribeTransactionsRequest createDescribeTransactionsRequest(short version) {
        DescribeTransactionsRequestData data = new DescribeTransactionsRequestData().setTransactionalIds(Arrays.asList("t1", "t2", "t3"));
        return new DescribeTransactionsRequest.Builder(data).build(version);
    }

    private DescribeTransactionsResponse createDescribeTransactionsResponse() {
        DescribeTransactionsResponseData data = new DescribeTransactionsResponseData();
        data.setTransactionStates(Arrays.asList(new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setTransactionalId("t1").setProducerId(12345L).setProducerEpoch((short)15).setTransactionStartTimeMs(13490218304L).setTransactionState("Empty"), new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setTransactionalId("t2").setProducerId(98765L).setProducerEpoch((short)30).setTransactionStartTimeMs(13490218304L).setTransactionState("Ongoing").setTopics(new DescribeTransactionsResponseData.TopicDataCollection(Arrays.asList(new DescribeTransactionsResponseData.TopicData().setTopic("foo").setPartitions(Arrays.asList(1, 3, 5, 7)), new DescribeTransactionsResponseData.TopicData().setTopic("bar").setPartitions(Arrays.asList(1, 3))).iterator())), new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NOT_COORDINATOR.code()).setTransactionalId("t3")));
        return new DescribeTransactionsResponse(data);
    }

    private ListTransactionsRequest createListTransactionsRequest(short version) {
        return new ListTransactionsRequest.Builder(new ListTransactionsRequestData().setStateFilters(Collections.singletonList("Ongoing")).setProducerIdFilters(Arrays.asList(1L, 2L, 15L))).build(version);
    }

    private ListTransactionsResponse createListTransactionsResponse() {
        ListTransactionsResponseData response = new ListTransactionsResponseData();
        response.setErrorCode(Errors.NONE.code());
        response.setTransactionStates(Arrays.asList(new ListTransactionsResponseData.TransactionState().setTransactionalId("foo").setProducerId(12345L).setTransactionState("Ongoing"), new ListTransactionsResponseData.TransactionState().setTransactionalId("bar").setProducerId(98765L).setTransactionState("PrepareAbort")));
        return new ListTransactionsResponse(response);
    }

    private ReportQuotaConsumptionRequest createReportQuotaConsumptionRequest(short version) {
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.setBrokerId(1);
        data.setEntries(Arrays.asList(new ReportQuotaConsumptionRequestData.EntryData().setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("confluent-tenant").setEntityName("lkc-abcdef"))).setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("egress").setThrottled(true).setUsage(200.0)))));
        return new ReportQuotaConsumptionRequest.Builder(data).build(version);
    }

    private ReportQuotaConsumptionResponse createReportQuotaConsumptionResponse() {
        ReportQuotaConsumptionResponseData data = new ReportQuotaConsumptionResponseData().setThrottleTimeMs(100);
        return new ReportQuotaConsumptionResponse(data);
    }

    private PublishQuotaTargetRequest createPublishQuotaTargetRequest(short version) {
        PublishQuotaTargetRequestData data = new PublishQuotaTargetRequestData().setEntries(Collections.singletonList(new PublishQuotaTargetRequestData.EntryData().setEntity(Collections.singletonList(new PublishQuotaTargetRequestData.EntityData().setEntityType("confluent-tenant").setEntityName("lkc-abcdef"))).setQuotas(Collections.singletonList(new PublishQuotaTargetRequestData.QuotaData().setQuotaType("egress").setQuota(200.0)))));
        return new PublishQuotaTargetRequest.Builder(data).build(version);
    }

    private PublishQuotaTargetResponse createPublishQuotaTargetResponse() {
        PublishQuotaTargetResponseData data = new PublishQuotaTargetResponseData().setThrottleTimeMs(100);
        return new PublishQuotaTargetResponse(data);
    }

    @Test
    public void testInvalidSaslHandShakeRequest() {
        AbstractRequest request = new SaslHandshakeRequest.Builder(new SaslHandshakeRequestData().setMechanism("PLAIN")).build();
        ByteBuffer serializedBytes = request.serialize();
        serializedBytes.putShort(0, (short)Short.MAX_VALUE);
        String msg = ((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> AbstractRequest.parseRequest((ApiKeys)request.apiKey(), (short)request.version(), (ByteBuffer)serializedBytes, (MessageContext)MessageContext.IDENTITY))).getMessage();
        Assertions.assertEquals((Object)"Error reading byte array of 32767 byte(s): only 5 byte(s) available", (Object)msg);
    }

    @Test
    public void testInvalidSaslAuthenticateRequest() {
        short version = 1;
        byte[] b = new byte[]{17, 31, 21, 44, 94, 42, 32, 38, 108, 57, 69, 31, 37, 28, 45, 37, 67, 42, 17, 118};
        SaslAuthenticateRequestData data = new SaslAuthenticateRequestData().setAuthBytes(b);
        SaslAuthenticateRequest request = new SaslAuthenticateRequest(data, version);
        ByteBuffer serializedBytes = request.serialize();
        serializedBytes.putInt(0, Integer.MAX_VALUE);
        String msg = ((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> RequestResponseTest.lambda$testInvalidSaslAuthenticateRequest$19((AbstractRequest)request, serializedBytes))).getMessage();
        Assertions.assertEquals((Object)"Error reading byte array of 2147483647 byte(s): only 20 byte(s) available", (Object)msg);
    }

    @Test
    public void testSaslAuthenticateRequestWithTags() {
        byte[] b = new byte[]{17, 31, 21, 44, 94, 42, 32, 38, 108, 57, 69, 31, 37, 28, 45, 37, 67, 42, 17, 118};
        SaslAuthenticateRequestData data = new SaslAuthenticateRequestData().setAuthBytes(b).setNetworkId("ne-test");
        SaslAuthenticateRequest request = new SaslAuthenticateRequest(data, 2);
        this.checkRequest((AbstractRequest)request);
    }

    @Test
    public void testValidTaggedFieldsWithSaslAuthenticateRequest() {
        byte[] byteArray = new byte[11];
        ByteBufferAccessor accessor = new ByteBufferAccessor(ByteBuffer.wrap(byteArray));
        byte[] authBytes = "test".getBytes(StandardCharsets.UTF_8);
        accessor.writeUnsignedVarint(authBytes.length + 1);
        accessor.writeByteArray(authBytes);
        accessor.writeUnsignedVarint(1);
        RawTaggedField taggedField = new RawTaggedField(1, new byte[]{1, 2, 3});
        accessor.writeUnsignedVarint(taggedField.tag());
        accessor.writeUnsignedVarint(taggedField.size());
        accessor.writeByteArray(taggedField.data());
        accessor.flip();
        SaslAuthenticateRequest saslAuthenticateRequest = (SaslAuthenticateRequest)AbstractRequest.parseRequest((ApiKeys)ApiKeys.SASL_AUTHENTICATE, (short)ApiKeys.SASL_AUTHENTICATE.latestVersion(), (ByteBuffer)accessor.buffer(), (MessageContext)MessageContext.IDENTITY).request;
        Assertions.assertArrayEquals((byte[])authBytes, (byte[])saslAuthenticateRequest.data().authBytes());
        Assertions.assertEquals((int)1, (int)saslAuthenticateRequest.data().unknownTaggedFields().size());
        Assertions.assertEquals((Object)taggedField, saslAuthenticateRequest.data().unknownTaggedFields().get(0));
    }

    @Test
    public void testInvalidTaggedFieldsWithSaslAuthenticateRequest() {
        byte[] byteArray = new byte[13];
        ByteBufferAccessor accessor = new ByteBufferAccessor(ByteBuffer.wrap(byteArray));
        byte[] authBytes = "test".getBytes(StandardCharsets.UTF_8);
        accessor.writeUnsignedVarint(authBytes.length + 1);
        accessor.writeByteArray(authBytes);
        accessor.writeUnsignedVarint(1);
        RawTaggedField taggedField = new RawTaggedField(1, new byte[]{1, 2, 3});
        accessor.writeUnsignedVarint(taggedField.tag());
        accessor.writeUnsignedVarint(Short.MAX_VALUE);
        accessor.writeByteArray(taggedField.data());
        accessor.flip();
        String msg = ((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> AbstractRequest.parseRequest((ApiKeys)ApiKeys.SASL_AUTHENTICATE, (short)ApiKeys.SASL_AUTHENTICATE.latestVersion(), (ByteBuffer)accessor.buffer(), (MessageContext)MessageContext.IDENTITY))).getMessage();
        Assertions.assertEquals((Object)"Error reading byte array of 32767 byte(s): only 3 byte(s) available", (Object)msg);
    }

    @Test
    public void testSaslAuthenticateRequestResponseToStringMasksSensitiveData() {
        byte[] sensitiveAuthBytes = "sensitive-auth-token-123".getBytes(StandardCharsets.UTF_8);
        SaslAuthenticateRequestData requestData = new SaslAuthenticateRequestData().setAuthBytes(sensitiveAuthBytes);
        SaslAuthenticateRequest request = new SaslAuthenticateRequest(requestData, 2);
        String requestString = request.toString();
        Assertions.assertTrue((boolean)requestString.contains("authBytes=[]"), (String)"authBytes field should be empty in toString() output");
        SaslAuthenticateResponseData responseData = new SaslAuthenticateResponseData().setAuthBytes(sensitiveAuthBytes);
        SaslAuthenticateResponse response = new SaslAuthenticateResponse(responseData);
        String responseString = response.toString();
        Assertions.assertTrue((boolean)responseString.contains("authBytes=[]"), (String)"authBytes field should be empty in toString() output");
    }

    private static /* synthetic */ void lambda$testInvalidSaslAuthenticateRequest$19(AbstractRequest request, ByteBuffer serializedBytes) throws Throwable {
        AbstractRequest.parseRequest((ApiKeys)request.apiKey(), (short)request.version(), (ByteBuffer)serializedBytes, (MessageContext)MessageContext.IDENTITY);
    }
}

