/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.TestDigestLoginModule;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class LoginManagerTest {
    private Password dynamicPlainContext;
    private Password dynamicDigestContext;

    @BeforeEach
    public void setUp() {
        this.dynamicPlainContext = new Password(PlainLoginModule.class.getName() + " required user=\"plainuser\" password=\"plain-secret\";");
        this.dynamicDigestContext = new Password(TestDigestLoginModule.class.getName() + " required user=\"digestuser\" password=\"digest-secret\";");
        TestJaasConfig.createConfiguration("SCRAM-SHA-256", Collections.singletonList("SCRAM-SHA-256"));
    }

    @AfterEach
    public void tearDown() {
        LoginManager.closeAll();
    }

    @Test
    public void testClientLoginManager() throws Exception {
        Map<String, Password> configs = Collections.singletonMap("sasl.jaas.config", this.dynamicPlainContext);
        JaasContext dynamicContext = JaasContext.loadClientContext(configs);
        JaasContext staticContext = JaasContext.loadClientContext(Collections.emptyMap());
        LoginManager dynamicLogin = LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertEquals((Object)this.dynamicPlainContext, (Object)dynamicLogin.cacheKey());
        LoginManager staticLogin = LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)dynamicLogin, (Object)staticLogin);
        Assertions.assertEquals((Object)"KafkaClient", (Object)staticLogin.cacheKey());
        Assertions.assertSame((Object)dynamicLogin, (Object)LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs));
        Assertions.assertSame((Object)staticLogin, (Object)LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs));
        this.verifyLoginManagerRelease(dynamicLogin, 2, dynamicContext, configs);
        this.verifyLoginManagerRelease(staticLogin, 2, staticContext, configs);
    }

    @Test
    public void testServerLoginManager() throws Exception {
        HashMap<String, Password> configs = new HashMap<String, Password>();
        configs.put("plain.sasl.jaas.config", this.dynamicPlainContext);
        configs.put("digest-md5.sasl.jaas.config", this.dynamicDigestContext);
        ListenerName listenerName = new ListenerName("listener1");
        JaasContext plainJaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)"PLAIN", configs);
        JaasContext digestJaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)"DIGEST-MD5", configs);
        JaasContext scramJaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)"SCRAM-SHA-256", configs);
        LoginManager dynamicPlainLogin = LoginManager.acquireLoginManager((JaasContext)plainJaasContext, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertEquals((Object)this.dynamicPlainContext, (Object)dynamicPlainLogin.cacheKey());
        LoginManager dynamicDigestLogin = LoginManager.acquireLoginManager((JaasContext)digestJaasContext, (String)"DIGEST-MD5", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)dynamicPlainLogin, (Object)dynamicDigestLogin);
        Assertions.assertEquals((Object)this.dynamicDigestContext, (Object)dynamicDigestLogin.cacheKey());
        LoginManager staticScramLogin = LoginManager.acquireLoginManager((JaasContext)scramJaasContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)dynamicPlainLogin, (Object)staticScramLogin);
        Assertions.assertEquals((Object)"KafkaServer", (Object)staticScramLogin.cacheKey());
        Assertions.assertSame((Object)dynamicPlainLogin, (Object)LoginManager.acquireLoginManager((JaasContext)plainJaasContext, (String)"PLAIN", DefaultLogin.class, configs));
        Assertions.assertSame((Object)dynamicDigestLogin, (Object)LoginManager.acquireLoginManager((JaasContext)digestJaasContext, (String)"DIGEST-MD5", DefaultLogin.class, configs));
        Assertions.assertSame((Object)staticScramLogin, (Object)LoginManager.acquireLoginManager((JaasContext)scramJaasContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs));
        this.verifyLoginManagerRelease(dynamicPlainLogin, 2, plainJaasContext, configs);
        this.verifyLoginManagerRelease(dynamicDigestLogin, 2, digestJaasContext, configs);
        this.verifyLoginManagerRelease(staticScramLogin, 2, scramJaasContext, configs);
    }

    @Test
    public void testNonReconfigurableLoginManager() throws Exception {
        Map<String, Password> configs = Collections.singletonMap("sasl.jaas.config", this.dynamicPlainContext);
        JaasContext context = JaasContext.loadClientContext(configs);
        LoginManager loginManager = LoginManager.acquireLoginManager((JaasContext)context, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertEquals((Object)this.dynamicPlainContext, (Object)loginManager.cacheKey());
        Assertions.assertThrows(IllegalStateException.class, () -> loginManager.reconfigure(configs));
        this.verifyLoginManagerRelease(loginManager, 1, context, configs);
    }

    @Test
    public void testReconfigurableLoginManager() throws Exception {
        Password jaasConfig = new Password("io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule required username_config=\"test.username\" password_config=\"test.password\";");
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("sasl.jaas.config", jaasConfig);
        configs.put("sasl.login.callback.handler.class", Utils.loadClass((String)"io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler", AuthenticateCallbackHandler.class));
        configs.put("test.username", "alice");
        configs.put("test.password", "alice-password");
        JaasContext context = JaasContext.loadClientContext(configs);
        LoginManager loginManager = LoginManager.acquireLoginManager((JaasContext)context, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertEquals((Object)jaasConfig, (Object)loginManager.cacheKey());
        Assertions.assertEquals((int)1, (int)loginManager.subject().getPrivateCredentials().size());
        configs.put("test.password", "alice-new-password");
        loginManager.reconfigure(configs);
        Assertions.assertEquals((int)1, (int)loginManager.subject().getPrivateCredentials().size());
        this.verifyLoginManagerRelease(loginManager, 1, context, configs);
    }

    @Test
    public void testLoginManagerWithDifferentConfigs() throws Exception {
        HashMap<String, Object> configs1 = new HashMap<String, Object>();
        configs1.put("sasl.jaas.config", this.dynamicPlainContext);
        configs1.put("client.id", "client");
        configs1.put("sasl.oauthbearer.token.endpoint.url", "http://host1:1234");
        HashMap<String, String> configs2 = new HashMap<String, String>(configs1);
        configs2.put("sasl.oauthbearer.token.endpoint.url", "http://host2:1234");
        JaasContext dynamicContext = JaasContext.loadClientContext(configs1);
        HashMap<String, String> configs3 = new HashMap<String, String>(configs1);
        configs3.put("client.id", "client3");
        LoginManager dynamicLogin1 = LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs1);
        LoginManager dynamicLogin2 = LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs2);
        Assertions.assertEquals((Object)this.dynamicPlainContext, (Object)dynamicLogin1.cacheKey());
        Assertions.assertEquals((Object)this.dynamicPlainContext, (Object)dynamicLogin2.cacheKey());
        Assertions.assertNotSame((Object)dynamicLogin1, (Object)dynamicLogin2);
        Assertions.assertSame((Object)dynamicLogin1, (Object)LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs1));
        Assertions.assertSame((Object)dynamicLogin2, (Object)LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs2));
        Assertions.assertSame((Object)dynamicLogin1, (Object)LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, new HashMap(configs1)));
        Assertions.assertSame((Object)dynamicLogin1, (Object)LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, configs3));
        JaasContext staticContext = JaasContext.loadClientContext(Collections.emptyMap());
        LoginManager staticLogin1 = LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs1);
        LoginManager staticLogin2 = LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs2);
        Assertions.assertNotSame((Object)staticLogin1, (Object)dynamicLogin1);
        Assertions.assertNotSame((Object)staticLogin2, (Object)dynamicLogin2);
        Assertions.assertNotSame((Object)staticLogin1, (Object)staticLogin2);
        Assertions.assertSame((Object)staticLogin1, (Object)LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs1));
        Assertions.assertSame((Object)staticLogin2, (Object)LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs2));
        Assertions.assertSame((Object)staticLogin1, (Object)LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, new HashMap(configs1)));
        Assertions.assertSame((Object)staticLogin1, (Object)LoginManager.acquireLoginManager((JaasContext)staticContext, (String)"SCRAM-SHA-256", DefaultLogin.class, configs3));
        this.verifyLoginManagerRelease(dynamicLogin1, 4, dynamicContext, configs1);
        this.verifyLoginManagerRelease(dynamicLogin2, 2, dynamicContext, configs2);
        this.verifyLoginManagerRelease(staticLogin1, 4, staticContext, configs1);
        this.verifyLoginManagerRelease(staticLogin2, 2, staticContext, configs2);
    }

    @Test
    public void testShouldReThrowExceptionOnErrorLoginAttempt() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("sasl.jaas.config", this.dynamicPlainContext);
        config.put("sasl.login.class", Login.class);
        config.put("sasl.login.callback.handler.class", AuthenticateCallbackHandler.class);
        JaasContext dynamicContext = JaasContext.loadClientContext(config);
        Login mockLogin = (Login)Mockito.mock(Login.class);
        AuthenticateCallbackHandler mockHandler = (AuthenticateCallbackHandler)Mockito.mock(AuthenticateCallbackHandler.class);
        ((Login)Mockito.doThrow((Throwable[])new Throwable[]{new LoginException("Expecting LoginException")}).when((Object)mockLogin)).login();
        try (MockedStatic mockedUtils = Mockito.mockStatic(Utils.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            mockedUtils.when(() -> {
                Login cfr_ignored_0 = (Login)Utils.newInstance(Login.class);
            }).thenReturn((Object)mockLogin);
            mockedUtils.when(() -> {
                AuthenticateCallbackHandler cfr_ignored_0 = (AuthenticateCallbackHandler)Utils.newInstance(AuthenticateCallbackHandler.class);
            }).thenReturn((Object)mockHandler);
            Assertions.assertThrows(LoginException.class, () -> LoginManager.acquireLoginManager((JaasContext)dynamicContext, (String)"PLAIN", DefaultLogin.class, (Map)config));
            ((Login)Mockito.verify((Object)mockLogin)).close();
            ((AuthenticateCallbackHandler)Mockito.verify((Object)mockHandler)).close();
        }
    }

    private void verifyLoginManagerRelease(LoginManager loginManager, int acquireCount, JaasContext jaasContext, Map<String, ?> configs) throws Exception {
        int i;
        for (i = 0; i < acquireCount - 1; ++i) {
            loginManager.release();
        }
        Assertions.assertSame((Object)loginManager, (Object)LoginManager.acquireLoginManager((JaasContext)jaasContext, (String)"PLAIN", DefaultLogin.class, configs));
        for (i = 0; i < 2; ++i) {
            loginManager.release();
        }
        LoginManager newLoginManager = LoginManager.acquireLoginManager((JaasContext)jaasContext, (String)"PLAIN", DefaultLogin.class, configs);
        Assertions.assertNotSame((Object)loginManager, (Object)newLoginManager);
        newLoginManager.release();
    }
}

