/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathAwareSniHostnameTest {
    @Test
    public void testV3BootstrapHostname() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pkc-abc.us-west-2.aws.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"pkc-abc.us-west-2.aws.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV3BrokerHostname() {
        this.testV3BrokerHostname("b0-pkc-abc.us-west-2.aws.confluent.cloud");
        this.testV3BrokerHostname("b10-pkc-abc.us-west-2.aws.confluent.cloud");
    }

    @Test
    public void testV3BootstrapOnV4() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pkc-2396y.us-west-1.aws.confluent.cloud", "us-west-1");
        Assertions.assertEquals((Object)"us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertNull((Object)sniHostName.apeId());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
    }

    @Test
    public void testv4DNS() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-2v531-lg1y3.us-west-1.aws.confluent.cloud", "lg1y3.us-west-1");
        Assertions.assertEquals((Object)"lg1y3.us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
        sniHostName = new PathAwareSniHostName("lkc-2v531-00aa-usw1-az1-lg1y3.us-west-1.aws.confluent.cloud", "lg1y3.us-west-1");
        Assertions.assertEquals((Object)"lg1y3.us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
    }

    @Test
    public void testV4PrivateDNSPhase1() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-2v531.domz6wj0p.us-west-1.aws.confluent.cloud", "domz6wj0p.us-west-1");
        Assertions.assertEquals((Object)"domz6wj0p.us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
        sniHostName = new PathAwareSniHostName("lkc-2v531-00aa.usw1-az1.domz6wj0p.us-west-1.aws.confluent.cloud", "domz6wj0p.us-west-1");
        Assertions.assertEquals((Object)"domz6wj0p.us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
    }

    @Test
    public void testV4PrivateDNSPhase2() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-2v531.lg1y3.us-west-1.aws.confluent.cloud", "lg1y3.us-west-1");
        Assertions.assertEquals((Object)"lg1y3.us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
        sniHostName = new PathAwareSniHostName("lkc-2v531-00aa.usw1-az1.lg1y3.us-west-1.aws.confluent.cloud", "lg1y3.us-west-1");
        Assertions.assertEquals((Object)"lg1y3.us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
    }

    @Test
    public void testEnterpriseSKUPrivate() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-2v531.ape1.us-west-1.aws.private.confluent.cloud", "us-west-1");
        Assertions.assertEquals((Object)"us-west-1.aws.private.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"ape1", (Object)sniHostName.apeId());
        sniHostName = new PathAwareSniHostName("lkc-2v531-00aa.az1.ape1.us-west-1.aws.private.confluent.cloud", "us-west-1");
        Assertions.assertEquals((Object)"us-west-1.aws.private.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"ape1", (Object)sniHostName.apeId());
    }

    @Test
    public void testEnterpriseSKUPublic() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-2v531.us-west-1.aws.confluent.cloud", "us-west-1");
        Assertions.assertEquals((Object)"us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
        sniHostName = new PathAwareSniHostName("lkc-2v531-00aa.usw1-az1.us-west-1.aws.confluent.cloud", "us-west-1");
        Assertions.assertEquals((Object)"us-west-1.aws.confluent.cloud", (Object)sniHostName.subdomain());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)sniHostName.logicalClusterId());
        Assertions.assertNull((Object)sniHostName.apeId());
    }

    @Test
    public void testV4Bootstrap() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-1234-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BootstrapWithPathPrefix() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pb-lkc-1234-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertEquals((Object)"pb", (Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerNoLogicalCluster() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerNoLogicalClusterWithPathPrefix() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pb-e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertEquals((Object)"pb", (Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerWithLogicalCluster() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerWithLogicalClusterWithPathPrefix() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pb-lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertEquals((Object)"pb", (Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testHostnameNotNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PathAwareSniHostName(null));
    }

    private void testV3BrokerHostname(String hostname) {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName(hostname);
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)hostname, (Object)sniHostName.strippedHostname());
    }
}

