/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.NettySslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.SslFactoryTest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class NettySslFactoryTest
extends SslFactoryTest {
    public NettySslFactoryTest(String tlsProtocol) {
        super(tlsProtocol, NettySslEngineFactory.class);
    }

    @Override
    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        this.configureSslBuilderClass(serverSslConfig);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assertions.assertTrue((boolean)(sslFactory.sslEngineFactory() instanceof NettySslEngineFactory));
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assertions.assertNotNull((Object)engine);
        Set expected = Utils.mkSet((Object[])new String[]{this.tlsProtocol});
        expected.add("SSLv2Hello");
        Assertions.assertEquals((Object)expected, (Object)Utils.mkSet((Object[])engine.getEnabledProtocols()));
        Assertions.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Override
    @Test
    public void testSslFactoryConfigWithManyKeyStoreEntries() throws Exception {
        Map<String, Object> serverSslConfig = TestSslUtils.generateConfigsWithCertificateChains(this.tlsProtocol);
        this.configureSslBuilderClass(serverSslConfig);
        try (SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);){
            sslFactory.configure(serverSslConfig);
            SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
            Assertions.assertNotNull((Object)engine);
            Set expected = Utils.mkSet((Object[])new String[]{this.tlsProtocol});
            expected.add("SSLv2Hello");
            Assertions.assertEquals((Object)expected, (Object)Utils.mkSet((Object[])engine.getEnabledProtocols()));
            Assertions.assertFalse((boolean)engine.getUseClientMode());
        }
    }

    @Test
    public void testSslConfigureClient() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).build();
        this.configureSslBuilderClass(clientSslConfig);
        SslFactory clientSslFactory = new SslFactory(Mode.CLIENT);
        clientSslFactory.configure(clientSslConfig);
        Assertions.assertTrue((boolean)(clientSslFactory.sslEngineFactory() instanceof NettySslEngineFactory));
        SSLEngine clientEngine = clientSslFactory.createSslEngine("localhost", 0);
        Assertions.assertNotNull((Object)clientEngine);
    }

    @Test
    public void testSslConfigureInvalidServer() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = this.sslConfigsBuilder(Mode.CLIENT).createNewTrustStore(trustStoreFile).build();
        SslFactory serverSslFactory = new SslFactory(Mode.SERVER);
        serverSslFactory.configure(clientSslConfig);
        Assertions.assertTrue((boolean)(serverSslFactory.sslEngineFactory() instanceof DefaultSslEngineFactory));
        SSLEngine serverEngine = serverSslFactory.createSslEngine("localhost", 0);
        Assertions.assertNotNull((Object)serverEngine);
    }

    @Test
    public void testSslEngineCloser() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        this.configureSslBuilderClass(serverSslConfig);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assertions.assertTrue((boolean)(sslFactory.sslEngineFactory() instanceof NettySslEngineFactory));
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assertions.assertNotNull((Object)engine);
        Assertions.assertTrue((boolean)(engine instanceof ReferenceCountedOpenSslEngine));
        ReferenceCountedOpenSslEngine opensslEngine = (ReferenceCountedOpenSslEngine)engine;
        Assertions.assertEquals((int)1, (int)opensslEngine.refCnt());
        sslFactory.createCloseableSslEngine((SSLEngine)opensslEngine).close();
        Assertions.assertEquals((int)0, (int)opensslEngine.refCnt());
    }
}

