/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.server.quota.ClientQuotaClusterDescriber;
import org.apache.kafka.server.quota.ZkClientQuotaClusterDescriber;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZkClientQuotaClusterDescriberTest {
    private static final List<Node> NODES = Arrays.asList(new Node(0, "localhost", 9000), new Node(1, "localhost", 9001), new Node(2, "localhost", 9002), new Node(3, "localhost", 9003), new Node(4, "localhost", 9004));
    private static final Cluster CLUSTER_A = new Cluster("clusterA", NODES, Arrays.asList(new PartitionInfo("foobar", 0, NODES.get(0), new Node[]{NODES.get(0)}, new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[0]), new PartitionInfo("foobar", 1, NODES.get(1), new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[0]), new PartitionInfo("foobar", 2, Node.noNode(), new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[0], new Node[0]), new PartitionInfo("baaz", 0, NODES.get(2), new Node[]{NODES.get(0)}, new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[0]), new PartitionInfo("quux", 0, NODES.get(3), new Node[]{NODES.get(3), NODES.get(4), NODES.get(0)}, new Node[]{NODES.get(3), NODES.get(4), NODES.get(0)}, new Node[0])), Collections.emptySet(), Collections.emptySet());
    private static final ZkClientQuotaClusterDescriber DESCRIBER = new ZkClientQuotaClusterDescriber(CLUSTER_A);

    @Test
    public void testTopicNames() {
        HashSet topicNames = new HashSet();
        Iterator iterator = DESCRIBER.topicNames();
        while (iterator.hasNext()) {
            topicNames.add(iterator.next());
        }
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foobar", "baaz", "quux")), topicNames);
    }

    @Test
    public void testPartitionsForNonExistentTopic() {
        Iterator iterator = DESCRIBER.partitionsForTopic("nonexistent");
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testPartitionsForTopic() {
        ArrayList partitions = new ArrayList();
        Iterator iterator = DESCRIBER.partitionsForTopic("foobar");
        while (iterator.hasNext()) {
            partitions.add(iterator.next());
        }
        Assertions.assertEquals(Arrays.asList(new ClientQuotaClusterDescriber.Partition(0, 0), new ClientQuotaClusterDescriber.Partition(1, 1), new ClientQuotaClusterDescriber.Partition(2, -1)), partitions);
    }
}

