/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.test.TestUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDSAContentSignerBuilder;
import org.bouncycastle.operator.bc.BcECContentSignerBuilder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class TestSslUtils {
    public static final String TRUST_STORE_PASSWORD = "TrustStorePassword";
    public static final String DEFAULT_TLS_PROTOCOL_FOR_TESTS = SslConfigs.DEFAULT_SSL_PROTOCOL;

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) throws CertificateException {
        return new CertificateBuilder(days, algorithm).generate(dn, pair);
    }

    public static X509Certificate generateSignedCertificate(String dn, KeyPair keyPair, int daysBeforeNow, int daysAfterNow, String issuer, KeyPair parentKeyPair, String algorithm, boolean isCA, boolean isServerCert, boolean isClientCert) throws CertificateException {
        return new CertificateBuilder(0, algorithm).generateSignedCertificate(dn, keyPair, daysBeforeNow, daysAfterNow, issuer, parentKeyPair, isCA, isServerCert, isClientCert);
    }

    public static X509Certificate generateSignedCertificate(String dn, KeyPair keyPair, int daysBeforeNow, int daysAfterNow, String issuer, KeyPair parentKeyPair, String algorithm, boolean isCA, boolean isServerCert, boolean isClientCert, String[] hostNames) throws CertificateException, IOException {
        return new CertificateBuilder(0, algorithm).sanDnsNames(hostNames).generateSignedCertificate(dn, keyPair, daysBeforeNow, daysAfterNow, issuer, parentKeyPair, isCA, isServerCert, isClientCert);
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(algorithm.equals("EC") ? 256 : 2048);
        return keyGen.genKeyPair();
    }

    private static KeyStore createEmptyKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    private static void saveKeyStore(KeyStore ks, String filename, Password password) throws GeneralSecurityException, IOException {
        try (OutputStream out = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            ks.store(out, password.value().toCharArray());
        }
    }

    public static void createKeyStore(String filename, Password password, Password keyPassword, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = TestSslUtils.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, keyPassword.value().toCharArray(), new Certificate[]{cert});
        TestSslUtils.saveKeyStore(ks, filename, password);
    }

    public static <T extends Certificate> void createTrustStore(String filename, Password password, Map<String, T> certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        try (InputStream in = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            ks.load(in, password.value().toCharArray());
        }
        catch (EOFException e) {
            ks = TestSslUtils.createEmptyKeyStore();
        }
        for (Map.Entry<String, T> cert : certs.entrySet()) {
            ks.setCertificateEntry(cert.getKey(), (Certificate)cert.getValue());
        }
        TestSslUtils.saveKeyStore(ks, filename, password);
    }

    private static Map<String, Object> createSslConfig(Mode mode, File keyStoreFile, Password password, Password keyPassword, File trustStoreFile, Password trustStorePassword) {
        HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
        sslConfigs.put("ssl.protocol", "TLSv1.2");
        if (mode == Mode.SERVER || mode == Mode.CLIENT && keyStoreFile != null) {
            sslConfigs.put("ssl.keystore.location", keyStoreFile.getPath());
            sslConfigs.put("ssl.keystore.type", "JKS");
            sslConfigs.put("ssl.keymanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
            sslConfigs.put("ssl.keystore.password", password);
            sslConfigs.put("ssl.key.password", keyPassword);
        }
        sslConfigs.put("ssl.engine.factory.class", "org.apache.kafka.common.security.ssl.NettySslEngineFactory");
        sslConfigs.put("ssl.truststore.location", trustStoreFile.getPath());
        sslConfigs.put("ssl.truststore.password", trustStorePassword);
        sslConfigs.put("ssl.truststore.type", "JKS");
        sslConfigs.put("ssl.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        enabledProtocols.add("TLSv1.2");
        sslConfigs.put("ssl.enabled.protocols", enabledProtocols);
        return sslConfigs;
    }

    public static Map<String, Object> createSslConfig(String keyManagerAlgorithm, String trustManagerAlgorithm, String tlsProtocol) {
        HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
        sslConfigs.put("ssl.protocol", tlsProtocol);
        sslConfigs.put("ssl.keymanager.algorithm", keyManagerAlgorithm);
        sslConfigs.put("ssl.trustmanager.algorithm", trustManagerAlgorithm);
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        enabledProtocols.add(tlsProtocol);
        sslConfigs.put("ssl.enabled.protocols", enabledProtocols);
        return sslConfigs;
    }

    public static Map<String, Object> createSslConfig(boolean useClientCert, boolean trustStore, Mode mode, File trustStoreFile, String certAlias) throws IOException, GeneralSecurityException {
        return TestSslUtils.createSslConfig(useClientCert, trustStore, mode, trustStoreFile, certAlias, "localhost");
    }

    public static Map<String, Object> createSslConfig(boolean useClientCert, boolean trustStore, Mode mode, File trustStoreFile, String certAlias, String cn) throws IOException, GeneralSecurityException {
        return TestSslUtils.createSslConfig(useClientCert, trustStore, mode, trustStoreFile, certAlias, cn, new CertificateBuilder());
    }

    public static Map<String, Object> createSslConfig(boolean useClientCert, boolean createTrustStore, Mode mode, File trustStoreFile, String certAlias, String cn, CertificateBuilder certBuilder) throws IOException, GeneralSecurityException {
        SslConfigsBuilder builder = new SslConfigsBuilder(mode).useClientCert(useClientCert).certAlias(certAlias).cn(cn).certBuilder(certBuilder);
        builder = createTrustStore ? builder.createNewTrustStore(trustStoreFile) : builder.useExistingTrustStore(trustStoreFile);
        return builder.build();
    }

    public static void convertToPem(Map<String, Object> sslProps, boolean writeToFile, boolean encryptPrivateKey) throws Exception {
        String tsPath = (String)sslProps.get("ssl.truststore.location");
        String tsType = (String)sslProps.get("ssl.truststore.type");
        Password tsPassword = (Password)sslProps.remove("ssl.truststore.password");
        Password trustCerts = (Password)sslProps.remove("ssl.truststore.certificates");
        if (trustCerts == null && tsPath != null) {
            trustCerts = TestSslUtils.exportCertificates(tsPath, tsPassword, tsType);
        }
        if (trustCerts != null) {
            if (tsPath == null) {
                tsPath = TestUtils.tempFile("truststore", ".pem").getPath();
                sslProps.put("ssl.truststore.location", tsPath);
            }
            sslProps.put("ssl.truststore.type", "PEM");
            if (writeToFile) {
                TestSslUtils.writeToFile(tsPath, trustCerts);
            } else {
                sslProps.put("ssl.truststore.certificates", trustCerts);
                sslProps.remove("ssl.truststore.location");
            }
        }
        String ksPath = (String)sslProps.get("ssl.keystore.location");
        Password certChain = (Password)sslProps.remove("ssl.keystore.certificate.chain");
        Password key = (Password)sslProps.remove("ssl.keystore.key");
        if (certChain == null && ksPath != null) {
            String ksType = (String)sslProps.get("ssl.keystore.type");
            Password ksPassword = (Password)sslProps.remove("ssl.keystore.password");
            Password keyPassword = (Password)sslProps.get("ssl.key.password");
            certChain = TestSslUtils.exportCertificates(ksPath, ksPassword, ksType);
            Password pemKeyPassword = encryptPrivateKey ? keyPassword : null;
            key = TestSslUtils.exportPrivateKey(ksPath, ksPassword, keyPassword, ksType, pemKeyPassword);
            if (!encryptPrivateKey) {
                sslProps.remove("ssl.key.password");
            }
        }
        if (certChain != null) {
            if (ksPath == null) {
                ksPath = TestUtils.tempFile("keystore", ".pem").getPath();
                sslProps.put("ssl.keystore.location", ksPath);
            }
            sslProps.put("ssl.keystore.type", "PEM");
            if (writeToFile) {
                TestSslUtils.writeToFile(ksPath, key, certChain);
            } else {
                sslProps.put("ssl.keystore.key", key);
                sslProps.put("ssl.keystore.certificate.chain", certChain);
                sslProps.remove("ssl.keystore.location");
            }
        }
    }

    private static void writeToFile(String path, Password ... entries) throws IOException {
        try (FileOutputStream out = new FileOutputStream(path);){
            for (Password entry : entries) {
                out.write(entry.value().getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static void convertToPemWithoutFiles(Properties sslProps) throws Exception {
        String ksPath;
        String tsPath = sslProps.getProperty("ssl.truststore.location");
        if (tsPath != null) {
            Password trustCerts = TestSslUtils.exportCertificates(tsPath, new Password(sslProps.getProperty("ssl.truststore.password")), sslProps.getProperty("ssl.truststore.type"));
            sslProps.remove("ssl.truststore.location");
            sslProps.remove("ssl.truststore.password");
            sslProps.setProperty("ssl.truststore.type", "PEM");
            sslProps.setProperty("ssl.truststore.certificates", trustCerts.value());
        }
        if ((ksPath = sslProps.getProperty("ssl.keystore.location")) != null) {
            String ksType = sslProps.getProperty("ssl.keystore.type");
            Password ksPassword = new Password(sslProps.getProperty("ssl.keystore.password"));
            Password keyPassword = new Password(sslProps.getProperty("ssl.key.password"));
            Password certChain = TestSslUtils.exportCertificates(ksPath, ksPassword, ksType);
            Password key = TestSslUtils.exportPrivateKey(ksPath, ksPassword, keyPassword, ksType, keyPassword);
            sslProps.remove("ssl.keystore.location");
            sslProps.remove("ssl.keystore.password");
            sslProps.setProperty("ssl.keystore.type", "PEM");
            sslProps.setProperty("ssl.keystore.certificate.chain", certChain.value());
            sslProps.setProperty("ssl.keystore.key", key.value());
        }
    }

    public static Password exportCertificates(String storePath, Password storePassword, String storeType) throws Exception {
        StringBuilder builder = new StringBuilder();
        try (FileInputStream in = new FileInputStream(storePath);){
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(in, storePassword.value().toCharArray());
            Enumeration<String> aliases = ks.aliases();
            if (!aliases.hasMoreElements()) {
                throw new IllegalArgumentException("No certificates found in file " + storePath);
            }
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate[] certs = ks.getCertificateChain(alias);
                if (certs != null) {
                    for (Certificate cert : certs) {
                        builder.append(TestSslUtils.pem(cert));
                    }
                    continue;
                }
                builder.append(TestSslUtils.pem(ks.getCertificate(alias)));
            }
        }
        return new Password(builder.toString());
    }

    public static Password exportPrivateKey(String storePath, Password storePassword, Password keyPassword, String storeType, Password pemKeyPassword) throws Exception {
        try (FileInputStream in = new FileInputStream(storePath);){
            KeyStore ks = KeyStore.getInstance(storeType);
            ks.load(in, storePassword.value().toCharArray());
            String alias = ks.aliases().nextElement();
            Password password = new Password(TestSslUtils.pem((PrivateKey)ks.getKey(alias, keyPassword.value().toCharArray()), pemKeyPassword));
            return password;
        }
    }

    static String pem(Certificate cert) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)cert));
        }
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    static String pem(PrivateKey privateKey, Password password) throws IOException {
        ByteArrayOutputStream out;
        block15: {
            out = new ByteArrayOutputStream();
            try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
                if (password == null) {
                    pemWriter.writeObject((PemObjectGenerator)new JcaPKCS8Generator(privateKey, null));
                    break block15;
                }
                JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.PBE_SHA1_3DES);
                encryptorBuilder.setPassword(password.value().toCharArray());
                try {
                    pemWriter.writeObject((PemObjectGenerator)new JcaPKCS8Generator(privateKey, encryptorBuilder.build()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public static Map<String, Object> generateConfigsWithCertificateChains(String tlsProtocol) throws Exception {
        int nrOfCerts = 10;
        KeyPair[] keyPairs = new KeyPair[nrOfCerts];
        for (int i = 0; i < nrOfCerts; ++i) {
            keyPairs[i] = TestSslUtils.generateKeyPair("RSA");
        }
        String[] hostNames = new String[150];
        for (int i = 0; i < hostNames.length; ++i) {
            hostNames[i] = "hostName" + i;
        }
        Certificate[] certs = new X509Certificate[nrOfCerts];
        int caIndex = nrOfCerts - 1;
        certs[caIndex] = TestSslUtils.generateSignedCertificate("CN=CA", keyPairs[caIndex], 365, 365, null, null, "SHA512withRSA", true, false, false, hostNames);
        for (int intermediateCertIndex = caIndex - 1; intermediateCertIndex > 0; --intermediateCertIndex) {
            certs[intermediateCertIndex] = TestSslUtils.generateSignedCertificate("CN=Intermediate CA" + intermediateCertIndex, keyPairs[intermediateCertIndex], 365, 365, certs[intermediateCertIndex + 1].getSubjectX500Principal().getName(), keyPairs[intermediateCertIndex + 1], "SHA512withRSA", true, false, false, hostNames);
        }
        certs[0] = TestSslUtils.generateSignedCertificate("CN=kafka", keyPairs[0], 1, 1, certs[1].getSubjectX500Principal().getName(), keyPairs[1], "SHA512withRSA", false, true, true, hostNames);
        File keystoreStoreFile = TestUtils.tempFile("keystore", ".jks");
        Password keyStorePassword = new Password("password");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry("issued-cert", keyPairs[0].getPrivate(), keyStorePassword.value().toCharArray(), certs);
        TestSslUtils.saveKeyStore(keyStore, keystoreStoreFile.getPath(), keyStorePassword);
        File trustStoreFile = TestUtils.tempFile("truststore", ".jks");
        Password trustStorePassword = new Password("password");
        KeyStore trustStore = KeyStore.getInstance("PKCS12");
        trustStore.load(null, null);
        for (Certificate cert : certs) {
            trustStore.setCertificateEntry(((X509Certificate)cert).getSubjectX500Principal().getName(), cert);
        }
        TestSslUtils.saveKeyStore(trustStore, trustStoreFile.getPath(), trustStorePassword);
        HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
        sslConfigs.put("ssl.protocol", tlsProtocol);
        sslConfigs.put("ssl.keystore.location", keystoreStoreFile.getPath());
        sslConfigs.put("ssl.keystore.type", "JKS");
        sslConfigs.put("ssl.keymanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        sslConfigs.put("ssl.keystore.password", keyStorePassword);
        sslConfigs.put("ssl.key.password", keyStorePassword);
        sslConfigs.put("ssl.truststore.location", trustStoreFile.getPath());
        sslConfigs.put("ssl.truststore.password", trustStorePassword);
        sslConfigs.put("ssl.truststore.type", "JKS");
        sslConfigs.put("ssl.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        enabledProtocols.add(tlsProtocol);
        sslConfigs.put("ssl.enabled.protocols", enabledProtocols);
        return sslConfigs;
    }

    public static final class TestSslEngineFactory
    implements SslEngineFactory {
        public boolean closed = false;
        DefaultSslEngineFactory defaultSslEngineFactory = new DefaultSslEngineFactory();

        public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
            return this.defaultSslEngineFactory.createClientSslEngine(peerHost, peerPort, endpointIdentification);
        }

        public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
            return this.defaultSslEngineFactory.createServerSslEngine(peerHost, peerPort);
        }

        public boolean shouldBeRebuilt(Map<String, Object> nextConfigs) {
            return this.defaultSslEngineFactory.shouldBeRebuilt(nextConfigs);
        }

        public Set<String> reconfigurableConfigs() {
            return this.defaultSslEngineFactory.reconfigurableConfigs();
        }

        public KeyStore keystore() {
            return this.defaultSslEngineFactory.keystore();
        }

        public KeyStore truststore() {
            return this.defaultSslEngineFactory.truststore();
        }

        public void close() throws IOException {
            this.defaultSslEngineFactory.close();
            this.closed = true;
        }

        public void configure(Map<String, ?> configs) {
            this.defaultSslEngineFactory.configure(configs);
        }
    }

    public static class SslConfigsBuilder {
        final Mode mode;
        String tlsProtocol;
        boolean useClientCert;
        boolean createTrustStore;
        File trustStoreFile;
        Password trustStorePassword;
        Password keyStorePassword;
        Password keyPassword;
        String certAlias;
        String cn;
        List<String> cipherSuites;
        String algorithm;
        CertificateBuilder certBuilder;
        boolean usePem;

        public SslConfigsBuilder(Mode mode) {
            this.mode = mode;
            this.tlsProtocol = DEFAULT_TLS_PROTOCOL_FOR_TESTS;
            this.trustStorePassword = new Password(TestSslUtils.TRUST_STORE_PASSWORD);
            this.keyPassword = this.keyStorePassword = mode == Mode.SERVER ? new Password("ServerPassword") : new Password("ClientPassword");
            this.certBuilder = new CertificateBuilder();
            this.cn = "localhost";
            this.certAlias = mode.name().toLowerCase(Locale.ROOT);
            this.cipherSuites = Collections.emptyList();
            this.algorithm = "RSA";
            this.createTrustStore = true;
        }

        public SslConfigsBuilder tlsProtocol(String tlsProtocol) {
            this.tlsProtocol = tlsProtocol;
            return this;
        }

        public SslConfigsBuilder createNewTrustStore(File trustStoreFile) {
            this.trustStoreFile = trustStoreFile;
            this.createTrustStore = true;
            return this;
        }

        public SslConfigsBuilder useExistingTrustStore(File trustStoreFile) {
            this.trustStoreFile = trustStoreFile;
            this.createTrustStore = false;
            return this;
        }

        public SslConfigsBuilder useClientCert(boolean useClientCert) {
            this.useClientCert = useClientCert;
            return this;
        }

        public SslConfigsBuilder certAlias(String certAlias) {
            this.certAlias = certAlias;
            return this;
        }

        public SslConfigsBuilder cn(String cn) {
            this.cn = cn;
            return this;
        }

        public SslConfigsBuilder cipherSuites(List<String> cipherSuites) {
            this.cipherSuites = cipherSuites;
            return this;
        }

        public SslConfigsBuilder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public SslConfigsBuilder certBuilder(CertificateBuilder certBuilder) {
            this.certBuilder = certBuilder;
            return this;
        }

        public SslConfigsBuilder usePem(boolean usePem) {
            this.usePem = usePem;
            return this;
        }

        public Map<String, Object> build() throws IOException, GeneralSecurityException {
            if (this.usePem) {
                return this.buildPem();
            }
            return this.buildJks();
        }

        public Map<String, String> buildProperties() throws IOException, GeneralSecurityException {
            if (this.usePem) {
                return this.buildPemProperties();
            }
            return this.buildJksProperties();
        }

        private Map<String, Object> buildJks() throws IOException, GeneralSecurityException {
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            File keyStoreFile = null;
            if (this.mode == Mode.CLIENT && this.useClientCert) {
                keyStoreFile = TestUtils.tempFile("clientKS", ".jks");
                KeyPair cKP = TestSslUtils.generateKeyPair(this.algorithm);
                X509Certificate cCert = this.certBuilder.generate("CN=" + this.cn + ", O=A client", cKP);
                TestSslUtils.createKeyStore(keyStoreFile.getPath(), this.keyStorePassword, this.keyPassword, "client", cKP.getPrivate(), cCert);
                certs.put(this.certAlias, cCert);
            } else if (this.mode == Mode.SERVER) {
                keyStoreFile = TestUtils.tempFile("serverKS", ".jks");
                KeyPair sKP = TestSslUtils.generateKeyPair(this.algorithm);
                X509Certificate sCert = this.certBuilder.generate("CN=" + this.cn + ", O=A server", sKP);
                TestSslUtils.createKeyStore(keyStoreFile.getPath(), this.keyStorePassword, this.keyPassword, "server", sKP.getPrivate(), sCert);
                certs.put(this.certAlias, sCert);
                keyStoreFile.deleteOnExit();
            }
            if (this.createTrustStore) {
                TestSslUtils.createTrustStore(this.trustStoreFile.getPath(), this.trustStorePassword, certs);
                this.trustStoreFile.deleteOnExit();
            }
            HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
            sslConfigs.put("ssl.protocol", this.tlsProtocol);
            if (this.mode == Mode.SERVER || this.mode == Mode.CLIENT && keyStoreFile != null) {
                sslConfigs.put("ssl.keystore.location", keyStoreFile.getPath());
                sslConfigs.put("ssl.keystore.type", "JKS");
                sslConfigs.put("ssl.keymanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
                sslConfigs.put("ssl.keystore.password", this.keyStorePassword);
                sslConfigs.put("ssl.key.password", this.keyPassword);
            }
            sslConfigs.put("ssl.truststore.location", this.trustStoreFile.getPath());
            sslConfigs.put("ssl.truststore.password", this.trustStorePassword);
            sslConfigs.put("ssl.truststore.type", "JKS");
            sslConfigs.put("ssl.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            enabledProtocols.add(this.tlsProtocol);
            sslConfigs.put("ssl.enabled.protocols", enabledProtocols);
            sslConfigs.put("ssl.cipher.suites", this.cipherSuites);
            return sslConfigs;
        }

        private Map<String, String> buildJksProperties() throws IOException, GeneralSecurityException {
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            File keyStoreFile = null;
            if (this.mode == Mode.CLIENT && this.useClientCert) {
                keyStoreFile = File.createTempFile("clientKS", ".jks");
                KeyPair cKP = TestSslUtils.generateKeyPair(this.algorithm);
                X509Certificate cCert = this.certBuilder.generate("CN=" + this.cn + ", O=A client", cKP);
                TestSslUtils.createKeyStore(keyStoreFile.getPath(), this.keyStorePassword, this.keyPassword, "client", cKP.getPrivate(), cCert);
                certs.put(this.certAlias, cCert);
            } else if (this.mode == Mode.SERVER) {
                keyStoreFile = File.createTempFile("serverKS", ".jks");
                KeyPair sKP = TestSslUtils.generateKeyPair(this.algorithm);
                X509Certificate sCert = this.certBuilder.generate("CN=" + this.cn + ", O=A server", sKP);
                TestSslUtils.createKeyStore(keyStoreFile.getPath(), this.keyStorePassword, this.keyPassword, "server", sKP.getPrivate(), sCert);
                certs.put(this.certAlias, sCert);
                keyStoreFile.deleteOnExit();
            }
            if (this.createTrustStore) {
                TestSslUtils.createTrustStore(this.trustStoreFile.getPath(), this.trustStorePassword, certs);
                this.trustStoreFile.deleteOnExit();
            }
            HashMap<String, String> sslConfigs = new HashMap<String, String>();
            sslConfigs.put("ssl.protocol", this.tlsProtocol);
            if (this.mode == Mode.SERVER || this.mode == Mode.CLIENT && keyStoreFile != null) {
                sslConfigs.put("ssl.keystore.location", keyStoreFile.getPath());
                sslConfigs.put("ssl.keystore.type", "JKS");
                sslConfigs.put("ssl.keymanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
                sslConfigs.put("ssl.keystore.password", this.keyStorePassword.value());
                sslConfigs.put("ssl.key.password", this.keyPassword.value());
            }
            sslConfigs.put("ssl.truststore.location", this.trustStoreFile.getPath());
            sslConfigs.put("ssl.truststore.password", this.trustStorePassword.value());
            sslConfigs.put("ssl.truststore.type", "JKS");
            sslConfigs.put("ssl.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            enabledProtocols.add(this.tlsProtocol);
            sslConfigs.put("ssl.enabled.protocols", String.join((CharSequence)",", enabledProtocols));
            sslConfigs.put("ssl.cipher.suites", String.join((CharSequence)",", this.cipherSuites));
            return sslConfigs;
        }

        private Map<String, Object> buildPem() throws IOException, GeneralSecurityException {
            if (!this.createTrustStore) {
                throw new IllegalArgumentException("PEM configs cannot be created with existing trust stores");
            }
            HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
            sslConfigs.put("ssl.protocol", this.tlsProtocol);
            sslConfigs.put("ssl.enabled.protocols", Collections.singletonList(this.tlsProtocol));
            if (this.mode != Mode.CLIENT || this.useClientCert) {
                KeyPair keyPair = TestSslUtils.generateKeyPair(this.algorithm);
                X509Certificate cert = this.certBuilder.generate("CN=" + this.cn + ", O=A " + this.mode.name().toLowerCase(Locale.ROOT), keyPair);
                Password privateKeyPem = new Password(TestSslUtils.pem(keyPair.getPrivate(), this.keyPassword));
                Password certPem = new Password(TestSslUtils.pem(cert));
                sslConfigs.put("ssl.keystore.type", "PEM");
                sslConfigs.put("ssl.truststore.type", "PEM");
                sslConfigs.put("ssl.keystore.key", privateKeyPem);
                sslConfigs.put("ssl.keystore.certificate.chain", certPem);
                sslConfigs.put("ssl.key.password", this.keyPassword);
                sslConfigs.put("ssl.truststore.certificates", certPem);
            }
            return sslConfigs;
        }

        private Map<String, String> buildPemProperties() throws IOException, GeneralSecurityException {
            if (!this.createTrustStore) {
                throw new IllegalArgumentException("PEM configs cannot be created with existing trust stores");
            }
            HashMap<String, String> sslConfigs = new HashMap<String, String>();
            sslConfigs.put("ssl.protocol", this.tlsProtocol);
            sslConfigs.put("ssl.enabled.protocols", String.join((CharSequence)",", Collections.singletonList(this.tlsProtocol)));
            if (this.mode != Mode.CLIENT || this.useClientCert) {
                KeyPair keyPair = TestSslUtils.generateKeyPair(this.algorithm);
                X509Certificate cert = this.certBuilder.generate("CN=" + this.cn + ", O=A " + this.mode.name().toLowerCase(Locale.ROOT), keyPair);
                String certPem = TestSslUtils.pem(cert);
                sslConfigs.put("ssl.keystore.type", "PEM");
                sslConfigs.put("ssl.truststore.type", "PEM");
                sslConfigs.put("ssl.keystore.key", TestSslUtils.pem(keyPair.getPrivate(), this.keyPassword));
                sslConfigs.put("ssl.keystore.certificate.chain", certPem);
                sslConfigs.put("ssl.key.password", this.keyPassword.value());
                sslConfigs.put("ssl.truststore.certificates", certPem);
            }
            return sslConfigs;
        }
    }

    public static class CertificateBuilder {
        private final int days;
        private final String algorithm;
        private byte[] subjectAltName;

        public CertificateBuilder() {
            this(30, "SHA1withRSA");
        }

        public CertificateBuilder(int days, String algorithm) {
            this.days = days;
            this.algorithm = algorithm;
        }

        public CertificateBuilder sanDnsNames(String ... hostNames) throws IOException {
            if (hostNames.length > 0) {
                GeneralName[] altNames = new GeneralName[hostNames.length];
                for (int i = 0; i < hostNames.length; ++i) {
                    altNames[i] = new GeneralName(2, hostNames[i]);
                }
                this.subjectAltName = GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable[])altNames)).getEncoded();
            } else {
                this.subjectAltName = null;
            }
            return this;
        }

        public CertificateBuilder sanIpAddress(InetAddress hostAddress) throws IOException {
            this.subjectAltName = new GeneralNames(new GeneralName(7, (ASN1Encodable)new DEROctetString(hostAddress.getAddress()))).getEncoded();
            return this;
        }

        public X509Certificate generate(String dn, KeyPair keyPair) throws CertificateException {
            return this.generate(new X500Name(dn), keyPair);
        }

        public X509Certificate generate(String commonName, String org, boolean utf8, KeyPair keyPair) throws CertificateException {
            RDN[] rdns = new RDN[]{new RDN(new AttributeTypeAndValue(BCStyle.CN, (ASN1Encodable)(utf8 ? new DERUTF8String(commonName) : new DERT61String(commonName)))), new RDN(new AttributeTypeAndValue(BCStyle.O, (ASN1Encodable)(utf8 ? new DERUTF8String(org) : new DERT61String(org))))};
            return this.generate(new X500Name(rdns), keyPair);
        }

        public X509Certificate generate(X500Name dn, KeyPair keyPair) throws CertificateException {
            try {
                BcRSAContentSignerBuilder signerBuilder;
                Security.addProvider((Provider)new BouncyCastleProvider());
                AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.algorithm);
                AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
                AsymmetricKeyParameter privateKeyAsymKeyParam = PrivateKeyFactory.createKey((byte[])keyPair.getPrivate().getEncoded());
                SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
                String keyAlgorithm = keyPair.getPublic().getAlgorithm();
                if (keyAlgorithm.equals("RSA")) {
                    signerBuilder = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
                } else if (keyAlgorithm.equals("DSA")) {
                    signerBuilder = new BcDSAContentSignerBuilder(sigAlgId, digAlgId);
                } else if (keyAlgorithm.equals("EC")) {
                    signerBuilder = new BcECContentSignerBuilder(sigAlgId, digAlgId);
                } else {
                    throw new IllegalArgumentException("Unsupported algorithm " + keyAlgorithm);
                }
                ContentSigner sigGen = signerBuilder.build(privateKeyAsymKeyParam);
                Date now = new Date();
                Date from = this.days >= 0 ? now : new Date(now.getTime() + (long)this.days * 86400000L);
                Date to = this.days >= 0 ? new Date(now.getTime() + (long)this.days * 86400000L) : now;
                BigInteger sn = new BigInteger(64, new SecureRandom());
                X509v3CertificateBuilder v3CertGen = new X509v3CertificateBuilder(dn, sn, from, to, dn, subPubKeyInfo);
                if (this.subjectAltName != null) {
                    v3CertGen.addExtension(Extension.subjectAlternativeName, false, this.subjectAltName);
                }
                X509CertificateHolder certificateHolder = v3CertGen.build(sigGen);
                return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
            }
            catch (CertificateException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CertificateException(e);
            }
        }

        public X509Certificate generateSignedCertificate(String dn, KeyPair keyPair, int daysBeforeNow, int daysAfterNow, String issuer, KeyPair parentKeyPair, boolean isCA, boolean isServerCert, boolean isClientCert) throws CertificateException {
            X500Name issuerOrDn = issuer != null ? new X500Name(issuer) : new X500Name(dn);
            return this.generateSignedCertificate(new X500Name(dn), keyPair, daysBeforeNow, daysAfterNow, issuerOrDn, parentKeyPair, isCA, isServerCert, isClientCert);
        }

        public X509Certificate generateSignedCertificate(X500Name dn, KeyPair keyPair, int daysBeforeNow, int daysAfterNow, X500Name issuer, KeyPair parentKeyPair, boolean isCA, boolean isServerCert, boolean isClientCert) throws CertificateException {
            try {
                BcRSAContentSignerBuilder signerBuilder;
                Security.addProvider((Provider)new BouncyCastleProvider());
                AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(this.algorithm);
                AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
                KeyPair signingKeyPair = parentKeyPair != null ? parentKeyPair : keyPair;
                AsymmetricKeyParameter privateKeyAsymKeyParam = PrivateKeyFactory.createKey((byte[])signingKeyPair.getPrivate().getEncoded());
                SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
                String keyAlgorithm = keyPair.getPublic().getAlgorithm();
                if (keyAlgorithm.equals("RSA")) {
                    signerBuilder = new BcRSAContentSignerBuilder(sigAlgId, digAlgId);
                } else if (keyAlgorithm.equals("DSA")) {
                    signerBuilder = new BcDSAContentSignerBuilder(sigAlgId, digAlgId);
                } else if (keyAlgorithm.equals("EC")) {
                    signerBuilder = new BcECContentSignerBuilder(sigAlgId, digAlgId);
                } else {
                    throw new IllegalArgumentException("Unsupported algorithm " + keyAlgorithm);
                }
                ContentSigner sigGen = signerBuilder.build(privateKeyAsymKeyParam);
                Date now = new Date();
                Date from = new Date(now.getTime() - (long)daysBeforeNow * 86400000L);
                Date to = new Date(now.getTime() + (long)daysAfterNow * 86400000L);
                BigInteger sn = new BigInteger(64, new SecureRandom());
                X500Name issuerOrDn = issuer != null ? issuer : dn;
                X509v3CertificateBuilder v3CertGen = new X509v3CertificateBuilder(issuerOrDn, sn, from, to, dn, subPubKeyInfo);
                if (isCA) {
                    v3CertGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isCA));
                }
                if (isServerCert || isClientCert) {
                    ASN1EncodableVector purposes = new ASN1EncodableVector();
                    if (isServerCert) {
                        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
                    }
                    if (isClientCert) {
                        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
                    }
                    v3CertGen.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
                }
                if (this.subjectAltName != null) {
                    v3CertGen.addExtension(Extension.subjectAlternativeName, false, this.subjectAltName);
                }
                X509CertificateHolder certificateHolder = v3CertGen.build(sigGen);
                return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
            }
            catch (CertificateException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CertificateException(e);
            }
        }
    }
}

