/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.ZoneAlignment;
import io.confluent.kafka.multitenant.ZoneUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZoneUtilsTest {
    @Test
    public void testGetValidBrokerRackSet() {
        Assertions.assertEquals(ZoneUtilsTest.brokerRackSet("a", "b", "c", "d"), (Object)ZoneUtils.getValidBrokerRackSet((String)"a,b,c,d"));
        Assertions.assertEquals(ZoneUtilsTest.brokerRackSet("a", "b", "c", "d"), (Object)ZoneUtils.getValidBrokerRackSet((String)" a,b,c,d "));
        Assertions.assertEquals(ZoneUtilsTest.brokerRackSet(new String[0]), (Object)ZoneUtils.getValidBrokerRackSet((String)""));
        Assertions.assertEquals(ZoneUtilsTest.brokerRackSet(new String[0]), (Object)ZoneUtils.getValidBrokerRackSet((String)" "));
        Assertions.assertEquals(ZoneUtilsTest.brokerRackSet(new String[0]), (Object)ZoneUtils.getValidBrokerRackSet(null));
    }

    @Test
    public void testValidateZoneAlignment() {
        Set<String> rackSet = ZoneUtilsTest.brokerRackSet("a", "b", "c");
        Assertions.assertEquals((Object)ZoneAlignment.UNKNOWN, (Object)ZoneUtils.validateZoneAlignment(ZoneUtilsTest.brokerRackSet(new String[]{null}), null, null));
        Assertions.assertEquals((Object)ZoneAlignment.UNKNOWN, (Object)ZoneUtils.validateZoneAlignment(ZoneUtilsTest.brokerRackSet(new String[0]), null, null));
        Assertions.assertEquals((Object)ZoneAlignment.UNKNOWN, (Object)ZoneUtils.validateZoneAlignment(rackSet, (String)"a", (String)"d"));
        Assertions.assertEquals((Object)ZoneAlignment.SAME_ZONE, (Object)ZoneUtils.validateZoneAlignment(rackSet, (String)"a", (String)"a"));
        Assertions.assertEquals((Object)ZoneAlignment.CROSS_ZONE, (Object)ZoneUtils.validateZoneAlignment(rackSet, (String)"a", (String)"c"));
    }

    private static Set<String> brokerRackSet(String ... racks) {
        return Stream.of(racks).collect(Collectors.toSet());
    }
}

