/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.HashSet;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class MetadataVersionTest {
    MetadataVersionTest() {
    }

    @Test
    public void testKRaftFeatureLevelsBefore3_0_IV1() {
        for (int i = 0; i < MetadataVersion.IBP_3_0_IV1.ordinal(); ++i) {
            Assertions.assertEquals((int)-1, (int)MetadataVersion.VERSIONS[i].apacheFeatureLevel());
            Assertions.assertEquals((int)-1, (int)MetadataVersion.VERSIONS[i].confluentFeatureLevel());
        }
    }

    @Test
    public void testKRaftFeatureLevelsAtAndAfter3_0_IV1() {
        short lastApacheFeatureLevelSeen = -1;
        for (int i = MetadataVersion.IBP_3_0_IV1.ordinal(); i < MetadataVersion.VERSIONS.length; ++i) {
            short thisApacheFeatureLevel;
            short minApacheFeatureLevel = lastApacheFeatureLevelSeen;
            if (minApacheFeatureLevel < 0) {
                minApacheFeatureLevel = i - MetadataVersion.IBP_3_0_IV1.ordinal() + 1;
            }
            Assertions.assertTrue(((thisApacheFeatureLevel = MetadataVersion.VERSIONS[i].apacheFeatureLevel()) == minApacheFeatureLevel || thisApacheFeatureLevel == minApacheFeatureLevel + 1 ? 1 : 0) != 0);
            lastApacheFeatureLevelSeen = thisApacheFeatureLevel;
            int expectedConfluentLevel = 100 + i - MetadataVersion.IBP_3_0_IV1.ordinal() + 1;
            Assertions.assertEquals((int)expectedConfluentLevel, (int)MetadataVersion.VERSIONS[i].confluentFeatureLevel());
        }
    }

    @Test
    public void testFromVersionString() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.fromVersionString((String)"0.8.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.fromVersionString((String)"0.8.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.fromVersionString((String)"0.8.0.1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"8.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_1, (Object)MetadataVersion.fromVersionString((String)"0.8.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_1, (Object)MetadataVersion.fromVersionString((String)"0.8.1.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_1, (Object)MetadataVersion.fromVersionString((String)"0.8.1.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_2, (Object)MetadataVersion.fromVersionString((String)"0.8.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_2, (Object)MetadataVersion.fromVersionString((String)"0.8.2.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_2, (Object)MetadataVersion.fromVersionString((String)"0.8.2.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_9_0, (Object)MetadataVersion.fromVersionString((String)"0.9.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_9_0, (Object)MetadataVersion.fromVersionString((String)"0.9.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_9_0, (Object)MetadataVersion.fromVersionString((String)"0.9.0.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.1-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV0, (Object)MetadataVersion.fromVersionString((String)"0.11.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.11.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0.1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0.0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0-IV0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_1_IV0, (Object)MetadataVersion.fromVersionString((String)"1.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV1, (Object)MetadataVersion.fromVersionString((String)"2.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV0, (Object)MetadataVersion.fromVersionString((String)"2.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV1, (Object)MetadataVersion.fromVersionString((String)"2.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV2, (Object)MetadataVersion.fromVersionString((String)"2.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV0, (Object)MetadataVersion.fromVersionString((String)"2.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV1, (Object)MetadataVersion.fromVersionString((String)"2.1-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV2, (Object)MetadataVersion.fromVersionString((String)"2.1-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV1, (Object)MetadataVersion.fromVersionString((String)"2.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV0, (Object)MetadataVersion.fromVersionString((String)"2.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV1, (Object)MetadataVersion.fromVersionString((String)"2.2-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV1, (Object)MetadataVersion.fromVersionString((String)"2.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV0, (Object)MetadataVersion.fromVersionString((String)"2.3-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV1, (Object)MetadataVersion.fromVersionString((String)"2.3-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV1, (Object)MetadataVersion.fromVersionString((String)"2.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV0, (Object)MetadataVersion.fromVersionString((String)"2.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV1, (Object)MetadataVersion.fromVersionString((String)"2.4-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_5_IV0, (Object)MetadataVersion.fromVersionString((String)"2.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_5_IV0, (Object)MetadataVersion.fromVersionString((String)"2.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_6_IV0, (Object)MetadataVersion.fromVersionString((String)"2.6"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_6_IV0, (Object)MetadataVersion.fromVersionString((String)"2.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV0, (Object)MetadataVersion.fromVersionString((String)"2.7-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV1, (Object)MetadataVersion.fromVersionString((String)"2.7-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV2, (Object)MetadataVersion.fromVersionString((String)"2.7-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV1, (Object)MetadataVersion.fromVersionString((String)"2.8"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV0, (Object)MetadataVersion.fromVersionString((String)"2.8-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV1, (Object)MetadataVersion.fromVersionString((String)"2.8-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromVersionString((String)"3.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV0, (Object)MetadataVersion.fromVersionString((String)"3.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromVersionString((String)"3.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromVersionString((String)"3.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromVersionString((String)"3.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromVersionString((String)"3.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromVersionString((String)"3.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.fromVersionString((String)"3.3-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV1, (Object)MetadataVersion.fromVersionString((String)"3.3-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV2, (Object)MetadataVersion.fromVersionString((String)"3.3-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"3.3-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromVersionString((String)"3.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV1, (Object)MetadataVersion.fromVersionString((String)"3.5-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV0, (Object)MetadataVersion.fromVersionString((String)"3.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV1, (Object)MetadataVersion.fromVersionString((String)"3.6-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6-IV2"));
    }

    @Test
    public void testFromConfluentVersionString() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_2, (Object)MetadataVersion.fromVersionString((String)"CP-1.0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"CP-1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_9_0, (Object)MetadataVersion.fromVersionString((String)"CP-2.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-3.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-3.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-3.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-3.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-3.1-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-3.1-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-3.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-3.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-3.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-3.3-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-3.3-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-3.3-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-3.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-4.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-4.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_1_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-4.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_1_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-4.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-5.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-5.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.1-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-5.1-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-5.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-5.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.2-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-5.3-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.3-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-5.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.4-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-5.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_5_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-5.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_5_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-5.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_6_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-6.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_6_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-6.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-6.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-6.1-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-6.1-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-6.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-6.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-6.2-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-6.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.3-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.3-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.3-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"CP-7.3-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"CP-7.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.5-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.5-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV0, (Object)MetadataVersion.fromVersionString((String)"CP-7.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV1, (Object)MetadataVersion.fromVersionString((String)"CP-7.6-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.6-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"CP-7.6"));
    }

    @Test
    public void testFromConfluentFeatureLevel() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromConfluentFeatureLevel((short)7));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV2, (Object)MetadataVersion.fromConfluentFeatureLevel((short)6));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV1, (Object)MetadataVersion.fromConfluentFeatureLevel((short)5));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)4));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)3));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)2));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromConfluentFeatureLevel((short)1));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)109));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)108));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromConfluentFeatureLevel((short)107));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV2, (Object)MetadataVersion.fromConfluentFeatureLevel((short)106));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV1, (Object)MetadataVersion.fromConfluentFeatureLevel((short)105));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)104));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)103));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromConfluentFeatureLevel((short)102));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromConfluentFeatureLevel((short)101));
        for (int i = 8; i <= 100; ++i) {
            short confluentFeatureLevelThatShouldNotWork = (short)i;
            Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromConfluentFeatureLevel((short)confluentFeatureLevelThatShouldNotWork));
        }
    }

    @Test
    public void testMinSupportedVersionFor() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.minSupportedFor((RecordVersion)RecordVersion.V0));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV0, (Object)MetadataVersion.minSupportedFor((RecordVersion)RecordVersion.V1));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV0, (Object)MetadataVersion.minSupportedFor((RecordVersion)RecordVersion.V2));
        for (RecordVersion recordVersion : RecordVersion.values()) {
            Assertions.assertNotNull((Object)MetadataVersion.minSupportedFor((RecordVersion)recordVersion));
        }
    }

    @Test
    public void testShortVersion() {
        Assertions.assertEquals((Object)"0.8.0", (Object)MetadataVersion.IBP_0_8_0.shortVersion());
        Assertions.assertEquals((Object)"0.10.0", (Object)MetadataVersion.IBP_0_10_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"0.10.0", (Object)MetadataVersion.IBP_0_10_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)MetadataVersion.IBP_0_11_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)MetadataVersion.IBP_0_11_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)MetadataVersion.IBP_0_11_0_IV2.shortVersion());
        Assertions.assertEquals((Object)"1.0", (Object)MetadataVersion.IBP_1_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"1.1", (Object)MetadataVersion.IBP_1_1_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.0", (Object)MetadataVersion.IBP_2_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.0", (Object)MetadataVersion.IBP_2_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)MetadataVersion.IBP_2_1_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)MetadataVersion.IBP_2_1_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)MetadataVersion.IBP_2_1_IV2.shortVersion());
        Assertions.assertEquals((Object)"2.2", (Object)MetadataVersion.IBP_2_2_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.2", (Object)MetadataVersion.IBP_2_2_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.3", (Object)MetadataVersion.IBP_2_3_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.3", (Object)MetadataVersion.IBP_2_3_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.4", (Object)MetadataVersion.IBP_2_4_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.5", (Object)MetadataVersion.IBP_2_5_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.6", (Object)MetadataVersion.IBP_2_6_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.7", (Object)MetadataVersion.IBP_2_7_IV2.shortVersion());
        Assertions.assertEquals((Object)"2.8", (Object)MetadataVersion.IBP_2_8_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.8", (Object)MetadataVersion.IBP_2_8_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.0", (Object)MetadataVersion.IBP_3_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.0", (Object)MetadataVersion.IBP_3_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.1", (Object)MetadataVersion.IBP_3_1_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.2", (Object)MetadataVersion.IBP_3_2_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV3.shortVersion());
        Assertions.assertEquals((Object)"3.4", (Object)MetadataVersion.IBP_3_4_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV2.shortVersion());
    }

    @Test
    public void testVersion() {
        Assertions.assertEquals((Object)"0.8.0", (Object)MetadataVersion.IBP_0_8_0.version());
        Assertions.assertEquals((Object)"0.8.2", (Object)MetadataVersion.IBP_0_8_2.version());
        Assertions.assertEquals((Object)"0.10.0-IV0", (Object)MetadataVersion.IBP_0_10_0_IV0.version());
        Assertions.assertEquals((Object)"0.10.0-IV1", (Object)MetadataVersion.IBP_0_10_0_IV1.version());
        Assertions.assertEquals((Object)"0.11.0-IV0", (Object)MetadataVersion.IBP_0_11_0_IV0.version());
        Assertions.assertEquals((Object)"0.11.0-IV1", (Object)MetadataVersion.IBP_0_11_0_IV1.version());
        Assertions.assertEquals((Object)"0.11.0-IV2", (Object)MetadataVersion.IBP_0_11_0_IV2.version());
        Assertions.assertEquals((Object)"1.0-IV0", (Object)MetadataVersion.IBP_1_0_IV0.version());
        Assertions.assertEquals((Object)"1.1-IV0", (Object)MetadataVersion.IBP_1_1_IV0.version());
        Assertions.assertEquals((Object)"2.0-IV0", (Object)MetadataVersion.IBP_2_0_IV0.version());
        Assertions.assertEquals((Object)"2.0-IV1", (Object)MetadataVersion.IBP_2_0_IV1.version());
        Assertions.assertEquals((Object)"2.1-IV0", (Object)MetadataVersion.IBP_2_1_IV0.version());
        Assertions.assertEquals((Object)"2.1-IV1", (Object)MetadataVersion.IBP_2_1_IV1.version());
        Assertions.assertEquals((Object)"2.1-IV2", (Object)MetadataVersion.IBP_2_1_IV2.version());
        Assertions.assertEquals((Object)"2.2-IV0", (Object)MetadataVersion.IBP_2_2_IV0.version());
        Assertions.assertEquals((Object)"2.2-IV1", (Object)MetadataVersion.IBP_2_2_IV1.version());
        Assertions.assertEquals((Object)"2.3-IV0", (Object)MetadataVersion.IBP_2_3_IV0.version());
        Assertions.assertEquals((Object)"2.3-IV1", (Object)MetadataVersion.IBP_2_3_IV1.version());
        Assertions.assertEquals((Object)"2.4-IV0", (Object)MetadataVersion.IBP_2_4_IV0.version());
        Assertions.assertEquals((Object)"2.5-IV0", (Object)MetadataVersion.IBP_2_5_IV0.version());
        Assertions.assertEquals((Object)"2.6-IV0", (Object)MetadataVersion.IBP_2_6_IV0.version());
        Assertions.assertEquals((Object)"2.7-IV2", (Object)MetadataVersion.IBP_2_7_IV2.version());
        Assertions.assertEquals((Object)"2.8-IV0", (Object)MetadataVersion.IBP_2_8_IV0.version());
        Assertions.assertEquals((Object)"2.8-IV1", (Object)MetadataVersion.IBP_2_8_IV1.version());
        Assertions.assertEquals((Object)"3.0-IV0", (Object)MetadataVersion.IBP_3_0_IV0.version());
        Assertions.assertEquals((Object)"3.0-IV1", (Object)MetadataVersion.IBP_3_0_IV1.version());
        Assertions.assertEquals((Object)"3.1-IV0", (Object)MetadataVersion.IBP_3_1_IV0.version());
        Assertions.assertEquals((Object)"3.2-IV0", (Object)MetadataVersion.IBP_3_2_IV0.version());
        Assertions.assertEquals((Object)"3.3-IV0", (Object)MetadataVersion.IBP_3_3_IV0.version());
        Assertions.assertEquals((Object)"3.3-IV1", (Object)MetadataVersion.IBP_3_3_IV1.version());
        Assertions.assertEquals((Object)"3.3-IV2", (Object)MetadataVersion.IBP_3_3_IV2.version());
        Assertions.assertEquals((Object)"3.3-IV3", (Object)MetadataVersion.IBP_3_3_IV3.version());
        Assertions.assertEquals((Object)"3.4-IV0", (Object)MetadataVersion.IBP_3_4_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV0", (Object)MetadataVersion.IBP_3_5_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV1", (Object)MetadataVersion.IBP_3_5_IV1.version());
        Assertions.assertEquals((Object)"3.5-IV2", (Object)MetadataVersion.IBP_3_5_IV2.version());
        Assertions.assertEquals((Object)"3.6-IV0", (Object)MetadataVersion.IBP_3_6_IV0.version());
        Assertions.assertEquals((Object)"3.6-IV1", (Object)MetadataVersion.IBP_3_6_IV1.version());
        Assertions.assertEquals((Object)"3.6-IV2", (Object)MetadataVersion.IBP_3_6_IV2.version());
    }

    @Test
    public void testPrevious() {
        for (int i = 1; i < MetadataVersion.VERSIONS.length - 2; ++i) {
            MetadataVersion version = MetadataVersion.VERSIONS[i];
            Assertions.assertTrue((boolean)version.previous().isPresent(), (String)version.toString());
            Assertions.assertEquals((Object)MetadataVersion.VERSIONS[i - 1], version.previous().get());
        }
    }

    @Test
    public void testMetadataChanged() {
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_2_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_1_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_0_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_0_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_2_8_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_3_IV1, (MetadataVersion)MetadataVersion.IBP_3_3_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_3_IV2, (MetadataVersion)MetadataVersion.IBP_3_3_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_3_IV3, (MetadataVersion)MetadataVersion.IBP_3_3_IV2));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_4_IV0, (MetadataVersion)MetadataVersion.IBP_3_3_IV3));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_5_IV0, (MetadataVersion)MetadataVersion.IBP_3_4_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_0_IV0, (MetadataVersion)MetadataVersion.IBP_3_2_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_2_8_IV1, (MetadataVersion)MetadataVersion.IBP_3_2_IV0));
    }

    @Test
    public void testKRaftVersions() {
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            if (metadataVersion.isKRaftSupported()) {
                Assertions.assertTrue((metadataVersion.confluentFeatureLevel() > 0 ? 1 : 0) != 0);
                Assertions.assertTrue((metadataVersion.apacheFeatureLevel() > 0 ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertEquals((int)-1, (int)metadataVersion.confluentFeatureLevel());
            Assertions.assertEquals((int)-1, (int)metadataVersion.apacheFeatureLevel());
        }
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            if (metadataVersion.isAtLeast(MetadataVersion.IBP_3_0_IV1)) {
                Assertions.assertTrue((boolean)metadataVersion.isKRaftSupported(), (String)metadataVersion.toString());
                continue;
            }
            Assertions.assertFalse((boolean)metadataVersion.isKRaftSupported());
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsInControlledShutdownStateSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV3), (Object)metadataVersion.isInControlledShutdownStateSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testTopicPlacementVersion(MetadataVersion metadataVersion) {
        if (metadataVersion.isLessThan(MetadataVersion.IBP_3_5_IV0)) {
            Assertions.assertFalse((boolean)metadataVersion.isTopicPlacementSupported());
        } else {
            Assertions.assertTrue((boolean)metadataVersion.isTopicPlacementSupported());
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsDelegationTokenSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_6_IV2), (Object)metadataVersion.isDelegationTokenSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV3) ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.registerBrokerRecordVersion());
    }

    @Test
    public void testConfluentMetadataVersion() {
        HashSet<Short> confluentFeatureLevels = new HashSet<Short>();
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            if (!metadataVersion.isKRaftSupported()) continue;
            Assertions.assertTrue((metadataVersion.confluentFeatureLevel() >= metadataVersion.apacheFeatureLevel() ? 1 : 0) != 0, (String)"Each Confluent metadata version should be at least as high as the equivalent Apache feature level");
            Assertions.assertFalse((boolean)confluentFeatureLevels.contains(metadataVersion.confluentFeatureLevel()), (String)"Confluent feature levels versions must be unique");
            confluentFeatureLevels.add(metadataVersion.confluentFeatureLevel());
            short apacheLevel = metadataVersion.apacheFeatureLevel();
            Assertions.assertTrue((boolean)metadataVersion.isAtLeast(MetadataVersion.fromApacheFeatureLevel((short)apacheLevel)), (String)"Each apache version should correspond to an internal version that at least as high as it");
            Assertions.assertEquals((short)apacheLevel, (short)MetadataVersion.fromApacheFeatureLevel((short)apacheLevel).apacheFeatureLevel());
        }
    }

    @Test
    public void testMonotonicVersions() {
        int lastConfluentLevel = 100;
        short lastApacheLevel = 0;
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            if (!metadataVersion.isKRaftSupported()) continue;
            Assertions.assertEquals((int)(lastConfluentLevel + 1), (int)metadataVersion.confluentFeatureLevel());
            Assertions.assertTrue((metadataVersion.apacheFeatureLevel() >= lastApacheLevel ? 1 : 0) != 0);
            lastConfluentLevel = metadataVersion.confluentFeatureLevel();
            lastApacheLevel = metadataVersion.apacheFeatureLevel();
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testGroupMetadataValueVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_2_3_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_1_IV0) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_1_IV0) ? (short)1 : 0));
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.groupMetadataValueVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testOffsetCommitValueVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_2_1_IV1) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_1_IV0) ? (short)2 : 1);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.offsetCommitValueVersion(false));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testOffsetCommitValueVersionWithExpiredTimestamp(MetadataVersion metadataVersion) {
        Assertions.assertEquals((short)1, (short)metadataVersion.offsetCommitValueVersion(true));
    }
}

