/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.http;

import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.credential.HttpBearerCredential;
import io.confluent.security.authentication.credential.HttpCredential;
import io.confluent.security.authentication.http.HttpAuthenticator;
import io.confluent.security.authentication.oauthbearer.JwtPrincipal;

public final class HttpAuthenticatorJwt
extends HttpAuthenticator<JwtPrincipal> {
    private final Authenticator<BearerCredential, JwtPrincipal> authenticator;

    public HttpAuthenticatorJwt(Authenticator<BearerCredential, JwtPrincipal> authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public JwtPrincipal authenticate(HttpCredential credential) {
        if (!credential.scheme().equals((Object)HttpCredential.Scheme.BEARER)) {
            return null;
        }
        return this.authenticator.authenticate(((HttpBearerCredential)credential).credential());
    }

    @Override
    public String challenge() {
        return HttpCredential.Scheme.BEARER.toString();
    }
}

