/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.WakeupException;

public class WakeupTrigger {
    private AtomicReference<Wakeupable> pendingTask = new AtomicReference<Object>(null);

    public void wakeup() {
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return new WakeupFuture();
            }
            if (task instanceof ActiveFuture) {
                ActiveFuture active = (ActiveFuture)task;
                active.future().completeExceptionally(new WakeupException());
                return null;
            }
            return task;
        });
    }

    public <T> CompletableFuture<T> setActiveTask(CompletableFuture<T> currentTask) {
        Objects.requireNonNull(currentTask, "currentTask cannot be null");
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return new ActiveFuture(currentTask);
            }
            if (task instanceof WakeupFuture) {
                currentTask.completeExceptionally(new WakeupException());
                return null;
            }
            throw new KafkaException("Last active task is still active");
        });
        return currentTask;
    }

    public void clearActiveTask() {
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return null;
            }
            if (task instanceof ActiveFuture) {
                return null;
            }
            return task;
        });
    }

    Wakeupable getPendingTask() {
        return this.pendingTask.get();
    }

    static class WakeupFuture
    implements Wakeupable {
        WakeupFuture() {
        }
    }

    static class ActiveFuture
    implements Wakeupable {
        private final CompletableFuture<?> future;

        public ActiveFuture(CompletableFuture<?> future) {
            this.future = future;
        }

        public CompletableFuture<?> future() {
            return this.future;
        }
    }

    static interface Wakeupable {
    }
}

