/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.internal.ObjectPool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.xds.internal.security.SslContextProvider;
import io.grpc.xds.internal.security.SslContextProviderSupplier;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@VisibleForTesting
public final class SecurityProtocolNegotiators {
    private static final Logger logger = Logger.getLogger(SecurityProtocolNegotiators.class.getName());
    private static final AsciiString SCHEME = AsciiString.of((CharSequence)"http");
    public static final Attributes.Key<SslContextProviderSupplier> ATTR_SERVER_SSL_CONTEXT_PROVIDER_SUPPLIER = Attributes.Key.create((String)"io.grpc.xds.internal.security.server.sslContextProviderSupplier");
    public static final Attributes.Key<SslContextProviderSupplier> ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER = Attributes.Key.create((String)"io.grpc.xds.internal.security.SslContextProviderSupplier");

    private SecurityProtocolNegotiators() {
    }

    public static InternalProtocolNegotiator.ClientFactory clientProtocolNegotiatorFactory(@Nullable InternalProtocolNegotiator.ClientFactory fallbackNegotiator) {
        return new ClientFactory(fallbackNegotiator);
    }

    public static InternalProtocolNegotiator.ServerFactory serverProtocolNegotiatorFactory(@Nullable InternalProtocolNegotiator.ServerFactory fallbackNegotiator) {
        return new ServerFactory(fallbackNegotiator);
    }

    @VisibleForTesting
    static final class ServerSecurityHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final SslContextProviderSupplier sslContextProviderSupplier;

        ServerSecurityHandler(GrpcHttp2ConnectionHandler grpcHandler, SslContextProviderSupplier sslContextProviderSupplier) {
            super((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }, grpcHandler.getNegotiationLogger());
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.grpcHandler = grpcHandler;
            this.sslContextProviderSupplier = sslContextProviderSupplier;
        }

        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)bufferReads);
            this.sslContextProviderSupplier.updateSslContext(new SslContextProvider.Callback((Executor)ctx.executor()){

                @Override
                public void updateSslContext(SslContext sslContext) {
                    ChannelHandler handler = InternalProtocolNegotiators.serverTls((SslContext)sslContext).newHandler(grpcHandler);
                    if (!ctx.isRemoved()) {
                        ctx.pipeline().addAfter(ctx.name(), null, handler);
                        this.fireProtocolNegotiationEvent(ctx);
                        ctx.pipeline().remove((ChannelHandler)bufferReads);
                    }
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            });
        }
    }

    @VisibleForTesting
    static final class HandlerPickerHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        HandlerPickerHandler(GrpcHttp2ConnectionHandler grpcHandler, @Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.grpcHandler = (GrpcHttp2ConnectionHandler)Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                ProtocolNegotiationEvent pne = (ProtocolNegotiationEvent)evt;
                SslContextProviderSupplier sslContextProviderSupplier = (SslContextProviderSupplier)InternalProtocolNegotiationEvent.getAttributes((ProtocolNegotiationEvent)pne).get(ATTR_SERVER_SSL_CONTEXT_PROVIDER_SUPPLIER);
                if (sslContextProviderSupplier == null) {
                    logger.log(Level.FINE, "No sslContextProviderSupplier found in filterChainMatch for connection from {0} to {1}", new Object[]{ctx.channel().remoteAddress(), ctx.channel().localAddress()});
                    if (this.fallbackProtocolNegotiator == null) {
                        ctx.fireExceptionCaught((Throwable)new CertStoreException("No certificate source found!"));
                        return;
                    }
                    logger.log(Level.FINE, "Using fallback credentials for connection from {0} to {1}", new Object[]{ctx.channel().remoteAddress(), ctx.channel().localAddress()});
                    ctx.pipeline().replace((ChannelHandler)this, null, this.fallbackProtocolNegotiator.newHandler(this.grpcHandler));
                    ctx.fireUserEventTriggered((Object)pne);
                    return;
                }
                ctx.pipeline().replace((ChannelHandler)this, null, (ChannelHandler)new ServerSecurityHandler(this.grpcHandler, sslContextProviderSupplier));
                ctx.fireUserEventTriggered((Object)pne);
                return;
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    private static final class ServerSecurityProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        @VisibleForTesting
        public ServerSecurityProtocolNegotiator(@Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            return new HandlerPickerHandler(grpcHandler, this.fallbackProtocolNegotiator);
        }

        public void close() {
        }
    }

    @VisibleForTesting
    static final class ClientSecurityHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final SslContextProviderSupplier sslContextProviderSupplier;

        ClientSecurityHandler(GrpcHttp2ConnectionHandler grpcHandler, SslContextProviderSupplier sslContextProviderSupplier) {
            super((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }, grpcHandler.getNegotiationLogger());
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler");
            this.grpcHandler = grpcHandler;
            this.sslContextProviderSupplier = sslContextProviderSupplier;
        }

        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)bufferReads);
            this.sslContextProviderSupplier.updateSslContext(new SslContextProvider.Callback((Executor)ctx.executor()){

                @Override
                public void updateSslContext(SslContext sslContext) {
                    if (ctx.isRemoved()) {
                        return;
                    }
                    logger.log(Level.FINEST, "ClientSecurityHandler.updateSslContext authority={0}, ctx.name={1}", new Object[]{grpcHandler.getAuthority(), ctx.name()});
                    ChannelHandler handler = InternalProtocolNegotiators.tls((SslContext)sslContext).newHandler(grpcHandler);
                    ctx.pipeline().addAfter(ctx.name(), null, handler);
                    this.fireProtocolNegotiationEvent(ctx);
                    ctx.pipeline().remove((ChannelHandler)bufferReads);
                }

                @Override
                public void onException(Throwable throwable) {
                    ctx.fireExceptionCaught(throwable);
                }
            });
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    private static class BufferReadsHandler
    extends ChannelInboundHandlerAdapter {
        private final List<Object> reads = new ArrayList<Object>();
        private boolean readComplete;

        private BufferReadsHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.reads.add(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            this.readComplete = true;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            for (Object msg : this.reads) {
                super.channelRead(ctx, msg);
            }
            if (this.readComplete) {
                super.channelReadComplete(ctx);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.log(Level.SEVERE, "exceptionCaught", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    @VisibleForTesting
    static final class ClientSecurityProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        @Nullable
        private final InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

        ClientSecurityProtocolNegotiator(@Nullable InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
            this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            SslContextProviderSupplier localSslContextProviderSupplier = (SslContextProviderSupplier)grpcHandler.getEagAttributes().get(ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER);
            if (localSslContextProviderSupplier == null) {
                Preconditions.checkNotNull((Object)this.fallbackProtocolNegotiator, (Object)"No TLS config and no fallbackProtocolNegotiator!");
                return this.fallbackProtocolNegotiator.newHandler(grpcHandler);
            }
            return new ClientSecurityHandler(grpcHandler, localSslContextProviderSupplier);
        }

        public void close() {
        }
    }

    private static final class ClientFactory
    implements InternalProtocolNegotiator.ClientFactory {
        private final InternalProtocolNegotiator.ClientFactory fallbackProtocolNegotiator;

        private ClientFactory(InternalProtocolNegotiator.ClientFactory fallbackNegotiator) {
            this.fallbackProtocolNegotiator = fallbackNegotiator;
        }

        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator() {
            return new ClientSecurityProtocolNegotiator(this.fallbackProtocolNegotiator.newNegotiator());
        }

        public int getDefaultPort() {
            return 443;
        }
    }

    private static final class ServerFactory
    implements InternalProtocolNegotiator.ServerFactory {
        private final InternalProtocolNegotiator.ServerFactory fallbackProtocolNegotiator;

        private ServerFactory(InternalProtocolNegotiator.ServerFactory fallbackNegotiator) {
            this.fallbackProtocolNegotiator = fallbackNegotiator;
        }

        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator(ObjectPool<? extends Executor> offloadExecutorPool) {
            return new ServerSecurityProtocolNegotiator(this.fallbackProtocolNegotiator.newNegotiator(offloadExecutorPool));
        }
    }
}

