/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generic.GenericGroup;
import org.apache.kafka.coordinator.group.generic.GenericGroupState;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class OffsetMetadataManager {
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final Time time;
    private MetadataImage metadataImage;
    private final GroupMetadataManager groupMetadataManager;
    private final GroupCoordinatorConfig config;
    private final TimelineHashMap<String, TimelineHashMap<String, TimelineHashMap<Integer, OffsetAndMetadata>>> offsetsByGroup;

    OffsetMetadataManager(SnapshotRegistry snapshotRegistry, LogContext logContext, Time time, MetadataImage metadataImage, GroupMetadataManager groupMetadataManager, GroupCoordinatorConfig config) {
        this.snapshotRegistry = snapshotRegistry;
        this.log = logContext.logger(OffsetMetadataManager.class);
        this.time = time;
        this.metadataImage = metadataImage;
        this.groupMetadataManager = groupMetadataManager;
        this.config = config;
        this.offsetsByGroup = new TimelineHashMap(snapshotRegistry, 0);
    }

    private Group validateOffsetCommit(RequestContext context, OffsetCommitRequestData request) throws ApiException {
        Group group;
        try {
            group = this.groupMetadataManager.group(request.groupId());
        }
        catch (GroupIdNotFoundException ex) {
            if (request.generationIdOrMemberEpoch() < 0) {
                group = this.groupMetadataManager.getOrMaybeCreateGenericGroup(request.groupId(), true);
            }
            if (context.header.apiVersion() >= 9) {
                throw ex;
            }
            throw Errors.ILLEGAL_GENERATION.exception();
        }
        try {
            group.validateOffsetCommit(request.memberId(), request.groupInstanceId(), request.generationIdOrMemberEpoch());
        }
        catch (StaleMemberEpochException ex) {
            if (context.header.apiVersion() >= 9) {
                throw ex;
            }
            throw Errors.UNSUPPORTED_VERSION.exception();
        }
        return group;
    }

    private void validateOffsetFetch(OffsetFetchRequestData.OffsetFetchRequestGroup request, long lastCommittedOffset) throws GroupIdNotFoundException {
        Group group = this.groupMetadataManager.group(request.groupId(), lastCommittedOffset);
        group.validateOffsetFetch(request.memberId(), request.memberEpoch(), lastCommittedOffset);
    }

    private Group validateOffsetDelete(OffsetDeleteRequestData request) throws GroupIdNotFoundException {
        Group group = this.groupMetadataManager.group(request.groupId());
        group.validateOffsetDelete();
        return group;
    }

    private static OptionalLong expireTimestampMs(long retentionTimeMs, long currentTimeMs) {
        return retentionTimeMs == -1L ? OptionalLong.empty() : OptionalLong.of(currentTimeMs + retentionTimeMs);
    }

    public CoordinatorResult<OffsetCommitResponseData, Record> commitOffset(RequestContext context, OffsetCommitRequestData request) throws ApiException {
        GenericGroup genericGroup;
        Group group = this.validateOffsetCommit(context, request);
        if (group.type() == Group.GroupType.GENERIC && ((genericGroup = (GenericGroup)group).isInState(GenericGroupState.STABLE) || genericGroup.isInState(GenericGroupState.PREPARING_REBALANCE))) {
            this.groupMetadataManager.rescheduleGenericGroupMemberHeartbeat(genericGroup, genericGroup.member(request.memberId()));
        }
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        ArrayList records = new ArrayList();
        long currentTimeMs = this.time.milliseconds();
        OptionalLong expireTimestampMs = OffsetMetadataManager.expireTimestampMs(request.retentionTimeMs(), currentTimeMs);
        request.topics().forEach(topic -> {
            OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topic.name());
            response.topics().add(topicResponse);
            topic.partitions().forEach(partition -> {
                if (partition.committedMetadata() != null && partition.committedMetadata().length() > this.config.offsetMetadataMaxSize) {
                    topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.OFFSET_METADATA_TOO_LARGE.code()));
                } else {
                    this.log.debug("[GroupId {}] Committing offsets {} for partition {}-{} from member {} with leader epoch {}.", new Object[]{request.groupId(), partition.committedOffset(), topic.name(), partition.partitionIndex(), request.memberId(), partition.committedLeaderEpoch()});
                    topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.NONE.code()));
                    OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata.fromRequest(partition, currentTimeMs, expireTimestampMs);
                    records.add(RecordHelpers.newOffsetCommitRecord(request.groupId(), topic.name(), partition.partitionIndex(), offsetAndMetadata, this.metadataImage.features().metadataVersion()));
                }
            });
        });
        return new CoordinatorResult<OffsetCommitResponseData, Record>(records, response);
    }

    public CoordinatorResult<OffsetDeleteResponseData, Record> deleteOffsets(OffsetDeleteRequestData request) throws ApiException {
        Group group = this.validateOffsetDelete(request);
        ArrayList records = new ArrayList();
        OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection responseTopicCollection = new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection();
        TimelineHashMap offsetsByTopic = (TimelineHashMap)this.offsetsByGroup.get((Object)request.groupId());
        request.topics().forEach(topic -> {
            OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection responsePartitionCollection = new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection();
            if (group.isSubscribedToTopic(topic.name())) {
                topic.partitions().forEach(partition -> responsePartitionCollection.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code())));
            } else {
                TimelineHashMap offsetsByPartition;
                TimelineHashMap timelineHashMap = offsetsByPartition = offsetsByTopic == null ? null : (TimelineHashMap)offsetsByTopic.get((Object)topic.name());
                if (offsetsByPartition != null) {
                    topic.partitions().forEach(partition -> {
                        if (offsetsByPartition.containsKey((Object)partition.partitionIndex())) {
                            responsePartitionCollection.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition.partitionIndex()));
                            records.add(RecordHelpers.newOffsetCommitTombstoneRecord(request.groupId(), topic.name(), partition.partitionIndex()));
                        }
                    });
                }
            }
            responseTopicCollection.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic.name()).setPartitions(responsePartitionCollection));
        });
        return new CoordinatorResult<OffsetDeleteResponseData, Record>(records, new OffsetDeleteResponseData().setTopics(responseTopicCollection));
    }

    public int deleteAllOffsets(String groupId, List<Record> records) {
        TimelineHashMap offsetsByTopic = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
        AtomicInteger numDeletedOffsets = new AtomicInteger();
        if (offsetsByTopic != null) {
            offsetsByTopic.forEach((topic, offsetsByPartition) -> offsetsByPartition.keySet().forEach(partition -> {
                records.add(RecordHelpers.newOffsetCommitTombstoneRecord(groupId, topic, partition));
                numDeletedOffsets.getAndIncrement();
            }));
        }
        return numDeletedOffsets.get();
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchOffsets(OffsetFetchRequestData.OffsetFetchRequestGroup request, long lastCommittedOffset) throws ApiException {
        boolean failAllPartitions = false;
        try {
            this.validateOffsetFetch(request, lastCommittedOffset);
        }
        catch (GroupIdNotFoundException ex) {
            failAllPartitions = true;
        }
        ArrayList topicResponses = new ArrayList(request.topics().size());
        TimelineHashMap groupOffsets = failAllPartitions ? null : (TimelineHashMap)this.offsetsByGroup.get((Object)request.groupId(), lastCommittedOffset);
        request.topics().forEach(topic -> {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicResponse = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic.name());
            topicResponses.add(topicResponse);
            TimelineHashMap topicOffsets = groupOffsets == null ? null : (TimelineHashMap)groupOffsets.get((Object)topic.name(), lastCommittedOffset);
            topic.partitionIndexes().forEach(partitionIndex -> {
                OffsetAndMetadata offsetAndMetadata;
                OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = topicOffsets == null ? null : (OffsetAndMetadata)topicOffsets.get(partitionIndex, lastCommittedOffset);
                if (offsetAndMetadata == null) {
                    topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partitionIndex.intValue()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata(""));
                } else {
                    topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partitionIndex.intValue()).setCommittedOffset(offsetAndMetadata.offset).setCommittedLeaderEpoch(offsetAndMetadata.leaderEpoch.orElse(-1)).setMetadata(offsetAndMetadata.metadata));
                }
            });
        });
        return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setTopics(topicResponses);
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchAllOffsets(OffsetFetchRequestData.OffsetFetchRequestGroup request, long lastCommittedOffset) throws ApiException {
        try {
            this.validateOffsetFetch(request, lastCommittedOffset);
        }
        catch (GroupIdNotFoundException ex) {
            return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setTopics(Collections.emptyList());
        }
        ArrayList topicResponses = new ArrayList();
        TimelineHashMap groupOffsets = (TimelineHashMap)this.offsetsByGroup.get((Object)request.groupId(), lastCommittedOffset);
        if (groupOffsets != null) {
            groupOffsets.entrySet(lastCommittedOffset).forEach(topicEntry -> {
                String topic = (String)topicEntry.getKey();
                TimelineHashMap topicOffsets = (TimelineHashMap)topicEntry.getValue();
                OffsetFetchResponseData.OffsetFetchResponseTopics topicResponse = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic);
                topicResponses.add(topicResponse);
                topicOffsets.entrySet(lastCommittedOffset).forEach(partitionEntry -> {
                    int partition = (Integer)partitionEntry.getKey();
                    OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)partitionEntry.getValue();
                    topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition).setCommittedOffset(offsetAndMetadata.offset).setCommittedLeaderEpoch(offsetAndMetadata.leaderEpoch.orElse(-1)).setMetadata(offsetAndMetadata.metadata));
                });
            });
        }
        return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setTopics(topicResponses);
    }

    public boolean cleanupExpiredOffsets(String groupId, List<Record> records) {
        TimelineHashMap offsetsByTopic = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
        if (offsetsByTopic == null) {
            return true;
        }
        Group group = this.groupMetadataManager.group(groupId);
        HashSet expiredPartitions = new HashSet();
        long currentTimestampMs = this.time.milliseconds();
        Optional<OffsetExpirationCondition> offsetExpirationCondition = group.offsetExpirationCondition();
        if (!offsetExpirationCondition.isPresent()) {
            return false;
        }
        AtomicBoolean allOffsetsExpired = new AtomicBoolean(true);
        OffsetExpirationCondition condition = offsetExpirationCondition.get();
        offsetsByTopic.forEach((topic, partitions) -> {
            if (!group.isSubscribedToTopic((String)topic)) {
                partitions.forEach((partition, offsetAndMetadata) -> {
                    if (condition.isOffsetExpired((OffsetAndMetadata)offsetAndMetadata, currentTimestampMs, this.config.offsetsRetentionMs)) {
                        expiredPartitions.add(this.appendOffsetCommitTombstone(groupId, (String)topic, (int)partition, records).toString());
                    } else {
                        allOffsetsExpired.set(false);
                    }
                });
            } else {
                allOffsetsExpired.set(false);
            }
        });
        if (!expiredPartitions.isEmpty()) {
            this.log.info("[GroupId {}] Expiring offsets of partitions (allOffsetsExpired={}): {}", new Object[]{groupId, allOffsetsExpired, String.join((CharSequence)", ", expiredPartitions)});
        }
        return allOffsetsExpired.get();
    }

    private TopicPartition appendOffsetCommitTombstone(String groupId, String topic, int partition, List<Record> records) {
        records.add(RecordHelpers.newOffsetCommitTombstoneRecord(groupId, topic, partition));
        TopicPartition tp = new TopicPartition(topic, partition);
        this.log.trace("[GroupId {}] Removing expired offset and metadata for {}", (Object)groupId, (Object)tp);
        return tp;
    }

    public void replay(OffsetCommitKey key, OffsetCommitValue value) {
        String groupId = key.group();
        String topic = key.topic();
        int partition = key.partition();
        if (value != null) {
            try {
                this.groupMetadataManager.group(groupId);
            }
            catch (GroupIdNotFoundException ex) {
                this.groupMetadataManager.getOrMaybeCreateGenericGroup(groupId, true);
            }
            this.updateOffset(groupId, topic, partition, OffsetAndMetadata.fromRecord(value));
        } else {
            this.removeOffset(groupId, topic, partition);
        }
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.metadataImage = newImage;
    }

    OffsetAndMetadata offset(String groupId, String topic, int partition) {
        TimelineHashMap topicOffsets = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
        if (topicOffsets == null) {
            return null;
        }
        TimelineHashMap partitionOffsets = (TimelineHashMap)topicOffsets.get((Object)topic);
        if (partitionOffsets == null) {
            return null;
        }
        return (OffsetAndMetadata)partitionOffsets.get((Object)partition);
    }

    private void updateOffset(String groupId, String topic, int partition, OffsetAndMetadata offsetAndMetadata) {
        TimelineHashMap topicOffsets = (TimelineHashMap)this.offsetsByGroup.computeIfAbsent((Object)groupId, __ -> new TimelineHashMap(this.snapshotRegistry, 0));
        TimelineHashMap partitionOffsets = (TimelineHashMap)topicOffsets.computeIfAbsent((Object)topic, __ -> new TimelineHashMap(this.snapshotRegistry, 0));
        partitionOffsets.put((Object)partition, (Object)offsetAndMetadata);
    }

    private void removeOffset(String groupId, String topic, int partition) {
        TimelineHashMap topicOffsets = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
        if (topicOffsets == null) {
            return;
        }
        TimelineHashMap partitionOffsets = (TimelineHashMap)topicOffsets.get((Object)topic);
        if (partitionOffsets == null) {
            return;
        }
        partitionOffsets.remove((Object)partition);
        if (partitionOffsets.isEmpty()) {
            topicOffsets.remove((Object)topic);
        }
        if (topicOffsets.isEmpty()) {
            this.offsetsByGroup.remove((Object)groupId);
        }
    }

    public static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private Time time = null;
        private GroupMetadataManager groupMetadataManager = null;
        private MetadataImage metadataImage = null;
        private GroupCoordinatorConfig config = null;

        Builder withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        Builder withGroupMetadataManager(GroupMetadataManager groupMetadataManager) {
            this.groupMetadataManager = groupMetadataManager;
            return this;
        }

        Builder withGroupCoordinatorConfig(GroupCoordinatorConfig config) {
            this.config = config;
            return this;
        }

        Builder withMetadataImage(MetadataImage metadataImage) {
            this.metadataImage = metadataImage;
            return this;
        }

        public OffsetMetadataManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.metadataImage == null) {
                this.metadataImage = MetadataImage.EMPTY;
            }
            if (this.time == null) {
                this.time = Time.SYSTEM;
            }
            if (this.groupMetadataManager == null) {
                throw new IllegalArgumentException("GroupMetadataManager cannot be null");
            }
            return new OffsetMetadataManager(this.snapshotRegistry, this.logContext, this.time, this.metadataImage, this.groupMetadataManager, this.config);
        }
    }
}

