/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.confluent.telemetry.config.ExactMetricRule;
import io.confluent.telemetry.config.PatternMetricRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class FilterRuleSet {
    private final List<ExactMetricRule> exactRules;
    private final List<PatternMetricRule> patternRules;

    public FilterRuleSet(@JsonProperty(value="exact") List<ExactMetricRule> exactRules, @JsonProperty(value="pattern") List<PatternMetricRule> patternRules) {
        this.exactRules = FilterRuleSet.validateExactRules(exactRules);
        this.patternRules = patternRules;
    }

    private static List<ExactMetricRule> validateExactRules(List<ExactMetricRule> exactRules) {
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (ExactMetricRule exactRule : exactRules) {
            if (seen.add(exactRule.getName())) continue;
            duplicates.add(exactRule.getName());
        }
        Preconditions.checkArgument((boolean)duplicates.isEmpty(), (String)"Exact rules contains duplicate names: %s", duplicates);
        return exactRules;
    }

    public List<ExactMetricRule> getExactRules() {
        return this.exactRules;
    }

    public List<PatternMetricRule> getPatternRules() {
        return this.patternRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterRuleSet)) {
            return false;
        }
        FilterRuleSet that = (FilterRuleSet)o;
        return Objects.equals(this.exactRules, that.exactRules) && Objects.equals(this.patternRules, that.patternRules);
    }

    public int hashCode() {
        return Objects.hash(this.exactRules, this.patternRules);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exactRules", this.exactRules).add("patternRules", this.patternRules).toString();
    }
}

