/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.AzureDeveloperCliCredential;
import com.azure.identity.AzurePowerShellCredential;
import com.azure.identity.BrokerCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.IntelliJCredential;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.VisualStudioCodeCredential;
import com.azure.identity.WorkloadIdentityCredential;
import com.azure.identity.implementation.IdentityLogOptionsImpl;
import com.azure.identity.implementation.util.IdentityUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class DefaultAzureCredentialBuilder
extends CredentialBuilderBase<DefaultAzureCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultAzureCredentialBuilder.class);
    private String tenantId;
    private String managedIdentityClientId;
    private String workloadIdentityClientId;
    private String managedIdentityResourceId;
    private List<String> additionallyAllowedTenants = IdentityUtil.getAdditionalTenantsFromEnvironment(Configuration.getGlobalConfiguration().clone());

    public DefaultAzureCredentialBuilder() {
        this.identityClientOptions.setIdentityLogOptionsImpl(new IdentityLogOptionsImpl(true));
        this.identityClientOptions.setChained(true);
    }

    public DefaultAzureCredentialBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public DefaultAzureCredentialBuilder authorityHost(String authorityHost) {
        this.identityClientOptions.setAuthorityHost(authorityHost);
        return this;
    }

    @Deprecated
    public DefaultAzureCredentialBuilder intelliJKeePassDatabasePath(String databasePath) {
        if (CoreUtils.isNullOrEmpty((CharSequence)databasePath)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The KeePass database path is either empty or not configured. Please configure it on the builder."));
        }
        this.identityClientOptions.setIntelliJKeePassDatabasePath(databasePath);
        return this;
    }

    public DefaultAzureCredentialBuilder managedIdentityClientId(String clientId) {
        this.managedIdentityClientId = clientId;
        return this;
    }

    public DefaultAzureCredentialBuilder workloadIdentityClientId(String clientId) {
        this.workloadIdentityClientId = clientId;
        return this;
    }

    public DefaultAzureCredentialBuilder managedIdentityResourceId(String resourceId) {
        this.managedIdentityResourceId = resourceId;
        return this;
    }

    public DefaultAzureCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public DefaultAzureCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.additionallyAllowedTenants = IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants));
        return this;
    }

    public DefaultAzureCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.additionallyAllowedTenants = IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants);
        return this;
    }

    public DefaultAzureCredentialBuilder credentialProcessTimeout(Duration credentialProcessTimeout) {
        Objects.requireNonNull(credentialProcessTimeout);
        this.identityClientOptions.setCredentialProcessTimeout(credentialProcessTimeout);
        return this;
    }

    public DefaultAzureCredentialBuilder disableInstanceDiscovery() {
        this.identityClientOptions.disableInstanceDiscovery();
        return this;
    }

    public DefaultAzureCredential build() {
        this.loadFallbackValuesFromEnvironment();
        if (this.managedIdentityClientId != null && this.managedIdentityResourceId != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Only one of managedIdentityClientId and managedIdentityResourceId can be specified."));
        }
        if (!CoreUtils.isNullOrEmpty(this.additionallyAllowedTenants)) {
            this.identityClientOptions.setAdditionallyAllowedTenants(this.additionallyAllowedTenants);
        }
        return new DefaultAzureCredential(this.getCredentialsChain());
    }

    private void loadFallbackValuesFromEnvironment() {
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        this.tenantId = CoreUtils.isNullOrEmpty((CharSequence)this.tenantId) ? configuration.get("AZURE_TENANT_ID") : this.tenantId;
        this.managedIdentityClientId = CoreUtils.isNullOrEmpty((CharSequence)this.managedIdentityClientId) ? configuration.get("AZURE_CLIENT_ID") : this.managedIdentityClientId;
    }

    private ArrayList<TokenCredential> getCredentialsChain() {
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        String selectedCredential = configuration.get("AZURE_TOKEN_CREDENTIALS");
        ArrayList<TokenCredential> credentials = new ArrayList<TokenCredential>(8);
        if (!CoreUtils.isNullOrEmpty((CharSequence)selectedCredential)) {
            selectedCredential = selectedCredential.trim().toLowerCase(Locale.ROOT);
            HashMap<String, Runnable> credentialMap = new HashMap<String, Runnable>();
            credentialMap.put("prod", () -> this.addProdCredentials(credentials));
            credentialMap.put("dev", () -> this.addDevCredentials(credentials));
            credentialMap.put("environmentcredential", () -> credentials.add(new EnvironmentCredential(this.identityClientOptions.clone())));
            credentialMap.put("workloadidentitycredential", () -> credentials.add(this.getWorkloadIdentityCredential()));
            credentialMap.put("managedidentitycredential", () -> credentials.add(new ManagedIdentityCredential(this.managedIdentityClientId, this.managedIdentityResourceId, null, this.identityClientOptions.clone())));
            credentialMap.put("intellijcredential", () -> credentials.add(new IntelliJCredential(this.tenantId, this.identityClientOptions.clone())));
            credentialMap.put("azureclicredential", () -> credentials.add(new AzureCliCredential(this.tenantId, this.identityClientOptions.clone())));
            credentialMap.put("azurepowershellcredential", () -> credentials.add(new AzurePowerShellCredential(this.tenantId, this.identityClientOptions.clone())));
            credentialMap.put("azuredeveloperclicredential", () -> credentials.add(new AzureDeveloperCliCredential(this.tenantId, this.identityClientOptions.clone())));
            credentialMap.put("visualstudiocodecredential", () -> credentials.add(new VisualStudioCodeCredential(this.tenantId, this.identityClientOptions.clone())));
            Runnable adder = (Runnable)credentialMap.get(selectedCredential);
            if (adder != null) {
                adder.run();
                return credentials;
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid value for AZURE_TOKEN_CREDENTIALS: '" + selectedCredential + "'. Valid values are: 'prod', 'dev', or one of [EnvironmentCredential, WorkloadIdentityCredential, ManagedIdentityCredential, IntelliJCredential, AzureCliCredential, AzurePowerShellCredential, AzureDeveloperCliCredential, VisualStudioCodeCredential] (case-insensitive). To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azure-identity-java-default-azure-credential-troubleshoot"));
        }
        this.addProdCredentials(credentials);
        this.addDevCredentials(credentials);
        return credentials;
    }

    private void addProdCredentials(List<TokenCredential> credentials) {
        credentials.add(new EnvironmentCredential(this.identityClientOptions.clone()));
        credentials.add(this.getWorkloadIdentityCredential());
        credentials.add(new ManagedIdentityCredential(this.managedIdentityClientId, this.managedIdentityResourceId, null, this.identityClientOptions.clone()));
    }

    private void addDevCredentials(List<TokenCredential> credentials) {
        credentials.add(new IntelliJCredential(this.tenantId, this.identityClientOptions.clone()));
        credentials.add(new VisualStudioCodeCredential(this.tenantId, this.identityClientOptions.clone()));
        credentials.add(new AzureCliCredential(this.tenantId, this.identityClientOptions.clone()));
        credentials.add(new AzurePowerShellCredential(this.tenantId, this.identityClientOptions.clone()));
        credentials.add(new AzureDeveloperCliCredential(this.tenantId, this.identityClientOptions.clone()));
        credentials.add(new BrokerCredential(this.tenantId));
    }

    private WorkloadIdentityCredential getWorkloadIdentityCredential() {
        String clientId;
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        String azureAuthorityHost = configuration.get("AZURE_AUTHORITY_HOST");
        String string = clientId = CoreUtils.isNullOrEmpty((CharSequence)this.workloadIdentityClientId) ? this.managedIdentityClientId : this.workloadIdentityClientId;
        if (!CoreUtils.isNullOrEmpty((CharSequence)azureAuthorityHost)) {
            this.identityClientOptions.setAuthorityHost(azureAuthorityHost);
        }
        return new WorkloadIdentityCredential(this.tenantId, clientId, null, this.identityClientOptions.clone());
    }
}

