/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.AdminRequestInterceptor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.utils.Time;

public class ConfluentAdminUtils {
    private static final Map<String, MethodHandle> ADMIN_METHODS;
    private static final Map<Class<?>, MethodHandle> CONSTRUCTORS;
    private static final Map<String, MethodHandle> OTHER_METHODS;

    public static ConfluentAdmin createConfluentAdmin(AdminClientConfig config, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        return (ConfluentAdmin)ConfluentAdminUtils.invokeAdminMethod("createInternalWithCallback", config, requestCallback, proxyProtocolEngineFactory);
    }

    public static ConfluentAdmin createConfluentAdmin(AdminClientConfig config, AdminMetadataManager metadataManager, KafkaClient client, Time time) {
        return (ConfluentAdmin)ConfluentAdminUtils.invokeAdminMethod("createInternal", config, metadataManager, client, time, null);
    }

    public static ConfluentAdmin createConfluentAdmin(AdminClientConfig config, AdminMetadataManager metadataManager, KafkaClient client, Time time, AdminRequestInterceptor.Factory interceptorFactory) {
        return (ConfluentAdmin)ConfluentAdminUtils.invokeAdminMethod("createInternal", config, metadataManager, client, time, interceptorFactory);
    }

    public static Map<Integer, KafkaFutureImpl<Void>> initiateReverseConnections(ConfluentAdmin admin, InitiateReverseConnectionsRequestData requestData, Integer brokerId) {
        return (Map)ConfluentAdminUtils.invokeAdminMethod("initiateReverseConnections", admin, requestData, brokerId);
    }

    public static AlterMirrorsResult stopMirrors(ConfluentAdmin admin, Map<String, List<Long>> stoppedLogEndOffsets) {
        return (AlterMirrorsResult)ConfluentAdminUtils.invokeAdminMethod("stopMirrors", admin, stoppedLogEndOffsets);
    }

    public static AlterMirrorsResult failMirrors(ConfluentAdmin admin, Map<String, MirrorTopicError> mirrorFailures) {
        return (AlterMirrorsResult)ConfluentAdminUtils.invokeAdminMethod("failMirrors", admin, mirrorFailures);
    }

    public static AlterMirrorsResult convertToStartPendingMirrors(ConfluentAdmin admin, Map<String, String> sourceTopicNames, Map<String, Uuid> sourceTopicIds, Map<String, Uuid> expectedLocalTopicIds) {
        return (AlterMirrorsResult)ConfluentAdminUtils.invokeAdminMethod("convertToStartPendingMirrors", admin, sourceTopicNames, sourceTopicIds, expectedLocalTopicIds);
    }

    public static AlterMirrorsResult convertToPausePendingMirrors(ConfluentAdmin admin, Map<String, String> sourceTopicNames, Map<String, Uuid> sourceTopicIds, Map<String, Uuid> expectedLocalTopicIds) {
        return (AlterMirrorsResult)ConfluentAdminUtils.invokeAdminMethod("convertToPausePendingMirrors", admin, sourceTopicNames, sourceTopicIds, expectedLocalTopicIds);
    }

    public static DeleteAclsResult deleteAcls(ConfluentAdmin admin, Collection<AclBindingFilter> filters, DeleteAclsOptions options, AclState aclState) {
        return (DeleteAclsResult)ConfluentAdminUtils.invokeAdminMethod("deleteAcls", new Object[]{admin, filters, options, aclState});
    }

    public static DescribeAclsResult describeAcls(ConfluentAdmin admin, AclBindingFilter filter, DescribeAclsOptions options, AclState aclState) {
        return (DescribeAclsResult)ConfluentAdminUtils.invokeAdminMethod("describeAcls", new Object[]{admin, filter, options, aclState});
    }

    public static ListTopicsResult newListTopicsResult(KafkaFuture<Map<String, TopicListing>> future) {
        return (ListTopicsResult)ConfluentAdminUtils.invokeConstructor(ListTopicsResult.class, future);
    }

    public static AlterConfigsOptions skipMirrorTopicConfigValidation(AlterConfigsOptions options) {
        String methodName = "skipMirrorTopicConfigValidation";
        return (AlterConfigsOptions)ConfluentAdminUtils.invoke(methodName, OTHER_METHODS.get(ConfluentAdminUtils.methodKey(AlterConfigsOptions.class, methodName)), options);
    }

    public static boolean isFailbackOp(AlterMirrorOp alterMirrorOp) {
        String methodName = "isFailbackOp";
        return (Boolean)ConfluentAdminUtils.invoke(methodName, OTHER_METHODS.get(ConfluentAdminUtils.methodKey(AlterMirrorOp.class, methodName)), new Object[]{alterMirrorOp});
    }

    private static void addAdminMethod(MethodHandles.Lookup lookup, String methodName, Class<?> ... argTypes) {
        ADMIN_METHODS.put(methodName, ConfluentAdminUtils.methodHandle(lookup, KafkaAdminClient.class, methodName, argTypes));
    }

    private static void addMethod(MethodHandles.Lookup lookup, Class<?> clazz, String methodName, Class<?> ... argTypes) {
        OTHER_METHODS.put(ConfluentAdminUtils.methodKey(clazz, methodName), ConfluentAdminUtils.methodHandle(lookup, clazz, methodName, argTypes));
    }

    private static String methodKey(Class<?> clazz, String methodName) {
        return clazz.getName() + "." + methodName;
    }

    private static MethodHandle methodHandle(MethodHandles.Lookup lookup, Class<?> clazz, String methodName, Class<?> ... argTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new KafkaException("Failed to add method " + clazz.getName() + "." + methodName, e);
        }
    }

    private static void addConstructor(MethodHandles.Lookup lookup, Class<?> clazz, Class<?> ... argTypes) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            MethodHandle methodHandle = lookup.unreflectConstructor(constructor);
            CONSTRUCTORS.put(clazz, methodHandle);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new KafkaException("Failed to add constructor for " + clazz, e);
        }
    }

    private static <T> T invokeAdminMethod(String methodName, Object ... args) {
        return ConfluentAdminUtils.invoke(methodName, ADMIN_METHODS.get(methodName), args);
    }

    private static <T> T invokeConstructor(Class<?> clazz, Object ... args) {
        return ConfluentAdminUtils.invoke(clazz + " constructor", CONSTRUCTORS.get(clazz), args);
    }

    private static <T> T invoke(String methodName, MethodHandle methodHandle, Object ... args) {
        try {
            if (methodHandle == null) {
                throw new IllegalArgumentException("Admin method not found: " + methodName);
            }
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw new KafkaException("Admin method invocation failed: " + methodName, t);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ADMIN_METHODS = new HashMap<String, MethodHandle>();
        ConfluentAdminUtils.addAdminMethod(lookup, "createInternal", AdminClientConfig.class, AdminMetadataManager.class, KafkaClient.class, Time.class, AdminRequestInterceptor.Factory.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "createInternalWithCallback", AdminClientConfig.class, RequestCallback.class, ProxyProtocolEngineFactory.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "initiateReverseConnections", InitiateReverseConnectionsRequestData.class, Integer.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "deleteAcls", Collection.class, DeleteAclsOptions.class, AclState.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "describeAcls", AclBindingFilter.class, DescribeAclsOptions.class, AclState.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "stopMirrors", Map.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "failMirrors", Map.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "convertToStartPendingMirrors", Map.class, Map.class, Map.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "convertToPausePendingMirrors", Map.class, Map.class, Map.class);
        CONSTRUCTORS = new HashMap();
        ConfluentAdminUtils.addConstructor(lookup, ListTopicsResult.class, KafkaFuture.class);
        OTHER_METHODS = new HashMap<String, MethodHandle>();
        ConfluentAdminUtils.addMethod(lookup, AlterConfigsOptions.class, "skipMirrorTopicConfigValidation", new Class[0]);
        ConfluentAdminUtils.addMethod(lookup, AlterMirrorOp.class, "isFailbackOp", new Class[0]);
    }
}

