/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import io.confluent.kafka.storage.checksum.ChecksumProtectionForTopicChecker;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import io.confluent.kafka.storage.checksum.Crc32cChecksumStore;
import io.confluent.kafka.storage.checksum.Crc64ChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumMetrics;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedFileType;
import io.confluent.kafka.storage.checksum.E2EChecksumStoreConfig;
import java.io.IOException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E2EChecksumStore {
    public static final String STORE_FILE_NAME = "checksum.store";
    private static final Logger LOG = LoggerFactory.getLogger(E2EChecksumStore.class);
    private final ChecksumStore store;
    private final E2EChecksumStoreConfig config;
    private final boolean initialized;
    private final ChecksumProtectionForTopicChecker checksumProtectionForTopicChecker;

    public E2EChecksumStore(E2EChecksumStoreConfig e2EChecksumStoreConfig, Time time, ChecksumStoreReaderWriter readerWriter, Metrics rootMetrics, boolean shouldRecover, ChecksumProtectionForTopicChecker checksumProtectionForTopicChecker) throws IOException {
        LOG.info("Initializing checksum store to protect Kafka files with config : {} ", (Object)e2EChecksumStoreConfig);
        E2EChecksumMetrics metrics = new E2EChecksumMetrics(rootMetrics);
        switch (e2EChecksumStoreConfig.tierBackend()) {
            case ABS: {
                this.store = new Crc64ChecksumStore(e2EChecksumStoreConfig.storeEntryTTL(), time, readerWriter, metrics);
                break;
            }
            case S3: 
            case GCS: 
            case NONE: {
                this.store = new Crc32cChecksumStore(e2EChecksumStoreConfig.storeEntryTTL(), time, readerWriter, metrics);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported TierBackend: " + (Object)((Object)e2EChecksumStoreConfig.tierBackend()));
            }
        }
        this.config = e2EChecksumStoreConfig;
        if (shouldRecover) {
            this.store.recover();
        }
        this.checksumProtectionForTopicChecker = checksumProtectionForTopicChecker;
        this.initialized = true;
        LOG.info("Checksum store initialized successfully : {} ", this.store.getClass());
    }

    public E2EChecksumStore(E2EChecksumStoreConfig e2EChecksumStoreConfig, Time time, ChecksumStoreReaderWriter readerWriter, Metrics metrics) throws IOException {
        this(e2EChecksumStoreConfig, time, readerWriter, metrics, false, (partition, config) -> true);
    }

    public ChecksumStore store() {
        return this.store;
    }

    public synchronized void deRegisterMetrics() {
        if (this.initialized) {
            this.store().metrics().deRegister();
        }
    }

    public boolean checksumProtectionEnabled() {
        return this.initialized;
    }

    public boolean checksumProtectionEnabled(E2EChecksumProtectedFileType fileType) {
        return this.checksumProtectionEnabled() && this.config.filesProtected().contains(fileType.suffix());
    }

    public boolean checksumProtectionEnabledForTopic(TopicPartition topicPartition, LogConfig config) {
        return this.checksumProtectionEnabled() && this.checksumProtectionForTopicChecker.enabled(topicPartition, config);
    }
}

