/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedMemberEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedAssignorException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.CurrentAssignmentBuilder;
import org.apache.kafka.coordinator.group.consumer.TargetAssignmentBuilder;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generic.GenericGroup;
import org.apache.kafka.coordinator.group.generic.GenericGroupMember;
import org.apache.kafka.coordinator.group.generic.GenericGroupState;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.group.runtime.CoordinatorTimer;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;
import org.slf4j.Logger;

public class GroupMetadataManager {
    private final LogContext logContext;
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final Time time;
    private final CoordinatorTimer<Void, Record> timer;
    private final Map<String, PartitionAssignor> assignors;
    private final PartitionAssignor defaultAssignor;
    private final TimelineHashMap<String, Group> groups;
    private final TimelineHashMap<String, TimelineHashSet<String>> groupsByTopics;
    private final int consumerGroupMaxSize;
    private final int consumerGroupHeartbeatIntervalMs;
    private final int consumerGroupSessionTimeoutMs;
    private final int consumerGroupMetadataRefreshIntervalMs;
    private MetadataImage metadataImage;
    static final CoordinatorResult<Void, Record> EMPTY_RESULT = new CoordinatorResult(Collections.emptyList(), CompletableFuture.completedFuture(null));
    private final int genericGroupMaxSize;
    private final int genericGroupInitialRebalanceDelayMs;
    private final int genericGroupNewMemberJoinTimeoutMs;
    private final int genericGroupMinSessionTimeoutMs;
    private final int genericGroupMaxSessionTimeoutMs;

    private GroupMetadataManager(SnapshotRegistry snapshotRegistry, LogContext logContext, Time time, CoordinatorTimer<Void, Record> timer, List<PartitionAssignor> assignors, MetadataImage metadataImage, int consumerGroupMaxSize, int consumerGroupSessionTimeoutMs, int consumerGroupHeartbeatIntervalMs, int consumerGroupMetadataRefreshIntervalMs, int genericGroupMaxSize, int genericGroupInitialRebalanceDelayMs, int genericGroupNewMemberJoinTimeoutMs, int genericGroupMinSessionTimeoutMs, int genericGroupMaxSessionTimeoutMs) {
        this.logContext = logContext;
        this.log = logContext.logger(GroupMetadataManager.class);
        this.snapshotRegistry = snapshotRegistry;
        this.time = time;
        this.timer = timer;
        this.metadataImage = metadataImage;
        this.assignors = assignors.stream().collect(Collectors.toMap(PartitionAssignor::name, Function.identity()));
        this.defaultAssignor = assignors.get(0);
        this.groups = new TimelineHashMap(snapshotRegistry, 0);
        this.groupsByTopics = new TimelineHashMap(snapshotRegistry, 0);
        this.consumerGroupMaxSize = consumerGroupMaxSize;
        this.consumerGroupSessionTimeoutMs = consumerGroupSessionTimeoutMs;
        this.consumerGroupHeartbeatIntervalMs = consumerGroupHeartbeatIntervalMs;
        this.consumerGroupMetadataRefreshIntervalMs = consumerGroupMetadataRefreshIntervalMs;
        this.genericGroupMaxSize = genericGroupMaxSize;
        this.genericGroupInitialRebalanceDelayMs = genericGroupInitialRebalanceDelayMs;
        this.genericGroupNewMemberJoinTimeoutMs = genericGroupNewMemberJoinTimeoutMs;
        this.genericGroupMinSessionTimeoutMs = genericGroupMinSessionTimeoutMs;
        this.genericGroupMaxSessionTimeoutMs = genericGroupMaxSessionTimeoutMs;
    }

    public MetadataImage image() {
        return this.metadataImage;
    }

    public Group group(String groupId) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId, Long.MAX_VALUE);
        if (group == null) {
            throw new GroupIdNotFoundException(String.format("Group %s not found.", groupId));
        }
        return group;
    }

    public Group group(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId, committedOffset);
        if (group == null) {
            throw new GroupIdNotFoundException(String.format("Group %s not found.", groupId));
        }
        return group;
    }

    public List<ListGroupsResponseData.ListedGroup> listGroups(List<String> statesFilter, long committedOffset) {
        Stream<Object> groupStream = this.groups.values(committedOffset).stream();
        if (!statesFilter.isEmpty()) {
            groupStream = groupStream.filter(group -> statesFilter.contains(group.stateAsString(committedOffset)));
        }
        return groupStream.map(group -> group.asListedGroup(committedOffset)).collect(Collectors.toList());
    }

    public List<DescribeGroupsResponseData.DescribedGroup> describeGroups(List<String> groupIds, long committedOffset) {
        ArrayList<DescribeGroupsResponseData.DescribedGroup> describedGroups = new ArrayList<DescribeGroupsResponseData.DescribedGroup>();
        groupIds.forEach(groupId -> {
            try {
                GenericGroup group = this.genericGroup((String)groupId, committedOffset);
                if (group.isInState(GenericGroupState.STABLE)) {
                    if (!group.protocolName().isPresent()) {
                        throw new IllegalStateException("Invalid null group protocol for stable group");
                    }
                    describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(group.stateAsString()).setProtocolType(group.protocolType().orElse("")).setProtocolData(group.protocolName().get()).setMembers(group.allMembers().stream().map(member -> member.describe(group.protocolName().get())).collect(Collectors.toList())));
                } else {
                    describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(group.stateAsString()).setProtocolType(group.protocolType().orElse("")).setMembers(group.allMembers().stream().map(member -> member.describeNoMetadata()).collect(Collectors.toList())));
                }
            }
            catch (GroupIdNotFoundException exception) {
                describedGroups.add(new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setGroupState(GenericGroupState.DEAD.toString()));
            }
        });
        return describedGroups;
    }

    ConsumerGroup getOrMaybeCreateConsumerGroup(String groupId, boolean createIfNotExists) throws GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new GroupIdNotFoundException(String.format("Consumer group %s not found.", groupId));
        }
        if (group == null) {
            ConsumerGroup consumerGroup = new ConsumerGroup(this.snapshotRegistry, groupId);
            this.groups.put((Object)groupId, (Object)consumerGroup);
            return consumerGroup;
        }
        if (group.type() == Group.GroupType.CONSUMER) {
            return (ConsumerGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", groupId));
    }

    GenericGroup getOrMaybeCreateGenericGroup(String groupId, boolean createIfNotExists) throws UnknownMemberIdException, GroupIdNotFoundException {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group == null && !createIfNotExists) {
            throw new UnknownMemberIdException(String.format("Generic group %s not found.", groupId));
        }
        if (group == null) {
            GenericGroup genericGroup = new GenericGroup(this.logContext, groupId, GenericGroupState.EMPTY, this.time);
            this.groups.put((Object)groupId, (Object)genericGroup);
            return genericGroup;
        }
        if (group.type() == Group.GroupType.GENERIC) {
            return (GenericGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a generic group.", groupId));
    }

    public GenericGroup genericGroup(String groupId, long committedOffset) throws GroupIdNotFoundException {
        Group group = this.group(groupId, committedOffset);
        if (group.type() == Group.GroupType.GENERIC) {
            return (GenericGroup)group;
        }
        throw new GroupIdNotFoundException(String.format("Group %s is not a generic group.", groupId));
    }

    private void removeGroup(String groupId) {
        this.groups.remove((Object)groupId);
    }

    private void throwIfEmptyString(String value, String error) throws InvalidRequestException {
        if (value != null && value.isEmpty()) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfNotNull(Object value, String error) throws InvalidRequestException {
        if (value != null) {
            throw new InvalidRequestException(error);
        }
    }

    private void throwIfConsumerGroupHeartbeatRequestIsInvalid(ConsumerGroupHeartbeatRequestData request) throws InvalidRequestException, UnsupportedAssignorException {
        this.throwIfEmptyString(request.groupId(), "GroupId can't be empty.");
        this.throwIfEmptyString(request.instanceId(), "InstanceId can't be empty.");
        this.throwIfEmptyString(request.rackId(), "RackId can't be empty.");
        this.throwIfNotNull(request.subscribedTopicRegex(), "SubscribedTopicRegex is not supported yet.");
        if (request.memberEpoch() > 0 || request.memberEpoch() == -1) {
            this.throwIfEmptyString(request.memberId(), "MemberId can't be empty.");
        } else if (request.memberEpoch() == 0) {
            if (request.rebalanceTimeoutMs() == -1) {
                throw new InvalidRequestException("RebalanceTimeoutMs must be provided in first request.");
            }
            if (request.topicPartitions() == null || !request.topicPartitions().isEmpty()) {
                throw new InvalidRequestException("TopicPartitions must be empty when (re-)joining.");
            }
            if (request.subscribedTopicNames() == null || request.subscribedTopicNames().isEmpty()) {
                throw new InvalidRequestException("SubscribedTopicNames must be set in first request.");
            }
        } else {
            throw new InvalidRequestException("MemberEpoch is invalid.");
        }
        if (request.serverAssignor() != null && !this.assignors.containsKey(request.serverAssignor())) {
            throw new UnsupportedAssignorException("ServerAssignor " + request.serverAssignor() + " is not supported. Supported assignors: " + String.join((CharSequence)", ", this.assignors.keySet()) + ".");
        }
    }

    private boolean isSubset(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions, Map<Uuid, Set<Integer>> target) {
        if (ownedTopicPartitions == null) {
            return false;
        }
        for (ConsumerGroupHeartbeatRequestData.TopicPartitions topicPartitions : ownedTopicPartitions) {
            Set<Integer> partitions = target.get(topicPartitions.topicId());
            if (partitions == null) {
                return false;
            }
            for (Integer partitionId : topicPartitions.partitions()) {
                if (partitions.contains(partitionId)) continue;
                return false;
            }
        }
        return true;
    }

    private void throwIfConsumerGroupIsFull(ConsumerGroup group, String memberId) throws GroupMaxSizeReachedException {
        if (group.numMembers() >= this.consumerGroupMaxSize && (memberId.isEmpty() || !group.hasMember(memberId))) {
            throw new GroupMaxSizeReachedException("The consumer group has reached its maximum capacity of " + this.consumerGroupMaxSize + " members.");
        }
    }

    private void throwIfMemberEpochIsInvalid(ConsumerGroupMember member, int receivedMemberEpoch, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        if (receivedMemberEpoch > member.memberEpoch()) {
            throw new FencedMemberEpochException("The consumer group member has a greater member epoch (" + receivedMemberEpoch + ") than the one known by the group coordinator (" + member.memberEpoch() + "). The member must abandon all its partitions and rejoin.");
        }
        if (!(receivedMemberEpoch >= member.memberEpoch() || receivedMemberEpoch == member.previousMemberEpoch() && this.isSubset(ownedTopicPartitions, member.assignedPartitions()))) {
            throw new FencedMemberEpochException("The consumer group member has a smaller member epoch (" + receivedMemberEpoch + ") than the one known by the group coordinator (" + member.memberEpoch() + "). The member must abandon all its partitions and rejoin.");
        }
    }

    private ConsumerGroupHeartbeatResponseData.Assignment createResponseAssignment(ConsumerGroupMember member) {
        return new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(this.fromAssignmentMap(member.assignedPartitions()));
    }

    private List<ConsumerGroupHeartbeatResponseData.TopicPartitions> fromAssignmentMap(Map<Uuid, Set<Integer>> assignment) {
        return assignment.entrySet().stream().map(keyValue -> new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)keyValue.getKey()).setPartitions(new ArrayList((Collection)keyValue.getValue()))).collect(Collectors.toList());
    }

    private CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> consumerGroupHeartbeat(String groupId, String memberId, int memberEpoch, String instanceId, String rackId, int rebalanceTimeoutMs, String clientId, String clientHost, List<String> subscribedTopicNames, String subscribedTopicRegex, String assignorName, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) throws ApiException {
        long currentTimeMs = this.time.milliseconds();
        ArrayList<Record> records = new ArrayList<Record>();
        boolean createIfNotExists = memberEpoch == 0;
        ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, createIfNotExists);
        this.throwIfConsumerGroupIsFull(group, memberId);
        if (memberId.isEmpty()) {
            memberId = Uuid.randomUuid().toString();
        }
        ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, createIfNotExists);
        this.throwIfMemberEpochIsInvalid(member, memberEpoch, ownedTopicPartitions);
        if (memberEpoch == 0) {
            this.log.info("[GroupId {}] Member {} joins the consumer group.", (Object)groupId, (Object)memberId);
        }
        int groupEpoch = group.groupEpoch();
        Map<String, TopicMetadata> subscriptionMetadata = group.subscriptionMetadata();
        ConsumerGroupMember updatedMember = new ConsumerGroupMember.Builder(member).maybeUpdateInstanceId(Optional.ofNullable(instanceId)).maybeUpdateRackId(Optional.ofNullable(rackId)).maybeUpdateRebalanceTimeoutMs(Utils.ofSentinel(rebalanceTimeoutMs)).maybeUpdateServerAssignorName(Optional.ofNullable(assignorName)).maybeUpdateSubscribedTopicNames(Optional.ofNullable(subscribedTopicNames)).maybeUpdateSubscribedTopicRegex(Optional.ofNullable(subscribedTopicRegex)).setClientId(clientId).setClientHost(clientHost).build();
        boolean bumpGroupEpoch = false;
        if (!updatedMember.equals(member)) {
            records.add(RecordHelpers.newMemberSubscriptionRecord(groupId, updatedMember));
            if (!updatedMember.subscribedTopicNames().equals(member.subscribedTopicNames())) {
                this.log.info("[GroupId {}] Member {} updated its subscribed topics to: {}.", new Object[]{groupId, memberId, updatedMember.subscribedTopicNames()});
                bumpGroupEpoch = true;
            }
            if (!updatedMember.subscribedTopicRegex().equals(member.subscribedTopicRegex())) {
                this.log.info("[GroupId {}] Member {} updated its subscribed regex to: {}.", new Object[]{groupId, memberId, updatedMember.subscribedTopicRegex()});
                bumpGroupEpoch = true;
            }
        }
        if (bumpGroupEpoch || group.hasMetadataExpired(currentTimeMs)) {
            subscriptionMetadata = group.computeSubscriptionMetadata(member, updatedMember, this.metadataImage.topics(), this.metadataImage.cluster());
            if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
                this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)groupId, subscriptionMetadata);
                bumpGroupEpoch = true;
                records.add(RecordHelpers.newGroupSubscriptionMetadataRecord(groupId, subscriptionMetadata));
            }
            if (bumpGroupEpoch) {
                records.add(RecordHelpers.newGroupEpochRecord(groupId, ++groupEpoch));
                this.log.info("[GroupId {}] Bumped group epoch to {}.", (Object)groupId, (Object)groupEpoch);
            }
            group.setMetadataRefreshDeadline(currentTimeMs + (long)this.consumerGroupMetadataRefreshIntervalMs, groupEpoch);
        }
        int targetAssignmentEpoch = group.assignmentEpoch();
        Assignment targetAssignment = group.targetAssignment(memberId);
        if (groupEpoch > targetAssignmentEpoch) {
            String preferredServerAssignor = group.computePreferredServerAssignor(member, updatedMember).orElse(this.defaultAssignor.name());
            try {
                TargetAssignmentBuilder.TargetAssignmentResult assignmentResult = new TargetAssignmentBuilder(groupId, groupEpoch, this.assignors.get(preferredServerAssignor)).withMembers(group.members()).withSubscriptionMetadata(subscriptionMetadata).withTargetAssignment(group.targetAssignment()).addOrUpdateMember(memberId, updatedMember).build();
                this.log.info("[GroupId {}] Computed a new target assignment for epoch {}: {}.", new Object[]{groupId, groupEpoch, assignmentResult.targetAssignment()});
                records.addAll(assignmentResult.records());
                targetAssignment = assignmentResult.targetAssignment().get(memberId);
                targetAssignmentEpoch = groupEpoch;
            }
            catch (PartitionAssignorException ex) {
                String msg = String.format("Failed to compute a new target assignment for epoch %d: %s", groupEpoch, ex.getMessage());
                this.log.error("[GroupId {}] {}.", (Object)groupId, (Object)msg);
                throw new UnknownServerException(msg, (Throwable)((Object)ex));
            }
        }
        boolean assignmentUpdated = false;
        if (updatedMember.state() != ConsumerGroupMember.MemberState.STABLE || updatedMember.targetMemberEpoch() != targetAssignmentEpoch) {
            ConsumerGroupMember prevMember = updatedMember;
            if ((updatedMember = new CurrentAssignmentBuilder(updatedMember).withTargetAssignment(targetAssignmentEpoch, targetAssignment).withCurrentPartitionEpoch(group::currentPartitionEpoch).withOwnedTopicPartitions(ownedTopicPartitions).build()) != prevMember) {
                assignmentUpdated = true;
                records.add(RecordHelpers.newCurrentAssignmentRecord(groupId, updatedMember));
                this.log.info("[GroupId {}] Member {} transitioned from {} to {}.", new Object[]{groupId, memberId, member.currentAssignmentSummary(), updatedMember.currentAssignmentSummary()});
                if (updatedMember.state() == ConsumerGroupMember.MemberState.REVOKING) {
                    this.scheduleConsumerGroupRevocationTimeout(groupId, memberId, updatedMember.rebalanceTimeoutMs(), updatedMember.memberEpoch());
                } else {
                    this.cancelConsumerGroupRevocationTimeout(groupId, memberId);
                }
            }
        }
        this.scheduleConsumerGroupSessionTimeout(groupId, memberId);
        ConsumerGroupHeartbeatResponseData response = new ConsumerGroupHeartbeatResponseData().setMemberId(updatedMember.memberId()).setMemberEpoch(updatedMember.memberEpoch()).setHeartbeatIntervalMs(this.consumerGroupHeartbeatIntervalMs);
        if (ownedTopicPartitions != null || memberEpoch == 0 || assignmentUpdated) {
            response.setAssignment(this.createResponseAssignment(updatedMember));
        }
        return new CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record>(records, response);
    }

    private CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> consumerGroupLeave(String groupId, String memberId) throws ApiException {
        ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, false);
        ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
        this.log.info("[GroupId " + groupId + "] Member " + memberId + " left the consumer group.");
        List<Record> records = this.consumerGroupFenceMember(group, member);
        return new CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record>(records, new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(-1));
    }

    private List<Record> consumerGroupFenceMember(ConsumerGroup group, ConsumerGroupMember member) {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(RecordHelpers.newCurrentAssignmentTombstoneRecord(group.groupId(), member.memberId()));
        records.add(RecordHelpers.newTargetAssignmentTombstoneRecord(group.groupId(), member.memberId()));
        records.add(RecordHelpers.newMemberSubscriptionTombstoneRecord(group.groupId(), member.memberId()));
        Map<String, TopicMetadata> subscriptionMetadata = group.computeSubscriptionMetadata(member, null, this.metadataImage.topics(), this.metadataImage.cluster());
        if (!subscriptionMetadata.equals(group.subscriptionMetadata())) {
            this.log.info("[GroupId {}] Computed new subscription metadata: {}.", (Object)group.groupId(), subscriptionMetadata);
            records.add(RecordHelpers.newGroupSubscriptionMetadataRecord(group.groupId(), subscriptionMetadata));
        }
        int groupEpoch = group.groupEpoch() + 1;
        records.add(RecordHelpers.newGroupEpochRecord(group.groupId(), groupEpoch));
        this.cancelConsumerGroupSessionTimeout(group.groupId(), member.memberId());
        this.cancelConsumerGroupRevocationTimeout(group.groupId(), member.memberId());
        return records;
    }

    private void scheduleConsumerGroupSessionTimeout(String groupId, String memberId) {
        String key = GroupMetadataManager.consumerGroupSessionTimeoutKey(groupId, memberId);
        this.timer.schedule(key, this.consumerGroupSessionTimeoutMs, TimeUnit.MILLISECONDS, true, () -> {
            try {
                ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, false);
                ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
                this.log.info("[GroupId {}] Member {} fenced from the group because its session expired.", (Object)groupId, (Object)memberId);
                return new CoordinatorResult(this.consumerGroupFenceMember(group, member));
            }
            catch (GroupIdNotFoundException ex) {
                this.log.debug("[GroupId {}] Could not fence {} because the group does not exist.", (Object)groupId, (Object)memberId);
            }
            catch (UnknownMemberIdException ex) {
                this.log.debug("[GroupId {}] Could not fence {} because the member does not exist.", (Object)groupId, (Object)memberId);
            }
            return new CoordinatorResult(Collections.emptyList());
        });
    }

    private void cancelConsumerGroupSessionTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.consumerGroupSessionTimeoutKey(groupId, memberId));
    }

    private void scheduleConsumerGroupRevocationTimeout(String groupId, String memberId, long revocationTimeoutMs, int expectedMemberEpoch) {
        String key = GroupMetadataManager.consumerGroupRevocationTimeoutKey(groupId, memberId);
        this.timer.schedule(key, revocationTimeoutMs, TimeUnit.MILLISECONDS, true, () -> {
            try {
                ConsumerGroup group = this.getOrMaybeCreateConsumerGroup(groupId, false);
                ConsumerGroupMember member = group.getOrMaybeCreateMember(memberId, false);
                if (member.state() != ConsumerGroupMember.MemberState.REVOKING || member.memberEpoch() != expectedMemberEpoch) {
                    this.log.debug("[GroupId {}] Ignoring revocation timeout for {} because the member state does not match the expected state.", (Object)groupId, (Object)memberId);
                    return new CoordinatorResult(Collections.emptyList());
                }
                this.log.info("[GroupId {}] Member {} fenced from the group because it failed to revoke partitions within {}ms.", new Object[]{groupId, memberId, revocationTimeoutMs});
                return new CoordinatorResult(this.consumerGroupFenceMember(group, member));
            }
            catch (GroupIdNotFoundException ex) {
                this.log.debug("[GroupId {}] Could not fence {}} because the group does not exist.", (Object)groupId, (Object)memberId);
            }
            catch (UnknownMemberIdException ex) {
                this.log.debug("[GroupId {}] Could not fence {} because the member does not exist.", (Object)groupId, (Object)memberId);
            }
            return new CoordinatorResult(Collections.emptyList());
        });
    }

    private void cancelConsumerGroupRevocationTimeout(String groupId, String memberId) {
        this.timer.cancel(GroupMetadataManager.consumerGroupRevocationTimeoutKey(groupId, memberId));
    }

    public CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) throws ApiException {
        this.throwIfConsumerGroupHeartbeatRequestIsInvalid(request);
        if (request.memberEpoch() == -1) {
            return this.consumerGroupLeave(request.groupId(), request.memberId());
        }
        return this.consumerGroupHeartbeat(request.groupId(), request.memberId(), request.memberEpoch(), request.instanceId(), request.rackId(), request.rebalanceTimeoutMs(), context.clientId(), context.clientAddress.toString(), request.subscribedTopicNames(), request.subscribedTopicRegex(), request.serverAssignor(), request.topicPartitions());
    }

    public void replay(ConsumerGroupMemberMetadataKey key, ConsumerGroupMemberMetadataValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, value != null);
        HashSet<String> oldSubscribedTopicNames = new HashSet<String>(consumerGroup.subscribedTopicNames());
        if (value != null) {
            ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, true);
            consumerGroup.updateMember(new ConsumerGroupMember.Builder(oldMember).updateWith(value).build());
        } else {
            ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, false);
            if (oldMember.memberEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " but did not receive ConsumerGroupCurrentMemberAssignmentValue tombstone.");
            }
            if (consumerGroup.targetAssignment().containsKey(memberId)) {
                throw new IllegalStateException("Received a tombstone record to delete member " + memberId + " but did not receive ConsumerGroupTargetAssignmentMetadataValue tombstone.");
            }
            consumerGroup.removeMember(memberId);
        }
        this.updateGroupsByTopics(groupId, oldSubscribedTopicNames, consumerGroup.subscribedTopicNames());
    }

    public Set<String> groupsSubscribedToTopic(String topicName) {
        Set<String> groups = (Set<String>)this.groupsByTopics.get((Object)topicName);
        return groups != null ? groups : Collections.emptySet();
    }

    private void subscribeGroupToTopic(String groupId, String topicName) {
        ((TimelineHashSet)this.groupsByTopics.computeIfAbsent((Object)topicName, __ -> new TimelineHashSet(this.snapshotRegistry, 1))).add((Object)groupId);
    }

    private void unsubscribeGroupFromTopic(String groupId, String topicName) {
        this.groupsByTopics.computeIfPresent((Object)topicName, (__, groupIds) -> {
            groupIds.remove((Object)groupId);
            return groupIds.isEmpty() ? null : groupIds;
        });
    }

    private void updateGroupsByTopics(String groupId, Set<String> oldSubscribedTopics, Set<String> newSubscribedTopics) {
        if (oldSubscribedTopics.isEmpty()) {
            newSubscribedTopics.forEach(topicName -> this.subscribeGroupToTopic(groupId, (String)topicName));
        } else if (newSubscribedTopics.isEmpty()) {
            oldSubscribedTopics.forEach(topicName -> this.unsubscribeGroupFromTopic(groupId, (String)topicName));
        } else {
            oldSubscribedTopics.forEach(topicName -> {
                if (!newSubscribedTopics.contains(topicName)) {
                    this.unsubscribeGroupFromTopic(groupId, (String)topicName);
                }
            });
            newSubscribedTopics.forEach(topicName -> {
                if (!oldSubscribedTopics.contains(topicName)) {
                    this.subscribeGroupToTopic(groupId, (String)topicName);
                }
            });
        }
    }

    public void replay(ConsumerGroupMetadataKey key, ConsumerGroupMetadataValue value) {
        String groupId = key.groupId();
        if (value != null) {
            ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, true);
            consumerGroup.setGroupEpoch(value.epoch());
        } else {
            ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
            if (!consumerGroup.members().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the group still has " + consumerGroup.members().size() + " members.");
            }
            if (!consumerGroup.targetAssignment().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but the target assignment still has " + consumerGroup.targetAssignment().size() + " members.");
            }
            if (consumerGroup.assignmentEpoch() != -1) {
                throw new IllegalStateException("Received a tombstone record to delete group " + groupId + " but did not receive ConsumerGroupTargetAssignmentMetadataValue tombstone.");
            }
            this.removeGroup(groupId);
        }
    }

    public void replay(ConsumerGroupPartitionMetadataKey key, ConsumerGroupPartitionMetadataValue value) {
        String groupId = key.groupId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        if (value != null) {
            HashMap<String, TopicMetadata> subscriptionMetadata = new HashMap<String, TopicMetadata>();
            value.topics().forEach(topicMetadata -> subscriptionMetadata.put(topicMetadata.topicName(), TopicMetadata.fromRecord(topicMetadata)));
            consumerGroup.setSubscriptionMetadata(subscriptionMetadata);
        } else {
            consumerGroup.setSubscriptionMetadata(Collections.emptyMap());
        }
    }

    public void replay(ConsumerGroupTargetAssignmentMemberKey key, ConsumerGroupTargetAssignmentMemberValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        if (value != null) {
            consumerGroup.updateTargetAssignment(memberId, Assignment.fromRecord(value));
        } else {
            consumerGroup.removeTargetAssignment(memberId);
        }
    }

    public void replay(ConsumerGroupTargetAssignmentMetadataKey key, ConsumerGroupTargetAssignmentMetadataValue value) {
        String groupId = key.groupId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        if (value != null) {
            consumerGroup.setTargetAssignmentEpoch(value.assignmentEpoch());
        } else {
            if (!consumerGroup.targetAssignment().isEmpty()) {
                throw new IllegalStateException("Received a tombstone record to delete target assignment of " + groupId + " but the assignment still has " + consumerGroup.targetAssignment().size() + " members.");
            }
            consumerGroup.setTargetAssignmentEpoch(-1);
        }
    }

    public void replay(ConsumerGroupCurrentMemberAssignmentKey key, ConsumerGroupCurrentMemberAssignmentValue value) {
        String groupId = key.groupId();
        String memberId = key.memberId();
        ConsumerGroup consumerGroup = this.getOrMaybeCreateConsumerGroup(groupId, false);
        ConsumerGroupMember oldMember = consumerGroup.getOrMaybeCreateMember(memberId, false);
        if (value != null) {
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(oldMember).updateWith(value).build();
            consumerGroup.updateMember(newMember);
        } else {
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(oldMember).setMemberEpoch(-1).setPreviousMemberEpoch(-1).setTargetMemberEpoch(-1).setAssignedPartitions(Collections.emptyMap()).setPartitionsPendingRevocation(Collections.emptyMap()).setPartitionsPendingAssignment(Collections.emptyMap()).build();
            consumerGroup.updateMember(newMember);
        }
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.metadataImage = newImage;
        Optional.ofNullable(delta.topicsDelta()).ifPresent(topicsDelta -> {
            HashSet allGroupIds = new HashSet();
            topicsDelta.changedTopics().forEach((topicId, topicDelta) -> {
                String topicName = topicDelta.name();
                allGroupIds.addAll(this.groupsSubscribedToTopic(topicName));
            });
            topicsDelta.deletedTopicIds().forEach(topicId -> {
                TopicImage topicImage = delta.image().topics().getTopic(topicId);
                allGroupIds.addAll(this.groupsSubscribedToTopic(topicImage.name()));
            });
            allGroupIds.forEach(groupId -> {
                Group group = (Group)this.groups.get(groupId);
                if (group != null && group.type() == Group.GroupType.CONSUMER) {
                    ((ConsumerGroup)group).requestMetadataRefresh();
                }
            });
        });
    }

    public void onLoaded() {
        this.groups.forEach((groupId, group) -> {
            switch (group.type()) {
                case CONSUMER: {
                    ConsumerGroup consumerGroup = (ConsumerGroup)group;
                    this.log.info("Loaded consumer group {} with {} members.", groupId, (Object)consumerGroup.members().size());
                    consumerGroup.members().forEach((memberId, member) -> {
                        this.log.debug("Loaded member {} in consumer group {}.", memberId, groupId);
                        this.scheduleConsumerGroupSessionTimeout((String)groupId, (String)memberId);
                        if (member.state() == ConsumerGroupMember.MemberState.REVOKING) {
                            this.scheduleConsumerGroupRevocationTimeout((String)groupId, (String)memberId, member.rebalanceTimeoutMs(), member.memberEpoch());
                        }
                    });
                    break;
                }
                case GENERIC: {
                    GenericGroup genericGroup = (GenericGroup)group;
                    this.log.info("Loaded generic group {} with {} members.", groupId, (Object)genericGroup.allMembers().size());
                    genericGroup.allMembers().forEach(member -> {
                        this.log.debug("Loaded member {} in generic group {}.", (Object)member.memberId(), groupId);
                        this.rescheduleGenericGroupMemberHeartbeat(genericGroup, (GenericGroupMember)member);
                    });
                    if (genericGroup.size() <= this.genericGroupMaxSize) break;
                    this.prepareRebalance(genericGroup, "Freshly-loaded group " + groupId + " (size " + genericGroup.size() + ") is over capacity " + this.genericGroupMaxSize + ". Rebalancing in order to give a chance for consumers to commit offsets");
                }
            }
        });
    }

    public static String consumerGroupSessionTimeoutKey(String groupId, String memberId) {
        return "session-timeout-" + groupId + "-" + memberId;
    }

    public static String consumerGroupRevocationTimeoutKey(String groupId, String memberId) {
        return "revocation-timeout-" + groupId + "-" + memberId;
    }

    public void replay(GroupMetadataKey key, GroupMetadataValue value) {
        String groupId = key.group();
        if (value == null) {
            this.removeGroup(groupId);
        } else {
            ArrayList<GenericGroupMember> loadedMembers = new ArrayList<GenericGroupMember>();
            for (GroupMetadataValue.MemberMetadata member2 : value.members()) {
                int rebalanceTimeout = member2.rebalanceTimeout() == -1 ? member2.sessionTimeout() : member2.rebalanceTimeout();
                JoinGroupRequestData.JoinGroupRequestProtocolCollection supportedProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
                supportedProtocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName(value.protocol()).setMetadata(member2.subscription()));
                GenericGroupMember loadedMember = new GenericGroupMember(member2.memberId(), Optional.ofNullable(member2.groupInstanceId()), member2.clientId(), member2.clientHost(), rebalanceTimeout, member2.sessionTimeout(), value.protocolType(), supportedProtocols, member2.assignment());
                loadedMembers.add(loadedMember);
            }
            String protocolType = value.protocolType();
            GenericGroup genericGroup = new GenericGroup(this.logContext, groupId, loadedMembers.isEmpty() ? GenericGroupState.EMPTY : GenericGroupState.STABLE, this.time, value.generation(), protocolType == null || protocolType.isEmpty() ? Optional.empty() : Optional.of(protocolType), Optional.ofNullable(value.protocol()), Optional.ofNullable(value.leader()), value.currentStateTimestamp() == -1L ? Optional.empty() : Optional.of(value.currentStateTimestamp()));
            loadedMembers.forEach(member -> genericGroup.add((GenericGroupMember)member, null));
            this.groups.put((Object)groupId, (Object)genericGroup);
            genericGroup.setSubscribedTopics(genericGroup.computeSubscribedTopics());
        }
    }

    public CoordinatorResult<Void, Record> genericGroupJoin(RequestContext context, JoinGroupRequestData request, CompletableFuture<JoinGroupResponseData> responseFuture) {
        CoordinatorResult<Void, Record> result = EMPTY_RESULT;
        String groupId = request.groupId();
        String memberId = request.memberId();
        int sessionTimeoutMs = request.sessionTimeoutMs();
        if (sessionTimeoutMs < this.genericGroupMinSessionTimeoutMs || sessionTimeoutMs > this.genericGroupMaxSessionTimeoutMs) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.INVALID_SESSION_TIMEOUT.code()));
        } else {
            GenericGroup group;
            boolean isUnknownMember = memberId.equals("");
            boolean isNewGroup = !this.groups.containsKey((Object)groupId);
            try {
                group = this.getOrMaybeCreateGenericGroup(groupId, isUnknownMember);
            }
            catch (Throwable t2) {
                responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.forException((Throwable)t2).code()));
                return EMPTY_RESULT;
            }
            if (!this.acceptJoiningMember(group, memberId)) {
                group.remove(memberId);
                responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.GROUP_MAX_SIZE_REACHED.code()));
            } else {
                result = isUnknownMember ? this.genericGroupJoinNewMember(context, request, group, responseFuture) : this.genericGroupJoinExistingMember(context, request, group, responseFuture);
            }
            if (isNewGroup && result == EMPTY_RESULT) {
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        this.log.warn("Failed to write empty metadata for group {}: {}", (Object)group.groupId(), (Object)t.getMessage());
                        responseFuture.complete(new JoinGroupResponseData().setErrorCode(GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t)).code()));
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newEmptyGroupMetadataRecord(group, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
        }
        return result;
    }

    private CoordinatorResult<Void, Record> maybeCompleteJoinPhase(GenericGroup group) {
        if (group.isInState(GenericGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined() && group.previousState() != GenericGroupState.EMPTY) {
            return this.completeGenericGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> genericGroupJoinNewMember(RequestContext context, JoinGroupRequestData request, GenericGroup group, CompletableFuture<JoinGroupResponseData> responseFuture) {
        if (group.isInState(GenericGroupState.DEAD)) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        } else if (!group.supportsProtocols(request.protocolType(), request.protocols())) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()));
        } else {
            Optional<String> groupInstanceId = Optional.ofNullable(request.groupInstanceId());
            String newMemberId = group.generateMemberId(context.clientId(), groupInstanceId);
            if (groupInstanceId.isPresent()) {
                return this.genericGroupJoinNewStaticMember(context, request, group, newMemberId, responseFuture);
            }
            return this.genericGroupJoinNewDynamicMember(context, request, group, newMemberId, responseFuture);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> genericGroupJoinNewStaticMember(RequestContext context, JoinGroupRequestData request, GenericGroup group, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String groupInstanceId = request.groupInstanceId();
        String existingMemberId = group.staticMemberId(groupInstanceId);
        if (existingMemberId != null) {
            this.log.info("Static member with groupInstanceId={} and unknown member id joins group {} in {} state. Replacing previously mapped member {} with this groupInstanceId.", new Object[]{groupInstanceId, group.groupId(), group.currentState(), existingMemberId});
            return this.updateStaticMemberThenRebalanceOrCompleteJoin(context, request, group, existingMemberId, newMemberId, responseFuture);
        }
        this.log.info("Static member with groupInstanceId={} and unknown member id joins group {} in {} state. Created a new member id {} for this member and added to the group.", new Object[]{groupInstanceId, group.groupId(), group.currentState(), newMemberId});
        return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, newMemberId, responseFuture);
    }

    private CoordinatorResult<Void, Record> genericGroupJoinNewDynamicMember(RequestContext context, JoinGroupRequestData request, GenericGroup group, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        if (!JoinGroupRequest.requiresKnownMemberId((short)context.apiVersion())) {
            this.log.info("Dynamic member with unknown member id joins group {} in state {}. Created a new member id {} and added the member to the group.", new Object[]{group.groupId(), group.currentState(), newMemberId});
            return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, newMemberId, responseFuture);
        }
        this.log.info("Dynamic member with unknown member id joins group {} in {} state. Created a new member id {} and requesting the member to rejoin with this id.", new Object[]{group.groupId(), group.currentState(), newMemberId});
        group.addPendingMember(newMemberId);
        String genericGroupHeartbeatKey = GroupMetadataManager.genericGroupHeartbeatKey(group.groupId(), newMemberId);
        this.timer.schedule(genericGroupHeartbeatKey, request.sessionTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.expireGenericGroupMemberHeartbeat(group, newMemberId));
        responseFuture.complete(new JoinGroupResponseData().setMemberId(newMemberId).setErrorCode(Errors.MEMBER_ID_REQUIRED.code()));
        return EMPTY_RESULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoordinatorResult<Void, Record> genericGroupJoinExistingMember(RequestContext context, JoinGroupRequestData request, GenericGroup group, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String memberId = request.memberId();
        String groupInstanceId = request.groupInstanceId();
        if (group.isInState(GenericGroupState.DEAD)) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            return EMPTY_RESULT;
        }
        if (!group.supportsProtocols(request.protocolType(), request.protocols())) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()));
            return EMPTY_RESULT;
        }
        if (group.isPendingMember(memberId)) {
            if (groupInstanceId != null) {
                throw new IllegalStateException("Received unexpected JoinGroup with groupInstanceId=" + groupInstanceId + " for pending member with memberId=" + memberId);
            }
            this.log.debug("Pending dynamic member with id {} joins group {} in {} state. Adding to the group now.", new Object[]{memberId, group.groupId(), group.currentState()});
            return this.addMemberThenRebalanceOrCompleteJoin(context, request, group, memberId, responseFuture);
        }
        try {
            group.validateMember(memberId, groupInstanceId, "join-group");
        }
        catch (KafkaException ex) {
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.forException((Throwable)ex).code()).setProtocolType(null).setProtocolName(null));
            return EMPTY_RESULT;
        }
        GenericGroupMember member = group.member(memberId);
        if (group.isInState(GenericGroupState.PREPARING_REBALANCE)) {
            return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Member " + member.memberId() + " is joining group during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
        }
        if (group.isInState(GenericGroupState.COMPLETING_REBALANCE)) {
            if (!member.matches(request.protocols())) return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Updating metadata for member " + memberId + " during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            responseFuture.complete(new JoinGroupResponseData().setMembers(group.isLeader(memberId) ? group.currentGenericGroupMembers() : Collections.emptyList()).setMemberId(memberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false));
            return EMPTY_RESULT;
        } else if (group.isInState(GenericGroupState.STABLE)) {
            if (group.isLeader(memberId)) {
                return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Leader " + memberId + " re-joining group during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            }
            if (!member.matches(request.protocols())) {
                return this.updateMemberThenRebalanceOrCompleteJoin(request, group, member, "Updating metadata for member " + memberId + " during " + group.stateAsString() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request), responseFuture);
            }
            responseFuture.complete(new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId(memberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false));
            return EMPTY_RESULT;
        } else {
            this.log.warn("Attempt to add rejoining member {} of group {} in unexpected group state {}", new Object[]{memberId, group.groupId(), group.stateAsString()});
            responseFuture.complete(new JoinGroupResponseData().setMemberId(memberId).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> completeGenericGroupJoin(GenericGroup group) {
        this.timer.cancel(GroupMetadataManager.genericGroupJoinKey(group.groupId()));
        String groupId = group.groupId();
        Map<String, GenericGroupMember> notYetRejoinedDynamicMembers = group.notYetRejoinedMembers().entrySet().stream().filter(entry -> !((GenericGroupMember)entry.getValue()).isStaticMember()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!notYetRejoinedDynamicMembers.isEmpty()) {
            notYetRejoinedDynamicMembers.values().forEach(failedMember -> {
                group.remove(failedMember.memberId());
                this.timer.cancel(GroupMetadataManager.genericGroupHeartbeatKey(group.groupId(), failedMember.memberId()));
            });
            this.log.info("Group {} removed dynamic members who haven't joined: {}", (Object)groupId, notYetRejoinedDynamicMembers.keySet());
        }
        if (group.isInState(GenericGroupState.DEAD)) {
            this.log.info("Group {} is dead, skipping rebalance stage.", (Object)groupId);
        } else {
            if (!group.maybeElectNewJoinedLeader() && !group.allMembers().isEmpty()) {
                this.log.error("Group {} could not complete rebalance because no members rejoined.", (Object)groupId);
                this.timer.schedule(GroupMetadataManager.genericGroupJoinKey(groupId), group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.completeGenericGroupJoin(group));
                return EMPTY_RESULT;
            }
            group.initNextGeneration();
            if (group.isInState(GenericGroupState.EMPTY)) {
                this.log.info("Group {} with generation {} is now empty.", (Object)groupId, (Object)group.generationId());
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        this.log.warn("Failed to write empty metadata for group {}: {}", (Object)group.groupId(), (Object)t.getMessage());
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newGroupMetadataRecord(group, Collections.emptyMap(), this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
            this.log.info("Stabilized group {} generation {} with {} members.", new Object[]{groupId, group.generationId(), group.size()});
            group.allMembers().forEach(member -> {
                List<Object> members = Collections.emptyList();
                if (group.isLeader(member.memberId())) {
                    members = group.currentGenericGroupMembers();
                }
                JoinGroupResponseData response = new JoinGroupResponseData().setMembers(members).setMemberId(member.memberId()).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(false).setErrorCode(Errors.NONE.code());
                group.completeJoinFuture((GenericGroupMember)member, response);
                this.rescheduleGenericGroupMemberHeartbeat(group, (GenericGroupMember)member);
                member.setIsNew(false);
                group.addPendingSyncMember(member.memberId());
            });
            this.schedulePendingSync(group);
        }
        return EMPTY_RESULT;
    }

    private void schedulePendingSync(GenericGroup group) {
        this.timer.schedule(GroupMetadataManager.genericGroupSyncKey(group.groupId()), group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.expirePendingSync(group, group.generationId()));
    }

    private CoordinatorResult<Void, Record> expireGenericGroupMemberHeartbeat(GenericGroup group, String memberId) {
        if (group.isInState(GenericGroupState.DEAD)) {
            this.log.info("Received notification of heartbeat expiration for member {} after group {} had already been unloaded or deleted.", (Object)memberId, (Object)group.groupId());
        } else {
            if (group.isPendingMember(memberId)) {
                this.log.info("Pending member {} in group {} has been removed after session timeout expiration.", (Object)memberId, (Object)group.groupId());
                return this.removePendingMemberAndUpdateGenericGroup(group, memberId);
            }
            if (!group.hasMemberId(memberId)) {
                this.log.debug("Member {} has already been removed from the group.", (Object)memberId);
            } else {
                GenericGroupMember member = group.member(memberId);
                if (!member.hasSatisfiedHeartbeat()) {
                    this.log.info("Member {} in group {} has failed, removing it from the group.", (Object)member.memberId(), (Object)group.groupId());
                    return this.removeMemberAndUpdateGenericGroup(group, member, "removing member " + member.memberId() + " on heartbeat expiration.");
                }
            }
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> removeMemberAndUpdateGenericGroup(GenericGroup group, GenericGroupMember member, String reason) {
        group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        group.remove(member.memberId());
        if (group.isInState(GenericGroupState.STABLE) || group.isInState(GenericGroupState.COMPLETING_REBALANCE)) {
            return this.maybePrepareRebalanceOrCompleteJoin(group, reason);
        }
        if (group.isInState(GenericGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined()) {
            return this.completeGenericGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> removePendingMemberAndUpdateGenericGroup(GenericGroup group, String memberId) {
        group.remove(memberId);
        if (group.isInState(GenericGroupState.PREPARING_REBALANCE) && group.hasAllMembersJoined()) {
            return this.completeGenericGroupJoin(group);
        }
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> updateMemberThenRebalanceOrCompleteJoin(JoinGroupRequestData request, GenericGroup group, GenericGroupMember member, String joinReason, CompletableFuture<JoinGroupResponseData> responseFuture) {
        group.updateMember(member, request.protocols(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), responseFuture);
        return this.maybePrepareRebalanceOrCompleteJoin(group, joinReason);
    }

    private CoordinatorResult<Void, Record> addMemberThenRebalanceOrCompleteJoin(RequestContext context, JoinGroupRequestData request, GenericGroup group, String memberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        Optional<String> groupInstanceId = Optional.ofNullable(request.groupInstanceId());
        GenericGroupMember member = new GenericGroupMember(memberId, groupInstanceId, context.clientId(), context.clientAddress().toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), request.protocols());
        member.setIsNew(true);
        if (group.isInState(GenericGroupState.PREPARING_REBALANCE) && group.previousState() == GenericGroupState.EMPTY) {
            group.setNewMemberAdded(true);
        }
        group.add(member, responseFuture);
        this.rescheduleGenericGroupMemberHeartbeat(group, member, this.genericGroupNewMemberJoinTimeoutMs);
        return this.maybePrepareRebalanceOrCompleteJoin(group, "Adding new member " + memberId + " with group instance id " + request.groupInstanceId() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
    }

    private CoordinatorResult<Void, Record> maybePrepareRebalanceOrCompleteJoin(GenericGroup group, String reason) {
        if (group.canRebalance()) {
            return this.prepareRebalance(group, reason);
        }
        return this.maybeCompleteJoinPhase(group);
    }

    CoordinatorResult<Void, Record> prepareRebalance(GenericGroup group, String reason) {
        if (group.isInState(GenericGroupState.COMPLETING_REBALANCE)) {
            this.resetAndPropagateAssignmentWithError(group, Errors.REBALANCE_IN_PROGRESS);
        }
        this.removeSyncExpiration(group);
        boolean isInitialRebalance = group.isInState(GenericGroupState.EMPTY);
        if (isInitialRebalance) {
            int delayMs = this.genericGroupInitialRebalanceDelayMs;
            int remainingMs = Math.max(group.rebalanceTimeoutMs() - this.genericGroupInitialRebalanceDelayMs, 0);
            this.timer.schedule(GroupMetadataManager.genericGroupJoinKey(group.groupId()), delayMs, TimeUnit.MILLISECONDS, false, () -> this.tryCompleteInitialRebalanceElseSchedule(group, delayMs, remainingMs));
        }
        group.transitionTo(GenericGroupState.PREPARING_REBALANCE);
        this.log.info("Preparing to rebalance group {} in state {} with old generation {} (reason: {}).", new Object[]{group.groupId(), group.currentState(), group.generationId(), reason});
        return isInitialRebalance ? EMPTY_RESULT : this.maybeCompleteJoinElseSchedule(group);
    }

    private CoordinatorResult<Void, Record> maybeCompleteJoinElseSchedule(GenericGroup group) {
        String genericGroupJoinKey = GroupMetadataManager.genericGroupJoinKey(group.groupId());
        if (group.hasAllMembersJoined()) {
            return this.completeGenericGroupJoin(group);
        }
        this.timer.schedule(genericGroupJoinKey, group.rebalanceTimeoutMs(), TimeUnit.MILLISECONDS, false, () -> this.completeGenericGroupJoin(group));
        return EMPTY_RESULT;
    }

    private CoordinatorResult<Void, Record> tryCompleteInitialRebalanceElseSchedule(GenericGroup group, int delayMs, int remainingMs) {
        if (!group.newMemberAdded() || remainingMs == 0) {
            return this.completeGenericGroupJoin(group);
        }
        group.setNewMemberAdded(false);
        int newDelayMs = Math.min(this.genericGroupInitialRebalanceDelayMs, remainingMs);
        int newRemainingMs = Math.max(remainingMs - delayMs, 0);
        this.timer.schedule(GroupMetadataManager.genericGroupJoinKey(group.groupId()), newDelayMs, TimeUnit.MILLISECONDS, false, () -> this.tryCompleteInitialRebalanceElseSchedule(group, newDelayMs, newRemainingMs));
        return EMPTY_RESULT;
    }

    private void resetAndPropagateAssignmentWithError(GenericGroup group, Errors error) {
        if (!group.isInState(GenericGroupState.COMPLETING_REBALANCE)) {
            throw new IllegalStateException("Group " + group.groupId() + " must be in " + GenericGroupState.COMPLETING_REBALANCE.name() + " state but is in " + (Object)((Object)group.currentState()) + ".");
        }
        group.allMembers().forEach(member -> member.setAssignment(GenericGroupMember.EMPTY_ASSIGNMENT));
        this.propagateAssignment(group, error);
    }

    private void setAndPropagateAssignment(GenericGroup group, Map<String, byte[]> assignment) {
        if (!group.isInState(GenericGroupState.COMPLETING_REBALANCE)) {
            throw new IllegalStateException("The group must be in CompletingRebalance state to set and propagate assignment.");
        }
        group.allMembers().forEach(member -> member.setAssignment(assignment.getOrDefault(member.memberId(), GenericGroupMember.EMPTY_ASSIGNMENT)));
        this.propagateAssignment(group, Errors.NONE);
    }

    private void propagateAssignment(GenericGroup group, Errors error) {
        Optional<Object> protocolName = Optional.empty();
        Optional<Object> protocolType = Optional.empty();
        if (error == Errors.NONE) {
            protocolName = group.protocolName();
            protocolType = group.protocolType();
        }
        for (GenericGroupMember member : group.allMembers()) {
            if (!member.hasAssignment() && error == Errors.NONE) {
                this.log.warn("Sending empty assignment to member {} of {} for generation {} with no errors", new Object[]{member.memberId(), group.groupId(), group.generationId()});
            }
            if (!group.completeSyncFuture(member, new SyncGroupResponseData().setProtocolName((String)protocolName.orElse(null)).setProtocolType((String)protocolType.orElse(null)).setAssignment(member.assignment()).setErrorCode(error.code()))) continue;
            this.rescheduleGenericGroupMemberHeartbeat(group, member);
        }
    }

    public void rescheduleGenericGroupMemberHeartbeat(GenericGroup group, GenericGroupMember member) {
        this.rescheduleGenericGroupMemberHeartbeat(group, member, member.sessionTimeoutMs());
    }

    private void rescheduleGenericGroupMemberHeartbeat(GenericGroup group, GenericGroupMember member, long timeoutMs) {
        String genericGroupHeartbeatKey = GroupMetadataManager.genericGroupHeartbeatKey(group.groupId(), member.memberId());
        this.timer.schedule(genericGroupHeartbeatKey, timeoutMs, TimeUnit.MILLISECONDS, false, () -> this.expireGenericGroupMemberHeartbeat(group, member.memberId()));
    }

    private void removeSyncExpiration(GenericGroup group) {
        group.clearPendingSyncMembers();
        this.timer.cancel(GroupMetadataManager.genericGroupSyncKey(group.groupId()));
    }

    private CoordinatorResult<Void, Record> expirePendingSync(GenericGroup group, int generationId) {
        if (generationId != group.generationId()) {
            this.log.error("Received unexpected notification of sync expiration for {} with an old generation {} while the group has {}.", new Object[]{group.groupId(), generationId, group.generationId()});
        } else if (group.isInState(GenericGroupState.DEAD) || group.isInState(GenericGroupState.EMPTY) || group.isInState(GenericGroupState.PREPARING_REBALANCE)) {
            this.log.error("Received unexpected notification of sync expiration after group {} already transitioned to {} state.", (Object)group.groupId(), (Object)group.stateAsString());
        } else if ((group.isInState(GenericGroupState.COMPLETING_REBALANCE) || group.isInState(GenericGroupState.STABLE)) && !group.hasReceivedSyncFromAllMembers()) {
            HashSet<String> pendingSyncMembers = new HashSet<String>(group.allPendingSyncMembers());
            pendingSyncMembers.forEach(memberId -> {
                group.remove((String)memberId);
                this.timer.cancel(GroupMetadataManager.genericGroupHeartbeatKey(group.groupId(), memberId));
            });
            this.log.debug("Group {} removed members who haven't sent their sync requests: {}", (Object)group.groupId(), pendingSyncMembers);
            return this.prepareRebalance(group, "Removing " + pendingSyncMembers + " on pending sync request expiration");
        }
        return EMPTY_RESULT;
    }

    private boolean acceptJoiningMember(GenericGroup group, String memberId) {
        switch (group.currentState()) {
            case EMPTY: 
            case DEAD: {
                return true;
            }
            case PREPARING_REBALANCE: {
                return group.hasMemberId(memberId) && group.member(memberId).isAwaitingJoin() || group.numAwaitingJoinResponse() < this.genericGroupMaxSize;
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                return group.hasMemberId(memberId) || group.size() < this.genericGroupMaxSize;
            }
        }
        throw new IllegalStateException("Unknown group state: " + group.stateAsString());
    }

    private CoordinatorResult<Void, Record> updateStaticMemberThenRebalanceOrCompleteJoin(RequestContext context, JoinGroupRequestData request, GenericGroup group, String oldMemberId, String newMemberId, CompletableFuture<JoinGroupResponseData> responseFuture) {
        String currentLeader = group.leaderOrNull();
        GenericGroupMember newMember = group.replaceStaticMember(request.groupInstanceId(), oldMemberId, newMemberId);
        this.rescheduleGenericGroupMemberHeartbeat(group, newMember);
        int oldRebalanceTimeoutMs = newMember.rebalanceTimeoutMs();
        int oldSessionTimeoutMs = newMember.sessionTimeoutMs();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection oldProtocols = newMember.supportedProtocols();
        group.updateMember(newMember, request.protocols(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), responseFuture);
        if (group.isInState(GenericGroupState.STABLE)) {
            String groupInstanceId = request.groupInstanceId();
            String selectedProtocolForNextGeneration = group.selectProtocol();
            if (group.protocolName().orElse("").equals(selectedProtocolForNextGeneration)) {
                this.log.info("Static member which joins during Stable stage and doesn't affect the selected protocol will not trigger a rebalance.");
                Map<String, byte[]> groupAssignment = group.groupAssignment();
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (t != null) {
                        this.log.warn("Failed to persist metadata for group {} static member {} with group instance id {} due to {}. Reverting to old member id {}.", new Object[]{group.groupId(), newMemberId, groupInstanceId, t.getMessage(), oldMemberId});
                        group.updateMember(newMember, oldProtocols, oldRebalanceTimeoutMs, oldSessionTimeoutMs, null);
                        GenericGroupMember oldMember = group.replaceStaticMember(groupInstanceId, newMemberId, oldMemberId);
                        this.rescheduleGenericGroupMemberHeartbeat(group, oldMember);
                        responseFuture.complete(new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId("").setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(currentLeader).setSkipAssignment(false).setErrorCode(GroupMetadataManager.appendGroupMetadataErrorToResponseError(Errors.forException((Throwable)t)).code()));
                    } else if (JoinGroupRequest.supportsSkippingAssignment((short)context.apiVersion())) {
                        boolean isLeader = group.isLeader(newMemberId);
                        group.completeJoinFuture(newMember, new JoinGroupResponseData().setMembers(isLeader ? group.currentGenericGroupMembers() : Collections.emptyList()).setMemberId(newMemberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(group.leaderOrNull()).setSkipAssignment(isLeader));
                    } else {
                        group.completeJoinFuture(newMember, new JoinGroupResponseData().setMembers(Collections.emptyList()).setMemberId(newMemberId).setGenerationId(group.generationId()).setProtocolName((String)group.protocolName().orElse(null)).setProtocolType((String)group.protocolType().orElse(null)).setLeader(currentLeader).setSkipAssignment(false));
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newGroupMetadataRecord(group, groupAssignment, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
            return this.maybePrepareRebalanceOrCompleteJoin(group, "Group's selectedProtocol will change because static member " + newMember.memberId() + " with instance id " + groupInstanceId + " joined with change of protocol; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
        }
        if (group.isInState(GenericGroupState.COMPLETING_REBALANCE)) {
            return this.prepareRebalance(group, "Updating metadata for static member " + newMember.memberId() + " with instance id " + request.groupInstanceId() + "; client reason: " + JoinGroupRequest.joinReason((JoinGroupRequestData)request));
        }
        if (group.isInState(GenericGroupState.EMPTY) || group.isInState(GenericGroupState.DEAD)) {
            throw new IllegalStateException("Group " + group.groupId() + " was not supposed to be in the state " + group.stateAsString() + " when the unknown static member " + request.groupInstanceId() + " rejoins.");
        }
        return this.maybeCompleteJoinPhase(group);
    }

    public CoordinatorResult<Void, Record> genericGroupSync(RequestContext context, SyncGroupRequestData request, CompletableFuture<SyncGroupResponseData> responseFuture) throws UnknownMemberIdException, GroupIdNotFoundException {
        GenericGroup group;
        String groupId = request.groupId();
        String memberId = request.memberId();
        try {
            group = this.getOrMaybeCreateGenericGroup(groupId, false);
        }
        catch (Throwable t2) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.forException((Throwable)t2).code()));
            return EMPTY_RESULT;
        }
        Optional<Errors> errorOpt = this.validateSyncGroup(group, request);
        if (errorOpt.isPresent()) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(errorOpt.get().code()));
        } else if (group.isInState(GenericGroupState.EMPTY)) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        } else if (group.isInState(GenericGroupState.PREPARING_REBALANCE)) {
            responseFuture.complete(new SyncGroupResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code()));
        } else if (group.isInState(GenericGroupState.COMPLETING_REBALANCE)) {
            group.member(memberId).setAwaitingSyncFuture(responseFuture);
            this.removePendingSyncMember(group, request.memberId());
            if (group.isLeader(memberId)) {
                this.log.info("Assignment received from leader {} for group {} for generation {}. The group has {} members, {} of which are static.", new Object[]{memberId, groupId, group.generationId(), group.size(), group.allStaticMemberIds().size()});
                HashMap<String, byte[]> assignment = new HashMap<String, byte[]>();
                request.assignments().forEach(memberAssignment -> assignment.put(memberAssignment.memberId(), memberAssignment.assignment()));
                HashMap membersWithMissingAssignment = new HashMap();
                group.allMembers().forEach(member -> {
                    if (!assignment.containsKey(member.memberId())) {
                        membersWithMissingAssignment.put(member.memberId(), GenericGroupMember.EMPTY_ASSIGNMENT);
                    }
                });
                assignment.putAll(membersWithMissingAssignment);
                if (!membersWithMissingAssignment.isEmpty()) {
                    this.log.warn("Setting empty assignments for members {} of {} for generation {}.", new Object[]{membersWithMissingAssignment, groupId, group.generationId()});
                }
                CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
                appendFuture.whenComplete((__, t) -> {
                    if (group.isInState(GenericGroupState.COMPLETING_REBALANCE) && request.generationId() == group.generationId()) {
                        if (t != null) {
                            Errors error = Errors.forException((Throwable)t);
                            this.resetAndPropagateAssignmentWithError(group, error);
                            this.maybePrepareRebalanceOrCompleteJoin(group, "Error " + error + " when storing group assignmentduring SyncGroup (member: " + memberId + ").");
                        } else {
                            this.setAndPropagateAssignment(group, assignment);
                            group.transitionTo(GenericGroupState.STABLE);
                        }
                    }
                });
                List<Record> records = Collections.singletonList(RecordHelpers.newGroupMetadataRecord(group, assignment, this.metadataImage.features().metadataVersion()));
                return new CoordinatorResult<Void, Record>(records, appendFuture);
            }
        } else if (group.isInState(GenericGroupState.STABLE)) {
            this.removePendingSyncMember(group, memberId);
            GenericGroupMember member2 = group.member(memberId);
            responseFuture.complete(new SyncGroupResponseData().setProtocolType((String)group.protocolType().orElse(null)).setProtocolName((String)group.protocolName().orElse(null)).setAssignment(member2.assignment()).setErrorCode(Errors.NONE.code()));
        } else if (group.isInState(GenericGroupState.DEAD)) {
            throw new IllegalStateException("Reached unexpected condition for Dead group " + groupId);
        }
        return EMPTY_RESULT;
    }

    static Errors appendGroupMetadataErrorToResponseError(Errors appendError) {
        switch (appendError) {
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case NOT_ENOUGH_REPLICAS: {
                return Errors.COORDINATOR_NOT_AVAILABLE;
            }
            case NOT_LEADER_OR_FOLLOWER: 
            case KAFKA_STORAGE_ERROR: {
                return Errors.NOT_COORDINATOR;
            }
            case MESSAGE_TOO_LARGE: 
            case RECORD_LIST_TOO_LARGE: 
            case INVALID_FETCH_SIZE: {
                return Errors.UNKNOWN_SERVER_ERROR;
            }
        }
        return appendError;
    }

    private Optional<Errors> validateSyncGroup(GenericGroup group, SyncGroupRequestData request) {
        if (group.isInState(GenericGroupState.DEAD)) {
            return Optional.of(Errors.COORDINATOR_NOT_AVAILABLE);
        }
        try {
            group.validateMember(request.memberId(), request.groupInstanceId(), "sync-group");
        }
        catch (KafkaException ex) {
            return Optional.of(Errors.forException((Throwable)ex));
        }
        if (request.generationId() != group.generationId()) {
            return Optional.of(Errors.ILLEGAL_GENERATION);
        }
        if (this.isProtocolInconsistent(request.protocolType(), group.protocolType().orElse(null)) || this.isProtocolInconsistent(request.protocolName(), group.protocolName().orElse(null))) {
            return Optional.of(Errors.INCONSISTENT_GROUP_PROTOCOL);
        }
        return Optional.empty();
    }

    private void removePendingSyncMember(GenericGroup group, String memberId) {
        group.removePendingSyncMember(memberId);
        String syncKey = GroupMetadataManager.genericGroupSyncKey(group.groupId());
        switch (group.currentState()) {
            case EMPTY: 
            case DEAD: 
            case PREPARING_REBALANCE: {
                this.timer.cancel(syncKey);
                break;
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                if (!group.hasReceivedSyncFromAllMembers()) break;
                this.timer.cancel(syncKey);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown group state: " + group.stateAsString());
            }
        }
    }

    public HeartbeatResponseData genericGroupHeartbeat(RequestContext context, HeartbeatRequestData request) {
        GenericGroup group = this.getOrMaybeCreateGenericGroup(request.groupId(), false);
        this.validateGenericGroupHeartbeat(group, request.memberId(), request.groupInstanceId(), request.generationId());
        switch (group.currentState()) {
            case EMPTY: {
                return new HeartbeatResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
            }
            case PREPARING_REBALANCE: {
                this.rescheduleGenericGroupMemberHeartbeat(group, group.member(request.memberId()));
                return new HeartbeatResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code());
            }
            case COMPLETING_REBALANCE: 
            case STABLE: {
                this.rescheduleGenericGroupMemberHeartbeat(group, group.member(request.memberId()));
                return new HeartbeatResponseData();
            }
        }
        throw new IllegalStateException("Reached unexpected state " + (Object)((Object)group.currentState()) + " for group " + group.groupId());
    }

    private void validateGenericGroupHeartbeat(GenericGroup group, String memberId, String groupInstanceId, int generationId) throws CoordinatorNotAvailableException, IllegalGenerationException {
        if (group.isInState(GenericGroupState.DEAD)) {
            throw Errors.COORDINATOR_NOT_AVAILABLE.exception();
        }
        group.validateMember(memberId, groupInstanceId, "heartbeat");
        if (generationId != group.generationId()) {
            throw Errors.ILLEGAL_GENERATION.exception();
        }
    }

    public CoordinatorResult<LeaveGroupResponseData, Record> genericGroupLeave(RequestContext context, LeaveGroupRequestData request) throws UnknownMemberIdException, GroupIdNotFoundException {
        GenericGroup group = this.getOrMaybeCreateGenericGroup(request.groupId(), false);
        if (group.isInState(GenericGroupState.DEAD)) {
            return new CoordinatorResult<LeaveGroupResponseData, Record>(Collections.emptyList(), new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
        }
        ArrayList<LeaveGroupResponseData.MemberResponse> memberResponses = new ArrayList<LeaveGroupResponseData.MemberResponse>();
        for (LeaveGroupRequestData.MemberIdentity member : request.members()) {
            String reason;
            String string = reason = member.reason() != null ? member.reason() : "not provided";
            if ("".equals(member.memberId())) {
                if (member.groupInstanceId() != null && group.hasStaticMember(member.groupInstanceId())) {
                    this.removeCurrentMemberFromGenericGroup(group, group.staticMemberId(member.groupInstanceId()), reason);
                    memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
                    continue;
                }
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
                continue;
            }
            if (group.isPendingMember(member.memberId())) {
                group.remove(member.memberId());
                this.timer.cancel(GroupMetadataManager.genericGroupHeartbeatKey(group.groupId(), member.memberId()));
                this.log.info("[Group {}] Pending member {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{group.groupId(), member.memberId(), reason});
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
                continue;
            }
            try {
                group.validateMember(member.memberId(), member.groupInstanceId(), "leave-group");
                this.removeCurrentMemberFromGenericGroup(group, member.memberId(), reason);
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()));
            }
            catch (KafkaException e) {
                memberResponses.add(new LeaveGroupResponseData.MemberResponse().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId()).setErrorCode(Errors.forException((Throwable)e).code()));
            }
        }
        List validLeaveGroupMembers = memberResponses.stream().filter(response -> response.errorCode() == Errors.NONE.code()).map(LeaveGroupResponseData.MemberResponse::memberId).collect(Collectors.toList());
        String reason = "explicit `LeaveGroup` request for (" + String.join((CharSequence)", ", validLeaveGroupMembers) + ") members.";
        CoordinatorResult<Void, Record> coordinatorResult = EMPTY_RESULT;
        if (!validLeaveGroupMembers.isEmpty()) {
            switch (group.currentState()) {
                case COMPLETING_REBALANCE: 
                case STABLE: {
                    coordinatorResult = this.maybePrepareRebalanceOrCompleteJoin(group, reason);
                    break;
                }
                case PREPARING_REBALANCE: {
                    coordinatorResult = this.maybeCompleteJoinPhase(group);
                    break;
                }
            }
        }
        return new CoordinatorResult<LeaveGroupResponseData, Record>(coordinatorResult.records(), new LeaveGroupResponseData().setMembers(memberResponses), coordinatorResult.appendFuture());
    }

    private void removeCurrentMemberFromGenericGroup(GenericGroup group, String memberId, String reason) {
        GenericGroupMember member = group.member(memberId);
        this.timer.cancel(GroupMetadataManager.genericGroupHeartbeatKey(group.groupId(), memberId));
        this.log.info("[Group {}] Member {} has left group through explicit `LeaveGroup` request; client reason: {}", new Object[]{group.groupId(), memberId, reason});
        group.completeJoinFuture(member, new JoinGroupResponseData().setMemberId("").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()));
        group.remove(member.memberId());
    }

    public void deleteGroup(String groupId, List<Record> records) {
        this.group(groupId).createGroupTombstoneRecords(records);
    }

    void validateDeleteGroup(String groupId) throws ApiException {
        Group group = this.group(groupId);
        group.validateDeleteGroup();
    }

    public void maybeDeleteGroup(String groupId, List<Record> records) {
        Group group = (Group)this.groups.get((Object)groupId);
        if (group != null && group.isEmpty()) {
            this.deleteGroup(groupId, records);
        }
    }

    private boolean isProtocolInconsistent(String protocolTypeOrName, String groupProtocolTypeOrName) {
        return protocolTypeOrName != null && groupProtocolTypeOrName != null && !groupProtocolTypeOrName.equals(protocolTypeOrName);
    }

    public Set<String> groupIds() {
        return Collections.unmodifiableSet(this.groups.keySet());
    }

    static String genericGroupHeartbeatKey(String groupId, String memberId) {
        return "heartbeat-" + groupId + "-" + memberId;
    }

    static String genericGroupJoinKey(String groupId) {
        return "join-" + groupId;
    }

    static String genericGroupSyncKey(String groupId) {
        return "sync-" + groupId;
    }

    public static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private Time time = null;
        private CoordinatorTimer<Void, Record> timer = null;
        private List<PartitionAssignor> consumerGroupAssignors = null;
        private int consumerGroupMaxSize = Integer.MAX_VALUE;
        private int consumerGroupHeartbeatIntervalMs = 5000;
        private int consumerGroupMetadataRefreshIntervalMs = Integer.MAX_VALUE;
        private MetadataImage metadataImage = null;
        private int consumerGroupSessionTimeoutMs = 45000;
        private int genericGroupMaxSize = Integer.MAX_VALUE;
        private int genericGroupInitialRebalanceDelayMs = 3000;
        private int genericGroupNewMemberJoinTimeoutMs = 300000;
        private int genericGroupMinSessionTimeoutMs;
        private int genericGroupMaxSessionTimeoutMs;

        Builder withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        Builder withTimer(CoordinatorTimer<Void, Record> timer) {
            this.timer = timer;
            return this;
        }

        Builder withConsumerGroupAssignors(List<PartitionAssignor> consumerGroupAssignors) {
            this.consumerGroupAssignors = consumerGroupAssignors;
            return this;
        }

        Builder withConsumerGroupMaxSize(int consumerGroupMaxSize) {
            this.consumerGroupMaxSize = consumerGroupMaxSize;
            return this;
        }

        Builder withConsumerGroupSessionTimeout(int consumerGroupSessionTimeoutMs) {
            this.consumerGroupSessionTimeoutMs = consumerGroupSessionTimeoutMs;
            return this;
        }

        Builder withConsumerGroupHeartbeatInterval(int consumerGroupHeartbeatIntervalMs) {
            this.consumerGroupHeartbeatIntervalMs = consumerGroupHeartbeatIntervalMs;
            return this;
        }

        Builder withConsumerGroupMetadataRefreshIntervalMs(int consumerGroupMetadataRefreshIntervalMs) {
            this.consumerGroupMetadataRefreshIntervalMs = consumerGroupMetadataRefreshIntervalMs;
            return this;
        }

        Builder withMetadataImage(MetadataImage metadataImage) {
            this.metadataImage = metadataImage;
            return this;
        }

        Builder withGenericGroupMaxSize(int genericGroupMaxSize) {
            this.genericGroupMaxSize = genericGroupMaxSize;
            return this;
        }

        Builder withGenericGroupInitialRebalanceDelayMs(int genericGroupInitialRebalanceDelayMs) {
            this.genericGroupInitialRebalanceDelayMs = genericGroupInitialRebalanceDelayMs;
            return this;
        }

        Builder withGenericGroupNewMemberJoinTimeoutMs(int genericGroupNewMemberJoinTimeoutMs) {
            this.genericGroupNewMemberJoinTimeoutMs = genericGroupNewMemberJoinTimeoutMs;
            return this;
        }

        Builder withGenericGroupMinSessionTimeoutMs(int genericGroupMinSessionTimeoutMs) {
            this.genericGroupMinSessionTimeoutMs = genericGroupMinSessionTimeoutMs;
            return this;
        }

        Builder withGenericGroupMaxSessionTimeoutMs(int genericGroupMaxSessionTimeoutMs) {
            this.genericGroupMaxSessionTimeoutMs = genericGroupMaxSessionTimeoutMs;
            return this;
        }

        GroupMetadataManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.metadataImage == null) {
                this.metadataImage = MetadataImage.EMPTY;
            }
            if (this.time == null) {
                this.time = Time.SYSTEM;
            }
            if (this.timer == null) {
                throw new IllegalArgumentException("Timer must be set.");
            }
            if (this.consumerGroupAssignors == null || this.consumerGroupAssignors.isEmpty()) {
                throw new IllegalArgumentException("Assignors must be set before building.");
            }
            return new GroupMetadataManager(this.snapshotRegistry, this.logContext, this.time, this.timer, this.consumerGroupAssignors, this.metadataImage, this.consumerGroupMaxSize, this.consumerGroupSessionTimeoutMs, this.consumerGroupHeartbeatIntervalMs, this.consumerGroupMetadataRefreshIntervalMs, this.genericGroupMaxSize, this.genericGroupInitialRebalanceDelayMs, this.genericGroupNewMemberJoinTimeoutMs, this.genericGroupMinSessionTimeoutMs, this.genericGroupMaxSessionTimeoutMs);
        }
    }
}

