/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.kubernetes.client.Exec;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudAZNetworkFaultWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(CloudAZNetworkFaultWorker.class);
    private final String id;
    private CoreV1Api k8sCoreApi;
    private final String azName;
    private final Set<V1Pod> podFaultTracker;

    public CloudAZNetworkFaultWorker(String id, String azName) {
        this.id = id;
        this.azName = azName;
        this.podFaultTracker = new HashSet<V1Pod>();
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> haltFuture) throws Exception {
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        this.k8sCoreApi = new CoreV1Api();
        Set<V1Pod> kafkaPods = this.getAllKafkaClusterPods();
        Set<V1Pod> kafkaPodsMatchingAZ = kafkaPods.stream().filter(pod -> {
            String nodeName = pod.getSpec().getNodeName();
            try {
                V1Node nodeData = this.k8sCoreApi.readNode(nodeName, "false");
                return ((String)nodeData.getMetadata().getLabels().get("topology.kubernetes.io/zone")).equals(this.azName);
            }
            catch (ApiException e) {
                log.error("Failed to get node. Node name {}", (Object)nodeName, (Object)e);
                return false;
            }
        }).collect(Collectors.toSet());
        log.info("Activating CloudAZNetworkFaultWorker {}. Pods {}", (Object)this.id, (Object)this.getPodNames(kafkaPodsMatchingAZ));
        if (!kafkaPodsMatchingAZ.isEmpty()) {
            status.update((JsonNode)new TextNode("enabling traffic dropping for " + this.id));
            this.injectDataLossFault(kafkaPodsMatchingAZ);
            status.update((JsonNode)new TextNode("traffic dropping enabled " + this.id));
        }
    }

    private String getPodNames(Set<V1Pod> kafkaPods) {
        return kafkaPods.stream().map(v1Pod -> String.join((CharSequence)":", v1Pod.getMetadata().getNamespace(), v1Pod.getMetadata().getName())).collect(Collectors.joining(","));
    }

    private void injectDataLossFault(Set<V1Pod> kafkaPods) {
        String[] updateCommand = new String[]{"apt-get", "update"};
        String[] installCommand = new String[]{"apt-get", "install", "iproute2", "--yes"};
        String[] faultCommand = new String[]{"tc", "qdisc", "add", "dev", "eth0", "root", "netem", "loss", "100%"};
        kafkaPods.forEach(kafkaPod -> {
            this.podFaultTracker.add((V1Pod)kafkaPod);
            try {
                log.info("Injecting network AZ isolation fault on Kafka pod {}", (Object)kafkaPod.getMetadata().getName());
                boolean tty = System.console() != null;
                log.info("Injecting network AZ isolation fault on Kafka pod {}, tty {}", (Object)kafkaPod.getMetadata().getName(), (Object)tty);
                this.executeCommand((V1Pod)kafkaPod, updateCommand);
                this.executeCommand((V1Pod)kafkaPod, installCommand);
                this.executeCommand((V1Pod)kafkaPod, faultCommand);
                log.info("DONE:Injecting network AZ isolation fault on Kafka pod {}", (Object)kafkaPod.getMetadata().getName());
            }
            catch (ApiException | IOException ex) {
                log.error("Error injecting AZ network isolation fault on host {}, Kakfa pod {}", (Object)kafkaPod.getSpec().getHostname(), (Object)kafkaPod.getMetadata().getName());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                log.error("Interrupted", (Throwable)ie);
            }
        });
    }

    private void executeCommand(V1Pod kafkaPod, String[] commands) throws IOException, ApiException, InterruptedException {
        Exec exec = new Exec();
        Process process = exec.exec(kafkaPod, commands, false, false);
        boolean completionStatus = process.waitFor(1L, TimeUnit.MINUTES);
        process.destroy();
        log.info("Done:" + String.join((CharSequence)" ", commands) + ": Injecting network AZ isolation fault on Kafka pod {}. Result {}, Process Completion Status: {}", new Object[]{kafkaPod.getMetadata().getName(), process.exitValue(), completionStatus});
    }

    private Set<V1Pod> getAllKafkaClusterPods() throws ApiException {
        return this.k8sCoreApi.listPodForAllNamespaces(null, null, null, "type=kafka", null, null, null, null, null, null).getItems().stream().filter(v1Pod -> v1Pod.getMetadata().getName().matches("kafka-\\d+") && v1Pod.getMetadata().getNamespace().matches("pkc-[a-zA-Z0-9]+") && !v1Pod.getMetadata().getNamespace().endsWith("mothership")).collect(Collectors.toSet());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        log.info("Deactivating CloudNetworkAZFaultWorker {}. Pods {}", (Object)this.id, (Object)this.getPodNames(this.podFaultTracker));
        String[] removeTC = new String[]{"tc", "qdisc", "del", "dev", "eth0", "root"};
        for (V1Pod kafkaPod : this.podFaultTracker) {
            try {
                this.executeCommand(kafkaPod, removeTC);
            }
            catch (ApiException | IOException ex) {
                log.error("Error rolling back AZ network isolation fault on host {}, Kakfa pod {}", (Object)kafkaPod.getSpec().getHostname(), (Object)kafkaPod.getMetadata().getName());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                log.error("Interrupted", (Throwable)ie);
            }
        }
    }
}

