/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import io.confluent.security.auth.dataplane.DataplaneAuthReader;
import io.confluent.security.auth.dataplane.DataplaneBaseAuthStore;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class AuthnzAuthStore
extends DataplaneBaseAuthStore {
    public AuthnzAuthStore(Scope scope, Metrics metrics) {
        this(RbacRoles.loadDataPlanePolicy(), Time.SYSTEM, scope, metrics, 6);
    }

    public AuthnzAuthStore(RbacRoles rbacRoles, Time time, Scope scope, Metrics metrics, int numAuthTopicPartitions) {
        super(rbacRoles, time, scope, metrics, numAuthTopicPartitions);
    }

    public void configure(Map<String, ?> configs) {
        this.sessionUuid = (String)configs.get("confluent.authnz.session.uuid");
        int authnzId = (Integer)Objects.requireNonNull(configs.get("authnz.id"), "authnz.idshould be not null");
        String authTopic = (String)configs.get("authnz.auth.topic");
        if (Objects.isNull(authTopic) || authTopic.trim().isEmpty()) {
            log.info("{} value not provided, using default - {}", (Object)"authnz.auth.topic", (Object)"_confluent-metadata-auth");
            authTopic = "_confluent-metadata-auth";
        }
        this.clientConfig = new KafkaStoreConfig(authnzId, configs);
        String finalAuthTopic = authTopic;
        this.reader = new DataplaneAuthReader<AuthKey, AuthValue>(authTopic, this.numAuthTopicPartitions, CompletableFuture.supplyAsync(() -> this.createConsumer(this.clientConfig.consumerConfigs(finalAuthTopic))), this.authCache(), this, this.statusListener, this.clientConfig, this.time);
        AuthStore.addInstance((String)this.sessionUuid, (AuthStore)this, (Logger)log);
        log.debug("Configured {} with configs {}", (Object)this.getClass().getName(), (Object)this.clientConfig);
    }
}

