/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.security.auth.dataplane.DataplaneAuthReader;
import io.confluent.security.auth.dataplane.DataplaneBaseAuthStore;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.kafka.KafkaAuthStore;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.store.kafka.clients.DeserializationErrorHandlingJsonSerde;
import io.confluent.security.store.kafka.clients.JsonSerde;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.slf4j.Logger;

public class DataplaneAuthStore
extends DataplaneBaseAuthStore {
    private final ConfluentAuthorizerServerInfo serverInfo;
    private KafkaAuthStore.BackOffDecorator<Consumer<AuthKey, AuthValue>> decorator;

    public DataplaneAuthStore(Scope scope, ConfluentAuthorizerServerInfo serverInfo) {
        this(RbacRoles.loadDataPlanePolicy(), Time.SYSTEM, scope, serverInfo, 6);
    }

    public DataplaneAuthStore(RbacRoles rbacRoles, Time time, Scope scope, ConfluentAuthorizerServerInfo serverInfo, int numAuthTopicPartitions) {
        super(rbacRoles, time, scope, serverInfo.metrics(), numAuthTopicPartitions);
        this.serverInfo = serverInfo;
    }

    public static JsonSerde<AuthValue> valueSerde() {
        return DeserializationErrorHandlingJsonSerde.serde(AuthValue.class, false, DataplaneBaseAuthStore.DeserializerErrorForValue::new);
    }

    @Override
    public void close() {
        super.close();
        if (this.decorator != null) {
            try {
                this.decorator.close();
            }
            catch (Throwable e) {
                log.error("Unable to close kafka consumer service.");
                throw new KafkaException("Failed to close DataplaneAuthStore");
            }
        }
    }

    public void configure(Map<String, ?> configs) {
        this.sessionUuid = AuthUtils.getBrokerSessionUuid(configs);
        this.clientConfig = new KafkaStoreConfig((AuthorizerServerInfo)this.serverInfo, configs);
        Duration timeout = this.clientConfig.topicCreateTimeout;
        this.decorator = new KafkaAuthStore.BackOffDecorator(timeout, 0);
        CompletableFuture readyConsumer = this.decorator.withBackOff(() -> this.createConsumer(this.clientConfig.consumerConfigs("_confluent-metadata-auth")), KafkaAuthStore::retryPredicate);
        this.reader = new DataplaneAuthReader<AuthKey, AuthValue>("_confluent-metadata-auth", this.numAuthTopicPartitions, readyConsumer, this.authCache(), this, this.statusListener, this.clientConfig, this.time);
        AuthStore.addInstance((String)this.sessionUuid, (AuthStore)this, (Logger)log);
        log.debug("Configured {} with configs {}", (Object)this.getClass().getName(), (Object)this.clientConfig);
    }
}

