/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.kafka;

import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.store.cache.AbstractAuthCache;
import io.confluent.security.auth.store.cache.DefaultAuthCache;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.StatusKey;
import io.confluent.security.auth.store.data.StatusValue;
import io.confluent.security.auth.store.kafka.KafkaAuthWriter;
import io.confluent.security.auth.utils.AuthStoreMetrics;
import io.confluent.security.auth.utils.MetricsUtils;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.store.MetadataStoreStatus;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.store.kafka.clients.ConsumerListener;
import io.confluent.security.store.kafka.clients.JsonSerde;
import io.confluent.security.store.kafka.clients.KafkaReader;
import io.confluent.security.store.kafka.clients.StatusListener;
import io.confluent.security.store.kafka.coordinator.MetadataNodeManager;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAuthStore
implements AuthStore,
ConsumerListener<AuthKey, AuthValue> {
    private static final Logger log = LoggerFactory.getLogger(KafkaAuthStore.class);
    public static final String AUTH_TOPIC = "_confluent-metadata-auth";
    public static final String METRIC_GROUP = "confluent.metadata";
    private static final String METRIC_TYPE = KafkaAuthStore.class.getSimpleName();
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(30L);
    private final ConfluentAuthorizerServerInfo serverInfo;
    private final AbstractAuthCache authCache;
    private final Time time;
    private final int numAuthTopicPartitions;
    private final JsonSerde<AuthKey> keySerde;
    private final JsonSerde<AuthValue> valueSerde;
    private final Set<MetricName> metricNames;
    private final StoreStatusListener statusListener;
    private final List<Meter> successfulSendMeters;
    private final List<Meter> failedSendMeters;
    private final AuthStoreMetrics authStoreMetrics;
    private KafkaStoreConfig clientConfig;
    private KafkaReader<AuthKey, AuthValue> reader;
    private volatile MetadataNodeManager nodeManager;
    private volatile KafkaAuthWriter writer;
    private volatile Integer masterWriterId;
    private String sessionUuid;
    private BackOffDecorator<Consumer<AuthKey, AuthValue>> decorator;
    static final String CREATE_CONSUMER_RETRY_EXCEPTION_MSG = "No resolvable bootstrap urls";
    static final int CREATE_CONSUMER_RETRY_MAX_ATTEMPTS = 10;
    static final int CREATE_CONSUMER_RETRY_EXCEPTION_CAUSE_DEPTH = 20;

    public KafkaAuthStore(boolean isConfluentCloud, Scope scope, ConfluentAuthorizerServerInfo serverInfo, boolean isMdsApiEnabledOnThisBroker) {
        this(RbacRoles.loadDefaultPolicy((boolean)isConfluentCloud), Time.SYSTEM, scope, serverInfo, 6, isMdsApiEnabledOnThisBroker);
    }

    public KafkaAuthStore(RbacRoles rbacRoles, Time time, Scope scope, ConfluentAuthorizerServerInfo serverInfo, int numAuthTopicPartitions, boolean isMdsApiEnabledOnThisBroker) {
        this.serverInfo = serverInfo;
        this.authCache = this.createAuthCache(rbacRoles, scope);
        this.time = time;
        this.numAuthTopicPartitions = numAuthTopicPartitions;
        this.statusListener = new StoreStatusListener();
        this.keySerde = JsonSerde.serde(AuthKey.class, true);
        this.valueSerde = JsonSerde.serde(AuthValue.class, false);
        this.authStoreMetrics = new AuthStoreMetrics(serverInfo.metrics(), this.authCache);
        this.successfulSendMeters = new ArrayList<Meter>(numAuthTopicPartitions);
        this.failedSendMeters = new ArrayList<Meter>(numAuthTopicPartitions);
        this.metricNames = new HashSet<MetricName>();
        this.metricNames.add(MetricsUtils.newGauge(METRIC_GROUP, METRIC_TYPE, "reader-failure-start-seconds-ago", Collections.emptyMap(), this.statusListener::secondsAfterReaderFailure));
        this.metricNames.add(MetricsUtils.newGauge(METRIC_GROUP, METRIC_TYPE, "remote-failure-start-seconds-ago", Collections.emptyMap(), this.statusListener::secondsAfterRemoteFailure));
        if (isMdsApiEnabledOnThisBroker) {
            this.metricNames.add(MetricsUtils.newGauge(METRIC_GROUP, METRIC_TYPE, "active-writer-count", Collections.emptyMap(), () -> this.isMasterWriter() ? 1 : 0));
        }
        IntStream.range(0, numAuthTopicPartitions).forEach(p -> {
            Map tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)AUTH_TOPIC), Utils.mkEntry((Object)"partition", (Object)String.valueOf(p))});
            this.metricNames.add(MetricsUtils.newGauge(METRIC_GROUP, METRIC_TYPE, "metadata-status", tags, () -> this.authCache.status(p).name()));
        });
    }

    protected AbstractAuthCache createAuthCache(RbacRoles rbacRoles, Scope scope) {
        return new DefaultAuthCache(rbacRoles, scope);
    }

    public static boolean retryPredicate(Exception e) {
        if (e.getMessage().contains(CREATE_CONSUMER_RETRY_EXCEPTION_MSG)) {
            return true;
        }
        Throwable cause = e.getCause();
        for (int depth = 0; cause != null && depth < 20; cause = cause.getCause(), ++depth) {
            if (!cause.getMessage().contains(CREATE_CONSUMER_RETRY_EXCEPTION_MSG)) continue;
            return true;
        }
        return false;
    }

    public void configure(Map<String, ?> configs) {
        this.clientConfig = new KafkaStoreConfig((AuthorizerServerInfo)this.serverInfo, configs);
        Duration timeout = this.clientConfig.topicCreateTimeout;
        this.decorator = new BackOffDecorator(timeout, 0);
        CompletableFuture readyConsumer = this.decorator.withBackOff(() -> this.createConsumer(this.clientConfig.consumerConfigs(AUTH_TOPIC)), KafkaAuthStore::retryPredicate);
        this.reader = new KafkaReader<AuthKey, AuthValue>(AUTH_TOPIC, this.numAuthTopicPartitions, readyConsumer, this.authCache, this, this.statusListener, this.clientConfig, this.time);
        try {
            this.sessionUuid = AuthUtils.getBrokerSessionUuid(configs);
        }
        catch (ConfigException e) {
            log.info(e.getMessage());
        }
        AuthStore.addInstance((String)this.sessionUuid, (AuthStore)this, (Logger)log);
        log.info("Configured auth store with configs {}", (Object)this.clientConfig);
    }

    public AbstractAuthCache authCache() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has not been started for this store");
        }
        return this.authCache;
    }

    public AbstractAuthCache trustCache() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has not been started for this store");
        }
        return this.authCache;
    }

    public CompletionStage<Void> startReader() {
        return this.reader.start(this.clientConfig.topicCreateTimeout);
    }

    public CompletionStage<Void> startService(Collection<URL> nodeUrls) {
        if (nodeUrls == null || nodeUrls.isEmpty()) {
            throw new IllegalArgumentException("Server node URL not provided");
        }
        if (this.nodeManager != null) {
            throw new IllegalStateException("Writer has already been started for this store");
        }
        log.info("Starting writer for auth store {}", nodeUrls);
        this.metricNames.add(MetricsUtils.newGauge(METRIC_GROUP, METRIC_TYPE, "writer-failure-start-seconds-ago", Collections.emptyMap(), this.statusListener::secondsAfterWriterFailure));
        IntStream.range(0, this.numAuthTopicPartitions).forEach(p -> {
            Map tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"topic", (Object)AUTH_TOPIC), Utils.mkEntry((Object)"partition", (Object)String.valueOf(p))});
            MetricName metricName = MetricsUtils.metricName(METRIC_GROUP, METRIC_TYPE, "record-send-rate", tags);
            this.successfulSendMeters.add(MetricsUtils.newMeter(metricName, "records"));
            this.metricNames.add(metricName);
            metricName = MetricsUtils.metricName(METRIC_GROUP, METRIC_TYPE, "record-error-rate", tags);
            this.failedSendMeters.add(MetricsUtils.newMeter(metricName, "records"));
            this.metricNames.add(metricName);
        });
        this.writer = this.createWriter(this.numAuthTopicPartitions, this.clientConfig, this.authCache, this.statusListener, this.time);
        this.nodeManager = this.createNodeManager(nodeUrls, this.clientConfig, this.writer, this.time);
        this.writer.rebalanceListener(this.nodeManager);
        return this.nodeManager.start();
    }

    public KafkaAuthWriter writer() {
        return this.writer;
    }

    public final boolean isMasterWriter() {
        if (this.nodeManager == null) {
            return false;
        }
        return this.nodeManager.isMasterWriter();
    }

    public URL masterWriterUrl(String protocol) {
        if (this.nodeManager == null) {
            throw new IllegalStateException("Writer has not been started for this store");
        }
        return this.nodeManager.masterWriterUrl(protocol);
    }

    public Integer masterWriterId() {
        return this.masterWriterId;
    }

    public Collection<URL> activeNodeUrls(String protocol) {
        if (this.nodeManager == null) {
            throw new IllegalStateException("Writer has not been started for this store");
        }
        return this.nodeManager.activeNodeUrls(protocol);
    }

    public void close() {
        log.debug("Closing auth store");
        this.close(CLOSE_TIMEOUT);
    }

    public void close(Duration closeTimeout) {
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        if (this.nodeManager != null) {
            try {
                this.nodeManager.close(closeTimeout);
            }
            catch (Throwable e) {
                firstException.compareAndSet(null, e);
            }
            this.nodeManager = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close(closeTimeout);
            }
            catch (Throwable e) {
                firstException.compareAndSet(null, e);
            }
            this.writer = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close(closeTimeout);
            }
            catch (Throwable e) {
                firstException.compareAndSet(null, e);
            }
            this.reader = null;
        }
        if (this.decorator != null) {
            try {
                this.decorator.close();
            }
            catch (Throwable e) {
                firstException.compareAndSet(null, e);
            }
        }
        MetricsUtils.removeMetrics(this.metricNames);
        Throwable exception = firstException.getAndSet(null);
        if (exception != null) {
            throw new KafkaException("Failed to close KafkaAuthStore", exception);
        }
        AuthStore.removeInstance((String)this.sessionUuid, (AuthStore)this, (Logger)log);
    }

    @Override
    public void onConsumerRecord(ConsumerRecord<AuthKey, AuthValue> record, AuthValue oldValue) {
        if (this.writer != null) {
            this.writer.onConsumerRecord(record, oldValue);
        }
        if (record.key() instanceof StatusKey) {
            int partition = record.partition();
            StatusValue statusValue = (StatusValue)record.value();
            MetadataStoreStatus status = statusValue.status();
            switch (status) {
                case INITIALIZED: {
                    this.masterWriterId = statusValue.writerBrokerId();
                    this.statusListener.onRemoteSuccess(partition);
                    break;
                }
                case FAILED: {
                    if (!this.statusListener.onRemoteFailure(partition)) break;
                    throw new TimeoutException("Partition not successfully initialized within timeout " + partition);
                }
            }
        }
        if (((AuthKey)record.key()).entryType() != null) {
            this.authStoreMetrics.recordsProcessedSensors.get(((AuthKey)record.key()).entryType()).record();
        }
    }

    protected Consumer<AuthKey, AuthValue> createConsumer(Map<String, Object> configs) {
        return new KafkaConsumer(configs, this.keySerde.deserializer(), this.valueSerde.deserializer());
    }

    protected Producer<AuthKey, AuthValue> createProducer(Map<String, Object> configs) {
        return new KafkaProducer(configs, this.keySerde.serializer(), this.valueSerde.serializer());
    }

    protected AdminClient createAdminClient(Map<String, Object> configs) {
        return KafkaAdminClient.create(configs);
    }

    protected MetadataNodeManager createNodeManager(Collection<URL> nodeUrls, KafkaStoreConfig config, KafkaAuthWriter writer, Time time) {
        return new MetadataNodeManager(nodeUrls, config, writer, time);
    }

    protected KafkaAuthWriter createWriter(int numPartitions, KafkaStoreConfig clientConfig, AbstractAuthCache authCache, StatusListener statusListener, Time time) {
        return new KafkaAuthWriter(AUTH_TOPIC, numPartitions, clientConfig, this.createProducer(clientConfig.producerConfigs(AUTH_TOPIC)), () -> this.createAdminClient(clientConfig.adminClientConfigs()), authCache, statusListener, this.reader.existingRecordsFuture(), time);
    }

    Long writerFailuresStartMs() {
        return this.statusListener.firstFailureMs(this.statusListener.writerFailuresStartMs);
    }

    Long remoteFailuresStartMs() {
        return this.statusListener.firstFailureMs(this.statusListener.remoteFailuresStartMs);
    }

    KafkaStoreConfig clientConfig() {
        return this.clientConfig;
    }

    protected Metrics metrics() {
        return this.authStoreMetrics.metrics();
    }

    private class StoreStatusListener
    implements StatusListener {
        private final AtomicLong readerFailureStartMs = new AtomicLong(0L);
        private final ConcurrentHashMap<Integer, Long> writerFailuresStartMs;
        private final ConcurrentHashMap<Integer, Long> remoteFailuresStartMs;

        StoreStatusListener() {
            this.writerFailuresStartMs = new ConcurrentHashMap(KafkaAuthStore.this.numAuthTopicPartitions);
            this.remoteFailuresStartMs = new ConcurrentHashMap(KafkaAuthStore.this.numAuthTopicPartitions);
        }

        long secondsAfterReaderFailure() {
            return MetricsUtils.elapsedSeconds(KafkaAuthStore.this.time, this.readerFailureStartMs.get());
        }

        long secondsAfterWriterFailure() {
            return this.secondsAfterFailure(this.writerFailuresStartMs);
        }

        long secondsAfterRemoteFailure() {
            return this.secondsAfterFailure(this.remoteFailuresStartMs);
        }

        @Override
        public void onReaderSuccess() {
            if (this.readerFailureStartMs.get() != 0L) {
                log.info("KafkaReader is recovered from the error occurred at readerFailureStartMs : {}", (Object)this.readerFailureStartMs.get());
            }
            this.readerFailureStartMs.set(0L);
        }

        @Override
        public boolean onReaderFailure() {
            this.readerFailureStartMs.compareAndSet(0L, KafkaAuthStore.this.time.milliseconds());
            boolean status = this.failed(this.readerFailureStartMs.get());
            if (status) {
                log.error("KafkaReader failed to recover within retry timeout. readerFailureStartMs : {}", (Object)this.readerFailureStartMs.get());
            }
            return status;
        }

        @Override
        public void onWriterSuccess(int partition) {
            Long firstFailureMs = this.writerFailuresStartMs.get(partition);
            if (firstFailureMs != null) {
                log.info("KafkaPartitionWriter : {} is recovered from error occurred at writerFailuresStartMs : {}", (Object)partition, (Object)firstFailureMs);
            }
            this.writerFailuresStartMs.remove(partition);
        }

        @Override
        public boolean onWriterFailure(int partition) {
            this.writerFailuresStartMs.putIfAbsent(partition, KafkaAuthStore.this.time.milliseconds());
            boolean status = this.failed(this.firstFailureMs(this.writerFailuresStartMs));
            if (status) {
                log.error("KafkaPartitionWriter : {} failed to recover within retry timeout. writerFailuresStartMs : {}", (Object)partition, (Object)this.firstFailureMs(this.writerFailuresStartMs));
            }
            return status;
        }

        @Override
        public void onProduceSuccess(int partition) {
            ((Meter)KafkaAuthStore.this.successfulSendMeters.get(partition)).mark();
        }

        @Override
        public void onProduceFailure(int partition) {
            ((Meter)KafkaAuthStore.this.failedSendMeters.get(partition)).mark();
        }

        @Override
        public void onRemoteSuccess(int partition) {
            Long failureStartMs;
            this.remoteFailuresStartMs.remove(partition);
            if (KafkaAuthStore.this.nodeManager != null && !KafkaAuthStore.this.nodeManager.isMasterWriter() && (failureStartMs = this.writerFailuresStartMs.remove(partition)) != null) {
                log.info("Clearing auth partition {} writer failure recorded at writerFailureStartMs : {}", (Object)partition, (Object)failureStartMs);
            }
        }

        @Override
        public boolean onRemoteFailure(int partition) {
            this.remoteFailuresStartMs.putIfAbsent(partition, KafkaAuthStore.this.time.milliseconds());
            return this.failed(this.firstFailureMs(this.remoteFailuresStartMs));
        }

        private boolean failed(Long firstFailureMs) {
            if (firstFailureMs == null) {
                return false;
            }
            return KafkaAuthStore.this.time.milliseconds() > firstFailureMs + ((KafkaAuthStore)KafkaAuthStore.this).clientConfig.retryTimeout.toMillis();
        }

        private long secondsAfterFailure(ConcurrentHashMap<Integer, Long> failuresStartMs) {
            Long firstFailureMs = this.firstFailureMs(failuresStartMs);
            if (firstFailureMs == null) {
                return 0L;
            }
            return MetricsUtils.elapsedSeconds(KafkaAuthStore.this.time, firstFailureMs);
        }

        private Long firstFailureMs(Map<Integer, Long> failuresStartMs) {
            HashSet<Long> failures = new HashSet<Long>(failuresStartMs.values());
            return failures.isEmpty() ? null : Collections.min(failures);
        }
    }

    public static class BackOffDecorator<T> {
        private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        private int maxAttempts;
        private Duration timeout;
        private Future<?> future;
        private Exception exp;

        public BackOffDecorator(Duration timeout, int maxAttempts) {
            this.timeout = timeout;
            this.maxAttempts = maxAttempts <= 0 ? 10 : maxAttempts;
        }

        public CompletableFuture<T> withBackOff(Supplier<T> supplier, Predicate<Exception> predicate) {
            CompletableFuture readyRetVal = new CompletableFuture();
            long delay = this.timeout.toMillis() / (long)this.maxAttempts;
            this.future = this.executorService.submit(() -> {
                boolean shouldRetry = false;
                int tries = 0;
                do {
                    try {
                        this.exp = null;
                        ++tries;
                        shouldRetry = false;
                        readyRetVal.complete(supplier.get());
                        log.info("Successfully completed create consumer call.");
                    }
                    catch (Exception e) {
                        this.exp = e;
                        log.warn("Could not create consumer", (Throwable)e);
                        if (predicate.test(e)) {
                            log.error("Retry predicate succeeded for create consumer.");
                            shouldRetry = true;
                            try {
                                long jitter = (long)(100.0 * Math.random());
                                log.debug("Sleeping for " + Math.abs(delay - jitter) + " ms");
                                Thread.sleep(Math.abs(delay - jitter));
                            }
                            catch (InterruptedException ex) {
                                log.error("Interrupted while waiting for consumer.", (Throwable)ex);
                                shouldRetry = false;
                            }
                        }
                        log.warn("Retry predicate failed.");
                    }
                } while (shouldRetry && tries < this.maxAttempts);
                if (this.exp != null) {
                    readyRetVal.completeExceptionally(this.exp);
                }
            });
            return readyRetVal;
        }

        public void close() {
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
        }
    }
}

