/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.tools;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerProfiler<K, V>
implements ProducerInterceptor<K, V> {
    private static final Logger log = LoggerFactory.getLogger(ProducerProfiler.class);
    private long startTime;
    private long endTime;
    private long recordsNum;
    private long measuredRecordsNum;
    private long totalByteSize;
    private long measuredByteSize;
    private long recordSize;
    private final Set<Integer> partitions = new HashSet<Integer>();
    private static final int EXPECTED_RUNTIME_MS = 30000;

    public void configure(Map<String, ?> configs) {
    }

    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> record) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        return record;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
        int keySize = metadata.serializedKeySize();
        int valueSize = metadata.serializedValueSize();
        ++this.recordsNum;
        this.recordSize = 22 + (keySize == -1 ? 0 : keySize) + (valueSize == -1 ? 0 : valueSize);
        this.totalByteSize += this.recordSize;
        this.partitions.add(metadata.partition());
        int mod = (int)(0x100000L / this.recordSize);
        if (mod == 0) {
            mod = 1;
        }
        if (this.recordsNum % (long)mod == 0L) {
            this.measuredRecordsNum = this.recordsNum;
            this.measuredByteSize = this.totalByteSize;
            this.endTime = System.currentTimeMillis();
            log.debug("Got {} records", (Object)this.recordsNum);
        }
    }

    public void close() {
        long approxTime = this.endTime - this.startTime;
        Double approxThroughput = (double)this.measuredByteSize / (double)approxTime * 1000.0 / 1024.0 / 1024.0;
        if (approxTime < 30000L) {
            return;
        }
        String result = "{\"name\":\"producer_profiler\",\"partitions\":" + Arrays.toString(this.partitions.toArray()) + ",\"startTime\":" + this.startTime + ",\"endTime\":" + this.endTime + ",\"total records copied\":" + this.measuredRecordsNum + ",\"total bytes copied\":" + this.measuredByteSize + ",\"record size\":" + this.recordSize + ",\"approximate runtime\":" + approxTime + ",\"approximate throughput\":" + (approxThroughput.isInfinite() || approxThroughput.isNaN() ? approxThroughput.toString() : new BigDecimal(approxThroughput).setScale(4, 4).toString()) + "}";
        System.err.println(result);
    }
}

