/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.flowable;

import io.confluent.shaded.io.reactivex.Single;
import io.confluent.shaded.io.reactivex.SingleObserver;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.BiFunction;
import io.confluent.shaded.io.reactivex.internal.disposables.EmptyDisposable;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import io.confluent.shaded.io.reactivex.internal.operators.flowable.FlowableReduceSeedSingle;
import io.confluent.shaded.org.reactivestreams.Publisher;
import java.util.concurrent.Callable;

public final class FlowableReduceWithSingle<T, R>
extends Single<R> {
    final Publisher<T> source;
    final Callable<R> seedSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public FlowableReduceWithSingle(Publisher<T> source, Callable<R> seedSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.seedSupplier = seedSupplier;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        R seed;
        try {
            seed = ObjectHelper.requireNonNull(this.seedSupplier.call(), "The seedSupplier returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.source.subscribe(new FlowableReduceSeedSingle.ReduceSeedObserver<T, R>(observer, this.reducer, seed));
    }
}

