/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.util.Objects;
import java.util.Optional;

public class IdentityMetadata {
    private final String poolId;
    private final String providerId;
    private final String identity;
    private final String externalIdentityId;

    public IdentityMetadata(String poolId, String providerId, String identity, String externalIdentityId) {
        this.poolId = poolId;
        this.providerId = providerId;
        this.identity = identity;
        this.externalIdentityId = externalIdentityId;
    }

    public String poolId() {
        return this.poolId;
    }

    public String providerId() {
        return this.providerId;
    }

    public String identity() {
        return this.identity;
    }

    public String externalIdentityId() {
        return this.externalIdentityId;
    }

    public Optional<String> maybeGetPoolId() {
        return Optional.ofNullable(this.poolId).filter(s -> !s.isEmpty());
    }

    public Optional<String> maybeGetProviderId() {
        return Optional.ofNullable(this.providerId).filter(s -> !s.isEmpty());
    }

    public Optional<String> maybeGetIdentity() {
        return Optional.ofNullable(this.identity).filter(s -> !s.isEmpty());
    }

    public int hashCode() {
        return Objects.hash(this.poolId, this.providerId, this.identity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityMetadata that = (IdentityMetadata)o;
        return Objects.equals(this.poolId, that.poolId) && Objects.equals(this.providerId, that.providerId) && Objects.equals(this.identity, that.identity) && Objects.equals(this.externalIdentityId, that.externalIdentityId);
    }

    public String toString() {
        return "IdentityMetadata(poolId='" + this.poolId + "',providerId='" + this.providerId + "',identity='" + this.identity + "')";
    }

    public static class Builder {
        private String poolId;
        private String providerId;
        private String identity;
        private String externalIdentityId;

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder externalIdentityId(String externalIdentityId) {
            this.externalIdentityId = externalIdentityId;
            return this;
        }

        public IdentityMetadata build() {
            return new IdentityMetadata(this.poolId, this.providerId, this.identity, this.externalIdentityId);
        }
    }
}

