/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import io.confluent.kafka.util.ClientContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.oauthbearer.Contextable;
import org.apache.kafka.common.utils.CollectionUtils;

public abstract class CommonExtensionsValidatorCallback
implements Callback,
Contextable {
    public static final String SEPARATOR = "-";
    private final SaslExtensions inputExtensions;
    private final Map<String, String> validatedExtensions = new HashMap<String, String>();
    private final Map<String, String> invalidExtensions = new HashMap<String, String>();
    private final Map<String, String> data = new HashMap<String, String>();
    private String errorMessage = "";
    protected ClientContext context;

    public CommonExtensionsValidatorCallback(SaslExtensions extensions, ClientContext context) {
        this.inputExtensions = Objects.requireNonNull(extensions);
        this.context = context;
    }

    public CommonExtensionsValidatorCallback(SaslExtensions extensions) {
        this(extensions, new ClientContext());
    }

    @Override
    public ClientContext context() {
        return this.context;
    }

    public SaslExtensions inputExtensions() {
        return this.inputExtensions;
    }

    public Map<String, String> validatedExtensions() {
        return Collections.unmodifiableMap(this.validatedExtensions);
    }

    public Map<String, String> invalidExtensions() {
        return Collections.unmodifiableMap(this.invalidExtensions);
    }

    public Map<String, String> ignoredExtensions() {
        return Collections.unmodifiableMap(CollectionUtils.subtractMap(CollectionUtils.subtractMap(this.inputExtensions.map(), this.invalidExtensions), this.validatedExtensions));
    }

    public void error(String invalidExtensionName, String errorMessage) {
        if (Objects.requireNonNull(invalidExtensionName).isEmpty()) {
            throw new IllegalArgumentException("extension name must not be empty");
        }
        this.invalidExtensions.put(invalidExtensionName, errorMessage);
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void valid(String extensionName) {
        this.valid(extensionName, (String)null);
    }

    public void valid(String extensionName, String extensionValue) {
        if (!this.inputExtensions.map().containsKey(extensionName)) {
            throw new IllegalArgumentException(String.format("Extension %s was not found in the original extensions", extensionName));
        }
        this.validatedExtensions.put(extensionName, extensionValue == null ? this.inputExtensions.map().get(extensionName) : extensionValue);
    }

    public void valid(String extensionName, Map<String, Object> identityPoolClaims) {
        if (!this.inputExtensions.map().containsKey(extensionName)) {
            throw new IllegalArgumentException(String.format("Extension %s was not found in the original extensions", extensionName));
        }
        identityPoolClaims.forEach((key, value) -> this.validatedExtensions.put(extensionName + SEPARATOR + key, String.valueOf(value)));
    }

    public void data(String key, String value) {
        this.data.put(key, value);
    }

    public Map<String, String> data() {
        return Collections.unmodifiableMap(this.data);
    }
}

