/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.util.RetryUtils;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.Admin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapClusterIdSupplier
implements Supplier<String> {
    private static final Logger log = LoggerFactory.getLogger(BootstrapClusterIdSupplier.class);
    private static final int DESCRIBE_TIMEOUT = 15;
    private static final int RETRIES = 3;
    private final BootstrapClientSupplier bootstrapClientSupplier;

    @Inject
    public BootstrapClusterIdSupplier(BootstrapClientSupplier bootstrapClientSupplier) {
        this.bootstrapClientSupplier = bootstrapClientSupplier;
    }

    private static String getClusterId(BootstrapClientSupplier bootstrapClientSupplier) throws Exception {
        log.info("Fetching bootstrap cluster id");
        return RetryUtils.execute(() -> {
            try (Admin admin = bootstrapClientSupplier.get();){
                String clusterId = (String)admin.describeCluster().clusterId().get(15L, TimeUnit.SECONDS);
                log.info("Bootstrap cluster id {}", (Object)clusterId);
                String string = clusterId;
                return string;
            }
        }, 3);
    }

    public String get() {
        try {
            return BootstrapClusterIdSupplier.getClusterId(this.bootstrapClientSupplier);
        }
        catch (Exception e) {
            log.error("Failed to get bootstrap cluster id");
            throw new RuntimeException("Failed to get bootstrap cluster id", e);
        }
    }
}

