/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import io.confluent.controlcenter.httpclient.BasicHttpCredential;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterMetadata<T> {
    private static final Logger log = LoggerFactory.getLogger(ClusterMetadata.class);
    private static final String USER_INFO_SUFFIX = "basic.auth.user.info";
    protected final List<T> clusters = new ArrayList<T>();
    protected final Map<String, List<String>> endpointsLookup = new ConcurrentHashMap<String, List<String>>();
    protected final Map<String, HttpCredential> credentialsLookup = new ConcurrentHashMap<String, HttpCredential>();

    public List<T> getClusters() {
        return this.clusters;
    }

    public Map<String, List<String>> getEndpoints() {
        return this.endpointsLookup;
    }

    public Map<String, HttpCredential> getCredentials() {
        return this.credentialsLookup;
    }

    protected final boolean checkInvalidEndpoints(List<String> endpoints) {
        return endpoints == null || endpoints.isEmpty() || endpoints.stream().allMatch(String::isEmpty);
    }

    protected final String createClusterId(List<String> endpoints) {
        Collections.sort(endpoints);
        return Hashing.sha1().hashString((CharSequence)ConfigUtils.toString(endpoints), Charsets.UTF_8).toString();
    }

    protected final HttpCredential createCredential(String displayName, Map<String, Object> config) {
        String rawUserInfo = (String)config.get(USER_INFO_SUFFIX);
        if (rawUserInfo != null) {
            String[] credential = rawUserInfo.split(":");
            if (credential.length == 2) {
                return new BasicHttpCredential(credential[0], credential[1]);
            }
            log.error("Failed to parse basic authentication credential for cluster \"{}\". The credential should be in the format of <username>:<password>.", (Object)displayName);
        }
        return null;
    }

    protected abstract T createCluster(String var1, Map<String, Object> var2);

    protected abstract void addCluster(T var1);

    protected void addClusters(Map<String, Map<String, Object>> configs) {
        for (Map.Entry<String, Map<String, Object>> entry : configs.entrySet()) {
            T cluster = this.createCluster(entry.getKey(), entry.getValue());
            if (cluster == null) continue;
            this.addCluster(cluster);
        }
    }
}

