/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.application.AllControlCenter;
import io.confluent.controlcenter.application.ManagementControlCenter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ControlCenter {
    private static final String TOPICS_FOR_TASKS_OPT = "runTasksFor";

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        Option topicsForTasksOpt = Option.builder((String)TOPICS_FOR_TASKS_OPT).hasArg().longOpt("run-tasks-for").desc("Comma-separated list of topics. Run only tasks whose input topics include this set.").build();
        options.addOption(topicsForTasksOpt);
        DefaultParser parser = new DefaultParser();
        CommandLine cmdLine = parser.parse(options, args);
        if (cmdLine.getArgList().size() == 0) {
            System.err.println("You must provide a path to the config file");
            System.exit(1);
        }
        ControlCenterConfig config = new ControlCenterConfig((String)cmdLine.getArgList().get(0));
        String runTasksFor = cmdLine.getOptionValue(TOPICS_FOR_TASKS_OPT);
        io.confluent.controlcenter.application.ControlCenter controlCenter = config.getString("confluent.controlcenter.mode.enable").equals("all") ? new AllControlCenter(config, runTasksFor) : new ManagementControlCenter(config, runTasksFor);
        controlCenter.run();
    }
}

