/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import io.confluent.command.cluster_metadata.CommandClusterMetadata;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.alert.TriggerMetricTypes;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.annotation.Mode;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.streams.KafkaStreamsManager;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.controlcenter.streams.aggregation.MetricHolder;
import io.confluent.controlcenter.util.LruSet;
import io.confluent.controlcenter.util.TopicInfo;
import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.monitoring.common.Clock;
import io.confluent.monitoring.common.SystemClock;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.UberSerde;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterModule.class);
    private static final String CONTROL_CENTER_PATH = "io.confluent.controlcenter";

    protected void configure() {
    }

    @Provides
    @Singleton
    protected Reflections provideReflections() {
        return new Reflections(CONTROL_CENTER_PATH, new Scanner[0]);
    }

    @Provides
    @Singleton
    @Inject
    public Mode.ModeType provideModeType(ControlCenterConfig controlCenterConfig) {
        if (controlCenterConfig.getString("confluent.controlcenter.mode.enable").equals("all")) {
            return Mode.ModeType.ALL;
        }
        return Mode.ModeType.MANAGEMENT;
    }

    @Provides
    @Inject
    @Singleton
    protected Clock provideClock() {
        return new SystemClock();
    }

    @Provides
    @Singleton
    protected LruSet<CommandClusterMetadata.KafkaClusterMetadata> provideKcmLru() {
        return new LruSet<CommandClusterMetadata.KafkaClusterMetadata>(128);
    }

    @Provides
    @Singleton
    @BrokerCache
    protected LoadingCache<TokenCredential, Map<Integer, Long>> provideBrokerCache(ControlCenterConfig config, @ControlCenterConfigModule.ControlCenterMetricsBrokerCountStalenessThresholdMs Long brokerMetricsStalenessThreshold) {
        int streamsThreads = config.getInt("confluent.controlcenter.streams.num.stream.threads");
        Long ttl = brokerMetricsStalenessThreshold - 60000L;
        return CacheBuilder.newBuilder().expireAfterWrite(ttl.longValue(), TimeUnit.MILLISECONDS).maximumSize(10000L).concurrencyLevel(streamsThreads).build((CacheLoader)new CacheLoader<TokenCredential, Map<Integer, Long>>(){

            public Map<Integer, Long> load(TokenCredential credential) throws Exception {
                return new ConcurrentHashMap<Integer, Long>();
            }
        });
    }

    @Provides
    @Singleton
    @TopicCache
    protected LoadingCache<TokenCredential, SortedSet<String>> provideTopicCache(ControlCenterConfig config) {
        long retention = config.getLong("confluent.metrics.topic.retention.ms");
        return CacheBuilder.newBuilder().expireAfterWrite(retention, TimeUnit.MILLISECONDS).maximumSize(10000L).build((CacheLoader)new CacheLoader<TokenCredential, SortedSet<String>>(){

            public SortedSet<String> load(TokenCredential key) throws Exception {
                return new ConcurrentSkipListSet<String>();
            }
        });
    }

    @Provides
    @ControlCenterMetricsStoreRetentionDays
    @Inject
    protected int getControlCenterMetricsStoreRetentionDays(ControlCenterConfig config) {
        return config.getInt("confluent.metrics.store.retention.days");
    }

    @Inject
    @Provides
    @StreamsAppId
    protected String provideStreamsAppId(ControlCenterConfig controlCenterConfig) {
        return TopicStoreMaster.nameJoin(controlCenterConfig.getString("confluent.controlcenter.name"), ControlCenterConfig.CONTROL_CENTER_VERSION, controlCenterConfig.getString("confluent.controlcenter.id"));
    }

    @Provides
    @TopicStoreModule.AlertHistoryStore
    @Inject
    protected ReadOnlyKeyValueStore<Bytes, Alert.AlertInfo> provideAlertHistoryStore(Mode.ModeType modeType, Injector injector) {
        if (modeType == Mode.ModeType.ALL) {
            TopicStoreMaster.Store alertHistoryStore = (TopicStoreMaster.Store)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<TopicStoreMaster.Store<Bytes, Alert.AlertInfo, Alert.AlertInfo>>(){}, TopicStoreModule.AlertHistoryStore.class));
            KafkaStreamsManager kstream = (KafkaStreamsManager)injector.getInstance(KafkaStreamsManager.class);
            return (ReadOnlyKeyValueStore)kstream.getKStreams().store(StoreQueryParameters.fromNameAndType((String)alertHistoryStore.name, (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
        }
        log.debug("alert history is disabled in management mode");
        return null;
    }

    private void configureReplication(TopicInfo.Builder topicBuilder, int replicaCountInMrcCluster, short replication) {
        if (replicaCountInMrcCluster > 0) {
            topicBuilder.setReplication((short)replicaCountInMrcCluster).setIsMrcCluster(true);
        } else {
            topicBuilder.setReplication(replication);
        }
    }

    private int fetchReplicaCountInMrcCluster(KafkaHelper kafkaHelper) {
        int replicaCountInMrcCluster = -1;
        try {
            replicaCountInMrcCluster = kafkaHelper.getMrcClusterReplicaCount();
            log.info("Kafka cluster is an MRC cluster={}, with default replica count{}", (Object)(replicaCountInMrcCluster != -1 ? 1 : 0), (Object)replicaCountInMrcCluster);
            if (replicaCountInMrcCluster == 0) {
                throw new RuntimeException("Replica count in MRC cluster is 0. Please check the broker config");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e + "Error while getting broker config to check if broker contains replica placement");
        }
        return replicaCountInMrcCluster;
    }

    private void createAllModeTopics(Injector injector, ControlCenterConfig config, int replicaCountInMrcCluster, boolean shouldRespectMrc, ImmutableSet.Builder<TopicInfo> builder) {
        TopicInfo.Builder topicBuilder;
        TopicStoreMaster topicStoreMaster = (TopicStoreMaster)injector.getInstance(TopicStoreMaster.class);
        int internalPartitions = config.getInt("confluent.controlcenter.internal.topics.partitions");
        short internalReplication = config.getShort("confluent.controlcenter.internal.topics.replication");
        long internalRetentionMs = config.getLong("confluent.controlcenter.internal.topics.retention.ms");
        long internalRetentionBytes = config.getLong("confluent.controlcenter.internal.topics.retention.bytes");
        long internalChangelogSegmentBytes = config.getLong("confluent.controlcenter.internal.topics.changelog.segment.bytes");
        log.info("getPersistentStoreTopicNames={}", topicStoreMaster.getPersistentStoreTopicNames());
        for (Object name : topicStoreMaster.getPersistentStoreTopicNames()) {
            topicBuilder = TopicInfo.builder().setShouldRespectMrc(shouldRespectMrc).addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName((String)name).setCompact().setSegmentBytes(internalChangelogSegmentBytes).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention((String)name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention((String)name, internalRetentionMs));
            this.configureReplication(topicBuilder, replicaCountInMrcCluster, internalReplication);
            builder.add((Object)topicBuilder.build());
        }
        log.info("getLruStoreTopicNames={}", topicStoreMaster.getLruStoreTopicNames());
        for (Object name : topicStoreMaster.getLruStoreTopicNames()) {
            topicBuilder = TopicInfo.builder().setShouldRespectMrc(shouldRespectMrc).addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName((String)name).setCompact().setSegmentBytes(internalChangelogSegmentBytes / 2L).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention((String)name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention((String)name, internalRetentionMs));
            this.configureReplication(topicBuilder, replicaCountInMrcCluster, internalReplication);
            builder.add((Object)topicBuilder.build());
        }
        log.info("getWindowedStoreTopicNames={}", topicStoreMaster.getWindowedStoreTopicNames());
        for (Object name : topicStoreMaster.getWindowedStoreTopicNames()) {
            topicBuilder = TopicInfo.builder().setShouldRespectMrc(shouldRespectMrc).addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName((String)name).setCompactDelete().setSegmentBytes(internalChangelogSegmentBytes).setDeleteRetentionMs(KafkaHelper.compactedTopicRetention((String)name, internalRetentionMs)).setRetentionMs(KafkaHelper.compactedTopicRetention((String)name, internalRetentionMs));
            this.configureReplication(topicBuilder, replicaCountInMrcCluster, internalReplication);
            builder.add((Object)topicBuilder.build());
        }
        log.info("getLogAppendTimeIntermediateTopicNames={}", topicStoreMaster.getLogAppendTimeIntermediateTopicNames());
        for (Object name : topicStoreMaster.getLogAppendTimeIntermediateTopicNames()) {
            topicBuilder = TopicInfo.builder().setShouldRespectMrc(shouldRespectMrc).setPartitions(internalPartitions).setDelete().setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName((String)name).addConfigEntry("message.timestamp.type", TimestampType.LOG_APPEND_TIME.name);
            this.configureReplication(topicBuilder, replicaCountInMrcCluster, internalReplication);
            builder.add((Object)topicBuilder.build());
        }
        Sets.SetView intermediateTopics = Sets.difference(topicStoreMaster.getIntermediateTopicNames(), topicStoreMaster.getLogAppendTimeIntermediateTopicNames());
        log.info("intermediateTopics={}", (Object)intermediateTopics);
        for (String name : intermediateTopics) {
            TopicInfo.Builder topicBuilder2 = TopicInfo.builder().setShouldRespectMrc(shouldRespectMrc).addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setPartitions(internalPartitions).setDelete().setRetentionMs(internalRetentionMs).setRetentionBytes(internalRetentionBytes).setName(name);
            this.configureReplication(topicBuilder2, replicaCountInMrcCluster, internalReplication);
            builder.add((Object)topicBuilder2.build());
        }
        TopicInfo.Builder monitoringTopicBuilder = TopicInfo.builder().setShouldRespectMrc(shouldRespectMrc).addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).setName(config.getString("confluent.monitoring.interceptor.topic")).setPartitions(config.getInt("confluent.monitoring.interceptor.topic.partitions")).setDelete().setRetentionMs(config.getLong("confluent.monitoring.interceptor.topic.retention.ms")).setRetentionBytes(config.getLong("confluent.monitoring.interceptor.topic.retention.bytes")).addConfigEntry("message.timestamp.type", TimestampType.LOG_APPEND_TIME.name).setValidateConfig(config.getBoolean("confluent.monitoring.interceptor.topic.config.validate"));
        this.configureReplication(monitoringTopicBuilder, replicaCountInMrcCluster, config.getShort("confluent.monitoring.interceptor.topic.replication"));
        builder.add((Object)monitoringTopicBuilder.build());
        TopicInfo.Builder metricsTopicBuilder = TopicInfo.builder().setShouldRespectMrc(shouldRespectMrc).addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setName(config.getString("confluent.metrics.topic")).setPartitions(config.getInt("confluent.metrics.topic.partitions")).setDelete().setRetentionMs(config.getLong("confluent.metrics.topic.retention.ms")).setRetentionBytes(config.getLong("confluent.metrics.topic.retention.bytes")).addConfigEntry("max.message.bytes", config.getInt("confluent.metrics.topic.max.message.bytes")).setValidateConfig(config.getBoolean("confluent.metrics.topic.config.validate"));
        this.configureReplication(metricsTopicBuilder, replicaCountInMrcCluster, config.getShort("confluent.metrics.topic.replication"));
        builder.add((Object)metricsTopicBuilder.build());
    }

    @Provides
    @ControlTopics
    @Inject
    protected Set<TopicInfo> provideControlTopics(Mode.ModeType modeType, Injector injector, ControlCenterConfig config, BootstrapClientSupplier bootstrapClientSupplier) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Boolean shouldRespectMRC = config.getBoolean("confluent.controlcenter.mrc.respect");
        int replicaCountInMrcCluster = -1;
        if (shouldRespectMRC.booleanValue()) {
            log.info("Trying to Respect MRC cluster for topic creation");
            KafkaHelper kafkaHelper = new KafkaHelper(bootstrapClientSupplier.get());
            replicaCountInMrcCluster = this.fetchReplicaCountInMrcCluster(kafkaHelper);
        }
        if (modeType == Mode.ModeType.ALL) {
            this.createAllModeTopics(injector, config, replicaCountInMrcCluster, shouldRespectMRC, (ImmutableSet.Builder<TopicInfo>)builder);
        }
        TopicInfo.Builder commandTopicBuilder = TopicInfo.builder().setShouldRespectMrc(shouldRespectMRC).addConfigEntry("message.timestamp.difference.max.ms", Long.MAX_VALUE).addConfigEntry("message.timestamp.type", TimestampType.CREATE_TIME.name).setName(config.getString("confluent.controlcenter.command.topic")).setPartitions(1).setDeleteRetentionMs(config.getLong("confluent.controlcenter.command.topic.retention.ms")).setSegmentBytes(config.getLong("confluent.controlcenter.command.topic.segment.bytes")).setCompact();
        this.configureReplication(commandTopicBuilder, replicaCountInMrcCluster, config.getShort("confluent.controlcenter.command.topic.replication"));
        builder.add((Object)commandTopicBuilder.build());
        return builder.build();
    }

    @Provides
    @Inject
    @TriggerMetricTypesMap
    protected Map<String, Map<String, TriggerMetricTypes.MetricType>> provideTriggerMetricTypesMap(TriggerMetricTypes triggerMetricTypes) {
        return triggerMetricTypes.provideTriggerMetricTypesMap();
    }

    @Provides
    @Inject
    @TriggerMetricTypesList
    protected List<String> provideTriggerMetricsTypesList(TriggerMetricTypes triggerMetricTypes) {
        return triggerMetricTypes.provideAllMetricsAsFlatList();
    }

    @Provides
    @Inject
    @Nullable
    @MonitoringTopic
    protected TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void> provideMonitoringTopic(Mode.ModeType modeType, ControlCenterConfig cfg, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde) {
        if (modeType == Mode.ModeType.ALL) {
            return new TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void>(cfg.getString("confluent.monitoring.interceptor.topic"), null, null, monitoringMessageSerde, false);
        }
        return null;
    }

    @Provides
    @Inject
    @Nullable
    @MetricsTopic
    protected TopicStoreMaster.Topic<Void, ConfluentMetric.MetricsMessage, Void, Void> provideMetricsTopic(Mode.ModeType modeType, ControlCenterConfig cfg, UberSerde<ConfluentMetric.MetricsMessage> metricsMessageSerde) {
        if (modeType == Mode.ModeType.ALL) {
            return new TopicStoreMaster.Topic<Void, ConfluentMetric.MetricsMessage, Void, Void>(cfg.getString("confluent.metrics.topic"), null, null, metricsMessageSerde, false);
        }
        return null;
    }

    @Provides
    @CreateTime
    protected ImmutableSet<TopicStoreMaster.Topic> provideCreateTimeTopics(Mode.ModeType modeType, Injector injector) {
        if (modeType == Mode.ModeType.ALL) {
            return ImmutableSet.of((Object)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<TopicStoreMaster.Topic<Void, ConfluentMetric.MetricsMessage, Void, Void>>(){}, MetricsTopic.class)), (Object)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<TopicStoreMaster.Topic<?, MetricHolder, Void, Void>>(){}, TopicStoreModule.MetricsAggregateRepartitionTopic.class)));
        }
        return ImmutableSet.of();
    }

    @Provides
    @AllTopics
    protected ImmutableSet<TopicStoreMaster.Topic> provideTopics(Injector injector) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry e : injector.getAllBindings().entrySet()) {
            TopicStoreMaster.Topic topic;
            if (!((Key)e.getKey()).getTypeLiteral().getRawType().equals(TopicStoreMaster.Topic.class) || (topic = (TopicStoreMaster.Topic)((Binding)e.getValue()).getProvider().get()) == null) continue;
            builder.add((Object)topic);
        }
        return builder.build();
    }

    @Provides
    @AllStores
    protected ImmutableSet<TopicStoreMaster.Store> provideStores(Injector injector) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry e : injector.getAllBindings().entrySet()) {
            if (!((Key)e.getKey()).getTypeLiteral().getRawType().equals(TopicStoreMaster.Store.class)) continue;
            builder.add((Object)((TopicStoreMaster.Store)((Binding)e.getValue()).getProvider().get()));
        }
        return builder.build();
    }

    @Provides
    @Inject
    @VerifiableStores
    protected Set<TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long>> provideVerifiableStores(Injector injector) {
        HashSet result = Sets.newHashSet();
        for (Map.Entry e : injector.getAllBindings().entrySet()) {
            TypeLiteral typeLiteral = ((Key)e.getKey()).getTypeLiteral();
            if (!typeLiteral.getRawType().equals(TopicStoreMaster.Store.class)) continue;
            assert (typeLiteral.getType() instanceof ParameterizedType);
            ParameterizedType type = (ParameterizedType)typeLiteral.getType();
            Type[] types = type.getActualTypeArguments();
            assert (types.length == 3);
            if (!types[0].equals(String.class) || !types[1].equals(Controlcenter.VerifiableMonitoringMessage.class) || !types[2].equals(Long.class)) continue;
            result.add((TopicStoreMaster.Store)((Binding)e.getValue()).getProvider().get());
        }
        return result;
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface VerifiableStores {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface AllStores {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface AllTopics {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface CreateTime {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MetricsTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MonitoringTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerMetricTypesList {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerMetricTypesMap {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlTopics {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface StreamsAppId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlCenterMetricsStoreRetentionDays {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TopicCache {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface BrokerCache {
    }
}

