/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.common.base.Joiner;
import com.google.protobuf.Descriptors;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.AlertSender;
import io.confluent.controlcenter.alert.TriggerConfigUtil;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.record.Controlcenter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertUtil {
    private static final Logger log = LoggerFactory.getLogger(AlertUtil.class);
    private static final String CLUSTER_BROKER_SEPARATOR_IN_KEY = "-";
    private static final Joiner JOINER = Joiner.on((String)", ");
    private static final Descriptors.FieldDescriptor MONITORINGTRIGGER_FIELD_NUMBER = Alert.AlertInfo.getDescriptor().findFieldByNumber(3);

    public static Controlcenter.TriggerActions updateTriggerActionsFromConfig(String triggerGuid, Alert.ComponentDesc componentDesc, Controlcenter.TriggerActions actions, Command.CommandMessage triggerMessage, Collection<KeyValue<Command.CommandKey, Command.CommandMessage>> actionConfigs) {
        if (triggerMessage == null) {
            log.debug("Unable to find trigger config with guid={}", (Object)triggerGuid);
            return null;
        }
        CommandAlert.MonitoringTriggerConfig monitoringTriggerConfig = triggerMessage.getMonitoringTriggerConfig();
        if (!monitoringTriggerConfig.getGuid().equals(triggerGuid)) {
            log.warn("mismatching guids key={} trigger={}", (Object)triggerGuid, (Object)monitoringTriggerConfig.getGuid());
            return null;
        }
        if (!TriggerConfigUtil.componentMatch(componentDesc, monitoringTriggerConfig)) {
            log.info("Mismatching component {} in trigger {}, likely trigger config changed", (Object)componentDesc, (Object)monitoringTriggerConfig);
            return null;
        }
        List<Controlcenter.TriggerAction> actionList = AlertUtil.actionListForTrigger(triggerGuid, actionConfigs);
        if (actionList != null && actions == null) {
            log.trace("Initializing actions for trigger={}", (Object)triggerGuid);
            return Controlcenter.TriggerActions.newBuilder().setTriggerGuid(triggerGuid).setComponent(componentDesc).setNextTriggerInfoSequence(0L).addAllActions(actionList).build();
        }
        if (actionList == null) {
            log.trace("No actions defined for trigger={}", (Object)triggerGuid);
            return null;
        }
        ArrayList<Controlcenter.TriggerAction> updatedActionList = new ArrayList<Controlcenter.TriggerAction>();
        for (Controlcenter.TriggerAction configuredAction : actionList) {
            boolean found = false;
            for (Controlcenter.TriggerAction storedAction : actions.getActionsList()) {
                if (!AlertUtil.hasSameFrequency(configuredAction, storedAction)) continue;
                updatedActionList.add(Controlcenter.TriggerAction.newBuilder((Controlcenter.TriggerAction)configuredAction).setNextActionTimestamp(storedAction.getNextActionTimestamp()).setLastTriggerInfoSequence(storedAction.getLastTriggerInfoSequence()).build());
                found = true;
                break;
            }
            if (found) continue;
            updatedActionList.add(configuredAction);
        }
        return Controlcenter.TriggerActions.newBuilder().setTriggerGuid(actions.getTriggerGuid()).setComponent(componentDesc).setNextTriggerInfoSequence(actions.getNextTriggerInfoSequence()).addAllActions(updatedActionList).build();
    }

    public static List<Controlcenter.TriggerAction> actionListForTrigger(String triggerGuid, Collection<KeyValue<Command.CommandKey, Command.CommandMessage>> actionConfigs) {
        ArrayList<Controlcenter.TriggerAction> actionList = new ArrayList<Controlcenter.TriggerAction>();
        try {
            for (KeyValue<Command.CommandKey, Command.CommandMessage> actionConfigKv : actionConfigs) {
                CommandAlert.ActionConfig actionConfig = ((Command.CommandMessage)actionConfigKv.value).getActionConfig();
                if (actionConfig == null) {
                    log.warn("actionConfig=null for key={}", actionConfigKv.key);
                    continue;
                }
                if (!actionConfig.getEnabled() || !actionConfig.getTriggerGuidList().contains((Object)triggerGuid)) continue;
                long sendPeriodMs = actionConfig.getMaxSendRate() <= 0 ? 0L : actionConfig.getIntervalMs() / (long)actionConfig.getMaxSendRate();
                boolean found = false;
                for (Controlcenter.TriggerAction triggerAction : actionList) {
                    if (triggerAction.getIntervalMs() != actionConfig.getIntervalMs() || triggerAction.getSendPeriodMs() != sendPeriodMs) continue;
                    found = true;
                }
                if (found) continue;
                Controlcenter.TriggerAction.Builder triggerActionBuilder = Controlcenter.TriggerAction.newBuilder().setIntervalMs(actionConfig.getIntervalMs()).setSendPeriodMs(sendPeriodMs).addActions(AlertUtil.getActionInfoBuilderFromActionConfig(actionConfig)).setNextActionTimestamp(0L).setLastTriggerInfoSequence(-1L);
                try {
                    for (KeyValue<Command.CommandKey, Command.CommandMessage> actionConfigKv2 : actionConfigs) {
                        CommandAlert.ActionConfig actionConfig2 = ((Command.CommandMessage)actionConfigKv2.value).getActionConfig();
                        if (actionConfig2 == null) {
                            log.warn("actionConfig2=null for key={}", actionConfigKv2.key);
                            continue;
                        }
                        if (actionConfig.getGuid().equals(actionConfig2.getGuid()) || !actionConfig2.getTriggerGuidList().contains((Object)triggerGuid) || !AlertUtil.hasSameFrequency(actionConfig, actionConfig2) || !actionConfig2.getEnabled()) continue;
                        triggerActionBuilder.addActions(AlertUtil.getActionInfoBuilderFromActionConfig(actionConfig2));
                    }
                    actionList.add(triggerActionBuilder.build());
                }
                catch (Exception exception) {
                    log.warn("Action list for trigger={} maybe incomplete", (Object)triggerGuid, (Object)exception);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to build action list for trigger={}", (Object)triggerGuid, (Object)e);
        }
        return actionList.isEmpty() ? null : actionList;
    }

    public static Alert.ActionInfo.Builder getActionInfoBuilderFromActionConfig(CommandAlert.ActionConfig actionConfig) {
        Alert.ActionInfo.Builder actionInfoBuilder = Alert.ActionInfo.newBuilder().setGuid(actionConfig.getGuid()).setName(actionConfig.getName());
        if (actionConfig.hasEmail()) {
            actionInfoBuilder.setEmail(actionConfig.getEmail());
        } else if (actionConfig.hasWebhook()) {
            actionInfoBuilder.setWebhook(actionConfig.getWebhook());
        }
        return actionInfoBuilder;
    }

    public static long computeNextActionTimestamp(Controlcenter.TriggerAction action, long currentTime) {
        long nextActionTimestamp = currentTime;
        if (action.getSendPeriodMs() > 0L) {
            long numPeriods = currentTime / action.getSendPeriodMs();
            nextActionTimestamp = Math.min(action.getSendPeriodMs() * (numPeriods + 2L), currentTime + action.getSendPeriodMs());
        }
        return nextActionTimestamp;
    }

    public static boolean hasSameFrequency(Controlcenter.TriggerAction action1, Controlcenter.TriggerAction action2) {
        return action1.getIntervalMs() == action2.getIntervalMs() && action1.getSendPeriodMs() == action2.getSendPeriodMs();
    }

    public static boolean hasSameFrequency(CommandAlert.ActionConfig actionConfig1, CommandAlert.ActionConfig actionConfig2) {
        return actionConfig1.getIntervalMs() == actionConfig2.getIntervalMs() && actionConfig1.getMaxSendRate() == actionConfig2.getMaxSendRate();
    }

    public static String getComponentForKey(Alert.ComponentDesc componentDesc) {
        return componentDesc.getComponentCase() == Alert.ComponentDesc.ComponentCase.BROKERCLUSTER ? Joiner.on((String)CLUSTER_BROKER_SEPARATOR_IN_KEY).join((Object)componentDesc.getBrokerCluster().getClusterId(), (Object)componentDesc.getBrokerCluster().getBrokerId(), new Object[0]) : componentDesc.getComponentId();
    }

    public static String getAlertContent(Alert.AlertInfo alertInfo, AlertSender alertSender, boolean linkToHistory) {
        String component;
        StringBuilder sb = new StringBuilder();
        String dateFormatted = AlertUtil.getFormatedTimeStamp(alertInfo);
        sb.append(String.format("Date: %s%n", dateFormatted));
        String clusterId = alertInfo.getMonitoringTrigger().getClusterId();
        if (!clusterId.isEmpty() && clusterId.length() > 0) {
            sb.append(String.format("Cluster: %s%n", clusterId));
        }
        if (alertInfo.hasMonitoringTrigger() && !(component = AlertUtil.getComponent(alertInfo)).equals("")) {
            sb.append(String.format("Component: %s%n", component));
        }
        String metric = AlertUtil.getAlertMetric(alertInfo);
        sb.append(String.format("Metric: %s%n", metric));
        String condition = AlertUtil.getAlertCondition(alertInfo);
        sb.append(String.format("Condition: %s%n", condition));
        String trigger = AlertUtil.getAlertTrigger(alertInfo);
        sb.append(String.format("Trigger: %s%n", trigger));
        if (linkToHistory) {
            String link = AlertUtil.getHistoryLink(alertSender, alertInfo);
            sb.append(String.format("Alert: %s%n", link));
        }
        return sb.toString();
    }

    public static Map<String, String> getMapAlertContent(Alert.AlertInfo alertInfo, AlertSender alertSender, boolean linkToHistory) {
        String component;
        HashMap<String, String> content = new HashMap<String, String>();
        String dateFormatted = AlertUtil.getFormatedTimeStamp(alertInfo);
        content.put("Date", dateFormatted);
        String cluster = alertInfo.getMonitoringTrigger().getClusterId();
        if (!cluster.isEmpty() && cluster.length() > 0) {
            content.put("Cluster", cluster);
        }
        if (alertInfo.hasMonitoringTrigger() && !(component = AlertUtil.getComponent(alertInfo)).equals("")) {
            content.put("Component", component);
        }
        String metric = AlertUtil.getAlertMetric(alertInfo);
        content.put("Metric", metric);
        String condition = AlertUtil.getAlertCondition(alertInfo);
        content.put("Condition", condition);
        String trigger = AlertUtil.getAlertTrigger(alertInfo);
        content.put("Trigger", trigger);
        if (linkToHistory) {
            String link = AlertUtil.getHistoryLink(alertSender, alertInfo);
            content.put("Alert", link);
        }
        return content;
    }

    public static String getFormatedTimeStamp(Alert.AlertInfo alertInfo) {
        Date date = new Date(alertInfo.getTimestamp());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return formatter.format(date);
    }

    public static String getHistoryLink(AlertSender alertSender, Alert.AlertInfo alertInfo) {
        return String.format("%s/alerts/overview/history/%d-%s", alertSender.restEndpoint, alertInfo.getTimestamp(), alertInfo.getGuid());
    }

    public static String getAlertMetric(Alert.AlertInfo alertInfo) {
        if (alertInfo.hasField(MONITORINGTRIGGER_FIELD_NUMBER)) {
            switch (alertInfo.getMonitoringTrigger().getTriggerMetricCase().getNumber()) {
                case 5: {
                    return alertInfo.getMonitoringTrigger().getMetric().getValueDescriptor().getName();
                }
                case 11: {
                    return alertInfo.getMonitoringTrigger().getBrokerMetric().getValueDescriptor().getName();
                }
                case 12: {
                    return alertInfo.getMonitoringTrigger().getTopicMetric().getValueDescriptor().getName();
                }
            }
            return "";
        }
        return "";
    }

    public static String getComponent(Alert.AlertInfo alertInfo) {
        if (alertInfo.hasField(MONITORINGTRIGGER_FIELD_NUMBER)) {
            switch (alertInfo.getMonitoringTrigger().getComponentCase().getNumber()) {
                case 4: {
                    return alertInfo.getMonitoringTrigger().getGroup();
                }
                case 9: {
                    return String.join((CharSequence)",", (Iterable<? extends CharSequence>)alertInfo.getMonitoringTrigger().getBrokerClusters().getBrokerClustersList());
                }
                case 10: {
                    return String.join((CharSequence)" ", alertInfo.getMonitoringTrigger().getTopic().getFilter().getValueDescriptor().getName(), alertInfo.getMonitoringTrigger().getTopic().getValue());
                }
            }
            return "";
        }
        return "";
    }

    private static String getAlertCondition(Alert.AlertInfo alertInfo) {
        StringBuilder sb = new StringBuilder();
        if (alertInfo.hasField(MONITORINGTRIGGER_FIELD_NUMBER)) {
            sb.append(alertInfo.getMonitoringTrigger().getCondition().getValueDescriptor().getName());
            sb.append(" ");
            switch (alertInfo.getMonitoringTrigger().getValueCase().getNumber()) {
                case 7: {
                    sb.append(alertInfo.getMonitoringTrigger().getLongValue());
                    break;
                }
                case 13: {
                    sb.append(alertInfo.getMonitoringTrigger().getStatusValue().getValueDescriptor().getName());
                    break;
                }
            }
        }
        return sb.toString();
    }

    private static String getAlertTrigger(Alert.AlertInfo alertInfo) {
        if (alertInfo.hasField(MONITORINGTRIGGER_FIELD_NUMBER)) {
            return alertInfo.getMonitoringTrigger().getName();
        }
        return "";
    }
}

