/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.alert.AlertSender;
import io.confluent.controlcenter.alert.AlertUtil;
import io.confluent.controlcenter.alert.EmailProvider;
import io.confluent.controlcenter.alert.record.Alert;
import java.util.Arrays;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender
extends AlertSender {
    private static final Logger log = LoggerFactory.getLogger(EmailSender.class);
    private final EmailProvider<Email> emailProvider;

    public EmailSender(EmailProvider<Email> emailProvider, ControlCenterConfig config, String restEndpoint) {
        super(config, restEndpoint);
        this.emailProvider = emailProvider;
    }

    @Override
    void send(Alert.AlertInfo info, Alert.ActionInfo ai, boolean linkToHistory) {
        CommandAlert.EmailAction emailAction = ai.getEmail();
        if (this.config.getBoolean("confluent.controlcenter.mail.enabled").booleanValue()) {
            try {
                Email email = this.emailProvider.get();
                String emailAddresses = emailAction.getAddress();
                email.setTo(Arrays.asList(InternetAddress.parse((String)emailAddresses)));
                email.setSubject(emailAction.getSubject());
                email.setMsg(AlertUtil.getAlertContent(info, this, linkToHistory));
                String messageId = email.send();
                log.debug("sending=success email to={} with subject={} from trigger={} messageId={}", new Object[]{emailAction.getAddress(), emailAction.getSubject(), info.getMonitoringTrigger().getGuid(), messageId});
            }
            catch (AddressException | EmailException e) {
                log.warn("sending=failure email to={} with subject={} from trigger={} {}", new Object[]{emailAction.getAddress(), emailAction.getSubject(), info.getMonitoringTrigger().getGuid(), e});
            }
        } else {
            log.debug("sending=prevented email to={} with subject={} from trigger={} messageId={}", new Object[]{emailAction.getAddress(), emailAction.getSubject(), info.getMonitoringTrigger().getGuid()});
        }
    }
}

