/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.protobuf.Message;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.AlertSender;
import io.confluent.controlcenter.alert.AlertUtil;
import io.confluent.controlcenter.alert.SlackWebhookSender;
import io.confluent.controlcenter.alert.WebhookSender;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.serializers.ProtoSerde;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerdutyWebhookSender
extends WebhookSender {
    public static final String PAGERDUTY_URL = "https://events.pagerduty.com/v2/enqueue";
    private static final Logger log = LoggerFactory.getLogger(SlackWebhookSender.class);

    public PagerdutyWebhookSender(Alert.AlertInfo info, CommandAlert.WebHookAction webHookAction, boolean linkToHistory, AlertSender alertSender) {
        super(info, webHookAction, linkToHistory, alertSender);
        CommandAlert.PagerDutyLink links = CommandAlert.PagerDutyLink.newBuilder().setHref(AlertUtil.getHistoryLink(alertSender, info)).setText("Alert History Link").build();
        CommandAlert.PagerDuty pagerDuty = linkToHistory ? CommandAlert.PagerDuty.newBuilder().setEventAction("trigger").setPayload(CommandAlert.PagerDutyPayload.newBuilder().setSummary(webHookAction.getSubject()).setSource(String.format("confluent control center: %s", alertSender.restEndpoint)).setTimestamp(AlertUtil.getFormatedTimeStamp(info)).setComponent(AlertUtil.getComponent(info)).putAllCustomDetails(AlertUtil.getMapAlertContent(info, alertSender, linkToHistory))).addLinks(links).mergeFrom(webHookAction.getPagerduty()).build() : CommandAlert.PagerDuty.newBuilder().setEventAction("trigger").setPayload(CommandAlert.PagerDutyPayload.newBuilder().setSummary(webHookAction.getSubject()).setSource(String.format("confluent control center: %s", alertSender.restEndpoint)).setTimestamp(AlertUtil.getFormatedTimeStamp(info)).setComponent(AlertUtil.getComponent(info)).putAllCustomDetails(AlertUtil.getMapAlertContent(info, alertSender, linkToHistory))).mergeFrom(webHookAction.getPagerduty()).build();
        this.webHookAction = CommandAlert.WebHookAction.newBuilder((CommandAlert.WebHookAction)webHookAction).setUrl(PAGERDUTY_URL).setPagerduty(pagerDuty).build();
    }

    @Override
    void setHeader(HttpPost httpPost) {
    }

    @Override
    String constructPayloadFormat() {
        ProtoSerde pagerDutyProtoSerde = new ProtoSerde((Message)CommandAlert.PagerDuty.getDefaultInstance());
        String content = pagerDutyProtoSerde.toJson((Message)this.webHookAction.getPagerduty(), true);
        return content;
    }
}

