/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.record.Alert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(TriggerConfigUtil.class);

    public static boolean topicMatch(String topic, CommandAlert.MonitoringTriggerConfig triggerConfig) {
        if (triggerConfig.getComponentCase() == CommandAlert.MonitoringTriggerConfig.ComponentCase.TOPIC) {
            switch (triggerConfig.getTopic().getFilter()) {
                case EQUALS: {
                    return topic.equals(triggerConfig.getTopic().getValue());
                }
                case BEGINS_WITH: {
                    return topic.startsWith(triggerConfig.getTopic().getValue());
                }
                case ENDS_WITH: {
                    return topic.endsWith(triggerConfig.getTopic().getValue());
                }
                case CONTAINS: {
                    return topic.contains(triggerConfig.getTopic().getValue());
                }
                case ALL_TOPICS: {
                    return true;
                }
            }
            log.info("Unsupported topic filter in trigger config {}", (Object)triggerConfig);
        }
        return false;
    }

    public static boolean componentMatch(Alert.ComponentDesc componentDesc, CommandAlert.MonitoringTriggerConfig triggerConfig) {
        switch (triggerConfig.getComponentCase()) {
            case GROUP: {
                return triggerConfig.getGroup().equals(componentDesc.getComponentId());
            }
            case BROKERCLUSTERS: {
                return triggerConfig.getBrokerClusters().getBrokerClustersList().contains((Object)componentDesc.getBrokerCluster().getClusterId());
            }
            case TOPIC: {
                return TriggerConfigUtil.topicMatch(componentDesc.getComponentId(), triggerConfig);
            }
        }
        log.info("Unsupported component type in trigger config {}", (Object)triggerConfig);
        return false;
    }
}

