/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.annotation.Mode;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TriggerMetricTypes {
    static final String TOPIC = "TOPIC";
    static final String BROKER = "BROKER";
    static final String CG = "CONSUMER_GROUP";
    static final String CLUSTER = "CLUSTER";
    static final String FETCH_REQ_LATENCY = "fetch request latency";
    static final String PRODUCTION_REQ_LATENCY = "production request latency";
    private static final Function<Mode.ModeType, List<String>> TOPIC_TRIGGER_METRIC_TYPES = modeType -> modeType == Mode.ModeType.ALL ? TriggerMetricTypes.getEnumValues((Enum[])CommandAlert.TopicTriggerMetricType.values()) : Collections.emptyList();
    private static final Function<Mode.ModeType, List<String>> BROKER_TRIGGER_METRIC_TYPES = modeType -> modeType == Mode.ModeType.ALL ? TriggerMetricTypes.getSortedStrings(CommandAlert.BrokerTriggerMetricType.BROKER_BYTES_IN.name(), CommandAlert.BrokerTriggerMetricType.BROKER_BYTES_OUT.name(), FETCH_REQ_LATENCY, CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_COUNT.name(), PRODUCTION_REQ_LATENCY) : Collections.emptyList();
    private static final Function<Mode.ModeType, List<String>> CG_TRIGGER_METRIC_TYPES = modeType -> modeType == Mode.ModeType.ALL ? TriggerMetricTypes.getEnumValues((Enum[])CommandAlert.TriggerMetricType.values()) : TriggerMetricTypes.getSortedStrings(CommandAlert.TriggerMetricType.CONSUMER_LAG.name(), CommandAlert.TriggerMetricType.CONSUMER_LEAD.name());
    private static final Function<Mode.ModeType, List<String>> CLUSTER_TRIGGER_METRIC_TYPES = modeType -> modeType == Mode.ModeType.ALL ? TriggerMetricTypes.getSortedStrings(CommandAlert.BrokerTriggerMetricType.CLUSTER_STATUS.name(), CommandAlert.BrokerTriggerMetricType.LEADER_ELECTION_RATE.name(), CommandAlert.BrokerTriggerMetricType.OFFLINE_TOPIC_PARTITIONS.name(), CommandAlert.BrokerTriggerMetricType.UNCLEAN_ELECTION_COUNT.name(), CommandAlert.BrokerTriggerMetricType.UNDER_REPLICATED_TOPIC_PARTITIONS.name(), CommandAlert.BrokerTriggerMetricType.ZK_STATUS.name(), CommandAlert.BrokerTriggerMetricType.ZK_EXPIRATION_RATE.name()) : TriggerMetricTypes.getSortedStrings(CommandAlert.BrokerTriggerMetricType.CLUSTER_STATUS.name());
    private static final Map<String, Function<Mode.ModeType, List<String>>> ALL_METRIC_TYPES_MAP = ImmutableMap.of((Object)"TOPIC", TOPIC_TRIGGER_METRIC_TYPES, (Object)"BROKER", BROKER_TRIGGER_METRIC_TYPES, (Object)"CONSUMER_GROUP", CG_TRIGGER_METRIC_TYPES, (Object)"CLUSTER", CLUSTER_TRIGGER_METRIC_TYPES);
    private static final List<Function<Mode.ModeType, List<String>>> ALL_METRIC_TYPES_LIST = ImmutableList.copyOf(ALL_METRIC_TYPES_MAP.values());
    static final List<String> BROKER_PRODUCTION_REQ_LATENCY_PERCENTILES = TriggerMetricTypes.getSortedStrings(CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_950.name(), CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_990.name(), CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_999.name(), CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_MEDIAN.name());
    static final List<String> BROKER_FETCH_REQ_LATENCY_PERCENTILES = TriggerMetricTypes.getSortedStrings(CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_950.name(), CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_990.name(), CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_999.name(), CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_MEDIAN.name());
    static final List<String> CLUSTER_STATUSES = TriggerMetricTypes.getEnumValues((Enum[])CommandAlert.StatusValue.values());
    static final List<String> TRIGGER_CONDITIONS = TriggerMetricTypes.getEnumValues((Enum[])CommandAlert.TriggerCondition.values());
    static final List<String> TOPIC_NAME_FILTERS = TriggerMetricTypes.getEnumValues((Enum[])CommandAlert.TopicNameFilter.values());
    private final Mode.ModeType modeType;

    @Inject
    public TriggerMetricTypes(Mode.ModeType modeType) {
        this.modeType = modeType;
    }

    public Map<String, Map<String, MetricType>> provideTriggerMetricTypesMap() {
        return ALL_METRIC_TYPES_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            String componentType = (String)e.getKey();
            List metricTypes = (List)((Function)e.getValue()).apply(this.modeType);
            return metricTypes.stream().collect(Collectors.toMap(metricType -> metricType, metricType -> this.provideTriggerMetricType(componentType, (String)metricType)));
        }));
    }

    public List<String> provideAllMetricsAsFlatList() {
        return ALL_METRIC_TYPES_LIST.stream().flatMap(mapper -> ((List)mapper.apply(this.modeType)).stream()).map(metricType -> {
            if (metricType.equals(FETCH_REQ_LATENCY)) {
                return BROKER_FETCH_REQ_LATENCY_PERCENTILES;
            }
            if (metricType.equals(PRODUCTION_REQ_LATENCY)) {
                return BROKER_PRODUCTION_REQ_LATENCY_PERCENTILES;
            }
            return ImmutableList.of((Object)metricType);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private MetricType provideTriggerMetricType(String componentType, String metricType) {
        MetricType result = new MetricType(metricType);
        if (componentType.equals(TOPIC)) {
            result.filters = TOPIC_NAME_FILTERS;
        }
        if (metricType.equals(CommandAlert.BrokerTriggerMetricType.CLUSTER_STATUS.name()) || metricType.equals(CommandAlert.BrokerTriggerMetricType.ZK_STATUS.name())) {
            result.statuses = CLUSTER_STATUSES;
            return result;
        }
        if (metricType.equals(FETCH_REQ_LATENCY)) {
            result.percentiles = BROKER_FETCH_REQ_LATENCY_PERCENTILES;
        } else if (metricType.equals(PRODUCTION_REQ_LATENCY)) {
            result.percentiles = BROKER_PRODUCTION_REQ_LATENCY_PERCENTILES;
        }
        result.conditions = TRIGGER_CONDITIONS;
        return result;
    }

    private static <T extends Enum<T>> List<String> getEnumValues(T[] values) {
        return Arrays.stream(values).map(Enum::name).filter(name -> !name.equals("UNRECOGNIZED")).sorted().collect(Collectors.toList());
    }

    private static List<String> getSortedStrings(String ... values) {
        return Stream.of(values).sorted().collect(Collectors.toList());
    }

    @JsonStandard
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MetricType {
        @JsonProperty(value="name")
        final String name;
        @JsonProperty(value="conditions")
        List<String> conditions;
        @JsonProperty(value="filters")
        List<String> filters;
        @JsonProperty(value="percentiles")
        List<String> percentiles;
        @JsonProperty(value="statuses")
        List<String> statuses;

        public MetricType(String metricType) {
            this(metricType, null, null, null, null);
        }

        public MetricType(String metricType, List<String> conditions, List<String> filters, List<String> percentiles, List<String> statuses) {
            this.name = metricType;
            this.conditions = conditions;
            this.filters = filters;
            this.percentiles = percentiles;
            this.statuses = statuses;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricType that = (MetricType)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.conditions, that.conditions) && Objects.equals(this.filters, that.filters) && Objects.equals(this.percentiles, that.percentiles) && Objects.equals(this.statuses, that.statuses);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.conditions, this.filters, this.percentiles, this.statuses);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("conditions", this.conditions).add("filters", this.filters).add("percentiles", this.percentiles).add("statuses", this.statuses).toString();
        }
    }
}

