/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.consumption;

import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerHelper {
    private static final Logger log = LoggerFactory.getLogger(ConsumerHelper.class);
    private static final String SEEK_LOG_MESSAGE = "seeking topicPartition={} to offset={}";

    public static void setPosition(Consumer<?, ?> consumer, Position position) {
        Set assignment = consumer.assignment();
        log.debug("current assignment={} ", (Object)assignment);
        if (position != null) {
            switch (position.type()) {
                case LATEST: {
                    consumer.seekToEnd((Collection)assignment);
                    break;
                }
                case EARLIEST: {
                    log.debug("seeking all topicPartitions to beginning");
                    consumer.seekToBeginning((Collection)assignment);
                    break;
                }
                case OFFSET: {
                    long offset = position.position();
                    if (offset < 0L) {
                        Map endOffsets = consumer.endOffsets((Collection)assignment);
                        for (TopicPartition tp : endOffsets.keySet()) {
                            long newOffset = Math.max((Long)endOffsets.get(tp) + offset, 0L);
                            log.debug(SEEK_LOG_MESSAGE, (Object)tp, (Object)newOffset);
                            consumer.seek(tp, newOffset);
                        }
                    } else {
                        for (TopicPartition tp : assignment) {
                            log.debug(SEEK_LOG_MESSAGE, (Object)tp, (Object)offset);
                            consumer.seek(tp, offset);
                        }
                    }
                    break;
                }
                case TIMESTAMP: {
                    Map offsetsForTimes = consumer.offsetsForTimes((Map)FluentIterable.from((Iterable)assignment).toMap(Functions.constant((Object)position.position())));
                    for (Map.Entry entry : offsetsForTimes.entrySet()) {
                        if (entry.getValue() == null) continue;
                        log.debug(SEEK_LOG_MESSAGE, entry.getKey(), (Object)((OffsetAndTimestamp)entry.getValue()).offset());
                        try {
                            consumer.seek((TopicPartition)entry.getKey(), ((OffsetAndTimestamp)entry.getValue()).offset());
                        }
                        catch (IllegalArgumentException | InvalidOffsetException e) {
                            log.warn("invalid offset={} for topicpartition={}", new Object[]{entry.getValue(), entry.getKey(), e});
                        }
                    }
                    break;
                }
                default: {
                    log.warn("unhandled position type={}", (Object)position.type());
                }
            }
        }
    }

    public static class Position {
        private final Type type;
        private final Long position;

        public Position(Type type, Long position) {
            this.type = type;
            this.position = position;
        }

        public Type type() {
            return this.type;
        }

        public long position() {
            return this.position;
        }

        public static enum Type {
            OFFSET,
            TIMESTAMP,
            EARLIEST,
            LATEST;

        }
    }
}

