/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerOffsetsDao
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerOffsetsDao.class);
    private final String clusterId;
    private final Admin kafkaAdminClient;
    private final int consumerMetadataTimeout;

    public ConsumerOffsetsDao(String clusterId, Admin kafkaAdminClient, int consumerMetadataTimeout) {
        this.clusterId = clusterId;
        this.kafkaAdminClient = kafkaAdminClient;
        this.consumerMetadataTimeout = consumerMetadataTimeout;
    }

    public Map<String, ConsumerGroupOffsets> getAllConsumerGroupOffsets() throws InterruptedException, ExecutionException, TimeoutException {
        Set<String> consumerGroupIds = this.getConsumerGroups();
        Map<String, ConsumerGroupDescription> fetchedConsumerGroupDesc = this.getAllConsumerGroupDescriptions(consumerGroupIds);
        HashMap<String, ConsumerGroupOffsets> cgOffsetsMap = new HashMap<String, ConsumerGroupOffsets>();
        for (ConsumerGroupDescription desc : fetchedConsumerGroupDesc.values()) {
            try {
                ConsumerGroupOffsets cgOffsets = this.getConsumerGroupOffsets(desc, IsolationLevel.READ_COMMITTED);
                cgOffsetsMap.put(desc.groupId(), cgOffsets);
            }
            catch (Exception ex) {
                log.warn("Failed to get offsets for consumer group {}", (Object)desc.groupId());
                throw ex;
            }
        }
        return cgOffsetsMap;
    }

    ConsumerGroupOffsets getConsumerGroupOffsets(ConsumerGroupDescription cgDesc, Map<TopicPartition, OffsetAndMetadata> fetchedCurrentOffsets, Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> earliestOffsets, Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> latestOffsets) {
        ConsumerGroupOffsets cgOffsets = new ConsumerGroupOffsets(cgDesc.groupId());
        HashMap<TopicPartition, String> tpConsumerIds = new HashMap<TopicPartition, String>();
        HashMap<TopicPartition, String> tpClientIds = new HashMap<TopicPartition, String>();
        for (MemberDescription memberDesc : cgDesc.members()) {
            for (TopicPartition tp : memberDesc.assignment().topicPartitions()) {
                tpConsumerIds.put(tp, memberDesc.consumerId());
                tpClientIds.put(tp, memberDesc.clientId());
            }
        }
        for (TopicPartition tp : fetchedCurrentOffsets.keySet()) {
            String consumerId = tpConsumerIds.getOrDefault(tp, "");
            String clientId = tpClientIds.getOrDefault(tp, "");
            long currentOffset = this.getCurrentOffset(fetchedCurrentOffsets, tp);
            long latestOffset = this.getOffset(latestOffsets, tp);
            long earliestOffset = this.getOffset(earliestOffsets, tp);
            if (currentOffset < 0L || latestOffset < 0L) {
                log.debug("invalid offsets for topic={} consumerId={} current={} latest={}", new Object[]{tp.topic(), consumerId, currentOffset, latestOffset});
                continue;
            }
            cgOffsets.addOffset(tp.topic(), consumerId, clientId, tp.partition(), currentOffset, earliestOffset, latestOffset);
        }
        return cgOffsets;
    }

    public ConsumerGroupOffsets getConsumerGroupOffsets(String consumerGroupId, IsolationLevel isolationLevel) throws InterruptedException, ExecutionException, TimeoutException {
        ConsumerGroupDescription cgDesc = this.getConsumerGroupDescription(consumerGroupId);
        return this.getConsumerGroupOffsets(cgDesc, isolationLevel);
    }

    private ConsumerGroupOffsets getConsumerGroupOffsets(ConsumerGroupDescription desc, IsolationLevel isolationLevel) throws InterruptedException, ExecutionException, TimeoutException {
        log.debug("Fetching offset for consumer group {}", (Object)desc.groupId());
        Map<TopicPartition, OffsetAndMetadata> fetchedCurrentOffsets = this.getCurrentOffsets(desc.groupId());
        ListOffsetsOptions listOffsetsOptions = (ListOffsetsOptions)new ListOffsetsOptions(isolationLevel).timeoutMs(Integer.valueOf(this.consumerMetadataTimeout));
        Map latestOffsetSpecs = fetchedCurrentOffsets.keySet().stream().collect(Collectors.toMap(Function.identity(), tp -> OffsetSpec.latest()));
        Map earliestOffsetSpecs = fetchedCurrentOffsets.keySet().stream().collect(Collectors.toMap(Function.identity(), tp -> OffsetSpec.earliest()));
        ListOffsetsResult latestOffsetResult = this.kafkaAdminClient.listOffsets(latestOffsetSpecs, listOffsetsOptions);
        ListOffsetsResult earliestOffsetResult = this.kafkaAdminClient.listOffsets(earliestOffsetSpecs, listOffsetsOptions);
        Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> latestOffsets = fetchedCurrentOffsets.keySet().stream().map(topicPartition -> {
            try {
                return new AbstractMap.SimpleImmutableEntry<TopicPartition, Object>((TopicPartition)topicPartition, latestOffsetResult.partitionResult(topicPartition).get((long)this.consumerMetadataTimeout, TimeUnit.MILLISECONDS));
            }
            catch (Exception e) {
                log.warn("Could not retrieve latest offset for group: {} topicPartition: {}", new Object[]{desc.groupId(), topicPartition, e});
                return null;
            }
        }).filter(listOffsetsResultInfo -> listOffsetsResultInfo != null).collect(Collectors.toMap(entry -> (TopicPartition)entry.getKey(), entry -> (ListOffsetsResult.ListOffsetsResultInfo)entry.getValue()));
        Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> earliestOffsets = fetchedCurrentOffsets.keySet().stream().map(topicPartition -> {
            try {
                return new AbstractMap.SimpleImmutableEntry<TopicPartition, Object>((TopicPartition)topicPartition, earliestOffsetResult.partitionResult(topicPartition).get((long)this.consumerMetadataTimeout, TimeUnit.MILLISECONDS));
            }
            catch (Exception e) {
                log.warn("Could not retrieve earliest offset for group: {} topicPartition: {}", new Object[]{desc.groupId(), topicPartition, e});
                return null;
            }
        }).filter(listOffsetsResultInfo -> listOffsetsResultInfo != null).collect(Collectors.toMap(entry -> (TopicPartition)entry.getKey(), entry -> (ListOffsetsResult.ListOffsetsResultInfo)entry.getValue()));
        return this.getConsumerGroupOffsets(desc, fetchedCurrentOffsets, earliestOffsets, latestOffsets);
    }

    public String clusterId() {
        return this.clusterId;
    }

    Set<String> getConsumerGroups() throws InterruptedException, ExecutionException, TimeoutException {
        LinkedHashSet cgs = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)((Iterable)this.kafkaAdminClient.listConsumerGroups((ListConsumerGroupsOptions)new ListConsumerGroupsOptions().timeoutMs(Integer.valueOf(this.consumerMetadataTimeout))).all().get((long)this.consumerMetadataTimeout, TimeUnit.MILLISECONDS)), ConsumerGroupListing::groupId));
        cgs.remove(ControlCenterConfig.CONTROL_CENTER_LAST_PRODUCE_TIME_CONSUMER_NAME);
        return cgs;
    }

    ConsumerGroupDescription getConsumerGroupDescription(String consumerGroupId) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupDescription> allCgDesc = this.getAllConsumerGroupDescriptions((Collection<String>)ImmutableSet.of((Object)consumerGroupId));
        log.debug("Fetching description for consumer group {}", (Object)consumerGroupId);
        return allCgDesc.get(consumerGroupId);
    }

    Map<String, ConsumerGroupDescription> getAllConsumerGroupDescriptions(Collection<String> consumerGroupIds) throws InterruptedException, ExecutionException, TimeoutException {
        HashMap<String, ConsumerGroupDescription> ret = new HashMap<String, ConsumerGroupDescription>();
        AtomicBoolean retryWithoutIncludeAuthorizedOperations = new AtomicBoolean(false);
        KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])Iterables.toArray((Iterable)Iterables.transform(this.kafkaAdminClient.describeConsumerGroups(consumerGroupIds, (DescribeConsumerGroupsOptions)new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true).timeoutMs(Integer.valueOf(this.consumerMetadataTimeout))).describedGroups().entrySet(), entry -> {
            String cgId = (String)entry.getKey();
            return ((KafkaFuture)entry.getValue()).whenComplete((cgDesc, throwable) -> {
                if (throwable != null) {
                    if (throwable.getCause() instanceof UnsupportedVersionException) {
                        log.debug("broker version is not supported. Retrying...", throwable);
                        retryWithoutIncludeAuthorizedOperations.set(true);
                    } else {
                        log.warn("failed fetching description for consumerGroup={}", (Object)cgId, throwable);
                    }
                } else if (cgDesc != null) {
                    ret.put(cgId, (ConsumerGroupDescription)cgDesc);
                }
            });
        }), KafkaFuture.class))).get((long)this.consumerMetadataTimeout, TimeUnit.MILLISECONDS);
        if (retryWithoutIncludeAuthorizedOperations.get()) {
            KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])Iterables.toArray((Iterable)Iterables.transform(this.kafkaAdminClient.describeConsumerGroups(consumerGroupIds, (DescribeConsumerGroupsOptions)new DescribeConsumerGroupsOptions().timeoutMs(Integer.valueOf(this.consumerMetadataTimeout))).describedGroups().entrySet(), entry -> {
                String cgId = (String)entry.getKey();
                return ((KafkaFuture)entry.getValue()).whenComplete((cgDesc, throwable) -> {
                    if (throwable != null) {
                        log.warn("failed fetching description for consumerGroup={}", (Object)cgId, throwable);
                    } else if (cgDesc != null) {
                        ret.put(cgId, (ConsumerGroupDescription)cgDesc);
                    }
                });
            }), KafkaFuture.class))).get((long)this.consumerMetadataTimeout, TimeUnit.MILLISECONDS);
        }
        return ret;
    }

    public Map<TopicPartition, OffsetAndMetadata> getCurrentOffsets(String consumerGroupId) throws InterruptedException, ExecutionException, TimeoutException {
        return (Map)this.kafkaAdminClient.listConsumerGroupOffsets(consumerGroupId, (ListConsumerGroupOffsetsOptions)new ListConsumerGroupOffsetsOptions().timeoutMs(Integer.valueOf(this.consumerMetadataTimeout))).partitionsToOffsetAndMetadata().get((long)this.consumerMetadataTimeout, TimeUnit.MILLISECONDS);
    }

    private long getCurrentOffset(Map<TopicPartition, OffsetAndMetadata> map, TopicPartition tp) {
        if (map == null) {
            return -1L;
        }
        OffsetAndMetadata oam = map.get(tp);
        if (oam == null) {
            return -1L;
        }
        return oam.offset();
    }

    private long getOffset(Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> map, TopicPartition tp) {
        if (map == null) {
            return -1L;
        }
        ListOffsetsResult.ListOffsetsResultInfo offsetInfo = map.get(tp);
        if (offsetInfo == null) {
            return -1L;
        }
        return offsetInfo.offset();
    }

    @Override
    public void close() {
        this.kafkaAdminClient.close();
    }
}

